/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.generic.UFunc;
import breeze.linalg.CSCMatrix;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcF$sp;
import breeze.linalg.MatrixLike$mcF$sp;
import breeze.linalg.SparseVector;
import breeze.linalg.SparseVector$;
import breeze.linalg.SparseVector$mcF$sp;
import breeze.linalg.View;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.mapValues$;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.util.Arrays;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ClassTag;

public class CSCMatrix$mcF$sp
extends CSCMatrix<Object>
implements Matrix$mcF$sp {
    public float[] _data$mcF$sp;
    public final Zero<Object> evidence$1$mcF$sp;
    private final int[] _rowIndices;

    @Override
    public final float apply(Tuple2<Object, Object> i) {
        return Matrix$mcF$sp.apply$(this, i);
    }

    @Override
    public final float apply$mcF$sp(Tuple2<Object, Object> i) {
        return Matrix$mcF$sp.apply$mcF$sp$(this, i);
    }

    @Override
    public final void update(Tuple2<Object, Object> i, float e) {
        Matrix$mcF$sp.update$(this, i, e);
    }

    @Override
    public final void update$mcF$sp(Tuple2<Object, Object> i, float e) {
        Matrix$mcF$sp.update$mcF$sp$(this, i, e);
    }

    @Override
    public <V2, That> That map(Function1<Object, V2> fn, UFunc.UImpl2<mapValues$, CSCMatrix<Object>, Function1<Object, V2>, That> canMapValues) {
        return (That)MatrixLike$mcF$sp.map$(this, fn, canMapValues);
    }

    @Override
    public <V2, That> That map$mcF$sp(Function1<Object, V2> fn, UFunc.UImpl2<mapValues$, CSCMatrix<Object>, Function1<Object, V2>, That> canMapValues) {
        return (That)MatrixLike$mcF$sp.map$mcF$sp$(this, fn, canMapValues);
    }

    @Override
    public float[] _data$mcF$sp() {
        return this._data$mcF$sp;
    }

    public float[] _data() {
        return this._data$mcF$sp();
    }

    @Override
    public void _data$mcF$sp_$eq(float[] x$1) {
        this._data$mcF$sp = x$1;
    }

    public void _data_$eq(float[] x$1) {
        this._data$mcF$sp_$eq(x$1);
    }

    public float[] data() {
        return this.data$mcF$sp();
    }

    @Override
    public float[] data$mcF$sp() {
        return this._data();
    }

    @Override
    public float apply(int row, int col) {
        return this.apply$mcF$sp(row, col);
    }

    @Override
    public float apply$mcF$sp(int row, int col) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        return ind < 0 ? this.zero$mcF$sp() : this.data$mcF$sp()[ind];
    }

    @Override
    public void update(int row, int col, float v) {
        this.update$mcF$sp(row, col, v);
    }

    @Override
    public void update$mcF$sp(int row, int col, float v) {
        if (row >= this.rows() || col >= this.cols() || row < 0 || col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ind = this.breeze$linalg$CSCMatrix$$locate(row, col);
        if (ind >= 0) {
            this.data$mcF$sp()[ind] = v;
        } else if (v != this.zero$mcF$sp()) {
            int insertPos = ~ind;
            this.used_$eq(this.used() + 1);
            if (this.used() > this.data$mcF$sp().length) {
                int newLength = this.data$mcF$sp().length == 0 ? 4 : (this.data$mcF$sp().length < 1024 ? this.data$mcF$sp().length * 2 : (this.data$mcF$sp().length < 2048 ? this.data$mcF$sp().length + 1024 : (this.data$mcF$sp().length < 4096 ? this.data$mcF$sp().length + 2048 : (this.data$mcF$sp().length < 8192 ? this.data$mcF$sp().length + 4096 : (this.data$mcF$sp().length < 16384 ? this.data$mcF$sp().length + 8192 : this.data$mcF$sp().length + 16384)))));
                int[] newIndex = Arrays.copyOf(this.rowIndices(), newLength);
                float[] newData = (float[])ArrayUtil$.MODULE$.copyOf(this.data$mcF$sp(), newLength);
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, newIndex, insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcF$sp(), insertPos, newData, insertPos + 1, this.used() - insertPos - 1);
                this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(newIndex);
                this._data_$eq(newData);
            } else if (this.used() - insertPos > 1) {
                System.arraycopy(this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos, this.breeze$linalg$CSCMatrix$$_rowIndices(), insertPos + 1, this.used() - insertPos - 1);
                System.arraycopy(this.data$mcF$sp(), insertPos, this.data$mcF$sp(), insertPos + 1, this.used() - insertPos - 1);
            }
            this.rowIndices()[insertPos] = row;
            this.data$mcF$sp()[insertPos] = v;
            int end$macro$3 = this.cols();
            for (int index$macro$2 = col + 1; index$macro$2 <= end$macro$3; ++index$macro$2) {
                this.colPtrs()[index$macro$2] = this.colPtrs()[index$macro$2] + 1;
            }
        }
    }

    @Override
    public CSCMatrix<Object> repr() {
        return this.repr$mcF$sp();
    }

    @Override
    public CSCMatrix<Object> repr$mcF$sp() {
        return this;
    }

    @Override
    public float zero() {
        return this.zero$mcF$sp();
    }

    @Override
    public float zero$mcF$sp() {
        return ((Zero)Predef$.MODULE$.implicitly(this.evidence$1$mcF$sp)).zero$mcF$sp();
    }

    @Override
    public void use(CSCMatrix<Object> matrix) {
        this.use$mcF$sp(matrix);
    }

    @Override
    public void use$mcF$sp(CSCMatrix<Object> matrix) {
        this.use$mcF$sp(matrix.data$mcF$sp(), matrix.colPtrs(), matrix.rowIndices(), matrix.used());
    }

    public void use(float[] data, int[] colPtrs, int[] rowIndices, int used) {
        this.use$mcF$sp(data, colPtrs, rowIndices, used);
    }

    @Override
    public void use$mcF$sp(float[] data, int[] colPtrs, int[] rowIndices, int used) {
        boolean cond$macro$5;
        boolean cond$macro$4;
        boolean cond$macro$3;
        int left$macro$1 = colPtrs.length;
        int right$macro$2 = this.colPtrs().length;
        if (left$macro$1 != right$macro$2) {
            throw new IllegalArgumentException(new StringBuilder(20).append("requirement failed: ").append(new StringBuilder(44).append("colPtrs.length == this.colPtrs.length (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString()).toString());
        }
        boolean bl = cond$macro$3 = used >= 0;
        if (!cond$macro$3) {
            throw new IllegalArgumentException("requirement failed: used.>=(0)");
        }
        boolean bl2 = cond$macro$4 = data.length >= used;
        if (!cond$macro$4) {
            throw new IllegalArgumentException("requirement failed: data.length.>=(used)");
        }
        boolean bl3 = cond$macro$5 = rowIndices.length >= used;
        if (!cond$macro$5) {
            throw new IllegalArgumentException("requirement failed: rowIndices.length.>=(used)");
        }
        this._data_$eq(data);
        System.arraycopy(colPtrs, 0, this.colPtrs(), 0, colPtrs.length);
        this.breeze$linalg$CSCMatrix$$_rowIndices_$eq(rowIndices);
        this.used_$eq(used);
    }

    @Override
    public CSCMatrix<Object> copy() {
        return this.copy$mcF$sp();
    }

    @Override
    public CSCMatrix<Object> copy$mcF$sp() {
        return new CSCMatrix$mcF$sp((float[])ArrayUtil$.MODULE$.copyOf(this._data(), this.activeSize()), this.rows(), this.cols(), (int[])this.colPtrs().clone(), this.activeSize(), (int[])this.breeze$linalg$CSCMatrix$$_rowIndices().clone(), this.evidence$1$mcF$sp);
    }

    @Override
    public SparseVector<Object> flatten(View view) {
        return this.flatten$mcF$sp(view);
    }

    @Override
    public SparseVector<Object> flatten$mcF$sp(View view) {
        SparseVector<Object> sparseVector;
        View view2 = view;
        if (View$Require$.MODULE$.equals(view2)) {
            int[] indices = new int[this.data$mcF$sp().length];
            int ind = 0;
            for (int j = 0; j < this.cols(); ++j) {
                int ip = this.colPtrs()[j];
                while (ip < this.colPtrs()[j + 1]) {
                    int i = this.rowIndices()[ip];
                    indices[ind] = i * this.rows() + j;
                    ++ip;
                    ++ind;
                }
            }
            sparseVector = new SparseVector$mcF$sp(indices, this.data$mcF$sp(), this.activeSize(), this.rows() * this.cols(), this.evidence$1$mcF$sp);
        } else if (View$Copy$.MODULE$.equals(view2)) {
            ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcF$sp());
            SparseVector<Object> sv = SparseVector$.MODULE$.zeros$mFc$sp(this.rows() * this.cols(), man, this.evidence$1$mcF$sp);
            for (int j = 0; j < this.cols(); ++j) {
                for (int ip = this.colPtrs()[j]; ip < this.colPtrs()[j + 1]; ++ip) {
                    int i = this.rowIndices()[ip];
                    sv.update$mcF$sp(i * this.cols() + j, this.data$mcF$sp()[ip]);
                }
            }
            sparseVector = sv;
        } else if (View$Prefer$.MODULE$.equals(view2)) {
            sparseVector = this.flatten$mcF$sp(View$Require$.MODULE$);
        } else {
            throw new MatchError((Object)view2);
        }
        return sparseVector;
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcF$sp(cm, zero);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix$mcF$sp(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDense$mcF$sp();
    }

    @Override
    public DenseMatrix<Object> toDense() {
        return this.toDense$mcF$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDense$mcF$sp() {
        void var2_2;
        ClassTag ctg = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data$mcF$sp());
        Matrix res = DenseMatrix$.MODULE$.zeros$mFc$sp(this.rows(), this.cols(), ctg, (Zero)this.evidence$1$mcF$sp);
        for (int i = 0; i < this.cols(); ++i) {
            for (int j = this.colPtrs()[i]; j < this.colPtrs()[i + 1]; ++j) {
                ((DenseMatrix)res).update$mcF$sp(this.rowIndices()[j], i, this.data$mcF$sp()[j]);
            }
        }
        return var2_2;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public CSCMatrix$mcF$sp(float[] _data$mcF$sp, int rows, int cols, int[] colPtrs, int used, int[] _rowIndices, Zero<Object> evidence$1$mcF$sp) {
        this._data$mcF$sp = _data$mcF$sp;
        this.evidence$1$mcF$sp = evidence$1$mcF$sp;
        this._rowIndices = _rowIndices;
        super(_data$mcF$sp, rows, cols, colPtrs, used, _rowIndices, evidence$1$mcF$sp);
    }

    public CSCMatrix$mcF$sp(float[] data$mcF$sp, int rows, int cols, int[] colPtrs, int[] rowIndices, Zero<Object> evidence$2$mcF$sp) {
        this(data$mcF$sp, rows, cols, colPtrs, data$mcF$sp.length, rowIndices, evidence$2$mcF$sp);
    }
}

