/*
 * Decompiled with CFR 0.152.
 */
package breeze.linalg;

import breeze.collection.compat.package$;
import breeze.linalg.Axis$_0$;
import breeze.linalg.Axis$_1$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Matrix;
import breeze.linalg.Matrix$mcI$sp;
import breeze.linalg.View;
import breeze.linalg.View$;
import breeze.linalg.View$Copy$;
import breeze.linalg.View$Prefer$;
import breeze.linalg.View$Require$;
import breeze.linalg.operators.HasOps$;
import breeze.storage.Zero;
import breeze.util.ArrayUtil$;
import breeze.util.ReflectionUtil$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Builder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class DenseMatrix$mcI$sp
extends DenseMatrix<Object>
implements Matrix$mcI$sp {
    public static final long serialVersionUID = 1L;
    public final int[] data$mcI$sp;

    @Override
    public int[] data$mcI$sp() {
        return this.data$mcI$sp;
    }

    public int[] data() {
        return this.data$mcI$sp();
    }

    @Override
    public int apply(int row, int col) {
        return this.apply$mcI$sp(row, col);
    }

    @Override
    public int apply$mcI$sp(int row, int col) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        return this.data()[this.linearIndex(trueRow, trueCol)];
    }

    @Override
    public void update(int row, int col, int v) {
        this.update$mcI$sp(row, col, v);
    }

    @Override
    public void update$mcI$sp(int row, int col, int v) {
        if (row < -this.rows() || row >= this.rows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        if (col < -this.cols() || col >= this.cols()) {
            throw new IndexOutOfBoundsException(new StringBuilder(19).append(new Tuple2.mcII.sp(row, col)).append(" not in [-").append(this.rows()).append(",").append(this.rows()).append(") x [-").append(this.cols()).append(",").append(this.cols()).append(")").toString());
        }
        int trueRow = row < 0 ? row + this.rows() : row;
        int trueCol = col < 0 ? col + this.cols() : col;
        this.data()[this.linearIndex((int)trueRow, (int)trueCol)] = v;
    }

    public int[] toArray() {
        return this.toArray$mcI$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray$mcI$sp() {
        int[] nArray;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (this.isContiguous() && !this.isTranspose()) {
            nArray = (int[])ArrayUtil$.MODULE$.copyOfRange(this.data(), this.offset(), this.offset() + this.size());
        } else {
            void var2_2;
            int[] ret = (int[])man.newArray(this.rows() * this.cols());
            int limit$macro$9 = this.cols();
            for (int index$macro$7 = 0; index$macro$7 < limit$macro$9; ++index$macro$7) {
                int limit$macro$4 = this.rows();
                for (int index$macro$2 = 0; index$macro$2 < limit$macro$4; ++index$macro$2) {
                    ((JFunction2.mcVII.sp & Serializable & scala.Serializable)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(i, j) -> {
                        ret$4[i * $this.rows() + j] = this.data()[this.linearIndex(j, i)];
                    }).apply$mcVII$sp(index$macro$7, index$macro$2);
                }
            }
            nArray = var2_2;
        }
        return nArray;
    }

    @Override
    public DenseVector<Object> toDenseVector() {
        return this.toDenseVector$mcI$sp();
    }

    @Override
    public DenseVector<Object> toDenseVector$mcI$sp() {
        return DenseVector$.MODULE$.apply$mIc$sp(this.toArray$mcI$sp());
    }

    @Override
    public DenseVector<Object> flatten(View view) {
        return this.flatten$mcI$sp(view);
    }

    @Override
    public DenseVector<Object> flatten$mcI$sp(View view) {
        DenseVector<Object> denseVector;
        block4: {
            View view2;
            while (true) {
                if (View$Require$.MODULE$.equals(view2 = view)) {
                    if (!this.breeze$linalg$DenseMatrix$$canFlattenView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    denseVector = DenseVector$.MODULE$.create(this.data(), this.offset(), 1, this.rows() * this.cols());
                    break block4;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    denseVector = this.toDenseVector$mcI$sp();
                    break block4;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this.breeze$linalg$DenseMatrix$$canFlattenView());
            }
            throw new MatchError((Object)view2);
        }
        return denseVector;
    }

    @Override
    public DenseMatrix<Object> reshape(int rows, int cols, View view) {
        return this.reshape$mcI$sp(rows, cols, view);
    }

    @Override
    public DenseMatrix<Object> reshape$mcI$sp(int rows, int cols, View view) {
        int _cols;
        block5: {
            View view2;
            while (true) {
                int right$macro$2;
                int left$macro$1;
                if ((left$macro$1 = rows * (_cols = cols)) != (right$macro$2 = this_.size())) {
                    throw new IllegalArgumentException(new StringBuilder(67).append("requirement failed: ").append(new StringOps(Predef$.MODULE$.augmentString("Cannot reshape a (%d,%d) matrix to a (%d,%d) matrix!")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this_.rows()), BoxesRunTime.boxToInteger((int)this_.cols()), BoxesRunTime.boxToInteger((int)rows), BoxesRunTime.boxToInteger((int)_cols)}))).append(": ").append("rows.*(_cols) == DenseMatrix.this.size (").append(left$macro$1).append(" ").append("!=").append(" ").append(right$macro$2).append(")").toString());
                }
                view2 = view;
                if (View$Require$.MODULE$.equals(view2)) {
                    if (!this_.breeze$linalg$DenseMatrix$$canReshapeView()) {
                        throw new UnsupportedOperationException("Cannot make a view of this matrix.");
                    }
                    break block5;
                }
                if (View$Copy$.MODULE$.equals(view2)) {
                    DenseMatrix$mcI$sp result = new DenseMatrix$mcI$sp(this_.rows(), this_.cols(), (int[])ArrayUtil$.MODULE$.newArrayLike(this_.data(), this_.size()));
                    result.$colon$eq(this_, HasOps$.MODULE$.setDMDM());
                    view = View$Require$.MODULE$;
                    cols = _cols;
                    DenseMatrix$mcI$sp this_ = result;
                    continue;
                }
                if (!View$Prefer$.MODULE$.equals(view2)) break;
                view = View$.MODULE$.viewPreferenceFromBoolean(this_.breeze$linalg$DenseMatrix$$canReshapeView());
            }
            throw new MatchError((Object)view2);
        }
        DenseMatrix$mcI$sp denseMatrix$mcI$sp = new DenseMatrix$mcI$sp(rows, _cols, this_.data(), this_.offset(), this_.isTranspose() ? cols : rows, this_.isTranspose());
        return denseMatrix$mcI$sp;
    }

    @Override
    public DenseMatrix<Object> repr() {
        return this.repr$mcI$sp();
    }

    @Override
    public DenseMatrix<Object> repr$mcI$sp() {
        return this;
    }

    @Override
    public int valueAt(int i) {
        return this.valueAt$mcI$sp(i);
    }

    @Override
    public int valueAt$mcI$sp(int i) {
        return this.data()[i];
    }

    @Override
    public int valueAt(int row, int col) {
        return this.valueAt$mcI$sp(row, col);
    }

    @Override
    public int valueAt$mcI$sp(int row, int col) {
        return this.apply$mcI$sp(row, col);
    }

    @Override
    public DenseMatrix<Object> toDenseMatrix(ClassTag<Object> cm, Zero<Object> zero) {
        return this.toDenseMatrix$mcI$sp(cm, zero);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> toDenseMatrix$mcI$sp(ClassTag<Object> cm, Zero<Object> zero) {
        void var3_3;
        Matrix result = DenseMatrix$.MODULE$.create$mIc$sp(this.rows(), this.cols(), (int[])cm.newArray(this.size()), (Zero)zero);
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.setDMDM());
        return var3_3;
    }

    @Override
    public DenseMatrix<Object> copy() {
        return this.copy$mcI$sp();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DenseMatrix<Object> copy$mcI$sp() {
        void var2_2;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        Matrix result = DenseMatrix$.MODULE$.create$mIc$sp(this.rows(), this.cols(), (int[])man.newArray(this.size()), this.breeze$linalg$DenseMatrix$$dontNeedZero());
        ((DenseMatrix)result).$colon$eq(this, HasOps$.MODULE$.setDMDM());
        return var2_2;
    }

    @Override
    public DenseMatrix<Object> delete(int row, Axis$_0$ axis) {
        return this.delete$mcI$sp(row, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcI$sp(int row, Axis$_0$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = row >= 0 && row < this.rows();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(92).append("requirement failed: ").append("row ").append(row).append(" is not in bounds: [0, ").append(this.rows()).append(")").append(": ").append("row.>=(0).&&(row.<(DenseMatrix.this.rows))").toString());
        }
        return row == 0 ? this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.rows()), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcI$sp() : (row == this.rows() - 1 ? this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.rows() - 1), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()).copy$mcI$sp() : DenseMatrix$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows()), this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(row + 1), this.rows()), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())}), HasOps$.MODULE$.setDMDM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(int col, Axis$_1$ axis) {
        return this.delete$mcI$sp(col, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcI$sp(int col, Axis$_1$ axis) {
        boolean cond$macro$1;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        boolean bl = cond$macro$1 = col >= 0 && col < this.cols();
        if (!cond$macro$1) {
            throw new IllegalArgumentException(new StringBuilder(92).append("requirement failed: ").append("col ").append(col).append(" is not in bounds: [0, ").append(this.cols()).append(")").append(": ").append("col.>=(0).&&(col.<(DenseMatrix.this.cols))").toString());
        }
        return col == 0 ? this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), this.cols()), HasOps$.MODULE$.canSliceCols()).copy$mcI$sp() : (col == this.cols() - 1 ? this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.cols() - 1), HasOps$.MODULE$.canSliceCols()).copy$mcI$sp() : DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), col), HasOps$.MODULE$.canSliceCols()), this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(col + 1), this.cols()), HasOps$.MODULE$.canSliceCols())}), Predef$.MODULE$.$conforms(), HasOps$.MODULE$.setDMDM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero()));
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> rows, Axis$_0$ axis) {
        return this.delete$mcI$sp(rows, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcI$sp(Seq<Object> rows, Axis$_0$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (rows.isEmpty()) {
            denseMatrix = this.copy$mcI$sp();
        } else if (rows.size() == 1) {
            denseMatrix = this.delete$mcI$sp(BoxesRunTime.unboxToInt((Object)rows.apply(0)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)rows.sorted((Ordering)Ordering.Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt((Object)sorted.head()) >= 0 && BoxesRunTime.unboxToInt((Object)sorted.last()) < this.rows();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(97).append("requirement failed: ").append("row ").append(rows).append(" are not in bounds: [0, ").append(this.rows()).append(")").append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.rows))").toString());
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$7.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$7.elem ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(last$7.elem), index), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
                last$7.elem = index + 1;
            });
            Object object = last.elem != this.rows() ? matrices.$plus$eq(this.apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(last.elem), this.rows()), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRows())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.vertcat((Seq)matrices.result(), HasOps$.MODULE$.setDMDM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public DenseMatrix<Object> delete(Seq<Object> cols, Axis$_1$ axis) {
        return this.delete$mcI$sp(cols, axis);
    }

    @Override
    public DenseMatrix<Object> delete$mcI$sp(Seq<Object> cols, Axis$_1$ axis) {
        DenseMatrix<Object> denseMatrix;
        ClassTag man = ReflectionUtil$.MODULE$.elemClassTagFromArray(this.data());
        if (cols.isEmpty()) {
            denseMatrix = this.copy$mcI$sp();
        } else if (cols.size() == 1) {
            denseMatrix = this.delete$mcI$sp(BoxesRunTime.unboxToInt((Object)cols.apply(0)), axis);
        } else {
            boolean cond$macro$1;
            Seq sorted = (Seq)cols.sorted((Ordering)Ordering.Int$.MODULE$);
            boolean bl = cond$macro$1 = BoxesRunTime.unboxToInt((Object)sorted.head()) >= 0 && BoxesRunTime.unboxToInt((Object)sorted.last()) < this.cols();
            if (!cond$macro$1) {
                throw new IllegalArgumentException(new StringBuilder(97).append("requirement failed: ").append("col ").append(cols).append(" are not in bounds: [0, ").append(this.cols()).append(")").append(": ").append("sorted.head.>=(0).&&(sorted.last.<(this.cols))").toString());
            }
            IntRef last = IntRef.create((int)0);
            Builder matrices = package$.MODULE$.arraySeqBuilder(ClassTag$.MODULE$.apply(DenseMatrix.class));
            sorted.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                boolean cond$macro$2;
                boolean bl = cond$macro$2 = index >= last$8.elem;
                if (!cond$macro$2) {
                    throw new AssertionError((Object)"assertion failed: index.>=(last)");
                }
                Object object = index != last$8.elem ? matrices.$plus$eq(this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(last$8.elem), index), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
                last$8.elem = index + 1;
            });
            Object object = last.elem != this.cols() ? matrices.$plus$eq(this.apply(scala.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(last.elem), this.cols()), HasOps$.MODULE$.canSliceCols())) : BoxedUnit.UNIT;
            denseMatrix = DenseMatrix$.MODULE$.horzcat((Seq)matrices.result(), Predef$.MODULE$.$conforms(), HasOps$.MODULE$.setDMDM(), man, this.breeze$linalg$DenseMatrix$$dontNeedZero());
        }
        return denseMatrix;
    }

    @Override
    public boolean overlaps(DenseMatrix<Object> other) {
        return this.overlaps$mcI$sp(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean overlaps$mcI$sp(DenseMatrix<Object> other) {
        if (this.data() != other.data$mcI$sp()) return false;
        int astart = this.offset();
        int aend = this.offset() + this.breeze$linalg$DenseMatrix$$footprint();
        int bstart = other.offset();
        int bend = other.offset() + other.breeze$linalg$DenseMatrix$$footprint();
        if (scala.package$.MODULE$.Range().apply(astart, aend).contains(bstart)) return true;
        if (scala.package$.MODULE$.Range().apply(astart, aend).contains(bend)) return true;
        if (scala.package$.MODULE$.Range().apply(bstart, bend).contains(astart)) return true;
        if (!scala.package$.MODULE$.Range().apply(bstart, bend).contains(aend)) return false;
        return true;
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    public DenseMatrix$mcI$sp(int rows, int cols, int[] data$mcI$sp, int offset, int majorStride, boolean isTranspose) {
        this.data$mcI$sp = data$mcI$sp;
        super(rows, cols, null, offset, majorStride, isTranspose);
        if (isTranspose && scala.math.package$.MODULE$.abs(majorStride) < cols && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than cols == ").append(cols).append(", which is impossible").toString());
        }
        if (!isTranspose && scala.math.package$.MODULE$.abs(majorStride) < rows && majorStride != 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(61).append("MajorStride == ").append(majorStride).append(" is smaller than rows == ").append(rows).append(", which is impossible").toString());
        }
        if (rows < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Rows must be larger than zero. It was ").append(rows).toString());
        }
        if (cols < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(38).append("Cols must be larger than zero. It was ").append(cols).toString());
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(new StringBuilder(40).append("Offset must be larger than zero. It was ").append(offset).toString());
        }
        if (majorStride > 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, cols - 1)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(Predef$.MODULE$.genericArrayOps(this.data()).size()).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
        } else if (majorStride < 0) {
            if (ScalaRunTime$.MODULE$.array_length(this.data()) < this.linearIndex(rows - 1, 0)) {
                throw new IndexOutOfBoundsException(new StringBuilder(57).append("Storage array has size ").append(Predef$.MODULE$.genericArrayOps(this.data()).size()).append(" but indices can grow as large as ").append(this.linearIndex(rows - 1, cols - 1)).toString());
            }
            if (this.linearIndex(0, cols - 1) < 0) {
                throw new IndexOutOfBoundsException(new StringBuilder(84).append("Storage array has negative stride ").append(majorStride).append(" and offset ").append(offset).append(" which can result in negative indices.").toString());
            }
        }
        DenseMatrix$.MODULE$.breeze$linalg$DenseMatrix$$init();
    }

    public DenseMatrix$mcI$sp(int rows, int cols, ClassTag<Object> man) {
        this(rows, cols, (int[])man.newArray(rows * cols), 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcI$sp(int rows, int cols, int[] data$mcI$sp, int offset) {
        this(rows, cols, data$mcI$sp, offset, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcI$sp(int rows, int cols, int[] data$mcI$sp) {
        this(rows, cols, data$mcI$sp, 0, rows, DenseMatrix$.MODULE$.$lessinit$greater$default$6());
    }

    public DenseMatrix$mcI$sp(int rows, int[] data$mcI$sp, int offset) {
        int left$macro$1 = data$mcI$sp.length % rows;
        boolean right$macro$2 = false;
        if (left$macro$1 != 0) {
            throw new AssertionError((Object)new StringBuilder(49).append("assertion failed: ").append("data.length.%(rows) == 0 (").append(left$macro$1).append(" ").append("!=").append(" ").append(0).append(")").toString());
        }
        this(rows, data$mcI$sp.length / rows, data$mcI$sp, offset);
    }
}

