/*
 * Decompiled with CFR 0.152.
 */
package org.specs.runner;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.specs.Specification;
import org.specs.runner.SpecsFilter;
import org.specs.runner.SpecsFilter$;
import org.specs.runner.SpecsFilterPatternException;
import org.specs.specification.Example;
import org.specs.specification.Sus;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public abstract class SpecsFilter$class {
    public static String susFilterPattern(SpecsFilter $this) {
        return ".*";
    }

    public static String exampleFilterPattern(SpecsFilter $this) {
        return ".*";
    }

    public static List filteredSpecs(SpecsFilter $this) {
        return $this.filter($this.specs());
    }

    public static Pattern susFilter(SpecsFilter $this) {
        return SpecsFilter$class.compilePattern($this, "sus", $this.susPattern());
    }

    public static Pattern exampleFilter(SpecsFilter $this) {
        return SpecsFilter$class.compilePattern($this, "example", $this.examplePattern());
    }

    private static Pattern compilePattern(SpecsFilter $this, String description, String pattern) {
        Pattern exceptionResult1 = null;
        try {
            exceptionResult1 = Pattern.compile(pattern);
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new SpecsFilterPatternException(description, patternSyntaxException);
        }
    }

    public static List filter(SpecsFilter $this, Seq specifications) {
        return ((TraversableOnce)specifications.flatMap((Function1)new SpecsFilter$.anonfun.filter.1($this), Seq$.MODULE$.canBuildFrom())).toList();
    }

    public static Option filter(SpecsFilter $this, Specification specification) {
        specification.subSpecifications_$eq(((List)specification.subSpecifications().flatMap((Function1)new SpecsFilter$.anonfun.filter.2($this), List$.MODULE$.canBuildFrom())).toList());
        specification.systemsList_$eq((List<Sus>)((List)specification.systemsList().flatMap((Function1)new SpecsFilter$.anonfun.filter.3($this), List$.MODULE$.canBuildFrom())).toList());
        return specification.subSpecifications().isEmpty() && specification.systems().isEmpty() ? None$.MODULE$ : new Some((Object)specification);
    }

    public static Option filter(SpecsFilter $this, Sus sus) {
        None$ none$;
        if ($this.susFilter().matcher(sus.description()).find()) {
            sus.examplesFilter_$eq((Function1<Example, Option<Example>>)new SpecsFilter$.anonfun.filter.4($this));
            none$ = new Some((Object)sus);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option filterExample(SpecsFilter $this, Example example) {
        return $this.exampleFilter().matcher(example.description()).find() ? new Some((Object)example) : None$.MODULE$;
    }

    public static String susPattern(SpecsFilter $this) {
        String string = System.getProperty("sus");
        return string == null ? $this.susFilterPattern() : string;
    }

    public static String examplePattern(SpecsFilter $this) {
        String string = System.getProperty("example");
        return string == null ? $this.exampleFilterPattern() : string;
    }

    public static void $init$(SpecsFilter $this) {
    }
}

