/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_executions;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven_executions.JavaMainCallerSupport;
import org_scala_tools_maven_executions.MainHelper;
import org_scala_tools_maven_executions.MainWithArgsInFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMainCallerByFork
extends JavaMainCallerSupport {
    private boolean _forceUseArgFile = false;
    private String _javaExec;
    private boolean _redirectToLog;

    public JavaMainCallerByFork(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args, boolean forceUseArgFile) throws Exception {
        super(requester, mainClassName, classpath, jvmArgs, args);
        for (String key : System.getenv().keySet()) {
            this.env.add(key + "=" + System.getenv(key));
        }
        this._javaExec = System.getProperty("java.home");
        if (this._javaExec == null) {
            this._javaExec = System.getenv("JAVA_HOME");
            if (this._javaExec == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
        }
        this._javaExec = this._javaExec + File.separator + "bin" + File.separator + "java";
        this._forceUseArgFile = forceUseArgFile;
    }

    @Override
    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        DefaultExecutor exec = new DefaultExecutor();
        if (!this._redirectToLog) {
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out));
        } else {
            exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)new LogOutputStream(){

                protected void processLine(String line, int level) {
                    if (line.toLowerCase().indexOf("error") > -1) {
                        JavaMainCallerByFork.this.requester.getLog().error((CharSequence)line);
                    } else if (line.toLowerCase().indexOf("warn") > -1) {
                        JavaMainCallerByFork.this.requester.getLog().warn((CharSequence)line);
                    } else {
                        JavaMainCallerByFork.this.requester.getLog().info((CharSequence)line);
                    }
                }
            }));
        }
        CommandLine cl = new CommandLine((String)cmd[0]);
        for (int i = 1; i < cmd.length; ++i) {
            cl.addArgument((String)cmd[i]);
        }
        try {
            int exitValue = exec.execute(cl);
            if (exitValue != 0) {
                if (throwFailure) {
                    throw new MojoFailureException("command line returned non-zero value:" + exitValue);
                }
                return false;
            }
            return true;
        }
        catch (ExecuteException exc) {
            if (throwFailure) {
                throw exc;
            }
            return false;
        }
    }

    @Override
    public void spawn(boolean displayCmd) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        pb.start();
    }

    protected String[] buildCommand() throws Exception {
        ArrayList<String> back = new ArrayList<String>(2 + this.jvmArgs.size() + this.args.size());
        back.add(this._javaExec);
        if (!this._forceUseArgFile && this.lengthOf(this.args, 1L) + this.lengthOf(this.jvmArgs, 1L) < 400L) {
            back.addAll(this.jvmArgs);
            back.add(this.mainClassName);
            back.addAll(this.args);
        } else {
            File jarPath = new File(MainHelper.locateJar(MainHelper.class));
            this.requester.getLog().debug((CharSequence)("plugin jar to add :" + jarPath));
            this.addToClasspath(jarPath);
            back.addAll(this.jvmArgs);
            back.add(MainWithArgsInFile.class.getName());
            back.add(this.mainClassName);
            back.add(MainHelper.createArgFile(this.args).getCanonicalPath());
        }
        return back.toArray(new String[back.size()]);
    }

    private long lengthOf(List<String> l, long sepLength) throws Exception {
        long back = 0L;
        for (String str : l) {
            back += (long)str.length() + sepLength;
        }
        return back;
    }

    @Override
    public void redirectToLog() {
        this._redirectToLog = true;
    }
}

