/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionNumber
implements Comparable<VersionNumber> {
    private static Pattern _regexp = Pattern.compile("(\\d+)\\.(\\d+)(\\.\\d+)?(-\\w+)?");
    public int major;
    public int minor;
    public int bugfix;
    public String modifier;

    public VersionNumber() {
    }

    public VersionNumber(String s) {
        Matcher match = _regexp.matcher(s);
        if (!match.find()) {
            throw new IllegalArgumentException("invalid versionNumber : major.minor(.bugfix)(-modifier) :" + s);
        }
        this.major = Integer.parseInt(match.group(1));
        this.minor = Integer.parseInt(match.group(2));
        if (match.group(3) != null && match.group(3).length() > 1) {
            this.bugfix = Integer.parseInt(match.group(3).substring(1));
        }
        if (match.group(4) != null && match.group(4).length() > 1) {
            this.modifier = match.group(4).substring(1);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.major).append('.').append(this.minor).append('.').append(this.bugfix);
        if (this.modifier != null && this.modifier.length() > 0) {
            str.append('-').append(this.modifier);
        }
        return str.toString();
    }

    @Override
    public int compareTo(VersionNumber o) {
        int back = 0;
        if (back == 0 && this.major > o.major) {
            back = 1;
        }
        if (back == 0 && this.major < o.major) {
            back = -1;
        }
        if (back == 0 && this.minor > o.minor) {
            back = 1;
        }
        if (back == 0 && this.minor < o.minor) {
            back = -1;
        }
        if (back == 0 && this.bugfix > o.bugfix) {
            back = 1;
        }
        if (back == 0 && this.bugfix < o.bugfix) {
            back = -1;
        }
        return back;
    }
}

