/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.LinkedList;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.CancelSentiels;
import sbt.CompletionService;
import sbt.CompletionService$;
import sbt.ConcurrentRestrictions;
import sbt.ConcurrentRestrictions$;
import sbt.internal.util.AttributeKey;
import sbt.internal.util.AttributeKey$;
import sbt.util.OptJsonWriter;
import sbt.util.OptJsonWriter$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;

public final class ConcurrentRestrictions$ {
    public static ConcurrentRestrictions$ MODULE$;
    public final WeakHashMap<CompletionService<?, ?>, Object> sbt$ConcurrentRestrictions$$completionServices;
    private final AttributeKey<Map<ConcurrentRestrictions.Tag, Object>> tagsKey;
    private final ConcurrentRestrictions.Tag Untagged;
    private final ConcurrentRestrictions.Tag All;
    private final Map<ConcurrentRestrictions.Tag, Object> TagMap;
    private final AtomicInteger poolID;

    static {
        new ConcurrentRestrictions$();
    }

    public void cancelAll() {
        ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.sbt$ConcurrentRestrictions$$completionServices.keySet()).asScala()).toVector().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConcurrentRestrictions$.$anonfun$cancelAll$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void cancelAllSentinels() {
        ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.sbt$ConcurrentRestrictions$$completionServices.keySet()).asScala()).toVector().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ConcurrentRestrictions$.$anonfun$cancelAllSentinels$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public <A> ConcurrentRestrictions<A> unrestricted() {
        return new ConcurrentRestrictions<A>(){

            public void empty() {
            }

            public void add(BoxedUnit g, A a) {
            }

            public void remove(BoxedUnit g, A a) {
            }

            public boolean valid(BoxedUnit g) {
                return true;
            }
        };
    }

    public <A> ConcurrentRestrictions<A> limitTotal(int i) {
        Predef$.MODULE$.assert(i >= 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Maximum must be at least 1 (was ").append(i).append(")").toString());
        return new ConcurrentRestrictions<A>(i){
            private final int i$1;

            public int empty() {
                return 0;
            }

            public int add(int g, A a) {
                return g + 1;
            }

            public int remove(int g, A a) {
                return g - 1;
            }

            public boolean valid(int g) {
                return g <= this.i$1;
            }
            {
                this.i$1 = i$1;
            }
        };
    }

    public AttributeKey<Map<ConcurrentRestrictions.Tag, Object>> tagsKey() {
        return this.tagsKey;
    }

    public ConcurrentRestrictions.Tag Untagged() {
        return this.Untagged;
    }

    public ConcurrentRestrictions.Tag All() {
        return this.All;
    }

    public Map<ConcurrentRestrictions.Tag, Object> TagMap() {
        return this.TagMap;
    }

    public <A> ConcurrentRestrictions<A> tagged(Function1<A, Map<ConcurrentRestrictions.Tag, Object>> get, Function1<Map<ConcurrentRestrictions.Tag, Object>, Object> validF) {
        return new ConcurrentRestrictions<A>(get, validF){
            private final Function1 get$1;
            private final Function1 validF$1;

            public Map<ConcurrentRestrictions.Tag, Nothing$> empty() {
                return Predef$.MODULE$.Map().empty();
            }

            public Map<ConcurrentRestrictions.Tag, Object> add(Map<ConcurrentRestrictions.Tag, Object> g, A a) {
                return ConcurrentRestrictions$.MODULE$.sbt$ConcurrentRestrictions$$merge(g, a, this.get$1, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$1, x$2) -> x$1 + x$2);
            }

            public Map<ConcurrentRestrictions.Tag, Object> remove(Map<ConcurrentRestrictions.Tag, Object> g, A a) {
                return ConcurrentRestrictions$.MODULE$.sbt$ConcurrentRestrictions$$merge(g, a, this.get$1, (Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 - x$4);
            }

            public boolean valid(Map<ConcurrentRestrictions.Tag, Object> g) {
                return BoxesRunTime.unboxToBoolean((Object)this.validF$1.apply(g));
            }
            {
                this.get$1 = get$1;
                this.validF$1 = validF$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$add$1(int int ), $anonfun$remove$1(int int )}, serializedLambda);
            }
        };
    }

    public <A> Map<ConcurrentRestrictions.Tag, Object> sbt$ConcurrentRestrictions$$merge(Map<ConcurrentRestrictions.Tag, Object> m, A a, Function1<A, Map<ConcurrentRestrictions.Tag, Object>> get, Function2<Object, Object, Object> f) {
        Map aTags = (Map)get.apply(a);
        Map<ConcurrentRestrictions.Tag, Object> base = this.merge(m, aTags, f);
        Map<ConcurrentRestrictions.Tag, Object> un = aTags.isEmpty() ? this.update(base, this.Untagged(), BoxesRunTime.boxToInteger((int)1), f) : base;
        return this.update(un, this.All(), BoxesRunTime.boxToInteger((int)1), f);
    }

    private <A, B> Map<A, B> update(Map<A, B> m, A a, B b, Function2<B, B, B> f) {
        Object object;
        Option option = m.get(a);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object bv = some.value();
            object = f.apply(bv, b);
        } else if (None$.MODULE$.equals(option)) {
            object = b;
        } else {
            throw new MatchError((Object)option);
        }
        B newb = object;
        return m.updated(a, newb);
    }

    private <A, B> Map<A, B> merge(Map<A, B> m, Map<A, B> n, Function2<B, B, B> f) {
        return (Map)n.foldLeft(m, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Map acc;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    acc = (Map)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Object a = tuple2._1();
            Object b = tuple2._2();
            Map<Object, Object> map = MODULE$.update(acc, a, b, f);
            return map;
        });
    }

    public <A, R> Tuple2<CompletionService<A, R>, Function0<BoxedUnit>> completionService(ConcurrentRestrictions<A> tags, Function1<String, BoxedUnit> warn) {
        int id = this.poolID.getAndIncrement();
        AtomicInteger i = new AtomicInteger(1);
        ExecutorService pool = Executors.newCachedThreadPool(r -> new Thread(r, new StringBuilder(29).append("sbt-completion-service-pool-").append(id).append("-").append(i.getAndIncrement()).toString()));
        CompletionService<A, R> service = this.completionService(pool, tags, warn);
        return new Tuple2(service, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> pool.shutdownNow());
    }

    public <A, R> Tuple2<CompletionService<A, R>, Function0<BoxedUnit>> completionService(ConcurrentRestrictions<A> tags, Function1<String, BoxedUnit> warn, Function1<A, Object> isSentinel) {
        ExecutorService pool = Executors.newCachedThreadPool();
        CompletionService<A, R> service = this.completionService(pool, tags, warn, isSentinel);
        return new Tuple2(service, (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> pool.shutdownNow());
    }

    public <A, R> Tuple2<CompletionService<A, R>, Function1<Object, BoxedUnit>> cancellableCompletionService(ConcurrentRestrictions<A> tags, Function1<String, BoxedUnit> warn, Function1<A, Object> isSentinel) {
        ExecutorService pool = Executors.newCachedThreadPool();
        CompletionService service = this.completionService(pool, tags, warn, isSentinel);
        return new Tuple2(service, (Function1 & Serializable & scala.Serializable)force -> {
            ConcurrentRestrictions$.$anonfun$cancellableCompletionService$1(service, pool, BoxesRunTime.unboxToBoolean((Object)force));
            return BoxedUnit.UNIT;
        });
    }

    public <A, R> CompletionService<A, R> completionService(Executor backing, ConcurrentRestrictions<A> tags, Function1<String, BoxedUnit> warn) {
        return this.completionService(backing, tags, warn, (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ConcurrentRestrictions$.$anonfun$completionService$4(x$5)));
    }

    public <A, R> CompletionService<A, R> completionService(Executor backing, ConcurrentRestrictions<A> tags, Function1<String, BoxedUnit> warn, Function1<A, Object> isSentinel) {
        return new CompletionService<A, R>(backing, tags, isSentinel, warn){
            private final AtomicBoolean closed;
            private final ExecutorCompletionService<R> jservice;
            private Object tagState;
            private int running;
            private final LinkedList<ConcurrentRestrictions.Enqueue.1> pending;
            private final ListBuffer<Future<?>> sentinels;
            private final ConcurrentRestrictions tags$1;
            private final Function1 isSentinel$1;
            private final Function1 warn$1;

            public void close() {
                block0: {
                    if (!this.closed.compareAndSet(false, true)) break block0;
                    ConcurrentRestrictions$.MODULE$.sbt$ConcurrentRestrictions$$completionServices.remove(this);
                }
            }

            public void cancelSentinels() {
                this.sentinels.toList().foreach((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)anon.4.$anonfun$cancelSentinels$1(s)));
                this.sentinels.clear();
            }

            public synchronized void submit(A node, Function0<R> work) {
                ListBuffer listBuffer;
                if (this.closed.get()) {
                    throw new RejectedExecutionException();
                }
                if (BoxesRunTime.unboxToBoolean((Object)this.isSentinel$1.apply(node))) {
                    listBuffer = this.sentinels.$plus$eq(CompletionService$.MODULE$.submitFuture(work, this.jservice));
                } else {
                    Object newState = this.tags$1.add(this.tagState, node);
                    if (this.tags$1.valid(newState)) {
                        this.tagState = newState;
                        this.submitValid(node, work);
                    } else {
                        if (this.running == 0) {
                            this.errorAddingToIdle();
                        }
                        public final class Sbt_ConcurrentRestrictions$Enqueue$1 {
                            private final A node;
                            private final Function0<R> work;

                            public A node() {
                                return this.node;
                            }

                            public Function0<R> work() {
                                return this.work;
                            }

                            public Sbt_ConcurrentRestrictions$Enqueue$1(A node, Function0<R> work) {
                                this.node = node;
                                this.work = work;
                            }
                        }
                        this.pending.add(new Sbt_ConcurrentRestrictions$Enqueue$1(node, work));
                    }
                    listBuffer = BoxedUnit.UNIT;
                }
            }

            private void submitValid(A node, Function0<R> work) {
                ++this.running;
                Function0 & Serializable & scala.Serializable wrappedWork = (Function0 & Serializable & scala.Serializable)() -> {
                    Object object;
                    try {
                        object = work.apply();
                    }
                    finally {
                        this.cleanup(node);
                    }
                    return object;
                };
                CompletionService$.MODULE$.submitFuture(wrappedWork, this.jservice);
            }

            private synchronized void cleanup(A node) {
                --this.running;
                this.tagState = this.tags$1.remove(this.tagState, node);
                if (!this.tags$1.valid(this.tagState)) {
                    this.warn$1.apply((Object)"Invalid restriction: removing a completed node from a valid system must result in a valid system.");
                }
                this.submitValid(new LinkedList<ConcurrentRestrictions.Enqueue.1>());
            }

            private void errorAddingToIdle() {
                this.warn$1.apply((Object)"Invalid restriction: adding a node to an idle system must be allowed.");
            }

            private void submitValid(Queue<ConcurrentRestrictions.Enqueue.1> tried) {
                while (true) {
                    if (this.pending.isEmpty()) {
                        BoxedUnit boxedUnit;
                        if (!tried.isEmpty()) {
                            if (this.running == 0) {
                                this.errorAddingToIdle();
                            }
                            this.pending.addAll(tried);
                            boxedUnit = BoxedUnit.UNIT;
                            break;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        break;
                    }
                    Sbt_ConcurrentRestrictions$Enqueue$1 next = this.pending.remove();
                    Object newState = this.tags$1.add(this.tagState, next.node());
                    if (this.tags$1.valid(newState)) {
                        this.tagState = newState;
                        this.submitValid(next.node(), next.work());
                        continue;
                    }
                    tried.add(next);
                }
            }

            public R take() {
                if (this.closed.get()) {
                    throw new RejectedExecutionException("Tried to get values for a closed completion service");
                }
                return this.jservice.take().get();
            }

            public static final /* synthetic */ boolean $anonfun$cancelSentinels$1(Future s) {
                return s.cancel(true);
            }
            {
                this.tags$1 = tags$1;
                this.isSentinel$1 = isSentinel$1;
                this.warn$1 = warn$1;
                ConcurrentRestrictions$.MODULE$.sbt$ConcurrentRestrictions$$completionServices.put(this, BoxesRunTime.boxToBoolean((boolean)true));
                this.closed = new AtomicBoolean(false);
                this.jservice = new ExecutorCompletionService<V>(backing$1);
                this.tagState = tags$1.empty();
                this.running = 0;
                this.pending = new LinkedList<E>();
                this.sentinels = (ListBuffer)ListBuffer$.MODULE$.empty();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$cancelSentinels$1$adapted(java.util.concurrent.Future ), $anonfun$submitValid$1(sbt.ConcurrentRestrictions$$anon$4 scala.Function0 java.lang.Object )}, serializedLambda);
            }
        };
    }

    public static final /* synthetic */ void $anonfun$cancelAll$1(CompletionService x0$1) {
        CompletionService completionService = x0$1;
        if (completionService instanceof AutoCloseable) {
            AutoCloseable autoCloseable = (AutoCloseable)((Object)completionService);
            autoCloseable.close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$cancelAllSentinels$1(CompletionService x0$1) {
        CompletionService completionService = x0$1;
        if (completionService instanceof CancelSentiels) {
            CancelSentiels cancelSentiels = (CancelSentiels)((Object)completionService);
            cancelSentiels.cancelSentinels();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$cancellableCompletionService$1(CompletionService service$1, ExecutorService pool$3, boolean force) {
        if (force) {
            ((AutoCloseable)((Object)service$1)).close();
        }
        pool$3.shutdownNow();
    }

    public static final /* synthetic */ boolean $anonfun$completionService$4(Object x$5) {
        return false;
    }

    private ConcurrentRestrictions$() {
        MODULE$ = this;
        this.sbt$ConcurrentRestrictions$$completionServices = new WeakHashMap();
        this.tagsKey = AttributeKey$.MODULE$.apply("tags", "Attributes restricting concurrent execution of tasks.", ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(ConcurrentRestrictions.Tag.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.Int()})), (OptJsonWriter)OptJsonWriter$.MODULE$.fallback());
        this.Untagged = new ConcurrentRestrictions.Tag("untagged");
        this.All = new ConcurrentRestrictions.Tag("all");
        this.TagMap = Predef$.MODULE$.Map().empty();
        this.poolID = new AtomicInteger(1);
    }
}

