/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.RelativeUrlResolver;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.CacheDownloadOptions;
import org.apache.ivy.core.cache.CacheMetadataOptions;
import org.apache.ivy.core.cache.DownloadListener;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.event.download.EndArtifactDownloadEvent;
import org.apache.ivy.core.event.download.NeedArtifactEvent;
import org.apache.ivy.core.event.download.StartArtifactDownloadEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.settings.Validatable;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.ResolverSettings;
import org.apache.ivy.plugins.resolver.util.HasLatestStrategy;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Message;

public abstract class AbstractResolver
implements Validatable,
DependencyResolver,
HasLatestStrategy {
    private Boolean validate = null;
    private String name;
    private ResolverSettings settings;
    private EventManager eventManager = null;
    private LatestStrategy latestStrategy;
    private String latestStrategyName;
    private Namespace namespace;
    private String namespaceName;
    private String cacheManagerName;
    private RepositoryCacheManager repositoryCacheManager;
    private String changingMatcherName;
    private String changingPattern;
    private Boolean checkmodified;

    public ResolverSettings getSettings() {
        return this.settings;
    }

    public ParserSettings getParserSettings() {
        return new ResolverParserSettings();
    }

    @Override
    public void setSettings(ResolverSettings resolverSettings) {
        this.settings = resolverSettings;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected boolean doValidate(ResolveData resolveData) {
        if (this.validate != null) {
            return this.validate;
        }
        return resolveData.isValidate();
    }

    protected void checkInterrupted() {
        IvyContext.getContext().getIvy().checkInterrupted();
    }

    @Override
    public void reportFailure() {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    @Override
    public void reportFailure(Artifact artifact) {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void dumpSettings() {
        Message.verbose("\t" + this.getName() + " [" + this.getTypeName() + "]");
        Message.debug("\t\tcache: " + this.cacheManagerName);
    }

    public String getTypeName() {
        return this.getClass().getName();
    }

    @Override
    public ArtifactOrigin locate(Artifact object) {
        DownloadReport downloadReport = this.download(new Artifact[]{object}, new DownloadOptions());
        if (downloadReport == null) {
            throw new IllegalStateException("null download report returned by " + this.getName() + " (" + this.getClass().getName() + ") when trying to download " + object);
        }
        if (((ArtifactDownloadReport)(object = downloadReport.getArtifactReport((Artifact)object))).getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        return ((ArtifactDownloadReport)object).getArtifactOrigin();
    }

    @Override
    public LatestStrategy getLatestStrategy() {
        if (this.latestStrategy == null) {
            this.initLatestStrategyFromSettings();
        }
        return this.latestStrategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initLatestStrategyFromSettings() {
        if (this.getSettings() == null) throw new IllegalStateException("no ivy instance found: impossible to get a latest strategy without ivy instance");
        if (this.latestStrategyName != null && !"default".equals(this.latestStrategyName)) {
            this.latestStrategy = this.getSettings().getLatestStrategy(this.latestStrategyName);
            if (this.latestStrategy != null) return;
            throw new IllegalStateException("unknown latest strategy '" + this.latestStrategyName + "'");
        }
        this.latestStrategy = this.getSettings().getDefaultLatestStrategy();
        Message.debug(this.getName() + ": no latest strategy defined: using default");
    }

    @Override
    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this.latestStrategy = latestStrategy;
    }

    @Override
    public String getLatest() {
        if (this.latestStrategyName == null) {
            this.latestStrategyName = "default";
        }
        return this.latestStrategyName;
    }

    public Namespace getNamespace() {
        if (this.namespace == null) {
            this.initNamespaceFromSettings();
        }
        return this.namespace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initNamespaceFromSettings() {
        if (this.getSettings() != null) {
            if (this.namespaceName != null) {
                this.namespace = this.getSettings().getNamespace(this.namespaceName);
                if (this.namespace != null) return;
                throw new IllegalStateException("unknown namespace '" + this.namespaceName + "'");
            }
            this.namespace = this.getSettings().getSystemNamespace();
            Message.debug(this.getName() + ": no namespace defined: using system");
            return;
        }
        Message.verbose(this.getName() + ": no namespace defined nor ivy instance: using system namespace");
        this.namespace = Namespace.SYSTEM_NAMESPACE;
    }

    protected ModuleDescriptor toSystem(ModuleDescriptor moduleDescriptor) {
        return NameSpaceHelper.toSystem(moduleDescriptor, this.getNamespace());
    }

    protected Artifact fromSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getFromSystemTransformer());
    }

    protected Artifact toSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getToSystemTransformer());
    }

    protected MetadataArtifactDownloadReport toSystem(MetadataArtifactDownloadReport metadataArtifactDownloadReport) {
        return NameSpaceHelper.transform(metadataArtifactDownloadReport, this.getNamespace().getToSystemTransformer());
    }

    protected ModuleRevisionId toSystem(ModuleRevisionId moduleRevisionId) {
        return this.getNamespace().getToSystemTransformer().transform(moduleRevisionId);
    }

    protected DependencyDescriptor fromSystem(DependencyDescriptor dependencyDescriptor) {
        return NameSpaceHelper.transform(dependencyDescriptor, this.getNamespace().getFromSystemTransformer(), true);
    }

    protected DependencyDescriptor toSystem(DependencyDescriptor dependencyDescriptor) {
        return NameSpaceHelper.transform(dependencyDescriptor, this.getNamespace().getToSystemTransformer(), true);
    }

    protected ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        return this.findModuleInCache(dependencyDescriptor, resolveData, false);
    }

    protected ResolvedModuleRevision findModuleInCache(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, boolean bl) {
        DependencyDescriptor dependencyDescriptor2 = dependencyDescriptor;
        ResolvedModuleRevision resolvedModuleRevision = this.getRepositoryCacheManager().findModuleInCache(dependencyDescriptor2, dependencyDescriptor2.getDependencyRevisionId(), this.getCacheOptions(resolveData), bl ? null : this.getName());
        if (resolvedModuleRevision == null) {
            return null;
        }
        if (resolveData.getReport() != null) {
            ResolveData resolveData2 = resolveData;
            if (resolveData2.isBlacklisted(resolveData2.getReport().getConfiguration(), resolvedModuleRevision.getId())) {
                Message.verbose("\t" + this.getName() + ": found revision in cache: " + resolvedModuleRevision.getId() + " for " + dependencyDescriptor + ", but it is blacklisted");
                return null;
            }
        }
        return resolvedModuleRevision;
    }

    public void setChangingMatcher(String string) {
        this.changingMatcherName = string;
    }

    protected String getChangingMatcherName() {
        return this.changingMatcherName;
    }

    public void setChangingPattern(String string) {
        this.changingPattern = string;
    }

    protected String getChangingPattern() {
        return this.changingPattern;
    }

    @Override
    public RepositoryCacheManager getRepositoryCacheManager() {
        if (this.repositoryCacheManager == null) {
            this.initRepositoryCacheManagerFromSettings();
        }
        return this.repositoryCacheManager;
    }

    private void initRepositoryCacheManagerFromSettings() {
        if (this.cacheManagerName == null) {
            this.repositoryCacheManager = this.settings.getDefaultRepositoryCacheManager();
            if (this.repositoryCacheManager == null) {
                throw new IllegalStateException("no default cache manager defined with current settings");
            }
        } else {
            this.repositoryCacheManager = this.settings.getRepositoryCacheManager(this.cacheManagerName);
            if (this.repositoryCacheManager == null) {
                throw new IllegalStateException("unknown cache manager '" + this.cacheManagerName + "'. Available caches are " + Arrays.asList(this.settings.getRepositoryCacheManagers()));
            }
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public void validate() {
        this.initRepositoryCacheManagerFromSettings();
        this.initNamespaceFromSettings();
        this.initLatestStrategyFromSettings();
    }

    protected CacheMetadataOptions getCacheOptions(ResolveData resolveData) {
        AbstractResolver abstractResolver = this;
        return (CacheMetadataOptions)new CacheMetadataOptions().setChangingMatcherName(this.getChangingMatcherName()).setChangingPattern(this.getChangingPattern()).setCheckTTL(!resolveData.getOptions().isUseCacheOnly()).setCheckmodified(resolveData.getOptions().isUseCacheOnly() ? Boolean.FALSE : this.checkmodified).setValidate(this.doValidate(resolveData)).setNamespace(this.getNamespace()).setUseCacheOnly(resolveData.getOptions().isUseCacheOnly()).setForce(resolveData.getOptions().isRefresh()).setListener(abstractResolver.getDownloadListener(abstractResolver.getDownloadOptions(resolveData.getOptions())));
    }

    protected CacheDownloadOptions getCacheDownloadOptions(DownloadOptions downloadOptions) {
        return new CacheDownloadOptions().setListener(this.getDownloadListener(downloadOptions));
    }

    protected DownloadOptions getDownloadOptions(ResolveOptions resolveOptions) {
        return (DownloadOptions)new DownloadOptions().setLog(resolveOptions.getLog());
    }

    private DownloadListener getDownloadListener(final DownloadOptions downloadOptions) {
        return new DownloadListener(){

            @Override
            public void needArtifact(RepositoryCacheManager repositoryCacheManager, Artifact artifact) {
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new NeedArtifactEvent(AbstractResolver.this, artifact));
                }
            }

            @Override
            public void startArtifactDownload(RepositoryCacheManager repositoryCacheManager, ResolvedResource resolvedResource, Artifact artifact, ArtifactOrigin artifactOrigin) {
                if (artifact.isMetadata() || "quiet".equals(downloadOptions.getLog())) {
                    Message.verbose("downloading " + resolvedResource.getResource() + " ...");
                } else {
                    Message.info("downloading " + resolvedResource.getResource() + " ...");
                }
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new StartArtifactDownloadEvent(AbstractResolver.this, artifact, artifactOrigin));
                }
            }

            @Override
            public void endArtifactDownload(RepositoryCacheManager repositoryCacheManager, Artifact artifact, ArtifactDownloadReport artifactDownloadReport, File file) {
                if (AbstractResolver.this.eventManager != null) {
                    AbstractResolver.this.eventManager.fireIvyEvent(new EndArtifactDownloadEvent(AbstractResolver.this, artifact, artifactDownloadReport, file));
                }
            }
        };
    }

    protected boolean isAfter(ResolvedModuleRevision artifactInfoArray, ResolvedModuleRevision resolvedModuleRevision, Date date) {
        artifactInfoArray = new ArtifactInfo[]{new ChainResolver.ResolvedModuleRevisionArtifactInfo((ResolvedModuleRevision)artifactInfoArray), new ChainResolver.ResolvedModuleRevisionArtifactInfo(resolvedModuleRevision)};
        return this.getLatestStrategy().findLatest(artifactInfoArray, date) == artifactInfoArray[0];
    }

    protected ResolvedModuleRevision checkLatest(DependencyDescriptor dependencyDescriptor, ResolvedModuleRevision resolvedModuleRevision, ResolveData resolveData) {
        Checks.checkNotNull(dependencyDescriptor, "dd");
        Checks.checkNotNull(resolveData, "data");
        ResolvedModuleRevision resolvedModuleRevision2 = resolveData.getCurrentResolvedModuleRevision();
        String string = this.describe(resolvedModuleRevision);
        Message.debug("\tchecking " + string + " against " + this.describe(resolvedModuleRevision2));
        if (resolvedModuleRevision2 == null) {
            Message.debug("\tmodule revision kept as first found: " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        if (this.isAfter(resolvedModuleRevision, resolvedModuleRevision2, resolveData.getDate())) {
            Message.debug("\tmodule revision kept as younger: " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        if (!resolvedModuleRevision.getDescriptor().isDefault() && resolvedModuleRevision2.getDescriptor().isDefault()) {
            Message.debug("\tmodule revision kept as better (not default): " + string);
            this.saveModuleRevisionIfNeeded(dependencyDescriptor, resolvedModuleRevision);
            return resolvedModuleRevision;
        }
        Message.debug("\tmodule revision discarded as older: " + string);
        return resolvedModuleRevision2;
    }

    protected void saveModuleRevisionIfNeeded(DependencyDescriptor dependencyDescriptor, ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision != null && this.getSettings().getVersionMatcher().isDynamic(dependencyDescriptor.getDependencyRevisionId())) {
            this.getRepositoryCacheManager().saveResolvedRevision(dependencyDescriptor.getDependencyRevisionId(), resolvedModuleRevision.getId().getRevision());
        }
    }

    private String describe(ResolvedModuleRevision resolvedModuleRevision) {
        if (resolvedModuleRevision == null) {
            return "[none]";
        }
        return resolvedModuleRevision.getId() + (resolvedModuleRevision.getDescriptor().isDefault() ? "[default]" : "") + " from " + resolvedModuleRevision.getResolver().getName();
    }

    private class ResolverParserSettings
    implements ParserSettings {
        private ResolverParserSettings() {
        }

        @Override
        public ConflictManager getConflictManager(String string) {
            return AbstractResolver.this.getSettings().getConflictManager(string);
        }

        @Override
        public Namespace getContextNamespace() {
            return AbstractResolver.this.getNamespace();
        }

        @Override
        public PatternMatcher getMatcher(String string) {
            return AbstractResolver.this.getSettings().getMatcher(string);
        }

        @Override
        public Namespace getNamespace(String string) {
            return AbstractResolver.this.getSettings().getNamespace(string);
        }

        @Override
        public RelativeUrlResolver getRelativeUrlResolver() {
            return AbstractResolver.this.getSettings().getRelativeUrlResolver();
        }

        @Override
        public ResolutionCacheManager getResolutionCacheManager() {
            return AbstractResolver.this.getSettings().getResolutionCacheManager();
        }

        @Override
        public DependencyResolver getResolver(ModuleRevisionId moduleRevisionId) {
            return AbstractResolver.this.getSettings().getResolver(moduleRevisionId);
        }

        @Override
        public StatusManager getStatusManager() {
            return AbstractResolver.this.getSettings().getStatusManager();
        }

        @Override
        public File resolveFile(String string) {
            return AbstractResolver.this.getSettings().resolveFile(string);
        }

        @Override
        public String substitute(String string) {
            return AbstractResolver.this.getSettings().substitute(string);
        }
    }
}

