/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.UncheckedIOException;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;

public final class CharacterReader {
    private char[] charBuf;
    private Reader reader;
    private int bufLength;
    private int bufSplitPoint;
    private int bufPos;
    private int readerPos;
    private int bufMark = -1;
    private String[] stringCache = new String[512];
    private boolean readFully;

    /*
     * WARNING - void declaration
     */
    public CharacterReader(Reader input, int sz) {
        void var2_2;
        void var1_1;
        Validate.notNull(input);
        Validate.isTrue(input.markSupported());
        this.reader = var1_1;
        this.charBuf = new char[sz > 32768 ? 32768 : var2_2];
        this.bufferUp();
    }

    /*
     * WARNING - void declaration
     */
    public CharacterReader(Reader input) {
        this((Reader)var1_1, 32768);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CharacterReader(String input) {
        this(new StringReader(input), var1_1.length());
        void var1_1;
    }

    public final void close() {
        if (this.reader == null) {
            return;
        }
        try {
            this.reader.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            this.reader = null;
            this.charBuf = null;
            this.stringCache = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void bufferUp() {
        int offset;
        int pos;
        if (this.readFully || this.bufPos < this.bufSplitPoint) {
            return;
        }
        if (this.bufMark != -1) {
            pos = this.bufMark;
            offset = this.bufPos - this.bufMark;
        } else {
            pos = this.bufPos;
            offset = 0;
        }
        try {
            int read;
            int thisRead;
            long skipped = this.reader.skip(pos);
            this.reader.mark(32768);
            for (read = 0; read <= 1024; read += thisRead) {
                thisRead = this.reader.read(this.charBuf, read, this.charBuf.length - read);
                if (thisRead == -1) {
                    this.readFully = true;
                }
                if (thisRead <= 0) break;
            }
            this.reader.reset();
            if (read > 0) {
                void var2_2;
                void var1_1;
                Validate.isTrue(skipped == (long)pos);
                this.bufLength = read;
                this.readerPos += var1_1;
                this.bufPos = var2_2;
                if (this.bufMark != -1) {
                    this.bufMark = 0;
                }
                this.bufSplitPoint = this.bufLength > 24576 ? 24576 : this.bufLength;
            }
            return;
        }
        catch (IOException e) {
            void var3_4;
            throw new UncheckedIOException((IOException)var3_4);
        }
    }

    public final int pos() {
        return this.readerPos + this.bufPos;
    }

    public final boolean isEmpty() {
        this.bufferUp();
        return this.bufPos >= this.bufLength;
    }

    private boolean isEmptyNoBufferUp() {
        return this.bufPos >= this.bufLength;
    }

    public final char current() {
        this.bufferUp();
        if (this.isEmptyNoBufferUp()) {
            return '\uffff';
        }
        return this.charBuf[this.bufPos];
    }

    /*
     * WARNING - void declaration
     */
    final char consume() {
        void var1_1;
        this.bufferUp();
        int val = this.isEmptyNoBufferUp() ? 65535 : this.charBuf[this.bufPos];
        ++this.bufPos;
        return (char)var1_1;
    }

    final void unconsume() {
        if (this.bufPos <= 0) {
            throw new UncheckedIOException(new IOException("No buffer left to unconsume"));
        }
        --this.bufPos;
    }

    public final void advance() {
        ++this.bufPos;
    }

    final void mark() {
        if (this.bufLength - this.bufPos < 1024) {
            this.bufSplitPoint = 0;
        }
        this.bufferUp();
        this.bufMark = this.bufPos;
    }

    final void unmark() {
        this.bufMark = -1;
    }

    final void rewindToMark() {
        if (this.bufMark == -1) {
            throw new UncheckedIOException(new IOException("Mark invalid"));
        }
        this.bufPos = this.bufMark;
        this.unmark();
    }

    final int nextIndexOf(char c) {
        this.bufferUp();
        for (int i = this.bufPos; i < this.bufLength; ++i) {
            if (c != this.charBuf[i]) continue;
            return i - this.bufPos;
        }
        return -1;
    }

    final int nextIndexOf(CharSequence seq) {
        this.bufferUp();
        char startChar = seq.charAt(0);
        for (int offset = this.bufPos; offset < this.bufLength; ++offset) {
            if (startChar != this.charBuf[offset]) {
                while (++offset < this.bufLength && startChar != this.charBuf[offset]) {
                }
            }
            int i = offset + 1;
            int last = i + seq.length() - 1;
            if (offset >= this.bufLength || last > this.bufLength) continue;
            int j = 1;
            while (i < last && seq.charAt(j) == this.charBuf[i]) {
                ++i;
                ++j;
            }
            if (i != last) continue;
            return offset - this.bufPos;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public final String consumeTo(char c) {
        int offset = this.nextIndexOf(c);
        if (offset != -1) {
            void var2_2;
            void var1_1;
            String consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += var1_1;
            return var2_2;
        }
        return this.consumeToEnd();
    }

    /*
     * WARNING - void declaration
     */
    final String consumeTo(String seq) {
        void var2_4;
        void var1_2;
        String consumed;
        int offset = this.nextIndexOf(seq);
        if (offset != -1) {
            consumed = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, offset);
            this.bufPos += offset;
            return consumed;
        }
        if (this.bufLength - this.bufPos < consumed.length()) {
            return this.consumeToEnd();
        }
        int endPos = this.bufLength - consumed.length() + 1;
        int n = this.bufPos;
        String consumed2 = CharacterReader.cacheString(this.charBuf, this.stringCache, n, endPos - n);
        this.bufPos = var1_2;
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public final String consumeToAny(char ... chars) {
        int pos;
        this.bufferUp();
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        int charLen = chars.length;
        block0: while (pos < remaining) {
            for (int i = 0; i < charLen; ++i) {
                if (val[pos] == chars[i]) break block0;
            }
            ++pos;
        }
        this.bufPos = pos;
        if (pos > start) {
            void var3_3;
            void var2_2;
            return CharacterReader.cacheString(this.charBuf, this.stringCache, start, (int)(var2_2 - var3_3));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    final String consumeToAnySorted(char ... chars) {
        int pos;
        this.bufferUp();
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        while (pos < remaining && Arrays.binarySearch(chars, val[pos]) < 0) {
            ++pos;
        }
        this.bufPos = pos;
        if (this.bufPos > start) {
            void var3_3;
            void var2_2;
            return CharacterReader.cacheString(this.charBuf, this.stringCache, start, (int)(var2_2 - var3_3));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    final String consumeData() {
        int pos;
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos < remaining) {
            switch (val[pos]) {
                case '\u0000': 
                case '&': 
                case '<': {
                    break block3;
                }
                default: {
                    ++pos;
                    continue block3;
                }
            }
        }
        this.bufPos = pos;
        if (pos > start) {
            void var2_2;
            void var1_1;
            return CharacterReader.cacheString(this.charBuf, this.stringCache, start, (int)(var1_1 - var2_2));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    final String consumeRawData() {
        int pos;
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos < remaining) {
            switch (val[pos]) {
                case '\u0000': 
                case '<': {
                    break block3;
                }
                default: {
                    ++pos;
                    continue block3;
                }
            }
        }
        this.bufPos = pos;
        if (pos > start) {
            void var2_2;
            void var1_1;
            return CharacterReader.cacheString(this.charBuf, this.stringCache, start, (int)(var1_1 - var2_2));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    final String consumeTagName() {
        int pos;
        this.bufferUp();
        int start = pos = this.bufPos;
        int remaining = this.bufLength;
        char[] val = this.charBuf;
        block3: while (pos < remaining) {
            switch (val[pos]) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '/': 
                case '<': 
                case '>': {
                    break block3;
                }
                default: {
                    ++pos;
                    continue block3;
                }
            }
        }
        this.bufPos = pos;
        if (pos > start) {
            void var2_2;
            void var1_1;
            return CharacterReader.cacheString(this.charBuf, this.stringCache, start, (int)(var1_1 - var2_2));
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    final String consumeToEnd() {
        void var1_1;
        this.bufferUp();
        String data = CharacterReader.cacheString(this.charBuf, this.stringCache, this.bufPos, this.bufLength - this.bufPos);
        this.bufPos = this.bufLength;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final String consumeLetterSequence() {
        void var1_1;
        void var2_2;
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter((char)var2_2))) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final String consumeLetterThenDigitSequence() {
        void var1_1;
        void var2_2;
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter(c))) {
            ++this.bufPos;
        }
        while (!this.isEmptyNoBufferUp() && (c = this.charBuf[this.bufPos]) >= '0' && var2_2 <= 57) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final String consumeHexSequence() {
        void var1_1;
        void var2_2;
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && ((c = this.charBuf[this.bufPos]) >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && var2_2 <= 102)) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final String consumeDigitSequence() {
        void var1_1;
        void var2_2;
        char c;
        this.bufferUp();
        int start = this.bufPos;
        while (this.bufPos < this.bufLength && (c = this.charBuf[this.bufPos]) >= '0' && var2_2 <= 57) {
            ++this.bufPos;
        }
        return CharacterReader.cacheString(this.charBuf, this.stringCache, start, this.bufPos - var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean matches(char c) {
        void var1_1;
        return !this.isEmpty() && this.charBuf[this.bufPos] == var1_1;
    }

    final boolean matches(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            if (seq.charAt(offset) == this.charBuf[this.bufPos + offset]) continue;
            return false;
        }
        return true;
    }

    final boolean matchesIgnoreCase(String seq) {
        this.bufferUp();
        int scanLength = seq.length();
        if (scanLength > this.bufLength - this.bufPos) {
            return false;
        }
        for (int offset = 0; offset < scanLength; ++offset) {
            char upTarget;
            char upScan = Character.toUpperCase(seq.charAt(offset));
            if (upScan == (upTarget = Character.toUpperCase(this.charBuf[this.bufPos + offset]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchesAny(char ... seq) {
        void var1_1;
        if (this.isEmpty()) {
            return false;
        }
        this.bufferUp();
        char c = this.charBuf[this.bufPos];
        for (void var5_5 : var1_1) {
            if (var5_5 != c) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchesAnySorted(char[] seq) {
        void var1_1;
        this.bufferUp();
        return !this.isEmpty() && Arrays.binarySearch((char[])var1_1, this.charBuf[this.bufPos]) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchesLetter() {
        void var1_1;
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isLetter((char)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchesDigit() {
        void var1_1;
        if (this.isEmpty()) {
            return false;
        }
        char c = this.charBuf[this.bufPos];
        return c >= '0' && var1_1 <= 57;
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchConsume(String seq) {
        this.bufferUp();
        if (this.matches(seq)) {
            void var1_1;
            this.bufPos += var1_1.length();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean matchConsumeIgnoreCase(String seq) {
        if (this.matchesIgnoreCase(seq)) {
            void var1_1;
            this.bufPos += var1_1.length();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean containsIgnoreCase(String seq) {
        void var1_1;
        void var2_2;
        String loScan = seq.toLowerCase(Locale.ENGLISH);
        String hiScan = seq.toUpperCase(Locale.ENGLISH);
        return this.nextIndexOf((CharSequence)var2_2) >= 0 || this.nextIndexOf((CharSequence)var1_1) >= 0;
    }

    public final String toString() {
        if (this.bufLength - this.bufPos < 0) {
            return "";
        }
        return new String(this.charBuf, this.bufPos, this.bufLength - this.bufPos);
    }

    /*
     * WARNING - void declaration
     */
    private static String cacheString(char[] charBuf, String[] stringCache, int start, int count) {
        if (count > 12) {
            return new String(charBuf, start, count);
        }
        if (count <= 0) {
            return "";
        }
        int hash = count * 31;
        int offset = start;
        for (int i = 0; i < count; ++i) {
            hash = hash * 31 + charBuf[offset++];
        }
        int index = hash & 0x1FF;
        String cached = stringCache[index];
        if (cached == null) {
            stringCache[index] = cached = new String(charBuf, start, count);
        } else {
            void var3_3;
            void var2_2;
            char[] cArray;
            if (CharacterReader.rangeEquals(charBuf, start, count, cached)) {
                return cached;
            }
            var1_1[index] = cached = new String(cArray, (int)var2_2, (int)var3_3);
        }
        return cached;
    }

    /*
     * WARNING - void declaration
     */
    static boolean rangeEquals(char[] charBuf, int start, int count, String cached) {
        if (count == cached.length()) {
            int j = 0;
            while (count-- != 0) {
                void i;
                if (charBuf[i++] == cached.charAt(j++)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

