/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.latest;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.ComparatorLatestStrategy;
import org.apache.ivy.plugins.version.VersionMatcher;

public class LatestRevisionStrategy
extends ComparatorLatestStrategy {
    private static final Map DEFAULT_SPECIAL_MEANINGS = new HashMap<String, Integer>();
    private final Comparator mridComparator = new MridComparator();
    private final Comparator artifactInfoComparator = new ArtifactInfoComparator();
    private Map specialMeanings = null;
    private boolean usedefaultspecialmeanings = true;

    public LatestRevisionStrategy() {
        LatestRevisionStrategy latestRevisionStrategy = this;
        latestRevisionStrategy.setComparator(latestRevisionStrategy.artifactInfoComparator);
        this.setName("latest-revision");
    }

    public synchronized Map getSpecialMeanings() {
        if (this.specialMeanings == null) {
            this.specialMeanings = new HashMap();
            if (this.isUsedefaultspecialmeanings()) {
                this.specialMeanings.putAll(DEFAULT_SPECIAL_MEANINGS);
            }
        }
        return this.specialMeanings;
    }

    public boolean isUsedefaultspecialmeanings() {
        return this.usedefaultspecialmeanings;
    }

    static {
        DEFAULT_SPECIAL_MEANINGS.put("dev", -1);
        DEFAULT_SPECIAL_MEANINGS.put("rc", 1);
        DEFAULT_SPECIAL_MEANINGS.put("final", 2);
    }

    final class ArtifactInfoComparator
    implements Comparator {
        ArtifactInfoComparator() {
        }

        public final int compare(Object object, Object object2) {
            object = ((ArtifactInfo)object).getRevision();
            object2 = ((ArtifactInfo)object2).getRevision();
            VersionMatcher versionMatcher = IvyContext.getContext().getSettings().getVersionMatcher();
            object = ModuleRevisionId.newInstance("", "", (String)object);
            object2 = ModuleRevisionId.newInstance("", "", (String)object2);
            if (versionMatcher.isDynamic((ModuleRevisionId)object)) {
                int n = versionMatcher.compare((ModuleRevisionId)object, (ModuleRevisionId)object2, LatestRevisionStrategy.this.mridComparator);
                if (n >= 0) {
                    return 1;
                }
                return -1;
            }
            if (versionMatcher.isDynamic((ModuleRevisionId)object2)) {
                int n = versionMatcher.compare((ModuleRevisionId)object2, (ModuleRevisionId)object, LatestRevisionStrategy.this.mridComparator);
                if (n >= 0) {
                    return -1;
                }
                return 1;
            }
            return LatestRevisionStrategy.this.mridComparator.compare(object, object2);
        }
    }

    final class MridComparator
    implements Comparator {
        MridComparator() {
        }

        public final int compare(Object stringArray, Object stringArray2) {
            int n;
            stringArray = ((ModuleRevisionId)stringArray).getRevision();
            stringArray2 = ((ModuleRevisionId)stringArray2).getRevision();
            stringArray = stringArray.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            stringArray = stringArray.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            stringArray2 = stringArray2.replaceAll("([a-zA-Z])(\\d)", "$1.$2");
            stringArray2 = stringArray2.replaceAll("(\\d)([a-zA-Z])", "$1.$2");
            stringArray = stringArray.split("[\\._\\-\\+]");
            stringArray2 = stringArray2.split("[\\._\\-\\+]");
            for (n = 0; n < stringArray.length && n < stringArray2.length; ++n) {
                if (stringArray[n].equals(stringArray2[n])) continue;
                boolean bl = this.isNumber(stringArray[n]);
                boolean bl2 = this.isNumber(stringArray2[n]);
                if (bl && !bl2) {
                    return 1;
                }
                if (bl2 && !bl) {
                    return -1;
                }
                if (bl && bl2) {
                    return Long.valueOf(stringArray[n]).compareTo(Long.valueOf(stringArray2[n]));
                }
                Object object = LatestRevisionStrategy.this.getSpecialMeanings();
                Integer n2 = (Integer)object.get(stringArray[n].toLowerCase(Locale.US));
                object = (Integer)object.get(stringArray2[n].toLowerCase(Locale.US));
                if (n2 != null) {
                    object = object == null ? Integer.valueOf(0) : object;
                    return n2.compareTo((Integer)object);
                }
                if (object != null) {
                    return Integer.valueOf(0).compareTo((Integer)object);
                }
                return stringArray[n].compareTo(stringArray2[n]);
            }
            if (n < stringArray.length) {
                if (this.isNumber(stringArray[n])) {
                    return 1;
                }
                return -1;
            }
            if (n < stringArray2.length) {
                if (this.isNumber(stringArray2[n])) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }

        private boolean isNumber(String string) {
            return string.matches("\\d+");
        }
    }
}

