/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.ivy.core.cache.ModuleDescriptorMemoryCache$CacheEntry;
import org.apache.ivy.core.cache.ModuleDescriptorProvider;
import org.apache.ivy.core.cache.ParserSettingsMonitor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.util.Message;

final class ModuleDescriptorMemoryCache {
    private final int maxSize;
    private final LinkedHashMap valueMap = new LinkedHashMap(150);

    public ModuleDescriptorMemoryCache() {
        this.maxSize = 150;
    }

    public final ModuleDescriptor getStale(File file2, ParserSettings parserSettings, boolean bl, ModuleDescriptorProvider moduleDescriptorProvider) {
        ParserSettingsMonitor parserSettingsMonitor = new ParserSettingsMonitor(parserSettings);
        parserSettingsMonitor.getMonitoredSettings();
        ModuleDescriptor moduleDescriptor = moduleDescriptorProvider.provideModule$6172736d(file2, bl);
        this.putInCache(file2, parserSettingsMonitor, bl, moduleDescriptor);
        return moduleDescriptor;
    }

    final ModuleDescriptor getFromCache(File file2, ParserSettings parserSettings, boolean bl) {
        ModuleDescriptorMemoryCache$CacheEntry moduleDescriptorMemoryCache$CacheEntry = (ModuleDescriptorMemoryCache$CacheEntry)this.valueMap.get(file2);
        if (moduleDescriptorMemoryCache$CacheEntry != null) {
            if (moduleDescriptorMemoryCache$CacheEntry.isStale(bl, parserSettings)) {
                Message.debug("Entry is found in the ModuleDescriptorCache but entry should be reevaluated : " + file2);
                this.valueMap.remove(file2);
                return null;
            }
            this.valueMap.remove(file2);
            this.valueMap.put(file2, moduleDescriptorMemoryCache$CacheEntry);
            Message.debug("Entry is found in the ModuleDescriptorCache : " + file2);
            return ModuleDescriptorMemoryCache$CacheEntry.access$000(moduleDescriptorMemoryCache$CacheEntry);
        }
        Message.debug("No entry is found in the ModuleDescriptorCache : " + file2);
        return null;
    }

    final void putInCache(File file2, ParserSettingsMonitor parserSettingsMonitor, boolean bl, ModuleDescriptor moduleDescriptor) {
        if (this.valueMap.size() >= 150) {
            Message.debug("ModuleDescriptorCache is full, remove one entry");
            Iterator iterator2 = this.valueMap.values().iterator();
            iterator2.next();
            iterator2.remove();
        }
        this.valueMap.put(file2, new ModuleDescriptorMemoryCache$CacheEntry(moduleDescriptor, bl, parserSettingsMonitor));
    }
}

