/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.server;

import java.io.Serializable;
import sbt.ProjectRef;
import sbt.StandardMain$;
import sbt.internal.CommandExchange;
import sbt.internal.bsp.BuildServerTasks$;
import sbt.internal.bsp.BuildTargetIdentifier;
import sbt.internal.bsp.BuildTargetName$;
import sbt.internal.bsp.CompileReport;
import sbt.internal.bsp.CompileReport$;
import sbt.internal.bsp.CompileTask$;
import sbt.internal.bsp.StatusCode$;
import sbt.internal.bsp.TaskFinishParams;
import sbt.internal.bsp.TaskFinishParams$;
import sbt.internal.bsp.TaskId;
import sbt.internal.bsp.TaskId$;
import sbt.internal.bsp.TaskStartParams;
import sbt.internal.bsp.TaskStartParams$;
import sbt.internal.bsp.codec.JsonProtocol$;
import sbt.internal.io.Retry$;
import sbt.internal.server.BspCompileTask;
import sbt.librarymanagement.Configuration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;
import sjsonnew.JsonWriter;
import sjsonnew.shaded.scalajson.ast.unsafe.JValue;
import sjsonnew.support.scalajson.unsafe.Converter$;
import xsbti.CompileFailed;
import xsbti.Problem;
import xsbti.Severity;
import xsbti.compile.CompileResult;

public final class BspCompileTask$
implements scala.Serializable {
    public static BspCompileTask$ MODULE$;
    private CommandExchange exchange;
    private volatile boolean bitmap$0;

    static {
        new BspCompileTask$();
    }

    private CommandExchange exchange$lzycompute() {
        BspCompileTask$ bspCompileTask$ = this;
        synchronized (bspCompileTask$) {
            if (!this.bitmap$0) {
                this.exchange = StandardMain$.MODULE$.exchange();
                this.bitmap$0 = true;
            }
        }
        return this.exchange;
    }

    private CommandExchange exchange() {
        return !this.bitmap$0 ? this.exchange$lzycompute() : this.exchange;
    }

    public CompileResult compute(BuildTargetIdentifier targetId, ProjectRef project, Configuration config, Function0<CompileResult> compile) {
        CompileResult compileResult;
        BspCompileTask task = this.apply(targetId, project, config);
        try {
            this.notifyStart(task);
            CompileResult result = (CompileResult)Retry$.MODULE$.apply(compile, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Class[0]));
            this.notifySuccess(task, result);
            compileResult = result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                None$ none$;
                Throwable cause = (Throwable)option.get();
                Throwable throwable3 = cause;
                if (throwable3 instanceof CompileFailed) {
                    CompileFailed compileFailed = (CompileFailed)throwable3;
                    none$ = new Some((Object)compileFailed);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ compileFailed = none$;
                this.notifyFailure(task, (Option<CompileFailed>)compileFailed);
                throw cause;
            }
            throw throwable;
        }
        return compileResult;
    }

    private BspCompileTask apply(BuildTargetIdentifier targetId, ProjectRef project, Configuration config) {
        TaskId taskId = TaskId$.MODULE$.apply(BuildServerTasks$.MODULE$.uniqueId(), (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$));
        String targetName = BuildTargetName$.MODULE$.fromScope(project.project(), config.name());
        return this.apply(targetId, targetName, taskId, System.currentTimeMillis());
    }

    private void notifyStart(BspCompileTask task) {
        String message = new StringBuilder(10).append("Compiling ").append(task.targetName()).toString();
        JValue data = (JValue)Converter$.MODULE$.toJsonUnsafe((Object)CompileTask$.MODULE$.apply(task.targetId()), (JsonWriter)JsonProtocol$.MODULE$.CompileTaskFormat());
        TaskStartParams params = TaskStartParams$.MODULE$.apply(task.id(), task.startTimeMillis(), message, "compile-task", data);
        this.exchange().notifyEvent("build/taskStart", params, JsonProtocol$.MODULE$.TaskStartParamsFormat());
    }

    private void notifySuccess(BspCompileTask task, CompileResult result) {
        Seq seq;
        long endTimeMillis = System.currentTimeMillis();
        long elapsedTimeMillis = endTimeMillis - task.startTimeMillis();
        CompileResult compileResult = result;
        if (compileResult != null) {
            CompileResult compileResult2 = compileResult;
            Map sourceInfos = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(compileResult2.analysis().readSourceInfos().getAllSourceInfos()).asScala();
            seq = ((TraversableOnce)sourceInfos.values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.getReportedProblems())), Iterable$.MODULE$.canBuildFrom())).toSeq();
        } else {
            seq = (Seq)Nil$.MODULE$;
        }
        Seq problems = seq;
        CompileReport report = this.compileReport((Seq<Problem>)problems, task.targetId(), elapsedTimeMillis);
        TaskFinishParams params = TaskFinishParams$.MODULE$.apply(task.id(), endTimeMillis, new StringBuilder(9).append("Compiled ").append(task.targetName()).toString(), StatusCode$.MODULE$.Success(), "compile-report", (JValue)Converter$.MODULE$.toJsonUnsafe((Object)report, (JsonWriter)JsonProtocol$.MODULE$.CompileReportFormat()));
        this.exchange().notifyEvent("build/taskFinish", params, JsonProtocol$.MODULE$.TaskFinishParamsFormat());
    }

    private void notifyFailure(BspCompileTask task, Option<CompileFailed> cause) {
        long endTimeMillis = System.currentTimeMillis();
        long elapsedTimeMillis = endTimeMillis - task.startTimeMillis();
        Seq problems = (Seq)cause.map((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.problems())).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Nil$.MODULE$);
        CompileReport report = this.compileReport((Seq<Problem>)problems, task.targetId(), elapsedTimeMillis);
        TaskFinishParams params = TaskFinishParams$.MODULE$.apply(task.id(), endTimeMillis, new StringBuilder(9).append("Compiled ").append(task.targetName()).toString(), StatusCode$.MODULE$.Error(), "compile-report", (JValue)Converter$.MODULE$.toJsonUnsafe((Object)report, (JsonWriter)JsonProtocol$.MODULE$.CompileReportFormat()));
        this.exchange().notifyEvent("build/taskFinish", params, JsonProtocol$.MODULE$.TaskFinishParamsFormat());
    }

    private CompileReport compileReport(Seq<Problem> problems, BuildTargetIdentifier targetId, long elapsedTimeMillis) {
        scala.collection.immutable.Map countBySeverity = problems.groupBy((Function1 & Serializable & scala.Serializable)x$3 -> x$3.severity()).mapValues((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.size()));
        int warnings = BoxesRunTime.unboxToInt((Object)countBySeverity.getOrElse((Object)Severity.Warn, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        int errors = BoxesRunTime.unboxToInt((Object)countBySeverity.getOrElse((Object)Severity.Error, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
        return CompileReport$.MODULE$.apply(targetId, (Option)None$.MODULE$, errors, warnings, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)((int)elapsedTimeMillis))));
    }

    public BspCompileTask apply(BuildTargetIdentifier targetId, String targetName, TaskId id, long startTimeMillis) {
        return new BspCompileTask(targetId, targetName, id, startTimeMillis);
    }

    public Option<Tuple4<BuildTargetIdentifier, String, TaskId, Object>> unapply(BspCompileTask x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.targetId(), (Object)x$0.targetName(), (Object)x$0.id(), (Object)BoxesRunTime.boxToLong((long)x$0.startTimeMillis())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private BspCompileTask$() {
        MODULE$ = this;
    }
}

