/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.regex.Pattern;
import sbt.internal.FullScalaLoader;
import sbt.internal.JLineLoader;
import sbt.internal.ScalaLibraryClassLoader;
import sbt.internal.TestInterfaceLoader;
import xsbti.AppProvider;
import xsbti.ScalaProvider;

public final class MetaBuildLoader
extends URLClassLoader {
    private final URLClassLoader fullScalaLoader;
    private final URLClassLoader libraryLoader;
    private final URLClassLoader interfaceLoader;
    private final URLClassLoader jlineLoader;

    MetaBuildLoader(URL[] uRLArray, URLClassLoader uRLClassLoader, URLClassLoader uRLClassLoader2, URLClassLoader uRLClassLoader3, URLClassLoader uRLClassLoader4) {
        super(uRLArray, (ClassLoader)uRLClassLoader);
        this.fullScalaLoader = uRLClassLoader;
        this.libraryLoader = uRLClassLoader2;
        this.interfaceLoader = uRLClassLoader3;
        this.jlineLoader = uRLClassLoader4;
    }

    public String toString() {
        return "SbtMetaBuildClassLoader";
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.fullScalaLoader.close();
        this.libraryLoader.close();
        this.interfaceLoader.close();
        this.jlineLoader.close();
    }

    public static MetaBuildLoader makeLoader(AppProvider appProvider) throws IOException {
        Pattern pattern = Pattern.compile("^(test-interface-[0-9.]+|jline-(terminal-)?[0-9.]+-sbt-.*|jline-terminal-(jna|jansi)-[0-9.]+|jansi-[0-9.]+|jna-(platform-)?[0-9.]+)\\.jar");
        File[] fileArray = appProvider.mainClasspath();
        URL[] uRLArray = new URL[1];
        URL[] uRLArray2 = new URL[7];
        File[] fileArray2 = appProvider.id().classpathExtra() == null ? new File[]{} : appProvider.id().classpathExtra();
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        int n = 0;
        int n2 = 0;
        for (File file : fileArray) {
            String string = file.getName();
            if (string.contains("test-interface") && pattern.matcher(string).find()) {
                uRLArray[n] = file.toURI().toURL();
                ++n;
                continue;
            }
            if (pattern.matcher(string).find()) {
                uRLArray2[n2] = file.toURI().toURL();
                ++n2;
                continue;
            }
            linkedHashSet.add(file);
        }
        for (File file : fileArray2) {
            linkedHashSet.add(file);
        }
        URL[] uRLArray3 = new URL[linkedHashSet.size()];
        n2 = 0;
        for (File file : linkedHashSet) {
            uRLArray3[n2] = file.toURI().toURL();
            ++n2;
        }
        ScalaProvider scalaProvider = appProvider.scalaProvider();
        Object object2 = scalaProvider.launcher().topLoader();
        int n3 = 0;
        while (n3 == 0 && object2 != null) {
            if (object2 instanceof URLClassLoader) {
                for (URL object3 : ((URLClassLoader)object2).getURLs()) {
                    if (!object3.toString().contains("test-interface")) continue;
                    object2 = ((ClassLoader)object2).getParent();
                    n3 = 1;
                }
            }
            if (n3 != 0) continue;
            object2 = ((ClassLoader)object2).getParent();
        }
        if (object2 == null) {
            object2 = scalaProvider.launcher().topLoader();
        }
        TestInterfaceLoader testInterfaceLoader = new TestInterfaceLoader(uRLArray, (ClassLoader)object2);
        JLineLoader jLineLoader = new JLineLoader(uRLArray2, (ClassLoader)testInterfaceLoader);
        File[] fileArray3 = scalaProvider.jars();
        URL[] uRLArray4 = new URL[1];
        int n4 = fileArray3.length - 1;
        for (File file : fileArray3) {
            if (!pattern.matcher(file.getName()).find()) continue;
            --n4;
        }
        Serializable[] serializableArray = new URL[Math.max(0, n4)];
        int fullScalaLoader = 0;
        for (int scalaLibraryClassLoader = 0; scalaLibraryClassLoader < fileArray3.length; ++scalaLibraryClassLoader) {
            File file;
            file = fileArray3[scalaLibraryClassLoader];
            if (file.getName().equals("scala-library.jar")) {
                uRLArray4[0] = file.toURI().toURL();
                continue;
            }
            if (pattern.matcher(file.getName()).find()) continue;
            serializableArray[fullScalaLoader] = file.toURI().toURL();
            ++fullScalaLoader;
        }
        assert (uRLArray4[0] != null) : "no scala-library.jar";
        ScalaLibraryClassLoader scalaLibraryClassLoader = new ScalaLibraryClassLoader(uRLArray4, (ClassLoader)jLineLoader);
        FullScalaLoader fullScalaLoader2 = new FullScalaLoader((URL[])serializableArray, scalaLibraryClassLoader);
        return new MetaBuildLoader(uRLArray3, fullScalaLoader2, scalaLibraryClassLoader, testInterfaceLoader, jLineLoader);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

