/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sbt.BuildPaths$;
import sbt.Def$;
import sbt.InputKey;
import sbt.InputKey$;
import sbt.InputTask;
import sbt.InputTask$;
import sbt.Keys$;
import sbt.State;
import sbt.Task;
import sbt.Terminal;
import sbt.internal.util.AList$;
import sbt.internal.util.Init;
import sbt.io.IO$;
import sbt.io.Path$;
import sbt.io.RichFile$;
import sbt.io.syntax$;
import sbt.std.InitializeInstance$;
import sbt.std.ParserInstance$;
import sbt.std.TaskInstance$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.sys.process.package$;
import scala.util.Properties$;
import scala.util.Try$;

public final class InstallSbtn$ {
    public static InstallSbtn$ MODULE$;
    private final InputKey<BoxedUnit> installSbtn;
    private final Map<String, String> shellCompletions;

    static {
        new InstallSbtn$();
    }

    public InputKey<BoxedUnit> installSbtn() {
        return this.installSbtn;
    }

    public Init.Initialize<InputTask<BoxedUnit>> installSbtnImpl() {
        return InitializeInstance$.MODULE$.app((Object)new Tuple3(Keys$.MODULE$.state(), Keys$.MODULE$.terminal(), Keys$.MODULE$.sbtVersion()), (Function1 & Serializable & scala.Serializable)$p$macro$8 -> {
            Task task = (Task)$p$macro$8._1();
            Task task2 = (Task)$p$macro$8._2();
            String string = (String)$p$macro$8._3();
            return InputTask$.MODULE$.make(ParserInstance$.MODULE$.map(Def$.MODULE$.toSParser(Def$.MODULE$.spaceDelimited("version")), (Function1 & Serializable & scala.Serializable)$q$macro$4 -> TaskInstance$.MODULE$.app((Object)new Tuple2((Object)task, (Object)task2), (Function1 & Serializable & scala.Serializable)$p$macro$7 -> {
                InstallSbtn$.$anonfun$installSbtnImpl$3($q$macro$4, string, $p$macro$7);
                return BoxedUnit.UNIT;
            }, AList$.MODULE$.tuple2())));
        }, AList$.MODULE$.tuple3());
    }

    public void extractSbtn(Terminal term, String version, Path sbtZip, Path sbtn) {
        this.downloadRelease(term, version, sbtZip);
        Files.createDirectories(sbtn.getParent(), new FileAttribute[0]);
        String bin = Properties$.MODULE$.isWin() ? "pc-win32.exe" : (Properties$.MODULE$.isLinux() ? "pc-linux" : "apple-darwin");
        String sbtnName = new StringBuilder(20).append("sbt/bin/sbtn-x86_64-").append(bin).toString();
        FileInputStream fis = new FileInputStream(sbtZip.toFile());
        ZipInputStream zipInputStream = new ZipInputStream(fis);
        boolean foundBinary = false;
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String string = entry.getName();
                String string2 = sbtnName;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    foundBinary = true;
                    term.printStream().println(new StringBuilder(16).append("extracting ").append(sbtZip).append("!").append(sbtnName).append(" to ").append(sbtn).toString());
                    this.transfer(zipInputStream, sbtn);
                    sbtn.toFile().setExecutable(true);
                    entry = null;
                    continue;
                }
                entry = zipInputStream.getNextEntry();
            }
            if (!foundBinary) {
                throw new IllegalStateException(new StringBuilder(18).append("couldn't find ").append(sbtnName).append(" in ").append(sbtZip).toString());
            }
        }
        finally {
            fis.close();
            zipInputStream.close();
        }
    }

    private void downloadRelease(Terminal term, String version, Path location) {
        String zip = new StringBuilder(55).append("https://github.com/sbt/sbt/releases/download/v").append(version).append("/sbt-").append(version).append(".zip").toString();
        URL url = new URL(zip);
        term.printStream().println(new StringBuilder(16).append("downloading ").append(zip).append(" to ").append(location).toString());
        this.transfer(url.openStream(), location);
    }

    private void transfer(InputStream inputStream, Path path) {
        try (FileOutputStream os = new FileOutputStream(path.toFile());){
            byte[] result = new byte[0x100000];
            int bytesRead = -1;
            while (true) {
                if ((bytesRead = inputStream.read(result)) > 0) {
                    os.write(result, 0, bytesRead);
                }
                if (bytesRead > 0) {
                    continue;
                }
                break;
            }
        }
        finally {
            inputStream.close();
        }
    }

    private String getShell(Terminal term) {
        String string;
        term.printStream().print(new StringOps(Predef$.MODULE$.augmentString("Setup sbtn for shell:\n      | [1] bash\n      | [2] fish\n      | [3] powershell\n      | [4] zsh\n      | [5] none\n      |Enter option: ")).stripMargin());
        term.printStream().flush();
        int key = term.inputStream().read();
        term.printStream().println((char)key);
        int n = key;
        switch (n) {
            case 49: {
                string = "bash";
                break;
            }
            case 50: {
                string = "fish";
                break;
            }
            case 51: {
                string = "powershell";
                break;
            }
            case 52: {
                string = "zsh";
                break;
            }
            default: {
                string = "none";
                break;
            }
        }
        return string;
    }

    private void downloadCompletion(String completion, String version, Path target) {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        String comp = new StringBuilder(63).append("https://raw.githubusercontent.com/sbt/sbt/v").append(version).append("/client/completions/").append(completion).toString();
        this.transfer(new URL(comp).openStream(), target);
    }

    private void setupShell(String shell, Path baseDirectory, Terminal term, File configFile, Function1<Path, String> setPath, Function1<Path, String> setCompletions) {
        block12: {
            String newContents;
            String string;
            String contents;
            String string2;
            Path bin = baseDirectory.resolve("bin");
            String export = (String)setPath.apply((Object)bin);
            Path completions = baseDirectory.resolve("completions");
            String sourceCompletions = (String)setCompletions.apply((Object)completions);
            try {
                string2 = IO$.MODULE$.read(configFile, IO$.MODULE$.read$default$2());
            }
            catch (IOException iOException) {
                string2 = contents = "";
            }
            if (!contents.contains(export)) {
                term.printStream().print(new StringBuilder(35).append("Add ").append(bin).append(" to PATH in ").append(configFile).append("? y/n (y default): ").toString());
                term.printStream().flush();
                int n = term.inputStream().read();
                switch (n) {
                    case 110: {
                        term.printStream().println();
                        break;
                    }
                    default: {
                        term.printStream().println((char)n);
                        IO$.MODULE$.write(configFile, new StringBuilder(1).append(contents).append("\n").append(export).toString(), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
                        break;
                    }
                }
            }
            try {
                string = IO$.MODULE$.read(configFile, IO$.MODULE$.read$default$2());
            }
            catch (IOException iOException) {
                string = newContents = "";
            }
            if (newContents.contains(sourceCompletions)) break block12;
            term.printStream().print(new StringBuilder(42).append("Add tab completions to ").append(configFile).append("? y/n (y default): ").toString());
            term.printStream().flush();
            int n = term.inputStream().read();
            switch (n) {
                case 110: {
                    break;
                }
                default: {
                    term.printStream().println((char)n);
                    String string3 = shell;
                    String string4 = "zsh";
                    if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                        Files.deleteIfExists(RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".zcompdump").toPath());
                        IO$.MODULE$.write(configFile, new StringBuilder(1).append(sourceCompletions).append("\n").append(newContents).toString(), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
                        break;
                    }
                    IO$.MODULE$.write(configFile, new StringBuilder(1).append(newContents).append("\n").append(sourceCompletions).toString(), IO$.MODULE$.write$default$3(), IO$.MODULE$.write$default$4());
                    break;
                }
            }
            term.printStream().println();
        }
    }

    private void setupBash(Path baseDirectory, Terminal term) {
        this.setupShell("bash", baseDirectory, term, RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".bashrc"), (Function1<Path, String>)(Function1 & Serializable & scala.Serializable)bin -> new StringBuilder(18).append("export PATH=$PATH:").append(bin).toString(), (Function1<Path, String>)(Function1 & Serializable & scala.Serializable)completions -> new StringBuilder(17).append("source ").append(completions).append("/sbtn.bash").toString());
    }

    private void setupZsh(Path baseDirectory, Terminal term) {
        Function1 & Serializable & scala.Serializable comp = (Function1 & Serializable & scala.Serializable)completions -> new StringBuilder(113).append("# The following two lines were added by the sbt installSbtn task:\n").append("fpath=($fpath ").append(completions).append(")\nautoload -Uz compinit; compinit").toString();
        this.setupShell("zsh", baseDirectory, term, RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".zshrc"), (Function1<Path, String>)(Function1 & Serializable & scala.Serializable)bin -> new StringBuilder(13).append("path=($path ").append(bin).append(")").toString(), (Function1<Path, String>)comp);
    }

    private void setupFish(Path baseDirectory, Terminal term) {
        Function1 & Serializable & scala.Serializable comp = (Function1 & Serializable & scala.Serializable)completions -> new StringBuilder(17).append("source ").append(completions).append("/sbtn.fish").toString();
        Function1 & Serializable & scala.Serializable path = (Function1 & Serializable & scala.Serializable)bin -> new StringBuilder(15).append("set PATH $PATH ").append(bin).toString();
        File config = RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(RichFile$.MODULE$.$div$extension(syntax$.MODULE$.fileToRichFile(Path$.MODULE$.userHome()), ".config")), "fish")), "config.fish");
        this.setupShell("fish", baseDirectory, term, config, (Function1<Path, String>)path, (Function1<Path, String>)comp);
    }

    private void setupPowershell(Path baseDirectory, Terminal term) {
        Function1 & Serializable & scala.Serializable comp = (Function1 & Serializable & scala.Serializable)completions -> new StringBuilder(13).append(". \"").append(completions).append("\\sbtn.ps1\"").toString();
        Function1 & Serializable & scala.Serializable path = (Function1 & Serializable & scala.Serializable)bin -> new StringBuilder(16).append("$env:Path += \";").append(bin).append("\"").toString();
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"pwsh", (List)new .colon.colon((Object)"-Command", (List)new .colon.colon((Object)"echo $PROFILE", (List)Nil$.MODULE$)))).$bang$bang()).foreach((Function1 & Serializable & scala.Serializable)output -> {
            InstallSbtn$.$anonfun$setupPowershell$4(baseDirectory, term, path, comp, output);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.stringSeqToProcess((Seq)new .colon.colon((Object)"powershell", (List)new .colon.colon((Object)"-Command", (List)new .colon.colon((Object)"echo $PROFILE", (List)Nil$.MODULE$)))).$bang$bang()).foreach((Function1 & Serializable & scala.Serializable)output -> {
            InstallSbtn$.$anonfun$setupPowershell$7(baseDirectory, term, path, comp, output);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$installSbtnImpl$3(Seq $q$macro$4$1, String $q$macro$1$1, Tuple2 $p$macro$7) {
        String shell;
        State state = (State)$p$macro$7._1();
        Terminal terminal = (Terminal)$p$macro$7._2();
        Option inputVersion = $q$macro$4$1.headOption();
        String version = (String)inputVersion.getOrElse((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString($q$macro$1$1)).replaceAllLiterally("-SNAPSHOT", ""));
        Terminal term = terminal;
        term.setMode(false, false);
        Path baseDirectory = BuildPaths$.MODULE$.getGlobalBase(state).toPath();
        Path tmp = Files.createTempFile(new StringBuilder(4).append("sbt-").append(version).toString(), "zip", new FileAttribute[0]);
        String sbtn = Properties$.MODULE$.isWin() ? "sbtn.exe" : "sbtn";
        try {
            MODULE$.extractSbtn(term, version, tmp, baseDirectory.resolve("bin").resolve(sbtn));
        }
        finally {
            Files.deleteIfExists(tmp);
        }
        String string = shell = System.console() != null ? MODULE$.getShell(term) : "none";
        if ("none".equals(string)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String completion = (String)InstallSbtn$.MODULE$.shellCompletions.apply((Object)string);
            Path completionLocation = baseDirectory.resolve("completions").resolve(completion);
            MODULE$.downloadCompletion(completion, version, completionLocation);
            String string2 = string;
            if ("bash".equals(string2)) {
                MODULE$.setupBash(baseDirectory, term);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("fish".equals(string2)) {
                MODULE$.setupFish(baseDirectory, term);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("zsh".equals(string2)) {
                MODULE$.setupZsh(baseDirectory, term);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if ("powershell".equals(string2)) {
                MODULE$.setupPowershell(baseDirectory, term);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            String msg = new StringBuilder(90).append("Successfully installed sbtn for ").append(string).append(". You may need to restart ").append(string).append(" for the ").append("changes to take effect.").toString();
            term.printStream().println(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$setupPowershell$4(Path baseDirectory$1, Terminal term$1, Function1 path$1, Function1 comp$1, String output) {
        new StringOps(Predef$.MODULE$.augmentString(output)).linesIterator().toSeq().headOption().foreach((Function1 & Serializable & scala.Serializable)l -> {
            InstallSbtn$.MODULE$.setupShell("pwsh", baseDirectory$1, term$1, new File(l), (Function1<Path, String>)path$1, (Function1<Path, String>)comp$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$setupPowershell$7(Path baseDirectory$1, Terminal term$1, Function1 path$1, Function1 comp$1, String output) {
        new StringOps(Predef$.MODULE$.augmentString(output)).linesIterator().toSeq().headOption().foreach((Function1 & Serializable & scala.Serializable)l -> {
            InstallSbtn$.MODULE$.setupShell("pwsh", baseDirectory$1, term$1, new File(l), (Function1<Path, String>)path$1, (Function1<Path, String>)comp$1);
            return BoxedUnit.UNIT;
        });
    }

    private InstallSbtn$() {
        MODULE$ = this;
        this.installSbtn = InputKey$.MODULE$.apply("installSbtn", "install sbtn and tab completions", InputKey$.MODULE$.apply$default$3(), (Manifest)ManifestFactory$.MODULE$.Unit()).withRank(30);
        this.shellCompletions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bash"), (Object)"sbtn.bash"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fish"), (Object)"sbtn.fish"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"powershell"), (Object)"sbtn.ps1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zsh"), (Object)"_sbtn")}));
    }
}

