/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.util.Optional;
import xsbti.compile.ClassFileManager;
import xsbti.compile.ExternalHooks;
import xsbti.compile.InvalidationProfiler;
import xsbti.compile.WrappedClassFileManager;

public class DefaultExternalHooks
implements ExternalHooks {
    private Optional<ExternalHooks.Lookup> lookup = Optional.empty();
    private Optional<ClassFileManager> classFileManager = Optional.empty();
    private ExternalHooks.GetProvenance getProvenance = ExternalHooks.NoProvenance.INSTANCE;
    private InvalidationProfiler invalidationProfiler = InvalidationProfiler.EMPTY.INSTANCE;

    public DefaultExternalHooks(Optional<ExternalHooks.Lookup> lookup, Optional<ClassFileManager> classFileManager, ExternalHooks.GetProvenance getProvenance, InvalidationProfiler invalidationProfiler) {
        this.lookup = lookup;
        this.classFileManager = classFileManager;
        this.getProvenance = getProvenance;
        this.invalidationProfiler = invalidationProfiler;
    }

    public DefaultExternalHooks(Optional<ExternalHooks.Lookup> lookup, Optional<ClassFileManager> classFileManager, ExternalHooks.GetProvenance getProvenance) {
        this(lookup, classFileManager, getProvenance, InvalidationProfiler.EMPTY.INSTANCE);
    }

    public DefaultExternalHooks(Optional<ExternalHooks.Lookup> lookup, Optional<ClassFileManager> classFileManager) {
        this(lookup, classFileManager, ExternalHooks.NoProvenance.INSTANCE);
    }

    @Override
    public Optional<ExternalHooks.Lookup> getExternalLookup() {
        return this.lookup;
    }

    @Override
    public Optional<ClassFileManager> getExternalClassFileManager() {
        return this.classFileManager;
    }

    @Override
    public ExternalHooks.GetProvenance getProvenance() {
        return this.getProvenance;
    }

    @Override
    public InvalidationProfiler getInvalidationProfiler() {
        return this.invalidationProfiler;
    }

    @Override
    public ExternalHooks withExternalClassFileManager(ClassFileManager externalClassFileManager) {
        Optional<ClassFileManager> external = Optional.of(externalClassFileManager);
        Optional<ClassFileManager> mixedManager = this.classFileManager.isPresent() ? Optional.of(WrappedClassFileManager.of(this.classFileManager.get(), external)) : external;
        return new DefaultExternalHooks(this.lookup, mixedManager, this.getProvenance, this.invalidationProfiler);
    }

    @Override
    public ExternalHooks withExternalLookup(ExternalHooks.Lookup externalLookup) {
        Optional<ExternalHooks.Lookup> externalLookup1 = Optional.of(externalLookup);
        return new DefaultExternalHooks(externalLookup1, this.classFileManager, this.getProvenance, this.invalidationProfiler);
    }

    @Override
    public ExternalHooks withGetProvenance(ExternalHooks.GetProvenance getProvenance) {
        return new DefaultExternalHooks(this.lookup, this.classFileManager, getProvenance, this.invalidationProfiler);
    }

    @Override
    public ExternalHooks withInvalidationProfiler(InvalidationProfiler profiler) {
        return new DefaultExternalHooks(this.lookup, this.classFileManager, this.getProvenance, profiler);
    }
}

