/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import xsbti.FileConverter;
import xsbti.Position;
import xsbti.VirtualFile;
import xsbti.compile.CompileOrder;
import xsbti.compile.Output;
import xsbti.compile.analysis.ReadStamps;

public final class CompileOptions
implements Serializable {
    private VirtualFile[] classpath;
    private VirtualFile[] sources;
    private Path classesDirectory;
    private String[] scalacOptions;
    private String[] javacOptions;
    private int maxErrors;
    private Function<Position, Position> sourcePositionMapper;
    private CompileOrder order;
    private Optional<Path> temporaryClassesDirectory;
    private Optional<FileConverter> converter;
    private Optional<ReadStamps> stamper;
    private Optional<Output> earlyOutput;

    public static CompileOptions create() {
        return new CompileOptions();
    }

    public static CompileOptions of() {
        return new CompileOptions();
    }

    public static CompileOptions create(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order);
    }

    public static CompileOptions of(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order);
    }

    public static CompileOptions create(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory);
    }

    public static CompileOptions of(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory);
    }

    public static CompileOptions create(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory);
    }

    public static CompileOptions of(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory);
    }

    public static CompileOptions create(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory, Optional<FileConverter> _converter, Optional<ReadStamps> _stamper, Optional<Output> _earlyOutput) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory, _converter, _stamper, _earlyOutput);
    }

    public static CompileOptions of(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory, Optional<FileConverter> _converter, Optional<ReadStamps> _stamper, Optional<Output> _earlyOutput) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory, _converter, _stamper, _earlyOutput);
    }

    public static CompileOptions create(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory, FileConverter _converter, ReadStamps _stamper, Output _earlyOutput) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory, _converter, _stamper, _earlyOutput);
    }

    public static CompileOptions of(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory, FileConverter _converter, ReadStamps _stamper, Output _earlyOutput) {
        return new CompileOptions(_classpath, _sources, _classesDirectory, _scalacOptions, _javacOptions, _maxErrors, _sourcePositionMapper, _order, _temporaryClassesDirectory, _converter, _stamper, _earlyOutput);
    }

    protected CompileOptions() {
        this.classpath = new VirtualFile[0];
        this.sources = new VirtualFile[0];
        this.classesDirectory = Paths.get("classes", new String[0]);
        this.scalacOptions = new String[0];
        this.javacOptions = new String[0];
        this.maxErrors = 100;
        this.sourcePositionMapper = new Function<Position, Position>(){

            @Override
            public Position apply(Position a) {
                return a;
            }
        };
        this.order = CompileOrder.Mixed;
        this.temporaryClassesDirectory = Optional.empty();
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order) {
        this.classpath = _classpath;
        this.sources = _sources;
        this.classesDirectory = _classesDirectory;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
        this.maxErrors = _maxErrors;
        this.sourcePositionMapper = _sourcePositionMapper;
        this.order = _order;
        this.temporaryClassesDirectory = Optional.empty();
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory) {
        this.classpath = _classpath;
        this.sources = _sources;
        this.classesDirectory = _classesDirectory;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
        this.maxErrors = _maxErrors;
        this.sourcePositionMapper = _sourcePositionMapper;
        this.order = _order;
        this.temporaryClassesDirectory = _temporaryClassesDirectory;
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory) {
        this.classpath = _classpath;
        this.sources = _sources;
        this.classesDirectory = _classesDirectory;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
        this.maxErrors = _maxErrors;
        this.sourcePositionMapper = _sourcePositionMapper;
        this.order = _order;
        this.temporaryClassesDirectory = Optional.ofNullable(_temporaryClassesDirectory);
        this.converter = Optional.empty();
        this.stamper = Optional.empty();
        this.earlyOutput = Optional.empty();
    }

    protected CompileOptions(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Optional<Path> _temporaryClassesDirectory, Optional<FileConverter> _converter, Optional<ReadStamps> _stamper, Optional<Output> _earlyOutput) {
        this.classpath = _classpath;
        this.sources = _sources;
        this.classesDirectory = _classesDirectory;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
        this.maxErrors = _maxErrors;
        this.sourcePositionMapper = _sourcePositionMapper;
        this.order = _order;
        this.temporaryClassesDirectory = _temporaryClassesDirectory;
        this.converter = _converter;
        this.stamper = _stamper;
        this.earlyOutput = _earlyOutput;
    }

    protected CompileOptions(VirtualFile[] _classpath, VirtualFile[] _sources, Path _classesDirectory, String[] _scalacOptions, String[] _javacOptions, int _maxErrors, Function<Position, Position> _sourcePositionMapper, CompileOrder _order, Path _temporaryClassesDirectory, FileConverter _converter, ReadStamps _stamper, Output _earlyOutput) {
        this.classpath = _classpath;
        this.sources = _sources;
        this.classesDirectory = _classesDirectory;
        this.scalacOptions = _scalacOptions;
        this.javacOptions = _javacOptions;
        this.maxErrors = _maxErrors;
        this.sourcePositionMapper = _sourcePositionMapper;
        this.order = _order;
        this.temporaryClassesDirectory = Optional.ofNullable(_temporaryClassesDirectory);
        this.converter = Optional.ofNullable(_converter);
        this.stamper = Optional.ofNullable(_stamper);
        this.earlyOutput = Optional.ofNullable(_earlyOutput);
    }

    public VirtualFile[] classpath() {
        return this.classpath;
    }

    public VirtualFile[] sources() {
        return this.sources;
    }

    public Path classesDirectory() {
        return this.classesDirectory;
    }

    public String[] scalacOptions() {
        return this.scalacOptions;
    }

    public String[] javacOptions() {
        return this.javacOptions;
    }

    public int maxErrors() {
        return this.maxErrors;
    }

    public Function<Position, Position> sourcePositionMapper() {
        return this.sourcePositionMapper;
    }

    public CompileOrder order() {
        return this.order;
    }

    public Optional<Path> temporaryClassesDirectory() {
        return this.temporaryClassesDirectory;
    }

    public Optional<FileConverter> converter() {
        return this.converter;
    }

    public Optional<ReadStamps> stamper() {
        return this.stamper;
    }

    public Optional<Output> earlyOutput() {
        return this.earlyOutput;
    }

    public CompileOptions withClasspath(VirtualFile[] classpath) {
        return new CompileOptions(classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withSources(VirtualFile[] sources) {
        return new CompileOptions(this.classpath, sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withClassesDirectory(Path classesDirectory) {
        return new CompileOptions(this.classpath, this.sources, classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withScalacOptions(String[] scalacOptions) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withJavacOptions(String[] javacOptions) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withMaxErrors(int maxErrors) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withSourcePositionMapper(Function<Position, Position> sourcePositionMapper) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withOrder(CompileOrder order) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, order, this.temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withTemporaryClassesDirectory(Optional<Path> temporaryClassesDirectory) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, temporaryClassesDirectory, this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withTemporaryClassesDirectory(Path temporaryClassesDirectory) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, Optional.ofNullable(temporaryClassesDirectory), this.converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withConverter(Optional<FileConverter> converter) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, converter, this.stamper, this.earlyOutput);
    }

    public CompileOptions withConverter(FileConverter converter) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, Optional.ofNullable(converter), this.stamper, this.earlyOutput);
    }

    public CompileOptions withStamper(Optional<ReadStamps> stamper) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, stamper, this.earlyOutput);
    }

    public CompileOptions withStamper(ReadStamps stamper) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, Optional.ofNullable(stamper), this.earlyOutput);
    }

    public CompileOptions withEarlyOutput(Optional<Output> earlyOutput) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, earlyOutput);
    }

    public CompileOptions withEarlyOutput(Output earlyOutput) {
        return new CompileOptions(this.classpath, this.sources, this.classesDirectory, this.scalacOptions, this.javacOptions, this.maxErrors, this.sourcePositionMapper, this.order, this.temporaryClassesDirectory, this.converter, this.stamper, Optional.ofNullable(earlyOutput));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CompileOptions)) {
            return false;
        }
        CompileOptions o = (CompileOptions)obj;
        return Arrays.deepEquals(this.classpath(), o.classpath()) && Arrays.deepEquals(this.sources(), o.sources()) && this.classesDirectory().equals(o.classesDirectory()) && Arrays.deepEquals(this.scalacOptions(), o.scalacOptions()) && Arrays.deepEquals(this.javacOptions(), o.javacOptions()) && this.maxErrors() == o.maxErrors() && this.sourcePositionMapper().equals(o.sourcePositionMapper()) && this.order().equals((Object)o.order()) && this.temporaryClassesDirectory().equals(o.temporaryClassesDirectory()) && this.converter().equals(o.converter()) && this.stamper().equals(o.stamper()) && this.earlyOutput().equals(o.earlyOutput());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + "xsbti.compile.CompileOptions".hashCode()) + Arrays.deepHashCode(this.classpath())) + Arrays.deepHashCode(this.sources())) + this.classesDirectory().hashCode()) + Arrays.deepHashCode(this.scalacOptions())) + Arrays.deepHashCode(this.javacOptions())) + Integer.valueOf(this.maxErrors()).hashCode()) + this.sourcePositionMapper().hashCode()) + this.order().hashCode()) + this.temporaryClassesDirectory().hashCode()) + this.converter().hashCode()) + this.stamper().hashCode()) + this.earlyOutput().hashCode());
    }

    public String toString() {
        return "CompileOptions(classpath: " + this.classpath() + ", sources: " + this.sources() + ", classesDirectory: " + this.classesDirectory() + ", scalacOptions: " + this.scalacOptions() + ", javacOptions: " + this.javacOptions() + ", maxErrors: " + this.maxErrors() + ", sourcePositionMapper: " + this.sourcePositionMapper() + ", order: " + (Object)((Object)this.order()) + ", temporaryClassesDirectory: " + this.temporaryClassesDirectory() + ", converter: " + this.converter() + ", stamper: " + this.stamper() + ", earlyOutput: " + this.earlyOutput() + ")";
    }
}

