/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.File;
import java.io.Serializable;
import xsbti.Maybe;
import xsbti.Reporter;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.DefinesClass;
import xsbti.compile.F1;
import xsbti.compile.GlobalsCache;
import xsbti.compile.IncOptions;

public final class Setup
implements Serializable {
    private F1<File, Maybe<CompileAnalysis>> analysisMap;
    private F1<File, DefinesClass> definesClass;
    private boolean skip;
    private File cacheFile;
    private GlobalsCache cache;
    private IncOptions incrementalCompilerOptions;
    private Reporter reporter;

    public Setup(F1<File, Maybe<CompileAnalysis>> f1, F1<File, DefinesClass> f12, boolean bl, File file, GlobalsCache globalsCache, IncOptions incOptions, Reporter reporter) {
        this.analysisMap = f1;
        this.definesClass = f12;
        this.skip = bl;
        this.cacheFile = file;
        this.cache = globalsCache;
        this.incrementalCompilerOptions = incOptions;
        this.reporter = reporter;
    }

    public F1<File, Maybe<CompileAnalysis>> analysisMap() {
        return this.analysisMap;
    }

    public F1<File, DefinesClass> definesClass() {
        return this.definesClass;
    }

    public boolean skip() {
        return this.skip;
    }

    public File cacheFile() {
        return this.cacheFile;
    }

    public GlobalsCache cache() {
        return this.cache;
    }

    public IncOptions incrementalCompilerOptions() {
        return this.incrementalCompilerOptions;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public Setup withAnalysisMap(F1<File, Maybe<CompileAnalysis>> f1) {
        return new Setup(f1, this.definesClass, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter);
    }

    public Setup withDefinesClass(F1<File, DefinesClass> f1) {
        return new Setup(this.analysisMap, f1, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter);
    }

    public Setup withSkip(boolean bl) {
        return new Setup(this.analysisMap, this.definesClass, bl, this.cacheFile, this.cache, this.incrementalCompilerOptions, this.reporter);
    }

    public Setup withCacheFile(File file) {
        return new Setup(this.analysisMap, this.definesClass, this.skip, file, this.cache, this.incrementalCompilerOptions, this.reporter);
    }

    public Setup withCache(GlobalsCache globalsCache) {
        return new Setup(this.analysisMap, this.definesClass, this.skip, this.cacheFile, globalsCache, this.incrementalCompilerOptions, this.reporter);
    }

    public Setup withIncrementalCompilerOptions(IncOptions incOptions) {
        return new Setup(this.analysisMap, this.definesClass, this.skip, this.cacheFile, this.cache, incOptions, this.reporter);
    }

    public Setup withReporter(Reporter reporter) {
        return new Setup(this.analysisMap, this.definesClass, this.skip, this.cacheFile, this.cache, this.incrementalCompilerOptions, reporter);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Setup)) {
            return false;
        }
        Setup setup = (Setup)object;
        return this.analysisMap().equals(setup.analysisMap()) && this.definesClass().equals(setup.definesClass()) && this.skip() == setup.skip() && this.cacheFile().equals(setup.cacheFile()) && this.cache().equals(setup.cache()) && this.incrementalCompilerOptions().equals(setup.incrementalCompilerOptions()) && this.reporter().equals(setup.reporter());
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (37 * (37 * (17 + this.analysisMap().hashCode()) + this.definesClass().hashCode()) + new Boolean(this.skip()).hashCode()) + this.cacheFile().hashCode()) + this.cache().hashCode()) + this.incrementalCompilerOptions().hashCode()) + this.reporter().hashCode());
    }

    public String toString() {
        return "Setup(analysisMap: " + this.analysisMap() + ", " + "definesClass: " + this.definesClass() + ", " + "skip: " + this.skip() + ", " + "cacheFile: " + this.cacheFile() + ", " + "cache: " + this.cache() + ", " + "incrementalCompilerOptions: " + this.incrementalCompilerOptions() + ", " + "reporter: " + this.reporter() + ")";
    }
}

