/*
 * Decompiled with CFR 0.152.
 */
package xsbti.compile;

import java.io.Serializable;
import xsbti.compile.CompileOrder;
import xsbti.compile.MiniOptions;
import xsbti.compile.Output;

public final class MiniSetup
implements Serializable {
    private Output output;
    private MiniOptions options;
    private String compilerVersion;
    private CompileOrder order;
    private boolean nameHashing;

    public MiniSetup(Output output, MiniOptions miniOptions, String string, CompileOrder compileOrder, boolean bl) {
        this.output = output;
        this.options = miniOptions;
        this.compilerVersion = string;
        this.order = compileOrder;
        this.nameHashing = bl;
    }

    public Output output() {
        return this.output;
    }

    public MiniOptions options() {
        return this.options;
    }

    public String compilerVersion() {
        return this.compilerVersion;
    }

    public CompileOrder order() {
        return this.order;
    }

    public boolean nameHashing() {
        return this.nameHashing;
    }

    public MiniSetup withOutput(Output output) {
        return new MiniSetup(output, this.options, this.compilerVersion, this.order, this.nameHashing);
    }

    public MiniSetup withOptions(MiniOptions miniOptions) {
        return new MiniSetup(this.output, miniOptions, this.compilerVersion, this.order, this.nameHashing);
    }

    public MiniSetup withCompilerVersion(String string) {
        return new MiniSetup(this.output, this.options, string, this.order, this.nameHashing);
    }

    public MiniSetup withOrder(CompileOrder compileOrder) {
        return new MiniSetup(this.output, this.options, this.compilerVersion, compileOrder, this.nameHashing);
    }

    public MiniSetup withNameHashing(boolean bl) {
        return new MiniSetup(this.output, this.options, this.compilerVersion, this.order, bl);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MiniSetup)) {
            return false;
        }
        MiniSetup miniSetup = (MiniSetup)object;
        return this.output().equals(miniSetup.output()) && this.options().equals(miniSetup.options()) && this.compilerVersion().equals(miniSetup.compilerVersion()) && this.order().equals((Object)miniSetup.order()) && this.nameHashing() == miniSetup.nameHashing();
    }

    public int hashCode() {
        return 37 * (37 * (37 * (37 * (37 * (17 + this.output().hashCode()) + this.options().hashCode()) + this.compilerVersion().hashCode()) + this.order().hashCode()) + new Boolean(this.nameHashing()).hashCode());
    }

    public String toString() {
        return "MiniSetup(output: " + this.output() + ", " + "options: " + this.options() + ", " + "compilerVersion: " + this.compilerVersion() + ", " + "order: " + (Object)((Object)this.order()) + ", " + "nameHashing: " + this.nameHashing() + ")";
    }
}

