/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.scaladoc.tasty.comments;

import java.io.Serializable;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Regexes$
implements Serializable {
    private static final Regex TrailingWhitespace;
    private static final Regex CleanCommentLine;
    private static final Regex DangerousTags;
    private static final Regex JavadocTags;
    private static final Regex SafeTags;
    private static final char safeTagMarker;
    private static final char endOfLine;
    private static final char endOfText;
    private static final Regex SingleTagRegex;
    private static final Regex SimpleTagRegex;
    private static final Regex SymbolTagRegex;
    private static final Regex CodeBlockStartRegex;
    private static final Regex CodeBlockEndRegex;
    public static final Regexes$ MODULE$;

    private Regexes$() {
    }

    static {
        MODULE$ = new Regexes$();
        TrailingWhitespace = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\s+$"));
        CleanCommentLine = new Regex("(?:\\s*\\*\\s?\\s?)?(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        DangerousTags = new Regex("<(/?(div|ol|ul|li|h[1-6]|p))( [^>]*)?/?>|<!--.*-->", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        JavadocTags = new Regex("\\{\\@(code|docRoot|linkplain|link|literal|value)\\p{Zs}*([^}]*)\\}", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SafeTags = new Regex("((&\\w+;)|(&#\\d+;)|(</?(abbr|acronym|address|area|a|bdo|big|blockquote|br|button|b|caption|cite|code|col|colgroup|dd|del|dfn|em|fieldset|form|hr|img|input|ins|i|kbd|label|legend|link|map|object|optgroup|option|param|pre|q|samp|select|small|span|strong|sub|sup|table|tbody|td|textarea|tfoot|th|thead|tr|tt|var)( [^>]*)?/?>))", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        safeTagMarker = (char)14;
        endOfLine = (char)10;
        endOfText = (char)3;
        SingleTagRegex = new Regex("\\s*@(\\S+)\\s*", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SimpleTagRegex = new Regex("\\s*@(\\S+)\\s+(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        SymbolTagRegex = new Regex("\\s*@(param|tparam|throws|groupdesc|groupname|groupprio)\\s+(\\S*)\\s*(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        CodeBlockStartRegex = new Regex("(.*?)((?:\\{\\{\\{)|(?:```)|(?:\\u000E<pre(?: [^>]*)?>\\u000E))(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        CodeBlockEndRegex = new Regex("(.*?)((?:\\}\\}\\})|(?:```)|(?:\\u000E</pre>\\u000E))(.*)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Regexes$.class);
    }

    public Regex TrailingWhitespace() {
        return TrailingWhitespace;
    }

    public Regex CleanCommentLine() {
        return CleanCommentLine;
    }

    public Regex DangerousTags() {
        return DangerousTags;
    }

    public Regex JavadocTags() {
        return JavadocTags;
    }

    public String javadocReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        switch (string == null ? 0 : string.hashCode()) {
            case -1608837616: {
                if (!"linkplain".equals(string)) break;
                return new StringBuilder(4).append("[[").append(mtch.group(2)).append("]]").toString();
            }
            case 3059181: {
                if (!"code".equals(string)) break;
                return new StringBuilder(13).append("<code>").append(mtch.group(2)).append("</code>").toString();
            }
            case 3321850: {
                if (!"link".equals(string)) break;
                return new StringBuilder(6).append("`[[").append(mtch.group(2)).append("]]`").toString();
            }
            case 111972721: {
                if (!"value".equals(string)) break;
                return new StringBuilder(2).append("`").append(mtch.group(2)).append("`").toString();
            }
            case 182460591: {
                if (!"literal".equals(string)) break;
                return new StringBuilder(2).append("`").append(mtch.group(2)).append("`").toString();
            }
            case 1827872314: {
                if (!"docRoot".equals(string)) break;
                return "";
            }
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String htmlReplacement(Regex.Match mtch) {
        String string = mtch.group(1);
        switch (string == null ? 0 : string.hashCode()) {
            case 112: {
                if ("p".equals(string)) return "\n\n";
                return "";
            }
            case 3273: {
                if (!"h1".equals(string)) return "";
                return "\n= ";
            }
            case 3274: {
                if (!"h2".equals(string)) return "";
                return "\n== ";
            }
            case 3275: {
                if (!"h3".equals(string)) return "";
                return "\n=== ";
            }
            case 3276: {
                if ("h4".equals(string)) return "\n==== ";
                return "";
            }
            case 3277: {
                if ("h5".equals(string)) return "\n==== ";
                return "";
            }
            case 3278: {
                if ("h6".equals(string)) return "\n==== ";
                return "";
            }
            case 3453: {
                if (!"li".equals(string)) return "";
                return "\n *  - ";
            }
            case 48440: {
                if (!"/h1".equals(string)) return "";
                return " =\n";
            }
            case 48441: {
                if (!"/h2".equals(string)) return "";
                return " ==\n";
            }
            case 48442: {
                if (!"/h3".equals(string)) return "";
                return " ===\n";
            }
            case 48443: {
                if ("/h4".equals(string)) return " ====\n";
                return "";
            }
            case 48444: {
                if ("/h5".equals(string)) return " ====\n";
                return "";
            }
            case 48445: {
                if ("/h6".equals(string)) return " ====\n";
                return "";
            }
            case 99473: {
                if (!"div".equals(string)) return "";
                return "\n\n";
            }
        }
        return "";
    }

    public Regex SafeTags() {
        return SafeTags;
    }

    public char safeTagMarker() {
        return safeTagMarker;
    }

    public char endOfLine() {
        return endOfLine;
    }

    public char endOfText() {
        return endOfText;
    }

    public Regex SingleTagRegex() {
        return SingleTagRegex;
    }

    public Regex SimpleTagRegex() {
        return SimpleTagRegex;
    }

    public Regex SymbolTagRegex() {
        return SymbolTagRegex;
    }

    public Regex CodeBlockStartRegex() {
        return CodeBlockStartRegex;
    }

    public Regex CodeBlockEndRegex() {
        return CodeBlockEndRegex;
    }
}

