/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Path;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.meta.internal.metals.HtmlBuilder$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;

public final class HtmlBuilder {
    private final StringBuilder sb = new StringBuilder();

    public static HtmlBuilder apply() {
        return HtmlBuilder$.MODULE$.apply();
    }

    public static String bodyStyle() {
        return HtmlBuilder$.MODULE$.bodyStyle();
    }

    public static String htmlCSS() {
        return HtmlBuilder$.MODULE$.htmlCSS();
    }

    public String render() {
        return this.sb.toString();
    }

    public String toString() {
        return this.render();
    }

    public HtmlBuilder section(String title, Function1<HtmlBuilder, BoxedUnit> content) {
        return this.element("section", "class='container with-title' style='margin-bottom: .75rem'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$1 -> {
            HtmlBuilder htmlBuilder = _$1.element("h2", "class='title'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$2 -> _$2.text(title));
            htmlBuilder.element("div", htmlBuilder.element$default$2(), content);
        });
    }

    public HtmlBuilder page(String title, List<String> headElems, String bodyAttributes, Function1<HtmlBuilder, BoxedUnit> body) {
        HtmlBuilder htmlBuilder = this.raw("<!DOCTYPE html>");
        return htmlBuilder.element("html", htmlBuilder.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$3 -> _$3.element("head", _$3.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$4 -> _$4.element("title", _$4.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$5 -> _$5.text(title)).raw("<meta charset=\"UTF-8\">").raw(headElems.mkString())).element("body", bodyAttributes, body));
    }

    public List<String> page$default$2() {
        return package$.MODULE$.Nil();
    }

    public String page$default$3() {
        return "";
    }

    public HtmlBuilder submitButton(String query, String title) {
        return this.element("form", "action='/complete?" + query + "' method='post'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$6 -> _$6.element("button", "type='submit' class='btn'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$7 -> _$7.text(title)));
    }

    public <T> HtmlBuilder unorderedList(Iterable<T> iterable, Function1<T, BoxedUnit> fn) {
        this.sb.append("<ul>");
        iterable.foreach((Function1 & Serializable)item -> {
            this.sb.append("<li>");
            fn.apply(item);
            return this.sb.append("</li>");
        });
        this.sb.append("</ul>");
        return this;
    }

    private String color(MessageType tpe) {
        MessageType messageType = tpe;
        MessageType messageType2 = MessageType.Error;
        MessageType messageType3 = messageType;
        if (!(messageType2 != null ? !messageType2.equals(messageType3) : messageType3 != null)) {
            return "#f44336";
        }
        MessageType messageType4 = MessageType.Warning;
        MessageType messageType5 = messageType;
        if (!(messageType4 != null ? !messageType4.equals(messageType5) : messageType5 != null)) {
            return "#ff9800";
        }
        MessageType messageType6 = MessageType.Info;
        MessageType messageType7 = messageType;
        if (!(messageType6 != null ? !messageType6.equals(messageType7) : messageType7 != null)) {
            return "#3f51b5";
        }
        return "#009688";
    }

    public HtmlBuilder path(Path p) {
        return this.raw("</br>").text(p.toAbsolutePath().toString());
    }

    public HtmlBuilder call(Function1<HtmlBuilder, BoxedUnit> fn) {
        fn.apply((Object)this);
        return this;
    }

    public HtmlBuilder append(MessageParams params) {
        return this.element("font", "color='" + this.color(params.getType()) + "'", (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$8 -> _$8.text(params.getType().toString().toLowerCase())).text(" ").text(params.getMessage()).raw("\n");
    }

    public HtmlBuilder element(String name, String attr, Function1<HtmlBuilder, BoxedUnit> fn) {
        this.sb.append("<").append(name).append(" ").append(attr).append(">");
        fn.apply((Object)this);
        this.sb.append("</").append(name).append(">");
        return this;
    }

    public String element$default$2() {
        return "";
    }

    public HtmlBuilder raw(String string) {
        this.sb.append(string);
        return this;
    }

    public HtmlBuilder link(String url, String name) {
        this.sb.append("<a href='").append(url).append("'>").append(name).append("</a>");
        return this;
    }

    public HtmlBuilder optionally(boolean condition, Function1<HtmlBuilder, BoxedUnit> fn) {
        if (condition) {
            fn.apply((Object)this);
        }
        return this;
    }

    public HtmlBuilder text(String string) {
        this.sb.append(this.escape(string));
        return this;
    }

    public HtmlBuilder bold(String string) {
        this.sb.append("<b>" + this.escape(string) + "</b>");
        return this;
    }

    public HtmlBuilder pre(String content) {
        return this.element("pre", this.element$default$2(), (Function1<HtmlBuilder, BoxedUnit>)(JProcedure1 & Serializable)_$9 -> _$9.text(content));
    }

    private String escape(String s) {
        StringBuilder out = new StringBuilder(Math.max(16, s.length()));
        for (int i = 0; i < s.length(); ++i) {
            StringBuilder stringBuilder;
            char ch = s.charAt(i);
            if (ch > '\u007f' || ch == '\"' || ch == '<' || ch == '>' || ch == '&') {
                out.append("&#");
                out.append((int)ch);
                stringBuilder = out.append(';');
                continue;
            }
            stringBuilder = out.append(ch);
        }
        return out.toString();
    }
}

