/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.pc;

import dotty.tools.dotc.CompilationUnit;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.reporting.Diagnostic;
import dotty.tools.dotc.util.SourceFile;
import java.net.URI;
import java.util.Arrays;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.package$;

public class CachingDriver
extends InteractiveDriver {
    private final List<String> settings;
    private URI lastCompiledURI;
    private List<Diagnostic> previousDiags;

    public CachingDriver(List<String> settings) {
        this.settings = settings;
        super(settings);
        this.previousDiags = package$.MODULE$.List().empty();
    }

    public List<String> settings() {
        return this.settings;
    }

    private boolean alreadyCompiled(URI uri, char[] content) {
        Option option = this.compilationUnits().get((Object)uri);
        if (option instanceof Some) {
            Some some = (Some)option;
            CompilationUnit unit = (CompilationUnit)some.value();
            URI uRI = this.lastCompiledURI;
            URI uRI2 = uri;
            if (!(uRI != null ? !((Object)uRI).equals(uRI2) : uRI2 != null) && Arrays.equals(unit.source().content(), content)) {
                return true;
            }
        }
        return false;
    }

    public List<Diagnostic> run(URI uri, SourceFile source) {
        if (!this.alreadyCompiled(uri, source.content())) {
            this.previousDiags = super.run(uri, source);
        }
        this.lastCompiledURI = uri;
        return this.previousDiags;
    }
}

