/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.File;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.meta.internal.jdk.package$;
import scala.meta.internal.metals.PackageIndex$;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Properties$;
import scala.util.control.NonFatal$;

public class PackageIndex {
    private final Logger logger = Logger.getLogger(PackageIndex.class.getName());
    private final HashMap<String, Set<String>> packages = new HashMap();
    private final HashSet<Path> isVisited = new HashSet();
    private final Function<String, HashSet<String>> enterPackage = new Function<String, HashSet<String>>(){

        public Function compose(Function x$0) {
            return Function.super.compose(x$0);
        }

        public Function andThen(Function x$0) {
            return Function.super.andThen(x$0);
        }

        public HashSet apply(String t) {
            return new HashSet<E>();
        }
    };

    public static List<Path> bootClasspath() {
        return PackageIndex$.MODULE$.bootClasspath();
    }

    public static scala.collection.immutable.Seq<Path> dottyLibrary() {
        return PackageIndex$.MODULE$.dottyLibrary();
    }

    public static PackageIndex fromClasspath(Seq<Path> seq, Function1<String, Object> function1) {
        return PackageIndex$.MODULE$.fromClasspath(seq, function1);
    }

    public static scala.collection.immutable.Seq<Path> scala3Library() {
        return PackageIndex$.MODULE$.scala3Library();
    }

    public static scala.collection.immutable.Seq<Path> scalaLibrary() {
        return PackageIndex$.MODULE$.scalaLibrary();
    }

    public Logger logger() {
        return this.logger;
    }

    public HashMap<String, Set<String>> packages() {
        return this.packages;
    }

    public void visit(Path entry) {
        if (this.isVisited.contains(entry)) {
            return;
        }
        this.isVisited.add(entry);
        try {
            if (Files.isDirectory(entry, new LinkOption[0])) {
                this.visitDirectoryEntry(entry);
            } else if (Files.isRegularFile(entry, new LinkOption[0]) && entry.toString().endsWith(".jar")) {
                this.visitJarEntry(entry);
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                this.logger().log(Level.SEVERE, CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(entry).toURI().toString(), e);
            }
            throw throwable;
        }
    }

    public void addMember(String pkg, String member) {
        if (!member.contains("module-info.class")) {
            Set members = this.packages().computeIfAbsent(pkg, this.enterPackage);
            members.add(NameTransformer$.MODULE$.decode(member));
            return;
        }
    }

    private void visitDirectoryEntry(Path dir) {
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(dir, this){
            private final Path dir$1;
            private final /* synthetic */ PackageIndex $outer;
            {
                this.dir$1 = dir$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                String member = file.getFileName().toString();
                Option$.MODULE$.apply((Object)file.getParent()).filter(arg_0 -> PackageIndex.scala$meta$internal$metals$PackageIndex$$anon$2$$_$visitFile$$anonfun$1(member, arg_0)).foreach((Function1)(JProcedure1 & Serializable)parent -> {
                    Path relpath = this.dir$1.relativize((Path)parent);
                    String pkg = CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(relpath).toURI(true).toString();
                    this.$outer.addMember(pkg, member);
                });
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                if (dir.endsWith("META-INF")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{scala$meta$internal$metals$PackageIndex$$anon$2$$_$visitFile$$anonfun$1(java.lang.String java.nio.file.Path ), visitFile$$anonfun$2(java.lang.String java.nio.file.Path )}, serializedLambda);
            }
        });
    }

    public String dirname(String abspath) {
        int end;
        boolean isDir = abspath.endsWith("/");
        int n = end = isDir ? abspath.lastIndexOf(47, abspath.length() - 2) : abspath.lastIndexOf(47);
        if (end < 0) {
            return "/";
        }
        return abspath.substring(0, end + 1);
    }

    public String basename(String abspath) {
        boolean isDir;
        int end = abspath.lastIndexOf(47);
        boolean bl = isDir = end == abspath.length() - 1;
        if (end < 0) {
            return abspath;
        }
        if (!isDir) {
            return abspath.substring(end + 1);
        }
        int start = abspath.lastIndexOf(47, end - 1);
        if (start < 0) {
            return abspath.substring(0, end);
        }
        return abspath.substring(start + 1, end);
    }

    private void visitJarEntry(Path jarpath) {
        File file = jarpath.toFile();
        try (JarFile jar = new JarFile(file);){
            String classpathAttr;
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry element = entries.nextElement();
                if (element.isDirectory() || element.getName().startsWith("META-INF") || !element.getName().endsWith(".class")) continue;
                String pkg = this.dirname(element.getName());
                String member = this.basename(element.getName());
                this.addMember(pkg, member);
            }
            Manifest manifest = jar.getManifest();
            if (manifest != null && (classpathAttr = manifest.getMainAttributes().getValue("Class-Path")) != null) {
                Object object = Predef$.MODULE$.refArrayOps((Object[])classpathAttr.split(" "));
                ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)relpath -> Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)jarpath.getParent()).map((Function1 & Serializable)_$2 -> _$2.resolve((String)relpath))).find((Function1 & Serializable)abspath -> Files.isRegularFile(abspath, new LinkOption[0]) || Files.isDirectory(abspath, new LinkOption[0])).foreach((Function1)(JProcedure1 & Serializable)entry -> this.visit((Path)entry)));
            }
        }
    }

    public void visitBootClasspath(Function1<String, Object> isExcludedPackage) {
        if (Properties$.MODULE$.isJavaAtLeast("9")) {
            this.expandJrtClasspath(isExcludedPackage);
            return;
        }
        PackageIndex$.MODULE$.bootClasspath().foreach((Function1)(JProcedure1 & Serializable)entry -> this.visit((Path)entry));
    }

    private void expandJrtClasspath(Function1<String, Object> isExcludedPackage) {
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        Path dir = fs.getPath("/packages", new String[0]);
        package$.MODULE$.CollectionConverters().IteratorHasAsScala(Files.newDirectoryStream(dir).iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)pkg -> package$.MODULE$.CollectionConverters().IteratorHasAsScala(Files.list(pkg).iterator()).asScala().foreach((Function1 & Serializable)moduleLink -> {
            Path module = !Files.isSymbolicLink(moduleLink) ? moduleLink : Files.readSymbolicLink(moduleLink);
            return Files.walkFileTree(module, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(module, isExcludedPackage, this){
                private final Path module$1;
                private final Function1 isExcludedPackage$1;
                private String activeDirectory;
                private final /* synthetic */ PackageIndex $outer;
                {
                    this.module$1 = module$2;
                    this.isExcludedPackage$1 = isExcludedPackage$4;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.activeDirectory = "";
                }

                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    this.activeDirectory = package$.MODULE$.CollectionConverters().IteratorHasAsScala(this.module$1.relativize(dir).iterator()).asScala().mkString("", "/", "/");
                    if (BoxesRunTime.unboxToBoolean((Object)this.isExcludedPackage$1.apply((Object)this.activeDirectory))) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String filename = file.getFileName().toString();
                    if (filename.endsWith(".class")) {
                        this.$outer.addMember(this.activeDirectory, filename);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }));
    }

    public static final /* synthetic */ boolean scala$meta$internal$metals$PackageIndex$$anon$2$$_$visitFile$$anonfun$1(String member$1, Path _$1) {
        return member$1.endsWith(".class");
    }
}

