/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Function6;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.meta.internal.metals.PrefixCharSequence$;
import scala.meta.internal.metals.StringBloomFilter;
import scala.meta.internal.metals.TrigramSubstrings$;
import scala.meta.internal.metals.ZeroCopySubSequence;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.function.JProcedure1;

public class Fuzzy {
    private final int PrefixSearchLimit;

    public Fuzzy() {
        this.PrefixSearchLimit = 3;
    }

    public boolean prefixMatch(CharSequence query2, CharSequence symbol2, int skipNames) {
        return this.genericMatches(query2, symbol2, skipNames, (Function6<CharSequence, Object, Object, CharSequence, Object, Object, Object>)(Function6 & Serializable)(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx) -> this.prefixMatch$$anonfun$1((CharSequence)query, BoxesRunTime.unboxToInt((Object)queryStartIdx), BoxesRunTime.unboxToInt((Object)queryEndIdx), (CharSequence)symbol, BoxesRunTime.unboxToInt((Object)symbolStartIdx), BoxesRunTime.unboxToInt((Object)symbolEndIdx)));
    }

    public int prefixMatch$default$3() {
        return 0;
    }

    public boolean matches(CharSequence query2, CharSequence symbol2, int skipNames, boolean forgivingFirstChar) {
        Function6 & Serializable matcher = forgivingFirstChar ? (Function6 & Serializable)(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx) -> this.$anonfun$1((CharSequence)query, BoxesRunTime.unboxToInt((Object)queryStartIdx), BoxesRunTime.unboxToInt((Object)queryEndIdx), (CharSequence)symbol, BoxesRunTime.unboxToInt((Object)symbolStartIdx), BoxesRunTime.unboxToInt((Object)symbolEndIdx)) : (Function6 & Serializable)(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx) -> this.$anonfun$2((CharSequence)query, BoxesRunTime.unboxToInt((Object)queryStartIdx), BoxesRunTime.unboxToInt((Object)queryEndIdx), (CharSequence)symbol, BoxesRunTime.unboxToInt((Object)symbolStartIdx), BoxesRunTime.unboxToInt((Object)symbolEndIdx));
        return this.genericMatches(query2, symbol2, skipNames, (Function6<CharSequence, Object, Object, CharSequence, Object, Object, Object>)matcher);
    }

    public int matches$default$3() {
        return 0;
    }

    public boolean matches$default$4() {
        return false;
    }

    private boolean genericMatches(CharSequence query, CharSequence symbol, int skipNames, Function6<CharSequence, Object, Object, CharSequence, Object, Object, Object> matchesName) {
        int li = this.lastIndex(symbol);
        return this.loopDelimiters$1(query, symbol, matchesName, li, query.length(), this.lastIndex(symbol), 0, skipNames);
    }

    private boolean exactMatch(CharSequence query, CharSequence symbol, int sa, int sb) {
        if (query.length() == sb - sa) {
            for (int idx = 0; idx < query.length(); ++idx) {
                if (query.charAt(idx) == symbol.charAt(sa + idx)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean matchesNamePrefix(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        int sLen = symbolEndIdx - symbolStartIdx;
        int qLen = queryEndIdx - queryStartIdx;
        if (sLen < qLen) {
            return false;
        }
        int idx = 0;
        int offset = 0;
        while (idx < qLen && idx + offset < sLen) {
            if (query.charAt(queryStartIdx + idx) != symbol.charAt(symbolStartIdx + offset + idx)) {
                if (symbol.charAt(symbolStartIdx + idx) == '`') {
                    ++offset;
                    continue;
                }
                return false;
            }
            ++idx;
        }
        return true;
    }

    private int lastIndex(CharSequence symbol) {
        int end;
        for (end = symbol.length() - (this.endsWith(symbol, ".class") ? ".class".length() : 1); end >= 0 && this.isDelimiter(symbol.charAt(end)); --end) {
        }
        return end + 1;
    }

    public boolean isDelimiter(char ch) {
        char c = ch;
        switch (c) {
            case '#': 
            case '$': 
            case '.': 
            case '/': {
                return true;
            }
        }
        return false;
    }

    public int nameLength(CharSequence symbol) {
        int end;
        int start;
        for (start = end = this.lastIndex(symbol) - 1; start >= 0 && !this.isDelimiter(symbol.charAt(start)); --start) {
        }
        if (start < 0) {
            return end + 1;
        }
        return end - start;
    }

    public boolean endsWith(CharSequence cs, String string) {
        int a = cs.length() - 1;
        int b = string.length() - 1;
        if (b > a) {
            return false;
        }
        if (b == 0) {
            return false;
        }
        for (int i = 0; i <= a && i <= b; ++i) {
            if (cs.charAt(a - i) == string.charAt(b - i)) continue;
            return false;
        }
        return true;
    }

    private Delimiter lastDelimiter(CharSequence string, int fromIndex) {
        int curr = fromIndex - 2;
        boolean bl = true;
        while (curr >= 0 && bl) {
            if (this.isDelimiter(string.charAt(curr))) {
                bl = false;
                continue;
            }
            --curr;
        }
        if (curr < 0) {
            return new Delimiter(true, 0);
        }
        return new Delimiter(false, curr + 1);
    }

    public boolean matchesName(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        int backtickAdjust = symbol.charAt(symbolStartIdx) == '`' ? 1 : 0;
        return Fuzzy.loop$1(queryEndIdx, symbolEndIdx, query, symbol, queryStartIdx, -1, symbolStartIdx + backtickAdjust, -1);
    }

    public boolean forgivingFirstCharMatcher(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        boolean symbolStartCharIsLower = RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(symbol.charAt(symbolStartIdx)));
        int backtickAdjust = symbol.charAt(symbolStartIdx) == '`' ? 1 : 0;
        return Fuzzy.loop$2(queryEndIdx, symbolEndIdx, query, symbol, queryStartIdx, symbolStartCharIsLower, symbolStartIdx, queryStartIdx, -1, symbolStartIdx + backtickAdjust, -1);
    }

    public StringBloomFilter bloomFilterSymbolStrings(Iterable<String> symbols) {
        int estimatedSize = BoxesRunTime.unboxToInt((Object)symbols.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> Fuzzy.$anonfun$3(BoxesRunTime.unboxToInt((Object)x$1), (String)x$2)));
        StringBloomFilter hasher = new StringBloomFilter(estimatedSize);
        this.bloomFilterSymbolStrings(symbols, hasher);
        return hasher;
    }

    public void bloomFilterSymbolStrings(String symbol, StringBloomFilter hasher) {
        int i;
        ObjectRef allUpper = ObjectRef.create((Object)package$.MODULE$.List().empty());
        StringBuilder upper = new StringBuilder();
        if (symbol.endsWith("$sp.class")) {
            return;
        }
        hasher.reset();
        int delimiter = i = 0;
        int symbolicDelimiter = i;
        int N = this.lastIndex(symbol);
        while (i < N) {
            char ch;
            char c = ch = symbol.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '.': 
                case '/': {
                    hasher.reset();
                    symbolicDelimiter = delimiter = i + 1;
                    Fuzzy.flushUpper$1(upper, allUpper);
                    Boolean bl = BoxedUnit.UNIT;
                    break;
                }
                default: {
                    if (RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ch))) {
                        delimiter = i;
                        hasher.reset();
                        upper.append(ch);
                    }
                    Boolean bl = BoxesRunTime.boxToBoolean((boolean)hasher.putCharIncrementally(ch));
                    break;
                }
            }
            ++i;
        }
        ZeroCopySubSequence lastName = new ZeroCopySubSequence(symbol, symbolicDelimiter, N);
        if (!symbol.endsWith("/") && !this.isAllNumeric(lastName)) {
            for (int idx = 0; idx < lastName.length() && idx < this.PrefixSearchLimit(); ++idx) {
                hasher.putCharSequence(PrefixCharSequence$.MODULE$.apply(new ZeroCopySubSequence(symbol, symbolicDelimiter, symbolicDelimiter + idx + 1)));
            }
        }
        Fuzzy.flushUpper$1(upper, allUpper);
        TrigramSubstrings$.MODULE$.foreach((List<String>)((List)allUpper.elem), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)trigram -> hasher.putCharSequence((CharSequence)trigram), TrigramSubstrings$.MODULE$.foreach$default$3());
    }

    public void bloomFilterSymbolStrings(Iterable<String> symbols, StringBloomFilter hasher) {
        symbols.foreach((Function1)(JProcedure1 & Serializable)sym -> this.bloomFilterSymbolStrings((String)sym, hasher));
    }

    public boolean isAllNumeric(CharSequence string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public int PrefixSearchLimit() {
        return this.PrefixSearchLimit;
    }

    public Iterable<CharSequence> bloomFilterQueryStrings(String query, boolean includeTrigrams, boolean isShortQueryRetry) {
        if (query.isEmpty()) {
            return package$.MODULE$.Nil();
        }
        if (query.length() < this.PrefixSearchLimit() && !isShortQueryRetry) {
            return (Iterable)new .colon.colon((Object)PrefixCharSequence$.MODULE$.apply(query), (List)Nil$.MODULE$);
        }
        ObjectRef allUpper = ObjectRef.create((Object)package$.MODULE$.List().empty());
        StringBuilder upper = new StringBuilder();
        Set result = (Set)Set$.MODULE$.empty();
        int border = 0;
        block6: for (int i = 0; i < query.length(); ++i) {
            char ch;
            char c = ch = query.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '.': 
                case '/': {
                    result.add((Object)new ZeroCopySubSequence(query, border, i));
                    border = i + 1;
                    Fuzzy.flushUpper$2(upper, allUpper);
                    continue block6;
                }
                default: {
                    if (!RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ch))) continue block6;
                    if (border != i) {
                        ZeroCopySubSequence exactName = new ZeroCopySubSequence(query, border, i);
                        result.add((Object)exactName);
                    }
                    upper.append(ch);
                    border = i;
                    continue block6;
                }
            }
        }
        char c = StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(query));
        switch (c) {
            case '#': 
            case '$': 
            case '.': 
            case '/': {
                Object object = BoxedUnit.UNIT;
                break;
            }
            default: {
                Object object = BoxesRunTime.boxToBoolean((boolean)result.add((Object)new ZeroCopySubSequence(query, border, query.length())));
                break;
            }
        }
        Fuzzy.flushUpper$2(upper, allUpper);
        if (includeTrigrams) {
            TrigramSubstrings$.MODULE$.foreach((List<String>)((List)allUpper.elem), (Function1<String, BoxedUnit>)(JProcedure1 & Serializable)trigram -> result.$plus$eq(trigram), TrigramSubstrings$.MODULE$.foreach$default$3());
        }
        return result;
    }

    public boolean bloomFilterQueryStrings$default$2() {
        return true;
    }

    public boolean bloomFilterQueryStrings$default$3() {
        return false;
    }

    public boolean matchesSubCharacters(CharSequence query, CharSequence sym) {
        int A = query.length();
        int B = sym.length();
        return Fuzzy.loop$3(A, B, query, sym, 0, 0);
    }

    private final /* synthetic */ boolean prefixMatch$$anonfun$1(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        return this.matchesNamePrefix(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx);
    }

    private final /* synthetic */ boolean $anonfun$1(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        return this.forgivingFirstCharMatcher(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx);
    }

    private final /* synthetic */ boolean $anonfun$2(CharSequence query, int queryStartIdx, int queryEndIdx, CharSequence symbol, int symbolStartIdx, int symbolEndIdx) {
        return this.matchesName(query, queryStartIdx, queryEndIdx, symbol, symbolStartIdx, symbolEndIdx);
    }

    private final boolean loopDelimiters$1(CharSequence query$1, CharSequence symbol$1, Function6 matchesName$1, int li$1, int qb, int sb, int depth, int skip) {
        while (true) {
            Delimiter qd = this.lastDelimiter(query$1, qb);
            Delimiter sd = this.lastDelimiter(symbol$1, sb);
            if (skip > 0) {
                int n = sd.idx() - 1;
                int n2 = skip - 1;
                sb = n;
                skip = n2;
                continue;
            }
            boolean isMatch = BoxesRunTime.unboxToBoolean((Object)matchesName$1.apply((Object)query$1, (Object)BoxesRunTime.boxToInteger((int)qd.idx()), (Object)BoxesRunTime.boxToInteger((int)qb), (Object)symbol$1, (Object)BoxesRunTime.boxToInteger((int)sd.idx()), (Object)BoxesRunTime.boxToInteger((int)sb)));
            if (isMatch) {
                if (qd.isFinished()) {
                    return true;
                }
                if (sd.isFinished()) {
                    return false;
                }
                int n = qd.idx() - 1;
                int n3 = sd.idx() - 1;
                int n4 = depth + 1;
                int n5 = skip - 1;
                qb = n;
                sb = n3;
                depth = n4;
                skip = n5;
                continue;
            }
            if (sb == li$1 && this.exactMatch("package", symbol$1, sd.idx(), sb)) {
                sb = sd.idx() - 1;
                continue;
            }
            if (depth <= 0 || sd.isFinished()) break;
            int n = sd.idx() - 1;
            int n6 = skip - 1;
            sb = n;
            skip = n6;
        }
        return false;
    }

    private static final boolean loop$1(int queryEndIdx$1, int symbolEndIdx$1, CharSequence query$2, CharSequence symbol$2, int qa, int ql, int sa, int sl) {
        while (qa < queryEndIdx$1) {
            char ss;
            if (sa >= symbolEndIdx$1) {
                return false;
            }
            char qq = query$2.charAt(qa);
            if (qq == (ss = symbol$2.charAt(sa))) {
                int qll = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(qq)) ? qa : ql;
                int sll = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(ss)) ? sa : sl;
                int n = qa + 1;
                int n2 = qll;
                int n3 = sa + 1;
                int n4 = sll;
                qa = n;
                ql = n2;
                sa = n3;
                sl = n4;
                continue;
            }
            if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(qq))) {
                if (sl < 0 || ql < 0) {
                    return false;
                }
                int n = ql;
                int n5 = -1;
                int n6 = sl + 1;
                int n7 = -1;
                qa = n;
                ql = n5;
                sa = n6;
                sl = n7;
                continue;
            }
            ++sa;
        }
        return true;
    }

    private static final boolean loop$2(int queryEndIdx$2, int symbolEndIdx$2, CharSequence query$3, CharSequence symbol$3, int queryStartIdx$1, boolean symbolStartCharIsLower$1, int symbolStartIdx$1, int queryPos, int queryBacktrackingPos, int symbolPos, int symbolBacktrackingPos) {
        while (queryPos < queryEndIdx$2) {
            if (symbolPos >= symbolEndIdx$2) {
                return false;
            }
            char qChar = query$3.charAt(queryPos);
            char sChar = symbol$3.charAt(symbolPos);
            if (queryPos == queryStartIdx$1 && symbolStartCharIsLower$1 && RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(qChar)) == sChar) {
                int n = queryPos + 1;
                int n2 = queryPos;
                int n3 = symbolPos + 1;
                int n4 = symbolPos;
                queryPos = n;
                queryBacktrackingPos = n2;
                symbolPos = n3;
                symbolBacktrackingPos = n4;
                continue;
            }
            if (queryPos == queryStartIdx$1 && symbolPos != symbolStartIdx$1 && qChar == sChar) {
                int n = symbolPos + 1;
                int n5 = symbolPos;
                symbolPos = n;
                symbolBacktrackingPos = n5;
                continue;
            }
            if (qChar == sChar) {
                int newQueryBP = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(qChar)) ? queryPos : queryBacktrackingPos;
                int newSymbolBP = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(sChar)) ? symbolPos : symbolBacktrackingPos;
                int n = queryPos + 1;
                int n6 = newQueryBP;
                int n7 = symbolPos + 1;
                int n8 = newSymbolBP;
                queryPos = n;
                queryBacktrackingPos = n6;
                symbolPos = n7;
                symbolBacktrackingPos = n8;
                continue;
            }
            if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(qChar)) && queryPos != queryStartIdx$1) {
                if (queryBacktrackingPos < 0 || symbolBacktrackingPos < 0) {
                    return false;
                }
                int n = queryBacktrackingPos;
                int n9 = -1;
                int n10 = symbolPos + 1;
                int n11 = -1;
                queryPos = n;
                queryBacktrackingPos = n9;
                symbolPos = n10;
                symbolBacktrackingPos = n11;
                continue;
            }
            ++symbolPos;
        }
        return true;
    }

    private static final /* synthetic */ int $anonfun$3(int x$1, String x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int accum = BoxesRunTime.unboxToInt((Object)tuple2._1());
            String string = (String)tuple2._2();
            int redundantSuffix = string.endsWith(".class") ? ".class".length() : 0;
            int uppercases = StringOps$.MODULE$.count$extension(Predef$.MODULE$.augmentString(string), (Function1 & Serializable)_$1 -> RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)_$1))));
            return accum + string.length() + TrigramSubstrings$.MODULE$.trigramCombinations(uppercases) - redundantSuffix;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final void flushUpper$1(StringBuilder upper$1, ObjectRef allUpper$1) {
        if (upper$1.nonEmpty()) {
            String string = upper$1.result();
            allUpper$1.elem = ((List)allUpper$1.elem).$colon$colon((Object)string);
            upper$1.clear();
            return;
        }
    }

    private static final void flushUpper$2(StringBuilder upper$2, ObjectRef allUpper$2) {
        if (upper$2.nonEmpty()) {
            String string = upper$2.result();
            allUpper$2.elem = ((List)allUpper$2.elem).$colon$colon((Object)string);
            upper$2.clear();
            return;
        }
    }

    private static final boolean loop$3(int A$1, int B$1, CharSequence query$4, CharSequence sym$1, int a, int b) {
        while (a < A$1) {
            char cb;
            if (b >= B$1) {
                return false;
            }
            char ca = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(query$4.charAt(a)));
            if (ca == (cb = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(sym$1.charAt(b))))) {
                int n = a + 1;
                int n2 = b + 1;
                a = n;
                b = n2;
                continue;
            }
            if (cb == '$') {
                return false;
            }
            ++b;
        }
        return true;
    }

    public class Delimiter {
        private final boolean isFinished;
        private final int idx;

        public Delimiter(boolean isFinished, int idx) {
            this.isFinished = isFinished;
            this.idx = idx;
        }

        public boolean isFinished() {
            return this.isFinished;
        }

        public int idx() {
            return this.idx;
        }
    }
}

