/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.pc;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContextExecutor;
import scala.meta.internal.metals.PcQueryContext;
import scala.meta.internal.pc.CompilerJobQueue;
import scala.meta.internal.pc.CompilerJobQueue$;
import scala.meta.internal.pc.CompilerWrapper;
import scala.meta.internal.pc.InterruptException$;
import scala.meta.pc.CancelToken;
import scala.meta.pc.PresentationCompilerConfig;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public abstract class CompilerAccess<Reporter, Compiler> {
    private final PresentationCompilerConfig config;
    private final Option<ScheduledExecutorService> sh;
    private final Function0<CompilerWrapper<Reporter, Compiler>> newCompiler;
    private final boolean shouldResetJobQueue;
    private final ExecutionContextExecutor ec;
    private final Logger logger;
    private final CompilerJobQueue jobs;
    private CompilerWrapper<Reporter, Compiler> _compiler;

    public CompilerAccess(PresentationCompilerConfig config, Option<ScheduledExecutorService> sh, Function0<CompilerWrapper<Reporter, Compiler>> newCompiler, boolean shouldResetJobQueue, ExecutionContextExecutor ec) {
        this.config = config;
        this.sh = sh;
        this.newCompiler = newCompiler;
        this.shouldResetJobQueue = shouldResetJobQueue;
        this.ec = ec;
        this.logger = Logger.getLogger(CompilerAccess.class.getName());
        this.jobs = CompilerJobQueue$.MODULE$.apply();
    }

    private boolean isEmpty() {
        return this._compiler == null;
    }

    private boolean isDefined() {
        return !this.isEmpty();
    }

    private CompilerWrapper<Reporter, Compiler> loadCompiler() {
        if (this._compiler == null) {
            this._compiler = (CompilerWrapper)this.newCompiler.apply();
        }
        this._compiler.resetReporter();
        return this._compiler;
    }

    public abstract Reporter newReporter();

    public Reporter reporter() {
        if (this.isEmpty()) {
            return this.newReporter();
        }
        return this._compiler.reporterAccess().reporter();
    }

    public boolean isLoaded() {
        return this._compiler != null;
    }

    public void shutdown() {
        this.shutdownCurrentCompiler();
        this.jobs.shutdown();
    }

    public void shutdownCurrentCompiler() {
        CompilerWrapper compiler = this._compiler;
        if (compiler != null) {
            compiler.askShutdown();
            this._compiler = null;
            this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
                if (compiler.isAlive()) {
                    compiler.stop();
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            }, 2L, TimeUnit.SECONDS));
            return;
        }
    }

    public <T> CompletableFuture<T> withInterruptableCompiler(T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, PcQueryContext queryInfo) {
        AtomicBoolean isFinished = new AtomicBoolean(false);
        ObjectRef queueThread = ObjectRef.create((Object)Option$.MODULE$.empty());
        CompletableFuture<T> result = this.onCompilerJobQueue((Function0 & Serializable)() -> {
            Object object;
            queueThread$1.elem = Some$.MODULE$.apply((Object)Thread.currentThread());
            try {
                object = this.withSharedCompiler(t, thunk, queryInfo);
            }
            finally {
                isFinished.set(true);
            }
            return object;
        }, token);
        token.onCancel().whenCompleteAsync((isCancelled, _$2) -> ((Option)queueThread$2.elem).foreach((Function1)(JProcedure1 & Serializable)thread -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && isFinished.compareAndSet(false, true) && this.isDefined()) {
                Option<Thread> option = this._compiler.presentationCompilerThread();
                if (None$.MODULE$.equals(option)) {
                    return;
                }
                if (option instanceof Some) {
                    Thread pcThread = (Thread)((Some)option).value();
                    pcThread.interrupt();
                    Thread thread2 = thread;
                    Thread thread3 = pcThread;
                    if (thread2 == null ? thread3 != null : !thread2.equals(thread3)) {
                        thread.interrupt();
                        return;
                    }
                    return;
                }
                throw new MatchError(option);
            }
        }), (Executor)this.ec);
        return result;
    }

    public <T> CompletableFuture<T> withNonInterruptableCompiler(T t, CancelToken token, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, PcQueryContext queryInfo) {
        return this.onCompilerJobQueue((Function0 & Serializable)() -> this.withSharedCompiler(t, thunk, queryInfo), token);
    }

    public <T> T withSharedCompiler(T t, Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, PcQueryContext queryInfo) {
        Object object;
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null && InterruptException$.MODULE$.unapply(throwable2)) {
                object = t;
            }
            if (throwable2 != null) {
                Throwable other = throwable2;
                object = this.handleSharedCompilerException(other).map((Function1 & Serializable)message -> this.retryWithCleanCompiler(thunk, t, (String)message, queryInfo)).getOrElse(() -> this.withSharedCompiler$$anonfun$2(other, queryInfo, t));
            }
            throw throwable;
        }
        return (T)object;
    }

    public abstract Option<String> handleSharedCompilerException(Throwable var1);

    public abstract boolean ignoreException(Throwable var1);

    private <T> T retryWithCleanCompiler(Function1<CompilerWrapper<Reporter, Compiler>, T> thunk, T t, String cause, PcQueryContext queryInfo) {
        Object object;
        this.shutdownCurrentCompiler();
        this.logger.log(Level.INFO, new StringBuilder(62).append("compiler crashed due to ").append(cause).append(", retrying with new compiler instance.").toString());
        try {
            object = thunk.apply(this.loadCompiler());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 != null) {
                if (InterruptException$.MODULE$.unapply(throwable2)) {
                    object = t;
                }
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    this.handleError(e, queryInfo);
                    object = t;
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    private void handleError(Throwable e, PcQueryContext queryInfo) {
        queryInfo.report("compiler-error", e, "");
        this.shutdownCurrentCompiler();
    }

    private <T> CompletableFuture<T> onCompilerJobQueue(Function0<T> thunk, CancelToken token) {
        CompletableFuture result = new CompletableFuture();
        this.jobs.submit(result, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            token.checkCanceled();
            Thread.interrupted();
            result.complete(thunk.apply());
        });
        token.onCancel().whenCompleteAsync((isCancelled, _$3) -> {
            if (Predef$.MODULE$.Boolean2boolean(isCancelled) && !result.isDone()) {
                result.cancel(false);
                return;
            }
        }, (Executor)this.ec);
        this.sh.foreach((Function1 & Serializable)scheduler -> scheduler.schedule(() -> {
            if (!result.isDone()) {
                BoxedUnit boxedUnit;
                try {
                    if (this.shouldResetJobQueue) {
                        this.jobs.reset();
                    }
                    result.cancel(false);
                    this.shutdownCurrentCompiler();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                    } else if (throwable2 != null) {
                        Throwable other = throwable2;
                        if (!this.ignoreException(other)) {
                            throw other;
                        }
                    } else {
                        throw throwable;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
                return boxedUnit;
            }
            return BoxedUnit.UNIT;
        }, this.config.timeoutDelay(), this.config.timeoutUnit()));
        return result;
    }

    private final Object withSharedCompiler$$anonfun$2(Throwable other$1, PcQueryContext queryInfo$4, Object default$4) {
        this.handleError(other$1, queryInfo$4);
        return default$4;
    }
}

