/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHashFactory;
import scala.Predef$;

public class StringBloomFilter {
    private final double maxFalsePositiveRatio;
    private final BloomFilter<Long> bloom;
    private final StreamingXXHash64 streamingHash;
    private final byte[] buffer;

    public StringBloomFilter(int estimatedSize) {
        this.maxFalsePositiveRatio = 0.01;
        this.bloom = BloomFilter.create((Funnel)Funnels.longFunnel(), (int)Predef$.MODULE$.Integer2int(Integer.valueOf(estimatedSize)), (double)this.maxFalsePositiveRatio());
        XXHashFactory factory = XXHashFactory.fastestJavaInstance();
        this.streamingHash = factory.newStreamingHash64(1234L);
        this.buffer = new byte[2];
    }

    public double maxFalsePositiveRatio() {
        return this.maxFalsePositiveRatio;
    }

    public BloomFilter<Long> bloom() {
        return this.bloom;
    }

    public boolean isFull() {
        return this.bloom().expectedFpp() > this.maxFalsePositiveRatio();
    }

    public void reset() {
        this.streamingHash.reset();
    }

    public long value() {
        return this.streamingHash.getValue();
    }

    public boolean putCharIncrementally(char c) {
        this.updateHashCode(c);
        return this.bloom().put((Object)Predef$.MODULE$.long2Long(this.value()));
    }

    private void updateHashCode(char c) {
        this.buffer[0] = (byte)c;
        this.buffer[1] = (byte)(c >> 8);
        this.streamingHash.update(this.buffer, 0, 2);
    }

    public boolean putCharSequence(CharSequence chars) {
        return this.bloom().put((Object)Predef$.MODULE$.long2Long(this.computeHashCode(chars)));
    }

    public long computeHashCode(CharSequence chars) {
        this.streamingHash.reset();
        int N = chars.length();
        for (int i = 0; i < N; ++i) {
            this.updateHashCode(chars.charAt(i));
        }
        return this.value();
    }

    public boolean mightContain(CharSequence chars) {
        return this.bloom().mightContain((Object)Predef$.MODULE$.long2Long(this.computeHashCode(chars)));
    }

    public boolean mightContain(long hashCode) {
        return this.bloom().mightContain((Object)Predef$.MODULE$.long2Long(hashCode));
    }

    public long approximateElementCount() {
        return this.bloom().approximateElementCount();
    }
}

