/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.pc;

import dotty.tools.dotc.ast.Positioned;
import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Names;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.interactive.Interactive$;
import dotty.tools.dotc.interactive.InteractiveDriver;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourceFile$;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.dotc.util.SourcePosition$;
import dotty.tools.dotc.util.Spans;
import dotty.tools.pc.utils.InteractiveEnrichments$;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SelectionRange;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.meta.pc.OffsetParams;
import scala.package$;
import scala.runtime.LazyRef;
import scala.runtime.Scala3RunTime$;

public class SelectionRangeProvider {
    private final InteractiveDriver driver;
    private final java.util.List<OffsetParams> params;

    public SelectionRangeProvider(InteractiveDriver driver, java.util.List<OffsetParams> params) {
        this.driver = driver;
        this.params = params;
    }

    public List<SelectionRange> selectionRange() {
        LazyRef lazyRef = new LazyRef();
        return CollectionConverters$.MODULE$.ListHasAsScala(this.params).asScala().toList().map((Function1 & Serializable)param -> {
            URI x$proxy1 = param.uri();
            if (x$proxy1 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            URI uri = x$proxy1;
            String x$proxy2 = param.text();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            String text = x$proxy2;
            Path filePath = Paths.get(uri);
            SourceFile source = SourceFile$.MODULE$.virtual(filePath.toString(), text, SourceFile$.MODULE$.virtual$default$3());
            this.driver.run(uri, source);
            SourcePosition pos = InteractiveEnrichments$.MODULE$.sourcePosition(this.driver, (OffsetParams)param, InteractiveEnrichments$.MODULE$.sourcePosition$default$3(this.driver));
            List path = Interactive$.MODULE$.pathTo((List)this.driver.openedTrees().apply((Object)uri), pos, this.ctx$1(lazyRef));
            List bareRanges = path.flatMap((Function1 & Serializable)tree -> this.selectionRangesFromTree(pos, (Trees.Tree<Types.Type>)tree, this.ctx$1(lazyRef)));
            List comments = (List)this.driver.compilationUnits().get((Object)uri).map((Function1 & Serializable)_$1 -> _$1.comments()).toList().flatten(Predef$.MODULE$.$conforms());
            List commentRanges = comments.find((Function1 & Serializable)_$2 -> Spans.Span$.MODULE$.contains$extension(_$2.span(), pos.span())).map((Function1 & Serializable)comment -> {
                int startLine = source.offsetToLine(Spans.Span$.MODULE$.start$extension(comment.span()));
                int endLine = source.offsetToLine(Spans.Span$.MODULE$.end$extension(comment.span()));
                int startChar = source.column(Spans.Span$.MODULE$.start$extension(comment.span()));
                int endChar = source.column(Spans.Span$.MODULE$.end$extension(comment.span()));
                return new SelectionRange(startLine, startChar, endLine, endChar){
                    {
                        this.setRange(new Range(new Position(startLine$1, startChar$1), new Position(endLine$1, endChar$1)));
                    }
                };
            }).toList();
            return (SelectionRange)((IterableOnceOps)commentRanges.$plus$plus((IterableOnce)bareRanges)).reduceRightOption((Function2 & Serializable)(child, parent) -> this.setParent((SelectionRange)child, (SelectionRange)parent)).getOrElse(SelectionRangeProvider::selectionRange$$anonfun$1$$anonfun$2);
        });
    }

    private Iterable<SelectionRange> selectionRangesFromTree(SourcePosition pos, Trees.Tree<Types.Type> tree, Contexts.Context x$3) {
        SelectionRange treeSelectionRange = SelectionRangeProvider.toSelectionRange$1(tree.sourcePos(x$3));
        Trees.Tree<Types.Type> tree2 = tree;
        if (tree2 instanceof Trees.DefDef) {
            Trees.DefDef defDef = Trees.DefDef$.MODULE$.unapply((Trees.DefDef)tree2);
            Names.TermName termName = defDef._1();
            List list = defDef._2();
            Trees.Tree tree3 = defDef._3();
            Object object = defDef._4();
            Names.TermName name = termName;
            List paramss = list;
            Trees.Tree tpt = tree3;
            Object rhs = object;
            Option selectedParams = paramss.iterator().flatMap((Function1 & Serializable)x$1 -> {
                List list = x$1;
                SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)list);
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) == 0) {
                    Trees.ValOrTypeDef valOrTypeDef;
                    Trees.ValOrTypeDef param = valOrTypeDef = (Trees.ValOrTypeDef)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    return Some$.MODULE$.apply((Object)((Positioned)param).sourcePos(x$3));
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 1) >= 0) {
                    Seq seq;
                    Trees.ValOrTypeDef valOrTypeDef;
                    Trees.ValOrTypeDef head = valOrTypeDef = (Trees.ValOrTypeDef)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                    Seq tail = seq = SeqFactory.UnapplySeqWrapper$.MODULE$.drop$extension(seqOps, 1);
                    List params = list;
                    SourcePosition srcPos = ((Positioned)head).sourcePos(x$3);
                    long lastSpan = ((Positioned)tail.last()).span();
                    return Some$.MODULE$.apply((Object)SourcePosition$.MODULE$.apply(srcPos.source(), Spans.Span$.MODULE$.union$extension(srcPos.span(), lastSpan), srcPos.outer()));
                }
                if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)list);
            }).find((Function1 & Serializable)_$3 -> _$3.contains(pos)).map((Function1 & Serializable)srcPos -> SelectionRangeProvider.toSelectionRange$1(srcPos));
            return (Iterable)Option$.MODULE$.option2Iterable(selectedParams).$plus$plus((IterableOnce)((SeqOps)new .colon.colon((Object)treeSelectionRange, (List)Nil$.MODULE$)));
        }
        return (Iterable)((SeqOps)new .colon.colon((Object)treeSelectionRange, (List)Nil$.MODULE$));
    }

    private SelectionRange setParent(SelectionRange child, SelectionRange parent) {
        Range range = child.getRange();
        Range range2 = parent.getRange();
        if (!(range != null ? !range.equals(range2) : range2 != null)) {
            return parent;
        }
        child.setParent(parent);
        return child;
    }

    private final Contexts.Context ctx$lzyINIT1$1(LazyRef ctx$lzy1$1) {
        Contexts.Context context;
        LazyRef lazyRef = ctx$lzy1$1;
        synchronized (lazyRef) {
            context = (Contexts.Context)(ctx$lzy1$1.initialized() ? ctx$lzy1$1.value() : ctx$lzy1$1.initialize((Object)this.driver.currentCtx()));
        }
        return context;
    }

    private final Contexts.Context ctx$1(LazyRef ctx$lzy1$2) {
        return (Contexts.Context)(ctx$lzy1$2.initialized() ? ctx$lzy1$2.value() : this.ctx$lzyINIT1$1(ctx$lzy1$2));
    }

    private static final SelectionRange selectionRange$$anonfun$1$$anonfun$2() {
        return new SelectionRange();
    }

    private static final SelectionRange toSelectionRange$1(SourcePosition srcPos) {
        SelectionRange selectionRange = new SelectionRange();
        selectionRange.setRange(InteractiveEnrichments$.MODULE$.toLsp(srcPos));
        return selectionRange;
    }
}

