/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.utils;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.meta.internal.metals.TimeFormatter$;
import scala.meta.internal.metals.utils.LimitedFilesManager$WithTimestamp$;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.metals.utils.TimestampedFile$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import scala.util.matching.Regex;

public class LimitedFilesManager {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LimitedFilesManager.class.getDeclaredField("WithTimestamp$lzy1"));
    private final Path directory;
    private final int fileLimit;
    public final Regex scala$meta$internal$metals$utils$LimitedFilesManager$$prefixRegex;
    public final String scala$meta$internal$metals$utils$LimitedFilesManager$$extension;
    private volatile Object WithTimestamp$lzy1;

    public LimitedFilesManager(Path directory, int fileLimit, Regex prefixRegex, String extension) {
        this.directory = directory;
        this.fileLimit = fileLimit;
        this.scala$meta$internal$metals$utils$LimitedFilesManager$$prefixRegex = prefixRegex;
        this.scala$meta$internal$metals$utils$LimitedFilesManager$$extension = extension;
    }

    public List<TimestampedFile> getAllFiles() {
        if (Files.exists(this.directory, new LinkOption[0]) && Files.isDirectory(this.directory, new LinkOption[0])) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.directory.toFile().listFiles());
            Object[] oldFormat = (File[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$1 -> _$1.isFile());
            Object object2 = Predef$.MODULE$.refArrayOps(oldFormat);
            return (List)this.directoriesWithDate().flatMap((Function1 & Serializable)dir -> this.filesWithDate((File)dir)).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)file -> this.timestampedFile((File)file), ClassTag$.MODULE$.apply(TimestampedFile.class))).toList());
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public List<File> directoriesWithDate() {
        if (Files.exists(this.directory, new LinkOption[0]) && Files.isDirectory(this.directory, new LinkOption[0])) {
            return Predef$.MODULE$.wrapRefArray((Object[])this.directory.toFile().listFiles()).toList().filter((Function1 & Serializable)d -> d.isDirectory() && TimeFormatter$.MODULE$.hasDateName(d.getName()));
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public List<TimestampedFile> deleteOld(int limit) {
        List<TimestampedFile> files = this.getAllFiles();
        if (files.length() > limit) {
            List filesToDelete = ((List)files.sortBy((Function1 & Serializable)_$2 -> _$2.timestamp(), (Ordering)Ordering.Long$.MODULE$)).slice(0, files.length() - limit);
            filesToDelete.foreach((Function1)(JProcedure1 & Serializable)f -> Files.delete(f.toPath()));
            List emptyDateDirectories = this.directoriesWithDate().filter((Function1 & Serializable)_$3 -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])_$3.listFiles());
                return ArrayOps$.MODULE$.isEmpty$extension(object);
            });
            emptyDateDirectories.foreach((Function1)(JProcedure1 & Serializable)d -> Files.delete(d.toPath()));
            return filesToDelete;
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public int deleteOld$default$1() {
        return this.fileLimit;
    }

    private Option<TimestampedFile> timestampedFile(File file) {
        return this.scala$meta$internal$metals$utils$LimitedFilesManager$$prefixRegex.findPrefixMatchOf((CharSequence)file.getName()).map((Function1 & Serializable)reMatch -> {
            String timeStr = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(reMatch.after().toString()), this.scala$meta$internal$metals$utils$LimitedFilesManager$$extension);
            return Tuple2$.MODULE$.apply(reMatch, (Object)timeStr);
        }).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Regex.Match reMatch = (Regex.Match)tuple2._1();
                String timeStr = (String)tuple2._2();
                return Try$.MODULE$.apply(() -> LimitedFilesManager.timestampedFile$$anonfun$2$$anonfun$1(timeStr)).toOption().map((Function1 & Serializable)time -> TimestampedFile$.MODULE$.apply(file, BoxesRunTime.unboxToLong((Object)time)));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private List<TimestampedFile> filesWithDate(File dir) {
        String date = dir.getName();
        Object object = Predef$.MODULE$.refArrayOps((Object[])dir.listFiles());
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)_$4 -> this.withTimeAndDate((File)_$4, date), ClassTag$.MODULE$.apply(TimestampedFile.class))).toList();
    }

    private Option<TimestampedFile> withTimeAndDate(File file, String date) {
        Option<String> option;
        String string = file.getName();
        if (string != null && !(option = this.WithTimestamp().unapply(string)).isEmpty()) {
            String string2;
            String time = string2 = (String)option.get();
            return TimeFormatter$.MODULE$.parse(time, date).map((Function1 & Serializable)timestamp -> TimestampedFile$.MODULE$.apply(file, BoxesRunTime.unboxToLong((Object)timestamp)));
        }
        return None$.MODULE$;
    }

    public final LimitedFilesManager$WithTimestamp$ WithTimestamp() {
        Object object = this.WithTimestamp$lzy1;
        if (object instanceof LimitedFilesManager$WithTimestamp$) {
            return (LimitedFilesManager$WithTimestamp$)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LimitedFilesManager$WithTimestamp$)this.WithTimestamp$lzyINIT1();
    }

    private Object WithTimestamp$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.WithTimestamp$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LimitedFilesManager$WithTimestamp$ limitedFilesManager$WithTimestamp$ = null;
                    try {
                        limitedFilesManager$WithTimestamp$ = new LimitedFilesManager$WithTimestamp$(this);
                        object2 = limitedFilesManager$WithTimestamp$ == null ? LazyVals.NullValue$.MODULE$ : limitedFilesManager$WithTimestamp$;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.WithTimestamp$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return limitedFilesManager$WithTimestamp$;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private static final long timestampedFile$$anonfun$2$$anonfun$1(String timeStr$1) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(timeStr$1));
    }

    public static final /* synthetic */ String scala$meta$internal$metals$utils$LimitedFilesManager$WithTimestamp$$$_$unapply$$anonfun$2(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            Regex.Match prefixMatch = (Regex.Match)tuple2._1();
            String time = (String)tuple2._2();
            return time;
        }
        throw new MatchError((Object)tuple2);
    }
}

