/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals.utils;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.metals.utils.TimestampedFile$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class LimitedFilesManager {
    private final Path directory;
    private final int fileLimit;
    private final Regex fileNameRegex;

    public LimitedFilesManager(Path directory, int fileLimit, String prefixPattern) {
        this.directory = directory;
        this.fileLimit = fileLimit;
        this.fileNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(13).append(prefixPattern).append("([-+]?[0-9]+)").toString()));
    }

    public List<TimestampedFile> getAllFiles() {
        if (Files.exists(this.directory, new LinkOption[0]) && Files.isDirectory(this.directory, new LinkOption[0])) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.directory.toFile().listFiles());
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)file -> this.timestampedFile((File)file), ClassTag$.MODULE$.apply(TimestampedFile.class))).toList();
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public List<TimestampedFile> deleteOld(int limit) {
        List<TimestampedFile> files = this.getAllFiles();
        if (files.length() > limit) {
            List filesToDelete = ((List)files.sortBy((Function1 & Serializable)_$1 -> _$1.timestamp(), (Ordering)Ordering.Long$.MODULE$)).slice(0, files.length() - limit);
            filesToDelete.foreach((Function1)(JProcedure1 & Serializable)f -> Files.delete(f.toPath()));
            return filesToDelete;
        }
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    public int deleteOld$default$1() {
        return this.fileLimit;
    }

    private Option<TimestampedFile> timestampedFile(File file) {
        List list;
        Option option;
        String string = file.getName();
        if (string != null && !(option = this.fileNameRegex.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(1) == 0) {
            String string2;
            String time = string2 = (String)list.apply(0);
            return Some$.MODULE$.apply((Object)TimestampedFile$.MODULE$.apply(file, StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(time))));
        }
        if (string != null) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)string);
    }
}

