/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.metals;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.meta.internal.metals.Report;
import scala.meta.internal.metals.ReportLevel;
import scala.meta.internal.metals.Reporter;
import scala.meta.internal.metals.StdReportContext$;
import scala.meta.internal.metals.utils.LimitedFilesManager;
import scala.meta.internal.metals.utils.TimestampedFile;
import scala.meta.internal.mtags.CommonMtagsEnrichments$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class StdReporter
implements Reporter {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(StdReporter.class.getDeclaredField("userHome$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StdReporter.class.getDeclaredField("reportsDir$lzy2"));
    private final Path workspace;
    private Path pathToReports;
    private final ReportLevel level;
    private volatile Object reportsDir$lzy2;
    private final LimitedFilesManager limitedFilesManager;
    private volatile Object userHome$lzy1;
    private boolean initialized;
    private Set<String> reported;
    private final String idPrefix;

    public StdReporter(Path workspace, Path pathToReports, ReportLevel level) {
        this.workspace = workspace;
        this.pathToReports = pathToReports;
        this.level = level;
        this.limitedFilesManager = new LimitedFilesManager(this.reportsDir(), StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS(), "r_.*_");
        this.initialized = false;
        this.reported = Predef$.MODULE$.Set().empty();
        this.idPrefix = "id: ";
    }

    private Path reportsDir() {
        Object object = this.reportsDir$lzy2;
        if (object instanceof Path) {
            return (Path)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Path)this.reportsDir$lzyINIT2();
    }

    private Object reportsDir$lzyINIT2() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.reportsDir$lzy2) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Path path = null;
                    try {
                        path = CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(this.workspace.resolve(this.pathToReports)).createDirectories();
                        object2 = path == null ? LazyVals.NullValue$.MODULE$ : path;
                        this.pathToReports = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.reportsDir$lzy2;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return path;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Option<String> userHome() {
        Object object = this.userHome$lzy1;
        if (object instanceof Option) {
            return (Option)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Option)this.userHome$lzyINIT1();
    }

    private Object userHome$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.userHome$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Option option = null;
                    try {
                        option = Option$.MODULE$.apply((Object)System.getProperty("user.home"));
                        object2 = option == null ? LazyVals.NullValue$.MODULE$ : option;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.userHome$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return option;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void readInIds() {
        this.reported = this.getReports().flatMap((Function1 & Serializable)report -> {
            java.util.List<String> lines = Files.readAllLines(report.file().toPath());
            if (lines.size() > 0) {
                String string = lines.get(0);
                String id = string;
                if (id.startsWith(this.idPrefix)) {
                    return Some$.MODULE$.apply((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(id), this.idPrefix));
                }
                return None$.MODULE$;
            }
            return None$.MODULE$;
        }).toSet();
    }

    @Override
    public Option<Path> create(Function0<Report> report, boolean ifVerbose) {
        Option sanitizedId;
        if (ifVerbose && !this.level.isVerbose()) {
            return None$.MODULE$;
        }
        if (!this.initialized) {
            this.readInIds();
            this.initialized = true;
        }
        if ((sanitizedId = ((Report)report.apply()).id().map((Function1 & Serializable)text -> this.sanitize((String)text))).isDefined() && this.reported.contains(sanitizedId.get())) {
            return None$.MODULE$;
        }
        Path path = this.reportsDir().resolve(new StringBuilder(3).append("r_").append(((Report)report.apply()).name()).append("_").append(System.currentTimeMillis()).toString());
        sanitizedId.foreach((Function1)(JProcedure1 & Serializable)_$5 -> {
            this.reported = (Set)this.reported.$plus(_$5);
        });
        String idString = (String)sanitizedId.map((Function1 & Serializable)id -> new StringBuilder(1).append(this.idPrefix).append((String)id).append("\n").toString()).getOrElse(StdReporter::$anonfun$3);
        CommonMtagsEnrichments$.MODULE$.XtensionNIOPath(path).writeText(new StringBuilder(0).append(idString).append(this.sanitize(((Report)report.apply()).fullText())).toString());
        return Some$.MODULE$.apply((Object)path);
    }

    @Override
    public boolean create$default$2() {
        return false;
    }

    private String sanitize(String text) {
        String textAfterWokspaceReplace = text.replace(this.workspace.toString(), StdReportContext$.MODULE$.WORKSPACE_STR());
        return (String)this.userHome().map((Function1 & Serializable)_$6 -> textAfterWokspaceReplace.replace((CharSequence)_$6, StdReportContext$.MODULE$.HOME_STR())).getOrElse(() -> StdReporter.sanitize$$anonfun$2(textAfterWokspaceReplace));
    }

    @Override
    public List<TimestampedFile> cleanUpOldReports(int maxReportsNumber) {
        return this.limitedFilesManager.deleteOld(maxReportsNumber);
    }

    @Override
    public int cleanUpOldReports$default$1() {
        return StdReportContext$.MODULE$.MAX_NUMBER_OF_REPORTS();
    }

    @Override
    public List<TimestampedFile> getReports() {
        return this.limitedFilesManager.getAllFiles();
    }

    @Override
    public void deleteAll() {
        this.getReports().foreach((Function1)(JProcedure1 & Serializable)r -> Files.delete(r.toPath()));
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final String sanitize$$anonfun$2(String textAfterWokspaceReplace$2) {
        return textAfterWokspaceReplace$2;
    }
}

