/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileRange$;
import dotty.tools.dotc.profile.ProfileSnap;
import dotty.tools.dotc.profile.RealProfiler;
import dotty.tools.dotc.profile.ThreadPoolFactory$;
import dotty.tools.dotc.profile.ThreadPoolFactory$BaseThreadPoolFactory$CommonThreadFactory$;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public interface ThreadPoolFactory {
    public static ThreadPoolFactory apply(Phases.Phase phase, Contexts.Context context) {
        return ThreadPoolFactory$.MODULE$.apply(phase, context);
    }

    public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int var1, String var2, int var3);

    public static int newUnboundedQueueFixedThreadPool$default$3$(ThreadPoolFactory $this) {
        return $this.newUnboundedQueueFixedThreadPool$default$3();
    }

    default public int newUnboundedQueueFixedThreadPool$default$3() {
        return 5;
    }

    public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int var1, int var2, RejectedExecutionHandler var3, String var4, int var5);

    public static int newBoundedQueueFixedThreadPool$default$5$(ThreadPoolFactory $this) {
        return $this.newBoundedQueueFixedThreadPool$default$5();
    }

    default public int newBoundedQueueFixedThreadPool$default$5() {
        return 5;
    }

    public static abstract class BaseThreadPoolFactory
    implements ThreadPoolFactory {
        private final ThreadGroup baseGroup;
        public final ThreadPoolFactory$BaseThreadPoolFactory$CommonThreadFactory$ CommonThreadFactory$lzy1 = new ThreadPoolFactory$BaseThreadPoolFactory$CommonThreadFactory$();

        public BaseThreadPoolFactory(Phases.Phase phase) {
            this.baseGroup = new ThreadGroup(new StringBuilder(5).append("dotc-").append(phase.phaseName()).toString());
        }

        public ThreadGroup baseGroup() {
            return this.baseGroup;
        }

        public ThreadGroup dotty$tools$dotc$profile$ThreadPoolFactory$BaseThreadPoolFactory$$childGroup(String name) {
            return new ThreadGroup(this.baseGroup(), name);
        }

        public Runnable wrapWorker(Runnable worker, String shortId) {
            return worker;
        }

        public final ThreadPoolFactory$BaseThreadPoolFactory$CommonThreadFactory$ CommonThreadFactory() {
            return this.CommonThreadFactory$lzy1;
        }

        public final class CommonThreadFactory
        implements ThreadFactory {
            private final String shortId;
            private final boolean daemon;
            private final int priority;
            private final ThreadGroup group;
            private final AtomicInteger threadNumber;
            private final String namePrefix;
            private final /* synthetic */ BaseThreadPoolFactory $outer;

            public CommonThreadFactory(BaseThreadPoolFactory $outer, String shortId, boolean daemon, int priority) {
                this.shortId = shortId;
                this.daemon = daemon;
                this.priority = priority;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.group = $outer.dotty$tools$dotc$profile$ThreadPoolFactory$BaseThreadPoolFactory$$childGroup(shortId);
                this.threadNumber = new AtomicInteger(1);
                this.namePrefix = new StringBuilder(2).append($outer.baseGroup().getName()).append("-").append(shortId).append("-").toString();
            }

            @Override
            public Thread newThread(Runnable worker) {
                Runnable wrapped = this.$outer.wrapWorker(worker, this.shortId);
                Thread t = new Thread(this.group, wrapped, new StringBuilder(0).append(this.namePrefix).append(this.threadNumber.getAndIncrement()).toString(), 0L);
                if (t.isDaemon() != this.daemon) {
                    t.setDaemon(this.daemon);
                }
                if (t.getPriority() != this.priority) {
                    t.setPriority(this.priority);
                }
                return t;
            }

            public final /* synthetic */ BaseThreadPoolFactory dotty$tools$dotc$profile$ThreadPoolFactory$BaseThreadPoolFactory$CommonThreadFactory$$$outer() {
                return this.$outer;
            }
        }
    }

    public static final class BasicThreadPoolFactory
    extends BaseThreadPoolFactory {
        public BasicThreadPoolFactory(Phases.Phase phase) {
            super(phase);
        }

        @Override
        public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int nThreads, String shortId, int priority) {
            BaseThreadPoolFactory.CommonThreadFactory threadFactory = new BaseThreadPoolFactory.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int nThreads, int maxQueueSize, RejectedExecutionHandler rejectHandler, String shortId, int priority) {
            BaseThreadPoolFactory.CommonThreadFactory threadFactory = new BaseThreadPoolFactory.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize), threadFactory, rejectHandler);
        }
    }

    public static class ProfilingThreadPoolFactory
    extends BaseThreadPoolFactory {
        private final Phases.Phase phase;
        private final RealProfiler profiler;
        private final ThreadLocal<ThreadProfileData> localData;

        public ProfilingThreadPoolFactory(Phases.Phase phase, RealProfiler profiler) {
            this.phase = phase;
            this.profiler = profiler;
            super(phase);
            this.localData = new ThreadLocal();
        }

        private RealProfiler profiler() {
            return this.profiler;
        }

        @Override
        public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int nThreads, String shortId, int priority) {
            BaseThreadPoolFactory.CommonThreadFactory threadFactory = new BaseThreadPoolFactory.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new SinglePhaseInstrumentedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        }

        @Override
        public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int nThreads, int maxQueueSize, RejectedExecutionHandler rejectHandler, String shortId, int priority) {
            BaseThreadPoolFactory.CommonThreadFactory threadFactory = new BaseThreadPoolFactory.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new SinglePhaseInstrumentedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize), threadFactory, rejectHandler);
        }

        @Override
        public Runnable wrapWorker(Runnable worker, String shortId) {
            return () -> {
                ThreadProfileData data = new ThreadProfileData();
                this.localData().set(data);
                ProfileSnap profileStart = this.profiler().snapThread(0L);
                try {
                    worker.run();
                }
                finally {
                    ProfileSnap snap = this.profiler().snapThread(data.idleNs());
                    ProfileRange threadRange = ProfileRange$.MODULE$.apply(profileStart, snap, this.phase, shortId, data.taskCount(), Thread.currentThread());
                    this.profiler().completeBackground(threadRange);
                }
            };
        }

        public ThreadLocal<ThreadProfileData> localData() {
            return this.localData;
        }

        public class SinglePhaseInstrumentedThreadPoolExecutor
        extends ThreadPoolExecutor {
            public SinglePhaseInstrumentedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
                if (ProfilingThreadPoolFactory.this == null) {
                    throw new NullPointerException();
                }
                super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            }

            @Override
            public void beforeExecute(Thread t, Runnable r) {
                ThreadProfileData data = ProfilingThreadPoolFactory.this.localData().get();
                data.taskCount_$eq(data.taskCount() + 1);
                long now = System.nanoTime();
                if (data.firstStartNs() == 0L) {
                    data.firstStartNs_$eq(now);
                } else {
                    data.idleNs_$eq(data.idleNs() + (now - data.lastEndNs()));
                }
                data.lastStartNs_$eq(now);
                super.beforeExecute(t, r);
            }

            @Override
            public void afterExecute(Runnable r, Throwable t) {
                long now = System.nanoTime();
                ThreadProfileData data = ProfilingThreadPoolFactory.this.localData().get();
                data.lastEndNs_$eq(now);
                data.runningNs_$eq(data.runningNs() + (now - data.lastStartNs()));
                super.afterExecute(r, t);
            }

            public final /* synthetic */ ProfilingThreadPoolFactory dotty$tools$dotc$profile$ThreadPoolFactory$ProfilingThreadPoolFactory$SinglePhaseInstrumentedThreadPoolExecutor$$$outer() {
                return ProfilingThreadPoolFactory.this;
            }
        }

        public final class ThreadProfileData {
            private long firstStartNs;
            private int taskCount;
            private long idleNs;
            private long runningNs;
            private long lastStartNs;
            private long lastEndNs;

            public ThreadProfileData() {
                if (ProfilingThreadPoolFactory.this == null) {
                    throw new NullPointerException();
                }
                this.firstStartNs = 0L;
                this.taskCount = 0;
                this.idleNs = 0L;
                this.runningNs = 0L;
                this.lastStartNs = 0L;
                this.lastEndNs = 0L;
            }

            public long firstStartNs() {
                return this.firstStartNs;
            }

            public void firstStartNs_$eq(long x$1) {
                this.firstStartNs = x$1;
            }

            public int taskCount() {
                return this.taskCount;
            }

            public void taskCount_$eq(int x$1) {
                this.taskCount = x$1;
            }

            public long idleNs() {
                return this.idleNs;
            }

            public void idleNs_$eq(long x$1) {
                this.idleNs = x$1;
            }

            public long runningNs() {
                return this.runningNs;
            }

            public void runningNs_$eq(long x$1) {
                this.runningNs = x$1;
            }

            public long lastStartNs() {
                return this.lastStartNs;
            }

            public void lastStartNs_$eq(long x$1) {
                this.lastStartNs = x$1;
            }

            public long lastEndNs() {
                return this.lastEndNs;
            }

            public void lastEndNs_$eq(long x$1) {
                this.lastEndNs = x$1;
            }

            public final /* synthetic */ ProfilingThreadPoolFactory dotty$tools$dotc$profile$ThreadPoolFactory$ProfilingThreadPoolFactory$ThreadProfileData$$$outer() {
                return ProfilingThreadPoolFactory.this;
            }
        }
    }
}

