/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.backend.jvm;

import dotty.tools.backend.jvm.FileConflictException;
import dotty.tools.backend.jvm.PostProcessorFrontendAccess;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.reporting.Message;
import dotty.tools.io.AbstractFile;
import dotty.tools.io.Directory$;
import dotty.tools.io.Jar;
import dotty.tools.io.JarArchive;
import dotty.tools.io.JarWriter;
import dotty.tools.io.Path$;
import dotty.tools.io.PlainDirectory;
import dotty.tools.io.PlainFile;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ClassfileWriter {
    private final PostProcessorFrontendAccess frontendAccess;
    private final AbstractFile dumpOutputDir;
    private final JarWriter jarWriter;

    public ClassfileWriter(PostProcessorFrontendAccess frontendAccess) {
        JarWriter jarWriter;
        this.frontendAccess = frontendAccess;
        this.dumpOutputDir = this.getDirectoryOrNull(frontendAccess.compilerSettings().dumpClassesDirectory());
        AbstractFile abstractFile = frontendAccess.compilerSettings().outputDirectory();
        if (abstractFile instanceof JarArchive) {
            JarArchive jar = (JarArchive)abstractFile;
            Option mainClass = frontendAccess.compilerSettings().mainClass().orElse(() -> ClassfileWriter.$anonfun$1(frontendAccess));
            jarWriter = (JarWriter)jar.underlyingSource().map((Function1 & Serializable)source -> {
                if (jar.isEmpty()) {
                    List jarMainAttrs = mainClass.map((Function1 & Serializable)_$1 -> {
                        Attributes.Name name = (Attributes.Name)Predef$.MODULE$.ArrowAssoc((Object)Attributes.Name.MAIN_CLASS);
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)name, _$1);
                    }).toList();
                    return new Jar(source.file()).jarWriter((Seq<Tuple2<Attributes.Name, String>>)jarMainAttrs);
                }
                frontendAccess.backendReporting().warning((Function1<Contexts.Context, Message>)(Function1 & Serializable)evidence$4 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Tried to write to non-empty JAR: ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_AbstractFile()).apply(source)}), (Contexts.Context)evidence$4));
                return null;
            }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        } else {
            jarWriter = null;
        }
        this.jarWriter = jarWriter;
    }

    private AbstractFile getDirectoryOrNull(Option<String> dir) {
        return (AbstractFile)dir.map((Function1 & Serializable)d -> new PlainDirectory(Directory$.MODULE$.apply((String)d))).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private AbstractFile getFile(AbstractFile base, String clsName, String suffix) {
        if (base.file() != null) {
            return this.fastGetFile(base, clsName, suffix);
        }
        ObjectRef dir = ObjectRef.create((Object)base);
        List pathParts = Predef$.MODULE$.wrapRefArray((Object[])clsName.split("[./]")).toList();
        ((List)pathParts.init()).foreach((Function1)(JProcedure1 & Serializable)part -> {
            AbstractFile abstractFile = ClassfileWriter.ensureDirectory$1(base, clsName, suffix, (AbstractFile)dir$1.elem).subdirectoryNamed((String)part);
            dir$1.elem = abstractFile;
            abstractFile = null;
        });
        return ClassfileWriter.ensureDirectory$1(base, clsName, suffix, (AbstractFile)dir.elem).fileNamed(new StringBuilder(0).append((String)pathParts.last()).append(suffix).toString());
    }

    private PlainFile fastGetFile(AbstractFile base, String clsName, String suffix) {
        int index = clsName.lastIndexOf(47);
        Tuple2 tuple2 = index > 0 ? Tuple2$.MODULE$.apply((Object)clsName.substring(0, index), (Object)clsName.substring(index + 1)) : Tuple2$.MODULE$.apply((Object)"", (Object)clsName);
        String packageName = (String)tuple2._1();
        String simpleName = (String)tuple2._2();
        Path directory = base.file().toPath().resolve(packageName);
        return new PlainFile(Path$.MODULE$.apply(directory.resolve(new StringBuilder(0).append(simpleName).append(suffix).toString())));
    }

    private void writeBytes(AbstractFile outFile, byte[] bytes) {
        if (outFile.file() != null) {
            Path outPath = outFile.file().toPath();
            try {
                Files.write(outPath, bytes, new OpenOption[0]);
            }
            catch (NoSuchFileException noSuchFileException) {
                Files.createDirectories(outPath.getParent(), new FileAttribute[0]);
                Files.write(outPath, bytes, new OpenOption[0]);
            }
            return;
        }
        try (DataOutputStream out = new DataOutputStream(outFile.bufferedOutput());){
            out.write(bytes, 0, bytes.length);
        }
    }

    public AbstractFile writeClass(String className, byte[] bytes, AbstractFile sourceFile) {
        AbstractFile abstractFile;
        try {
            AbstractFile outFile = this.writeToJarOrFile(className, bytes, ".class");
            if (this.dumpOutputDir != null) {
                AbstractFile dumpFile = this.getFile(this.dumpOutputDir, className, ".class");
                this.writeBytes(dumpFile, bytes);
            }
            abstractFile = outFile;
        }
        catch (FileConflictException e) {
            this.frontendAccess.backendReporting().error((Function1<Contexts.Context, Message>)(Function1 & Serializable)evidence$5 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"error writing ", ": ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)className), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getMessage())}), (Contexts.Context)evidence$5));
            abstractFile = null;
        }
        catch (FileSystemException e) {
            if (this.frontendAccess.compilerSettings().debug()) {
                e.printStackTrace();
            }
            this.frontendAccess.backendReporting().error((Function1<Contexts.Context, Message>)(Function1 & Serializable)evidence$6 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"error writing ", ": ", " ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)className), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getClass().getName()), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)e.getMessage())}), (Contexts.Context)evidence$6));
            abstractFile = null;
        }
        return abstractFile;
    }

    public void writeTasty(String className, byte[] bytes) {
        this.writeToJarOrFile(className, bytes, ".tasty");
    }

    private AbstractFile writeToJarOrFile(String className, byte[] bytes, String suffix) {
        if (this.jarWriter == null) {
            AbstractFile outFolder = this.frontendAccess.compilerSettings().outputDirectory();
            AbstractFile outFile = this.getFile(outFolder, className, suffix);
            try {
                this.writeBytes(outFile, bytes);
            }
            catch (ClosedByInterruptException ex) {
                try {
                    try {
                        outFile.delete();
                    }
                    catch (Throwable throwable) {
                    }
                }
                finally {
                    throw ex;
                }
            }
            return outFile;
        }
        String path = new StringBuilder(0).append(className).append(suffix).toString();
        DataOutputStream out = this.jarWriter.newOutputStream(path);
        try {
            out.write(bytes, 0, bytes.length);
        }
        finally {
            out.flush();
        }
        return null;
    }

    public void close() {
        if (this.jarWriter != null) {
            this.jarWriter.close();
            return;
        }
    }

    private static final Option $anonfun$1(PostProcessorFrontendAccess frontendAccess$1) {
        List<String> names;
        List<String> list = frontendAccess$1.getEntryPoints();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            String name = (String)colon2.head();
            Nil$ nil$ = package$.MODULE$.Nil();
            List list3 = list2;
            if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                frontendAccess$1.backendReporting().log((Function1<Contexts.Context, String>)(Function1 & Serializable)evidence$1 -> Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unique entry point: setting Main-Class to ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)name)}), (Contexts.Context)evidence$1));
                return Some$.MODULE$.apply((Object)name);
            }
        }
        if ((names = list).isEmpty()) {
            frontendAccess$1.backendReporting().warning((Function1<Contexts.Context, Message>)(Function1 & Serializable)evidence$2 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No Main-Class designated or discovered."})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), (Contexts.Context)evidence$2));
        } else {
            frontendAccess$1.backendReporting().warning((Function1<Contexts.Context, Message>)(Function1 & Serializable)evidence$3 -> Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"No Main-Class due to multiple entry points:\\n  ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)names.mkString("\n  "))}), (Contexts.Context)evidence$3));
        }
        return None$.MODULE$;
    }

    private static final AbstractFile ensureDirectory$1(AbstractFile base$1, String clsName$1, String suffix$1, AbstractFile dir) {
        if (dir.isDirectory()) {
            return dir;
        }
        throw new FileConflictException(new StringBuilder(22).append(base$1.path()).append("/").append(clsName$1).append(suffix$1).append(": ").append(dir.path()).append(" is not a directory").toString(), dir);
    }
}

