/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Denotations;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.LazyStaticField;
import dotty.tools.dotc.reporting.MemberWithSameNameAsStatic;
import dotty.tools.dotc.reporting.MissingCompanionForStatic;
import dotty.tools.dotc.reporting.StaticFieldsOnlyAllowedInObjects;
import dotty.tools.dotc.reporting.StaticFieldsShouldPrecedeNonStatic;
import dotty.tools.dotc.reporting.StaticOverridingNonStaticMembers;
import dotty.tools.dotc.reporting.TraitCompanionWithMutableStatic;
import dotty.tools.dotc.transform.CheckStatic$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.transform.SymUtils$;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.immutable.List;
import scala.runtime.BooleanRef;
import scala.runtime.function.JProcedure1;

public class CheckStatic
extends MegaPhase.MiniPhase {
    public static String name() {
        return CheckStatic$.MODULE$.name();
    }

    @Override
    public String phaseName() {
        return CheckStatic$.MODULE$.name();
    }

    @Override
    public String description() {
        return CheckStatic$.MODULE$.description();
    }

    @Override
    public Trees.Tree<Types.Type> transformTemplate(Trees.Template<Types.Type> tree, Contexts.Context x$2) {
        List defns = tree.body(x$2).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Trees.Tree x) {
                boolean bl;
                Trees.Tree tree = x;
                if (tree instanceof Trees.ValOrDefDef) {
                    Trees.ValOrDefDef t = (Trees.ValOrDefDef)tree;
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Trees.Tree x, Function1 function1) {
                Object object;
                Trees.Tree tree = x;
                if (tree instanceof Trees.ValOrDefDef) {
                    Trees.ValOrDefDef t = (Trees.ValOrDefDef)tree;
                    object = t;
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        });
        BooleanRef hadNonStaticField = BooleanRef.create((boolean)false);
        defns.foreach((Function1)(JProcedure1 & Serializable)defn -> {
            if (SymUtils$.MODULE$.isScalaStatic(defn.symbol(x$2), x$2)) {
                Symbols.Symbol companion;
                if (!Symbols$.MODULE$.toDenot(x$2.owner(), x$2).isStaticOwner(x$2)) {
                    report$.MODULE$.error(new StaticFieldsOnlyAllowedInObjects(defn.symbol(x$2), x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                    Symbols$.MODULE$.toDenot(defn.symbol(x$2), x$2).resetFlag(Flags$.MODULE$.JavaStatic());
                }
                if (defn instanceof Trees.ValDef && hadNonStaticField$1.elem) {
                    report$.MODULE$.error(new StaticFieldsShouldPrecedeNonStatic(defn.symbol(x$2), (List<Trees.Tree<Types.Type>>)defns, x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                }
                if (!Symbols$.MODULE$.toDenot(companion = Symbols$.MODULE$.toDenot(x$2.owner(), x$2).companionClass(x$2), x$2).exists()) {
                    report$.MODULE$.error(new MissingCompanionForStatic(defn.symbol(x$2), x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                } else if (CheckStatic.clashes$1(x$2, defn, companion).exists()) {
                    report$.MODULE$.error(new MemberWithSameNameAsStatic(x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                } else if (Symbols$.MODULE$.toDenot(defn.symbol(x$2), x$2).is(Flags$.MODULE$.Mutable(), x$2) && Symbols$.MODULE$.toDenot(companion, x$2).is(Flags$.MODULE$.Trait(), x$2)) {
                    report$.MODULE$.error(new TraitCompanionWithMutableStatic(x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                } else if (Symbols$.MODULE$.toDenot(defn.symbol(x$2), x$2).is(Flags$.MODULE$.Lazy(), x$2)) {
                    report$.MODULE$.error(new LazyStaticField(x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                } else if (Symbols$.MODULE$.toDenot(defn.symbol(x$2), x$2).allOverriddenSymbols(x$2).nonEmpty()) {
                    report$.MODULE$.error(new StaticOverridingNonStaticMembers(x$2), defn.srcPos(), report$.MODULE$.error$default$3(), x$2);
                }
            } else {
                boolean bl;
                hadNonStaticField$1.elem = bl = hadNonStaticField$1.elem || defn instanceof Trees.ValDef;
            }
        });
        return tree;
    }

    private static final Denotations.PreDenotation clashes$1(Contexts.Context x$2$2, Trees.ValOrDefDef defn$1, Symbols.Symbol companion$1) {
        return Symbols$.MODULE$.toClassDenot(companion$1.asClass(), x$2$2).membersNamed(defn$1.name(), x$2$2);
    }
}

