/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.profile.AsyncHelper$;
import dotty.tools.dotc.profile.AsyncHelper$BaseAsyncHelper$CommonThreadFactory$;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileRange$;
import dotty.tools.dotc.profile.ProfileSnap;
import dotty.tools.dotc.profile.RealProfiler;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public interface AsyncHelper {
    public static AsyncHelper apply(Phases.Phase phase, Contexts.Context context) {
        return AsyncHelper$.MODULE$.apply(phase, context);
    }

    public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int var1, String var2, int var3);

    public static int newUnboundedQueueFixedThreadPool$default$3$(AsyncHelper $this) {
        return $this.newUnboundedQueueFixedThreadPool$default$3();
    }

    default public int newUnboundedQueueFixedThreadPool$default$3() {
        return 5;
    }

    public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int var1, int var2, RejectedExecutionHandler var3, String var4, int var5);

    public static int newBoundedQueueFixedThreadPool$default$5$(AsyncHelper $this) {
        return $this.newBoundedQueueFixedThreadPool$default$5();
    }

    default public int newBoundedQueueFixedThreadPool$default$5() {
        return 5;
    }

    private static abstract class BaseAsyncHelper
    implements AsyncHelper {
        private final ThreadGroup baseGroup;
        public final AsyncHelper$BaseAsyncHelper$CommonThreadFactory$ CommonThreadFactory$lzy1 = new AsyncHelper$BaseAsyncHelper$CommonThreadFactory$();

        public BaseAsyncHelper(Phases.Phase phase, Contexts.Context x$2) {
            this.baseGroup = new ThreadGroup(new StringBuilder(5).append("dotc-").append(phase.phaseName()).toString());
        }

        public ThreadGroup baseGroup() {
            return this.baseGroup;
        }

        public ThreadGroup dotty$tools$dotc$profile$AsyncHelper$BaseAsyncHelper$$childGroup(String name) {
            return new ThreadGroup(this.baseGroup(), name);
        }

        public abstract Runnable wrapRunnable(Runnable var1, String var2);

        public final AsyncHelper$BaseAsyncHelper$CommonThreadFactory$ CommonThreadFactory() {
            return this.CommonThreadFactory$lzy1;
        }

        public class CommonThreadFactory
        implements ThreadFactory {
            private final String shortId;
            private final boolean daemon;
            private final int priority;
            private final ThreadGroup group;
            private final AtomicInteger threadNumber;
            private final String namePrefix;
            private final /* synthetic */ BaseAsyncHelper $outer;

            public CommonThreadFactory(BaseAsyncHelper $outer, String shortId, boolean daemon, int priority) {
                this.shortId = shortId;
                this.daemon = daemon;
                this.priority = priority;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.group = $outer.dotty$tools$dotc$profile$AsyncHelper$BaseAsyncHelper$$childGroup(shortId);
                this.threadNumber = new AtomicInteger(1);
                this.namePrefix = new StringBuilder(2).append($outer.baseGroup().getName()).append("-").append(shortId).append("-").toString();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(Runnable r) {
                void var3_3;
                Runnable wrapped = this.$outer.wrapRunnable(r, this.shortId);
                Thread t = new Thread(this.group, wrapped, new StringBuilder(0).append(this.namePrefix).append(this.threadNumber.getAndIncrement()).toString(), 0L);
                if (t.isDaemon() != this.daemon) {
                    t.setDaemon(this.daemon);
                }
                if (t.getPriority() != this.priority) {
                    t.setPriority(this.priority);
                }
                return var3_3;
            }

            public final /* synthetic */ BaseAsyncHelper dotty$tools$dotc$profile$AsyncHelper$BaseAsyncHelper$CommonThreadFactory$$$outer() {
                return this.$outer;
            }
        }
    }

    private static final class BasicAsyncHelper
    extends BaseAsyncHelper {
        public BasicAsyncHelper(Phases.Phase phase, Contexts.Context x$2) {
            super(phase, x$2);
        }

        @Override
        public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int nThreads, String shortId, int priority) {
            BaseAsyncHelper.CommonThreadFactory threadFactory = new BaseAsyncHelper.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        }

        @Override
        public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int nThreads, int maxQueueSize, RejectedExecutionHandler rejectHandler, String shortId, int priority) {
            BaseAsyncHelper.CommonThreadFactory threadFactory = new BaseAsyncHelper.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize), threadFactory, rejectHandler);
        }

        @Override
        public Runnable wrapRunnable(Runnable r, String shortId) {
            return r;
        }
    }

    private static class ProfilingAsyncHelper
    extends BaseAsyncHelper {
        private final Phases.Phase phase;
        private final RealProfiler profiler;
        private final ThreadLocal localData;

        public ProfilingAsyncHelper(Phases.Phase phase, RealProfiler profiler, Contexts.Context x$3) {
            this.phase = phase;
            this.profiler = profiler;
            super(phase, x$3);
            this.localData = new ThreadLocal();
        }

        private RealProfiler profiler() {
            return this.profiler;
        }

        @Override
        public ThreadPoolExecutor newUnboundedQueueFixedThreadPool(int nThreads, String shortId, int priority) {
            BaseAsyncHelper.CommonThreadFactory threadFactory = new BaseAsyncHelper.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new SinglePhaseInstrumentedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, new ThreadPoolExecutor.AbortPolicy());
        }

        @Override
        public ThreadPoolExecutor newBoundedQueueFixedThreadPool(int nThreads, int maxQueueSize, RejectedExecutionHandler rejectHandler, String shortId, int priority) {
            BaseAsyncHelper.CommonThreadFactory threadFactory = new BaseAsyncHelper.CommonThreadFactory(this, shortId, this.CommonThreadFactory().$lessinit$greater$default$2(), priority);
            return new SinglePhaseInstrumentedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(maxQueueSize), threadFactory, rejectHandler);
        }

        @Override
        public Runnable wrapRunnable(Runnable r, String shortId) {
            return () -> {
                ThreadProfileData data = new ThreadProfileData();
                this.localData().set(data);
                ProfileSnap profileStart = this.profiler().snapThread(0L);
                try {
                    r.run();
                }
                finally {
                    ProfileSnap snap = this.profiler().snapThread(data.idleNs());
                    ProfileRange threadRange = ProfileRange$.MODULE$.apply(profileStart, snap, this.phase, shortId, data.taskCount(), Thread.currentThread());
                    this.profiler().completeBackground(threadRange);
                }
            };
        }

        public ThreadLocal<ThreadProfileData> localData() {
            return this.localData;
        }

        private class SinglePhaseInstrumentedThreadPoolExecutor
        extends ThreadPoolExecutor {
            public SinglePhaseInstrumentedThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
                if (ProfilingAsyncHelper.this == null) {
                    throw new NullPointerException();
                }
                super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
            }

            @Override
            public void beforeExecute(Thread t, Runnable r) {
                ThreadProfileData data = ProfilingAsyncHelper.this.localData().get();
                data.taskCount_$eq(data.taskCount() + 1);
                long now = System.nanoTime();
                if (data.firstStartNs() == 0L) {
                    data.firstStartNs_$eq(now);
                } else {
                    data.idleNs_$eq(data.idleNs() + (now - data.lastEndNs()));
                }
                data.lastStartNs_$eq(now);
                super.beforeExecute(t, r);
            }

            @Override
            public void afterExecute(Runnable r, Throwable t) {
                long now = System.nanoTime();
                ThreadProfileData data = ProfilingAsyncHelper.this.localData().get();
                data.lastEndNs_$eq(now);
                data.runningNs_$eq(data.runningNs() + (now - data.lastStartNs()));
                super.afterExecute(r, t);
            }

            public final /* synthetic */ ProfilingAsyncHelper dotty$tools$dotc$profile$AsyncHelper$ProfilingAsyncHelper$SinglePhaseInstrumentedThreadPoolExecutor$$$outer() {
                return ProfilingAsyncHelper.this;
            }
        }

        public final class ThreadProfileData {
            private long firstStartNs;
            private int taskCount;
            private long idleNs;
            private long runningNs;
            private long lastStartNs;
            private long lastEndNs;

            public ThreadProfileData() {
                if (ProfilingAsyncHelper.this == null) {
                    throw new NullPointerException();
                }
                this.firstStartNs = 0L;
                this.taskCount = 0;
                this.idleNs = 0L;
                this.runningNs = 0L;
                this.lastStartNs = 0L;
                this.lastEndNs = 0L;
            }

            public long firstStartNs() {
                return this.firstStartNs;
            }

            public void firstStartNs_$eq(long x$1) {
                this.firstStartNs = x$1;
            }

            public int taskCount() {
                return this.taskCount;
            }

            public void taskCount_$eq(int x$1) {
                this.taskCount = x$1;
            }

            public long idleNs() {
                return this.idleNs;
            }

            public void idleNs_$eq(long x$1) {
                this.idleNs = x$1;
            }

            public long runningNs() {
                return this.runningNs;
            }

            public void runningNs_$eq(long x$1) {
                this.runningNs = x$1;
            }

            public long lastStartNs() {
                return this.lastStartNs;
            }

            public void lastStartNs_$eq(long x$1) {
                this.lastStartNs = x$1;
            }

            public long lastEndNs() {
                return this.lastEndNs;
            }

            public void lastEndNs_$eq(long x$1) {
                this.lastEndNs = x$1;
            }

            public final /* synthetic */ ProfilingAsyncHelper dotty$tools$dotc$profile$AsyncHelper$ProfilingAsyncHelper$ThreadProfileData$$$outer() {
                return ProfilingAsyncHelper.this;
            }
        }
    }
}

