/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.semanticdb.internal;

import dotty.tools.dotc.semanticdb.internal.Internal$;
import dotty.tools.dotc.semanticdb.internal.InvalidProtocolBufferException;
import dotty.tools.dotc.semanticdb.internal.InvalidProtocolBufferException$;
import dotty.tools.dotc.semanticdb.internal.SemanticdbInputStream$;
import dotty.tools.dotc.semanticdb.internal.WireFormat$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import scala.Byte$;
import scala.Function1;
import scala.Int$;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.function.JProcedure1;

public class SemanticdbInputStream {
    private final byte[] buffer;
    private final InputStream input;
    private int totalBytesRetired;
    private int bufferPos;
    private int bufferSize;
    private int currentLimit;
    private int sizeLimit;
    private int bufferSizeAfterLimit;
    private int lastTag;

    public static int decodeZigZag32(int n) {
        return SemanticdbInputStream$.MODULE$.decodeZigZag32(n);
    }

    public static long decodeZigZag64(long l) {
        return SemanticdbInputStream$.MODULE$.decodeZigZag64(l);
    }

    public static SemanticdbInputStream newInstance(byte[] byArray) {
        return SemanticdbInputStream$.MODULE$.newInstance(byArray);
    }

    public static SemanticdbInputStream newInstance(byte[] byArray, int n, int n2) {
        return SemanticdbInputStream$.MODULE$.newInstance(byArray, n, n2);
    }

    public static SemanticdbInputStream newInstance(InputStream inputStream) {
        return SemanticdbInputStream$.MODULE$.newInstance(inputStream);
    }

    private SemanticdbInputStream(byte[] buffer, InputStream input) {
        this.buffer = buffer;
        this.input = input;
        this.totalBytesRetired = 0;
        this.bufferPos = 0;
        this.bufferSize = 0;
        this.currentLimit = Integer.MAX_VALUE;
        this.sizeLimit = SemanticdbInputStream$.dotty$tools$dotc$semanticdb$internal$SemanticdbInputStream$$$DEFAULT_SIZE_LIMIT;
        this.bufferSizeAfterLimit = 0;
        this.lastTag = 0;
    }

    public SemanticdbInputStream(byte[] buffer, int offset, int len) {
        this(buffer, null);
        this.bufferPos = offset;
        this.bufferSize = offset + len;
        this.totalBytesRetired = -offset;
    }

    public SemanticdbInputStream(InputStream is) {
        this(new byte[SemanticdbInputStream$.dotty$tools$dotc$semanticdb$internal$SemanticdbInputStream$$$BUFFER_SIZE], is);
        this.totalBytesRetired = 0;
    }

    private void ensureAvailable(int n) {
        if (this.bufferSize - this.bufferPos < n) {
            this.refillBuffer(n);
        }
    }

    private void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
    }

    private boolean tryRefillBuffer(int n) {
        Boolean bl;
        if (this.bufferPos + n <= this.bufferSize) {
            throw new IllegalStateException(new StringBuilder(66).append("refillBuffer() called when ").append(n).append(" bytes were already available in buffer").toString());
        }
        if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
            bl = BoxesRunTime.boxToBoolean((boolean)false);
        } else if (this.input != null) {
            int bytesRead;
            int pos = this.bufferPos;
            if (pos > 0) {
                if (this.bufferSize > pos) {
                    System.arraycopy(this.buffer, pos, this.buffer, 0, this.bufferSize - pos);
                }
                this.totalBytesRetired += pos;
                this.bufferSize -= pos;
                this.bufferPos = 0;
            }
            if ((bytesRead = this.input.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize)) == 0 || bytesRead < -1 || bytesRead > this.buffer.length) {
                throw new IllegalStateException(new StringBuilder(91).append("InputStream#read(byte[]) returned invalid result: ").append(bytesRead).append("\nThe InputStream implementation is buggy.").toString());
            }
            if (bytesRead > 0) {
                this.bufferSize += bytesRead;
                if (this.totalBytesRetired + n - this.sizeLimit > 0) {
                    throw InvalidProtocolBufferException$.MODULE$.sizeLimitExceeded();
                }
                this.recomputeBufferSizeAfterLimit();
                return this.bufferSize >= n || this.tryRefillBuffer(n);
            }
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxedUnit.UNIT;
        }
        return false;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            this.bufferSizeAfterLimit = bufferEnd - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
        } else {
            this.bufferSizeAfterLimit = 0;
        }
    }

    public boolean isAtEnd() {
        return this.bufferPos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired + this.bufferPos;
    }

    /*
     * WARNING - void declaration
     */
    public int pushLimit(int byteLimit0) {
        void var3_3;
        if (byteLimit0 < 0) {
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        int byteLimit = byteLimit0 + this.totalBytesRetired + this.bufferPos;
        int oldLimit = this.currentLimit;
        if (byteLimit > oldLimit) {
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        this.currentLimit = byteLimit;
        this.recomputeBufferSizeAfterLimit();
        return (int)var3_3;
    }

    public void popLimit(int oldLimit) {
        this.currentLimit = oldLimit;
        this.recomputeBufferSizeAfterLimit();
    }

    public boolean skipField(int tag) throws IOException {
        boolean bl;
        int n = WireFormat$.MODULE$.getTagWireType(tag);
        if (WireFormat$.MODULE$.WIRETYPE_VARINT() == n) {
            this.skipRawVarint();
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_FIXED64() == n) {
            this.skipRawBytes(8);
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED() == n) {
            this.skipRawBytes(this.readRawVarint32());
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_START_GROUP() == n) {
            this.skipMessage();
            this.checkLastTagWas(WireFormat$.MODULE$.makeTag(WireFormat$.MODULE$.getTagFieldNumber(tag), WireFormat$.MODULE$.WIRETYPE_END_GROUP()));
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_END_GROUP() == n) {
            bl = false;
        } else if (WireFormat$.MODULE$.WIRETYPE_FIXED32() == n) {
            this.skipRawBytes(4);
            bl = true;
        } else {
            throw InvalidProtocolBufferException$.MODULE$.invalidWireType();
        }
        return bl;
    }

    public void skipMessage() {
        while (true) {
            int tag = this.readTag();
            if (tag != 0 && this.skipField(tag)) continue;
            return;
        }
    }

    public void skipRawBytes(int size) {
        if (size <= this.bufferSize - this.bufferPos && size >= 0) {
            this.bufferPos += size;
        } else {
            this.skipRawBytesSlowPath(size);
        }
    }

    public int readRawVarint32() throws InvalidProtocolBufferException {
        int pos = this.bufferPos;
        if (this.bufferSize == pos) {
            return (int)this.readRawVarint64SlowPath();
        }
        byte[] buffer = this.buffer;
        int x = 0;
        if ((x = Byte$.MODULE$.byte2int(buffer[++pos - 1])) >= 0) {
            this.bufferPos = pos;
            return x;
        }
        if (this.bufferSize - pos < 9) {
            return (int)this.readRawVarint64SlowPath();
        }
        if ((x ^= buffer[++pos - 1] << 7) < 0) {
            x ^= 0xFFFFFF80;
        } else if ((x ^= buffer[++pos - 1] << 14) >= 0) {
            x ^= 0x3F80;
        } else if ((x ^= buffer[++pos - 1] << 21) < 0) {
            x ^= 0xFFE03F80;
        } else {
            int y = Byte$.MODULE$.byte2int(buffer[++pos - 1]);
            x ^= y << 28;
            x ^= 0xFE03F80;
            if (y < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0) {
                return (int)this.readRawVarint64SlowPath();
            }
        }
        this.bufferPos = pos;
        return x;
    }

    private void skipRawVarint() {
        if (this.bufferSize - this.bufferPos >= 10) {
            byte[] buffer = this.buffer;
            int pos = this.bufferPos;
            int i = 0;
            while (i < 10) {
                if (buffer[++pos - 1] >= 0) {
                    this.bufferPos = pos;
                    return;
                }
                int cfr_ignored_0 = ++i - 1;
            }
        }
        this.skipRawVarintSlowPath();
    }

    private void skipRawVarintSlowPath() throws IOException {
        int i = 0;
        while (i < 10) {
            if (this.readRawByte() >= 0) {
                return;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        throw InvalidProtocolBufferException$.MODULE$.malformedVarint();
    }

    private void skipRawBytesSlowPath(int size) {
        if (size < 0) {
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        int pos = this.bufferSize - this.bufferPos;
        this.bufferPos = this.bufferSize;
        this.refillBuffer(1);
        while (size - pos > this.bufferSize) {
            pos += this.bufferSize;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(1);
        }
        this.bufferPos = size - pos;
    }

    public int readTag() throws InvalidProtocolBufferException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat$.MODULE$.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException$.MODULE$.invalidTag();
        }
        return this.lastTag;
    }

    public String readString() {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            String result = new String(this.buffer, this.bufferPos, size, StandardCharsets.UTF_8);
            this.bufferPos += size;
            return result;
        }
        if (size == 0) {
            return "";
        }
        return new String(this.readRawBytesSlowPath(size), StandardCharsets.UTF_8);
    }

    public String readStringRequireUtf8() {
        int size = this.readRawVarint32();
        byte[] bytes = new byte[]{};
        int pos = this.bufferPos;
        if (size <= this.bufferSize - pos && size > 0) {
            bytes = this.buffer;
            this.bufferPos = pos + size;
        } else {
            if (size == 0) {
                return "";
            }
            bytes = this.readRawBytesSlowPath(size);
            pos = 0;
        }
        return new String(bytes, pos, size, "UTF-8");
    }

    public void checkLastTagWas(int value) {
        if (this.lastTag != value) {
            throw InvalidProtocolBufferException$.MODULE$.invalidEndTag();
        }
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - currentAbsolutePosition;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() {
        return this.readRawVarint64();
    }

    public long readInt64() {
        return this.readRawVarint64();
    }

    public int readInt32() {
        return this.readRawVarint32();
    }

    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    public int readUInt32() {
        return this.readRawVarint32();
    }

    public int readEnum() {
        return this.readRawVarint32();
    }

    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() {
        return SemanticdbInputStream$.MODULE$.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() {
        return SemanticdbInputStream$.MODULE$.decodeZigZag64(this.readRawVarint64());
    }

    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public long readRawVarint64() throws InvalidProtocolBufferException {
        void var3_3;
        int pos = this.bufferPos;
        if (this.bufferSize == pos) {
            return this.readRawVarint64SlowPath();
        }
        byte[] buffer = this.buffer;
        long x = 0L;
        int y = 0;
        if ((y = Byte$.MODULE$.byte2int(buffer[++pos - 1])) >= 0) {
            this.bufferPos = pos;
            return Int$.MODULE$.int2long(y);
        }
        if (this.bufferSize - pos < 9) {
            return this.readRawVarint64SlowPath();
        }
        if ((y ^= buffer[++pos - 1] << 7) < 0) {
            x = Int$.MODULE$.int2long(y ^ 0xFFFFFF80);
        } else if ((y ^= buffer[++pos - 1] << 14) >= 0) {
            x = Int$.MODULE$.int2long(y ^ 0x3F80);
        } else if ((y ^= buffer[++pos - 1] << 21) < 0) {
            x = Int$.MODULE$.int2long(y ^ 0xFFE03F80);
        } else if ((x = (long)y ^ (long)buffer[++pos - 1] << 28) >= 0L) {
            x ^= 0xFE03F80L;
        } else if ((x ^= (long)buffer[++pos - 1] << 35) < 0L) {
            x ^= 0xFFFFFFF80FE03F80L;
        } else if ((x ^= (long)buffer[++pos - 1] << 42) >= 0L) {
            x ^= 0x3F80FE03F80L;
        } else if ((x ^= (long)buffer[++pos - 1] << 49) < 0L) {
            x ^= 0xFFFE03F80FE03F80L;
        } else {
            x ^= (long)buffer[++pos - 1] << 56;
            if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)buffer[++pos - 1] < 0L) {
                return this.readRawVarint64SlowPath();
            }
        }
        this.bufferPos = pos;
        return (long)var3_3;
    }

    public long readRawVarint64SlowPath() throws InvalidProtocolBufferException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferException$.MODULE$.malformedVarint();
    }

    public int readRawLittleEndian32() {
        int pos = this.bufferPos;
        if (this.bufferSize - pos < 4) {
            this.refillBuffer(4);
            pos = this.bufferPos;
        }
        byte[] buffer = this.buffer;
        this.bufferPos = pos + 4;
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8 | (buffer[pos + 2] & 0xFF) << 16 | (buffer[pos + 3] & 0xFF) << 24;
    }

    public long readRawLittleEndian64() {
        int pos = this.bufferPos;
        if (this.bufferSize - pos < 8) {
            this.refillBuffer(8);
            pos = this.bufferPos;
        }
        byte[] buffer = this.buffer;
        this.bufferPos = pos + 8;
        return (long)buffer[pos] & 0xFFL | ((long)buffer[pos + 1] & 0xFFL) << 8 | ((long)buffer[pos + 2] & 0xFFL) << 16 | ((long)buffer[pos + 3] & 0xFFL) << 24 | ((long)buffer[pos + 4] & 0xFFL) << 32 | ((long)buffer[pos + 5] & 0xFFL) << 40 | ((long)buffer[pos + 6] & 0xFFL) << 48 | ((long)buffer[pos + 7] & 0xFFL) << 56;
    }

    public byte readRawByte() throws InvalidProtocolBufferException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(1);
        }
        ++this.bufferPos;
        return this.buffer[this.bufferPos - 1];
    }

    public byte[] readRawBytes(int size) throws InvalidProtocolBufferException {
        byte[] byArray;
        int pos = this.bufferPos;
        if (size <= this.bufferSize - pos && size > 0) {
            this.bufferPos = pos + size;
            byArray = Arrays.copyOfRange(this.buffer, pos, pos + size);
        } else {
            byArray = this.readRawBytesSlowPath(size);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readRawBytesSlowPath(int size) {
        byte[] byArray;
        if (size <= 0) {
            if (size == 0) {
                return Internal$.MODULE$.EMPTY_BYTE_ARRAY();
            }
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            this.skipRawBytes(this.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        if (size < SemanticdbInputStream$.dotty$tools$dotc$semanticdb$internal$SemanticdbInputStream$$$BUFFER_SIZE) {
            void var2_2;
            byte[] bytes = new byte[size];
            int pos = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, bytes, 0, pos);
            this.bufferPos = this.bufferSize;
            this.ensureAvailable(size - pos);
            System.arraycopy(this.buffer, 0, bytes, pos, size - pos);
            this.bufferPos = size - pos;
            byArray = var2_2;
        } else {
            byte[] chunk2;
            int originalBufferPos = this.bufferPos;
            int originalBufferSize = this.bufferSize;
            this.totalBytesRetired += this.bufferSize;
            this.bufferPos = 0;
            this.bufferSize = 0;
            ArrayBuffer chunks = new ArrayBuffer();
            for (int sizeLeft = size - (originalBufferSize - originalBufferPos); sizeLeft > 0; sizeLeft -= chunk2.length) {
                int n;
                chunk2 = new byte[Math.min(sizeLeft, SemanticdbInputStream$.dotty$tools$dotc$semanticdb$internal$SemanticdbInputStream$$$BUFFER_SIZE)];
                for (int pos = 0; pos < chunk2.length; pos += n) {
                    int n2 = n = this.input == null ? -1 : this.input.read(chunk2, pos, chunk2.length - pos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
                    }
                    this.totalBytesRetired += n;
                }
                chunks.$plus$eq((Object)chunk2);
            }
            byte[] bytes = new byte[size];
            IntRef pos = IntRef.create((int)(originalBufferSize - originalBufferPos));
            System.arraycopy(this.buffer, originalBufferPos, bytes, 0, pos.elem);
            chunks.foreach((Function1)(JProcedure1 & Serializable)chunk -> {
                int n;
                System.arraycopy(chunk, 0, bytes, pos$1.elem, ((byte[])chunk).length);
                pos$1.elem = n = pos$1.elem + ((byte[])chunk).length;
            });
            byArray = bytes;
        }
        return byArray;
    }

    public void enableAliasing(boolean aliasing) {
    }

    /*
     * WARNING - void declaration
     */
    public int setSizeLimit(int limit) {
        void var2_2;
        if (limit < 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Size limit cannot be negative: ").append(limit).toString());
        }
        int oldLimit = this.sizeLimit;
        this.sizeLimit = limit;
        return (int)var2_2;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired = -this.bufferPos;
    }
}

