/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.config;

import dotty.tools.dotc.Compiler;
import dotty.tools.dotc.config.CommandLineParser$;
import dotty.tools.dotc.config.CommonScalaSettings;
import dotty.tools.dotc.config.Settings;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Phases;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public interface CliCommand {
    public static void $init$(CliCommand $this) {
    }

    public String versionMsg();

    public String ifErrorsMsg();

    public String cmdName();

    public boolean isHelpFlag(Settings.SettingGroup var1, Settings.SettingsState var2);

    public String helpMsg(Settings.SettingGroup var1, Settings.SettingsState var2, Contexts.Context var3);

    private String explainAdvanced() {
        return "\n    |-- Notes on option parsing --\n    |Boolean settings are always false unless set.\n    |Where multiple values are accepted, they should be comma-separated.\n    |  example: -Xplugin:plugin1,plugin2\n    |<phases> means one or a comma-separated list of:\n    |  - (partial) phase names with an optional \"+\" suffix to include the next phase\n    |  - the string \"all\"\n    |  example: -Xprint:all prints all phases.\n    |  example: -Xprint:typer,mixin prints the typer and mixin phases.\n    |  example: -Ylog:erasure+ logs the erasure phase and the phase after the erasure phase.\n    |           This is useful because during the tree transform of phase X, we often\n    |           already are in phase X + 1.\n  ";
    }

    public static Settings.ArgsSummary distill$(CliCommand $this, String[] args, Settings.SettingGroup sg, Settings.SettingsState ss, Contexts.Context x$4) {
        return $this.distill(args, sg, ss, x$4);
    }

    default public Settings.ArgsSummary distill(String[] args, Settings.SettingGroup sg, Settings.SettingsState ss, Contexts.Context x$4) {
        return sg.processArguments((List<String>)CliCommand.expandedArguments$1(args, x$4), true, ss);
    }

    public static Settings.SettingsState distill$default$3$(CliCommand $this, String[] args, Settings.SettingGroup sg) {
        return $this.distill$default$3(args, sg);
    }

    default public Settings.SettingsState distill$default$3(String[] args, Settings.SettingGroup sg) {
        return sg.defaultState();
    }

    public static String availableOptionsMsg$(CliCommand $this, Function1 cond, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.availableOptionsMsg(cond, settings, x$3);
    }

    default public String availableOptionsMsg(Function1<Settings.Setting<?>, Object> cond, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        List ss = (List)((IterableOnceOps)settings.allSettings().filter(cond)).toList().sortBy((Function1 & Serializable)_$2 -> _$2.name(), (Ordering)Ordering.String$.MODULE$);
        int maxNameWidth = 30;
        List nameWidths = (List)ss.map((Function1 & Serializable)_$3 -> _$3.name().length()).partition((Function1)(JFunction1.mcZI.sp & Serializable)_$4 -> _$4 < maxNameWidth)._1();
        int width = nameWidths.nonEmpty() ? BoxesRunTime.unboxToInt((Object)nameWidths.max((Ordering)Ordering.Int$.MODULE$)) : maxNameWidth;
        int terminalWidth = BoxesRunTime.unboxToInt((Object)this.value(((CommonScalaSettings)((Object)settings)).pageWidth(), x$3));
        int w1 = width < maxNameWidth ? width : maxNameWidth;
        int w2 = terminalWidth < w1 + maxNameWidth ? 0 : terminalWidth - w1 - 1;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)w1), (Object)BoxesRunTime.boxToInteger((int)w2));
        int nameWidth = BoxesRunTime.unboxToInt((Object)tuple2._1());
        int descriptionWidth = BoxesRunTime.unboxToInt((Object)tuple2._2());
        return ss.map((Function1 & Serializable)s -> this.helpStr$1(settings, x$3, nameWidth, descriptionWidth, (Settings.Setting)s)).mkString("", "\n", "\n" + CliCommand.formatName$1(nameWidth, "@<file>") + " " + CliCommand.formatDescription$1(nameWidth, descriptionWidth, "A text file containing compiler arguments (options and source files).") + "\n");
    }

    public static String shortUsage$(CliCommand $this) {
        return $this.shortUsage();
    }

    default public String shortUsage() {
        return "Usage: " + this.cmdName() + " <options> <source files>";
    }

    public static String createUsageMsg$(CliCommand $this, String label, boolean shouldExplain, Function1 cond, Settings.SettingGroup settings, Settings.SettingsState x$5) {
        return $this.createUsageMsg(label, shouldExplain, cond, settings, x$5);
    }

    default public String createUsageMsg(String label, boolean shouldExplain, Function1<Settings.Setting<?>, Object> cond, Settings.SettingGroup settings, Settings.SettingsState x$5) {
        String prefix = ((IterableOnceOps)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)this.shortUsage()), Some$.MODULE$.apply((Object)this.explainAdvanced()).filter((Function1 & Serializable)_$5 -> shouldExplain), Some$.MODULE$.apply((Object)(label + " options include:"))}))).flatten(Predef$.MODULE$.$conforms())).mkString("\n");
        return prefix + "\n" + this.availableOptionsMsg(cond, settings, x$5);
    }

    public static boolean isStandard$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isStandard(s, settings, x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isStandard(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        if (!(this.isVerbose(s, settings, x$3) || this.isWarning(s, settings, x$3) || this.isAdvanced(s, settings, x$3))) {
            if (!this.isPrivate(s, settings, x$3)) return true;
        }
        String string = s.name();
        String string2 = "-Werror";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = s.name();
        String string4 = "-Wconf";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static boolean isVerbose$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isVerbose(s, settings, x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isVerbose(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        if (!s.name().startsWith("-V")) return false;
        String string = s.name();
        String string2 = "-V";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static boolean isWarning$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isWarning(s, settings, x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isWarning(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        if (s.name().startsWith("-W")) {
            String string = s.name();
            String string2 = "-W";
            if (string == null) {
                if (string2 != null) {
                    return true;
                }
            } else if (!string.equals(string2)) return true;
        }
        String string = s.name();
        String string3 = "-Xlint";
        if (string != null) {
            if (!string.equals(string3)) return false;
            return true;
        }
        if (string3 == null) return true;
        return false;
    }

    public static boolean isAdvanced$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isAdvanced(s, settings, x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isAdvanced(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        if (!s.name().startsWith("-X")) return false;
        String string = s.name();
        String string2 = "-X";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static boolean isPrivate$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isPrivate(s, settings, x$3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public boolean isPrivate(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        if (!s.name().startsWith("-Y")) return false;
        String string = s.name();
        String string2 = "-Y";
        if (string == null) {
            if (string2 == null) return false;
            return true;
        } else if (string.equals(string2)) return false;
        return true;
    }

    public static String shortHelp$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.shortHelp(s, settings, x$3);
    }

    default public String shortHelp(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return (String)StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(s.description())).next();
    }

    public static boolean isHelping$(CliCommand $this, Settings.Setting s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return $this.isHelping(s, settings, x$3);
    }

    default public boolean isHelping(Settings.Setting<?> s, Settings.SettingGroup settings, Settings.SettingsState x$3) {
        return PartialFunction$.MODULE$.cond(this.value(s, x$3), (PartialFunction)new Serializable(s){
            private final Settings.Setting s$1;
            {
                this.s$1 = s$3;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof List) {
                    List ss = (List)object;
                    if (this.s$1.isMultivalue()) {
                        return true;
                    }
                }
                if (!(object instanceof String)) return false;
                String s = (String)object;
                return true;
            }

            /*
             * Enabled aggressive block sorting
             */
            public final Object applyOrElse(Object x, Function1 function1) {
                Object object;
                Object object2 = x;
                if (object2 instanceof List) {
                    List ss = (List)object2;
                    if (this.s$1.isMultivalue()) {
                        object = BoxesRunTime.boxToBoolean((boolean)ss.contains((Object)"help"));
                        return object;
                    }
                }
                if (!(object2 instanceof String)) {
                    object = function1.apply(x);
                    return object;
                }
                String s = (String)object2;
                object = BoxesRunTime.boxToBoolean(("help".equals(s) ? 1 : 0) != 0);
                return object;
            }
        });
    }

    public static String usageMessage$(CliCommand $this, Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return $this.usageMessage(settings, x$2);
    }

    default public String usageMessage(Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return this.createUsageMsg("where possible standard", false, (Function1 & Serializable)s -> this.isStandard((Settings.Setting<?>)s, settings, x$2), settings, x$2);
    }

    public static String vusageMessage$(CliCommand $this, Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return $this.vusageMessage(settings, x$2);
    }

    default public String vusageMessage(Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return this.createUsageMsg("Possible verbose", true, (Function1 & Serializable)s -> this.isVerbose((Settings.Setting<?>)s, settings, x$2), settings, x$2);
    }

    public static String wusageMessage$(CliCommand $this, Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return $this.wusageMessage(settings, x$2);
    }

    default public String wusageMessage(Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return this.createUsageMsg("Possible warning", true, (Function1 & Serializable)s -> this.isWarning((Settings.Setting<?>)s, settings, x$2), settings, x$2);
    }

    public static String xusageMessage$(CliCommand $this, Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return $this.xusageMessage(settings, x$2);
    }

    default public String xusageMessage(Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return this.createUsageMsg("Possible advanced", true, (Function1 & Serializable)s -> this.isAdvanced((Settings.Setting<?>)s, settings, x$2), settings, x$2);
    }

    public static String yusageMessage$(CliCommand $this, Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return $this.yusageMessage(settings, x$2);
    }

    default public String yusageMessage(Settings.SettingGroup settings, Settings.SettingsState x$2) {
        return this.createUsageMsg("Possible private", true, (Function1 & Serializable)s -> this.isPrivate((Settings.Setting<?>)s, settings, x$2), settings, x$2);
    }

    public static String phasesMessage$(CliCommand $this) {
        return $this.phasesMessage();
    }

    default public String phasesMessage() {
        return new Compiler().phases().map((Function1 & Serializable)x$1 -> {
            String string;
            SeqOps seqOps;
            List list = x$1;
            if (list != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps = package$.MODULE$.List().unapplySeq((SeqOps)list), 1) == 0) {
                Phases.Phase phase;
                Phases.Phase single = phase = (Phases.Phase)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                string = single.phaseName();
            } else {
                List more = list;
                string = more.map((Function1 & Serializable)_$6 -> _$6.phaseName()).mkString("{", ", ", "}");
            }
            return string;
        }).mkString("\n");
    }

    public static Option checkUsage$(CliCommand $this, Settings.ArgsSummary summary, boolean sourcesRequired, Settings.SettingGroup settings, Settings.SettingsState x$4, Contexts.Context x$5) {
        return $this.checkUsage(summary, sourcesRequired, settings, x$4, x$5);
    }

    default public Option<List<String>> checkUsage(Settings.ArgsSummary summary, boolean sourcesRequired, Settings.SettingGroup settings, Settings.SettingsState x$4, Contexts.Context x$5) {
        None$ none$;
        summary.warnings().foreach((Function1)(JProcedure1 & Serializable)_$7 -> report$.MODULE$.warning(Message$.MODULE$.toNoExplanation(() -> CliCommand.checkUsage$$anonfun$7$$anonfun$1(_$7)), report$.MODULE$.warning$default$2(), x$5));
        if (summary.errors().nonEmpty()) {
            summary.errors().foreach((Function1)(JProcedure1 & Serializable)_$8 -> report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> CliCommand.checkUsage$$anonfun$8$$anonfun$1(_$8)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$5));
            report$.MODULE$.echo(this::checkUsage$$anonfun$3, report$.MODULE$.echo$default$2(), x$5);
            none$ = None$.MODULE$;
        } else if (BoxesRunTime.unboxToBoolean((Object)this.value(((CommonScalaSettings)((Object)settings)).version(), x$4))) {
            report$.MODULE$.echo(this::checkUsage$$anonfun$4, report$.MODULE$.echo$default$2(), x$5);
            none$ = None$.MODULE$;
        } else if (this.isHelpFlag(settings, x$4)) {
            report$.MODULE$.echo(() -> this.checkUsage$$anonfun$5(settings, x$4, x$5), report$.MODULE$.echo$default$2(), x$5);
            none$ = None$.MODULE$;
        } else if (sourcesRequired && summary.arguments().isEmpty()) {
            report$.MODULE$.echo(() -> this.checkUsage$$anonfun$6(settings, x$4), report$.MODULE$.echo$default$2(), x$5);
            none$ = None$.MODULE$;
        } else {
            none$ = Some$.MODULE$.apply(summary.arguments());
        }
        return none$;
    }

    public static Object value$(CliCommand $this, Settings.Setting setting, Settings.SettingsState ss) {
        return $this.value(setting, ss);
    }

    default public <T> T value(Settings.Setting<T> setting, Settings.SettingsState ss) {
        return setting.valueIn(ss);
    }

    private static /* synthetic */ boolean stripComment$1$$anonfun$1(char _$1) {
        return _$1 != '#';
    }

    private static String stripComment$3(String s) {
        return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(s), (Function1 & Serializable)_$1 -> CliCommand.stripComment$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$1)));
    }

    private static String expandArg$1$$anonfun$1(Path path$1) {
        return "Argument file " + path$1.getFileName() + " could not be found";
    }

    private static List expandArg$2(Contexts.Context x$4$1, String arg) {
        List<String> list;
        Path path = Paths.get(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(arg), "@"), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> CliCommand.expandArg$1$$anonfun$1(path)), report$.MODULE$.error$default$2(), report$.MODULE$.error$default$3(), x$4$1);
            list = package$.MODULE$.Nil();
        } else {
            java.util.List<String> lines = Files.readAllLines(path);
            String params = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(lines).asScala()).map((Function1 & Serializable)s -> CliCommand.stripComment$3(s))).mkString(" ");
            list = CommandLineParser$.MODULE$.tokenize(params);
        }
        return list;
    }

    private static List expandedArguments$1(String[] args$1, Contexts.Context x$4$2) {
        return Predef$.MODULE$.wrapRefArray((Object[])args$1).toList().flatMap((Function1 & Serializable)x$1 -> {
            List list;
            String string = x$1;
            String x = string;
            if (x.startsWith("@")) {
                list = CliCommand.expandArg$2(x$4$2, x);
            } else {
                String x2 = string;
                list = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{x2}));
            }
            return list;
        });
    }

    private static String formatName$1(int nameWidth$1, String name) {
        return name.length() <= nameWidth$1 ? StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%-" + nameWidth$1 + "s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{name})) : StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString(name + "\n%-" + nameWidth$1 + "s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{""}));
    }

    private static String formatDescription$1(int nameWidth$2, int descriptionWidth$1, String text) {
        String string;
        if (descriptionWidth$1 == 0) {
            string = text;
        } else if (text.length() < descriptionWidth$1) {
            string = text;
        } else {
            int inx = text.substring(0, descriptionWidth$1).lastIndexOf(" ");
            if (inx < 0) {
                string = text;
            } else {
                String str = text.substring(0, inx);
                string = "" + str + "\n" + CliCommand.formatName$1(nameWidth$2, "") + " " + CliCommand.formatDescription$1(nameWidth$2, descriptionWidth$1, text.substring(inx + 1));
            }
        }
        return string;
    }

    private static String formatSetting$1(int nameWidth$4, String name, String value) {
        return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value)) ? "\n" + CliCommand.formatName$1(nameWidth$4, "") + " " + name + ": " + value + "." : "";
    }

    private static String defaultValue$1(Settings.Setting s$1) {
        Object t = s$1.default();
        return t instanceof Integer || t instanceof String ? s$1.default().toString() : "";
    }

    private String helpStr$1(Settings.SettingGroup settings$1, Settings.SettingsState x$3$1, int nameWidth$3, int descriptionWidth$2, Settings.Setting s) {
        return "" + CliCommand.formatName$1(nameWidth$3, s.name()) + " " + CliCommand.formatDescription$1(nameWidth$3, descriptionWidth$2, this.shortHelp(s, settings$1, x$3$1)) + CliCommand.formatSetting$1(nameWidth$3, "Default", CliCommand.defaultValue$1(s)) + CliCommand.formatSetting$1(nameWidth$3, "Choices", s.legalChoices());
    }

    private static String checkUsage$$anonfun$7$$anonfun$1(String _$7$1) {
        return _$7$1;
    }

    private static String checkUsage$$anonfun$8$$anonfun$1(String _$8$1) {
        return _$8$1;
    }

    private String checkUsage$$anonfun$3() {
        return this.ifErrorsMsg();
    }

    private String checkUsage$$anonfun$4() {
        return this.versionMsg();
    }

    private String checkUsage$$anonfun$5(Settings.SettingGroup settings$7, Settings.SettingsState x$4$3, Contexts.Context x$5$3) {
        return this.helpMsg(settings$7, x$4$3, x$5$3);
    }

    private String checkUsage$$anonfun$6(Settings.SettingGroup settings$8, Settings.SettingsState x$4$4) {
        return this.usageMessage(settings$8, x$4$4);
    }
}

