/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.ast.tpd$;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Flags$;
import dotty.tools.dotc.core.Symbols;
import dotty.tools.dotc.core.Symbols$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.report$;
import dotty.tools.dotc.reporting.Message$;
import dotty.tools.dotc.transform.MegaPhase;
import dotty.tools.dotc.typer.Inliner$;
import dotty.tools.dotc.util.Spans$Span$;
import dotty.tools.dotc.util.SrcPos;
import java.io.Serializable;
import scala.Function1;
import scala.StringContext$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public class InlineVals
extends MegaPhase.MiniPhase {
    @Override
    public String phaseName() {
        return "inlineVals";
    }

    @Override
    public void checkPostCondition(Trees.Tree tree, Contexts.Context x$2) {
        block0: {
            Trees.Tree tree2;
            if (x$2.erasedTypes() || !((tree2 = tree) instanceof Trees.ValDef)) break block0;
            Trees.ValDef tree3 = (Trees.ValDef)tree2;
            this.checkInlineConformant(tree3, x$2);
        }
    }

    @Override
    public Trees.Tree transformValDef(Trees.ValDef tree, Contexts.Context x$2) {
        this.checkInlineConformant(tree, x$2);
        return tree;
    }

    private void checkInlineConformant(Trees.ValDef tree, Contexts.Context x$2) {
        block6: {
            Types.Type type;
            Trees.Tree tpt;
            Trees.Tree rhs;
            block7: {
                if (!Symbols$.MODULE$.toDenot(tree.symbol(x$2), x$2).is(Flags$.MODULE$.Inline(), Flags$.MODULE$.DeferredOrTermParamOrAccessor(), x$2) || Inliner$.MODULE$.inInlineMethod(x$2)) break block6;
                rhs = tree.rhs(x$2);
                tpt = tree.tpt();
                type = ((Types.Type)tpt.tpe()).widenTermRefExpr(x$2).dealias(x$2).normalized(x$2);
                if (!(type instanceof Types.ConstantType)) break block7;
                Types.ConstantType tp = (Types.ConstantType)type;
                if (tpd$.MODULE$.isPureExpr(rhs, x$2)) break block6;
                String details = tpd$.MODULE$.enclosingInlineds(x$2).isEmpty() ? "" : Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"but was: ", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{rhs}), x$2);
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> InlineVals.checkInlineConformant$$anonfun$1(details)), rhs.srcPos(), report$.MODULE$.error$default$3(), x$2);
                break block6;
            }
            Types.Type tp = type;
            if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).UnitClass(x$2), x$2)) {
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> InlineVals.checkInlineConformant$$anonfun$2(x$2)), rhs, report$.MODULE$.error$default$3(), x$2);
            } else if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).StringClass(), x$2) || ((IterableOnceOps)Symbols$.MODULE$.defn(x$2).ScalaValueClasses().apply(x$2)).exists((Function1 & Serializable)_$1 -> tp.derivesFrom((Symbols.Symbol)_$1, x$2))) {
                SrcPos pos = Spans$Span$.MODULE$.isZeroExtent$extension(tpt.span()) ? rhs.srcPos() : tpt.srcPos();
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> InlineVals.checkInlineConformant$$anonfun$4(x$2)), pos, report$.MODULE$.error$default$3(), x$2);
            } else if (tp.derivesFrom(Symbols$.MODULE$.defn(x$2).NullClass(), x$2)) {
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> InlineVals.checkInlineConformant$$anonfun$5(x$2)), rhs, report$.MODULE$.error$default$3(), x$2);
            } else {
                report$.MODULE$.error(Message$.MODULE$.toNoExplanation(() -> InlineVals.checkInlineConformant$$anonfun$6(x$2)), rhs, report$.MODULE$.error$default$3(), x$2);
            }
        }
    }

    private static final String checkInlineConformant$$anonfun$1(String details$1) {
        return "inline value must be pure" + details$1;
    }

    private static final String checkInlineConformant$$anonfun$2(Contexts.Context x$2$1) {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`inline val` of type `Unit` is not supported.\\n\\nTo inline a `Unit` consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2$1);
    }

    private static final String checkInlineConformant$$anonfun$4(Contexts.Context x$2$3) {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inline value must have a literal constant type"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2$3);
    }

    private static final String checkInlineConformant$$anonfun$5(Contexts.Context x$2$4) {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"`inline val` with `null` is not supported.\\n\\nTo inline a `null` consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2$4);
    }

    private static final String checkInlineConformant$$anonfun$6(Contexts.Context x$2$5) {
        return Decorators$.MODULE$.em(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inline value must contain a literal constant value.\\n\\nTo inline more complex types consider using `inline def`"})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]), x$2$5);
    }
}

