/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.testkit;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import scala.Function0;

public class ClearAfterClass {
    private static Map<Class<?>, Map<String, Object>> cache = new ConcurrentHashMap();

    @ClassRule
    public static TestRule clearClassCache() {
        return (statement, desc) -> new Statement(){

            public void evaluate() throws Throwable {
                ConcurrentHashMap perClassCache = new ConcurrentHashMap();
                cache.put(desc.getTestClass(), perClassCache);
                try {
                    statement.evaluate();
                }
                finally {
                    perClassCache.values().forEach(x$0 -> ClearAfterClass.closeIfClosable(x$0));
                    cache.remove(desc.getTestClass());
                }
            }
        };
    }

    private static void closeIfClosable(Object o) {
        if (o instanceof Closeable) {
            try {
                ((Closeable)o).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public <T> T cached(String key, Function0<T> t) {
        Map<String, Object> perClassCache = cache.get(this.getClass());
        return (T)perClassCache.computeIfAbsent(key, s -> t.apply());
    }
}

