/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple5;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.mutable.RedBlackTree$;
import scala.collection.mutable.RedBlackTree$Node$;
import scala.collection.mutable.RedBlackTree$Tree$;
import scala.math.Ordering;
import scala.runtime.Null$;
import scala.runtime.Scala3RunTime$;

public final class RedBlackTree {
    public static void clear(Tree<?, ?> tree) {
        RedBlackTree$.MODULE$.clear(tree);
    }

    public static <A> boolean contains(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.contains(tree, a, ordering);
    }

    public static <A, B> Node<A, B> copyTree(Node<A, B> node) {
        return RedBlackTree$.MODULE$.copyTree(node);
    }

    public static <A, B> void delete(Tree<A, B> tree, A a, Ordering<A> ordering) {
        RedBlackTree$.MODULE$.delete(tree, a, ordering);
    }

    public static <A, B, U> void foreach(Tree<A, B> tree, Function1<Tuple2<A, B>, U> function1) {
        RedBlackTree$.MODULE$.foreach(tree, function1);
    }

    public static <A, B, U> void foreachEntry(Tree<A, B> tree, Function2<A, B, U> function2) {
        RedBlackTree$.MODULE$.foreachEntry(tree, function2);
    }

    public static <A, U> void foreachKey(Tree<A, ?> tree, Function1<A, U> function1) {
        RedBlackTree$.MODULE$.foreachKey(tree, function1);
    }

    public static <A, B> Tree<A, B> fromOrderedEntries(Iterator<Tuple2<A, B>> iterator, int n) {
        return RedBlackTree$.MODULE$.fromOrderedEntries(iterator, n);
    }

    public static <A> Tree<A, Null$> fromOrderedKeys(Iterator<A> iterator, int n) {
        return RedBlackTree$.MODULE$.fromOrderedKeys(iterator, n);
    }

    public static <A, B> Option<B> get(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.get(tree, a, ordering);
    }

    public static <A, B> void insert(Tree<A, B> tree, A a, B b, Ordering<A> ordering) {
        RedBlackTree$.MODULE$.insert(tree, a, b, ordering);
    }

    public static boolean isBlack(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.isBlack(node);
    }

    public static boolean isEmpty(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.isEmpty(tree);
    }

    public static boolean isRed(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.isRed(node);
    }

    public static <A, B> boolean isValid(Tree<A, B> tree, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.isValid(tree, ordering);
    }

    public static <A, B> Iterator<Tuple2<A, B>> iterator(Tree<A, B> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.iterator(tree, option, option2, ordering);
    }

    public static <A> Iterator<A> keysIterator(Tree<A, ?> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.keysIterator(tree, option, option2, ordering);
    }

    public static <A, B> Option<Tuple2<A, B>> max(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.max(tree);
    }

    public static <A, B> Option<Tuple2<A, B>> maxBefore(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.maxBefore(tree, a, ordering);
    }

    public static <A> Option<A> maxKey(Tree<A, ?> tree) {
        return RedBlackTree$.MODULE$.maxKey(tree);
    }

    public static <A> Option<A> maxKeyBefore(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.maxKeyBefore(tree, a, ordering);
    }

    public static <A, B> Node<A, B> maxNodeNonNull(Node<A, B> node) {
        return RedBlackTree$.MODULE$.maxNodeNonNull(node);
    }

    public static <A, B> Option<Tuple2<A, B>> min(Tree<A, B> tree) {
        return RedBlackTree$.MODULE$.min(tree);
    }

    public static <A, B> Option<Tuple2<A, B>> minAfter(Tree<A, B> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.minAfter(tree, a, ordering);
    }

    public static <A> Option<A> minKey(Tree<A, ?> tree) {
        return RedBlackTree$.MODULE$.minKey(tree);
    }

    public static <A> Option<A> minKeyAfter(Tree<A, ?> tree, A a, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.minKeyAfter(tree, a, ordering);
    }

    public static <A, B> Node<A, B> minNodeNonNull(Node<A, B> node) {
        return RedBlackTree$.MODULE$.minNodeNonNull(node);
    }

    public static int size(Node<?, ?> node) {
        return RedBlackTree$.MODULE$.size(node);
    }

    public static int size(Tree<?, ?> tree) {
        return RedBlackTree$.MODULE$.size(tree);
    }

    public static <A, B> void transform(Tree<A, B> tree, Function2<A, B, B> function2) {
        RedBlackTree$.MODULE$.transform(tree, function2);
    }

    public static <A, B> Iterator<B> valuesIterator(Tree<A, B> tree, Option<A> option, Option<A> option2, Ordering<A> ordering) {
        return RedBlackTree$.MODULE$.valuesIterator(tree, option, option2, ordering);
    }

    public static <A, B> None$ iterator$default$2() {
        return RedBlackTree$.MODULE$.iterator$default$2();
    }

    public static <A> None$ keysIterator$default$2() {
        return RedBlackTree$.MODULE$.keysIterator$default$2();
    }

    public static <A, B> None$ valuesIterator$default$2() {
        return RedBlackTree$.MODULE$.valuesIterator$default$2();
    }

    public static <A, B> None$ iterator$default$3() {
        return RedBlackTree$.MODULE$.iterator$default$3();
    }

    public static <A> None$ keysIterator$default$3() {
        return RedBlackTree$.MODULE$.keysIterator$default$3();
    }

    public static <A, B> None$ valuesIterator$default$3() {
        return RedBlackTree$.MODULE$.valuesIterator$default$3();
    }

    public static final class EntriesIterator<A, B>
    extends TreeIterator<A, B, Tuple2<A, B>> {
        public EntriesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
            super(tree, start, end, evidence$1);
        }

        @Override
        public Tuple2<A, B> nextResult(Node<A, B> node) {
            return Tuple2$.MODULE$.apply(node.key(), node.value());
        }
    }

    public static final class KeysIterator<A, B>
    extends TreeIterator<A, B, A> {
        public KeysIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
            super(tree, start, end, evidence$1);
        }

        @Override
        public A nextResult(Node<A, B> node) {
            return node.key();
        }
    }

    public static final class Node<A, B> {
        private A key;
        private B value;
        private boolean red;
        private Node<A, B> left;
        private Node<A, B> right;
        private Node<A, B> parent;

        public static <A, B> Node<A, B> apply(A a, B b, boolean bl, Node<A, B> node, Node<A, B> node2, Node<A, B> node3) {
            return RedBlackTree$Node$.MODULE$.apply(a, b, bl, node, node2, node3);
        }

        public static <A, B> Node<A, B> leaf(A a, B b, boolean bl, Node<A, B> node) {
            return RedBlackTree$Node$.MODULE$.leaf(a, b, bl, node);
        }

        public static <A, B> Some<Tuple5<A, B, Node<A, B>, Node<A, B>, Node<A, B>>> unapply(Node<A, B> node) {
            return RedBlackTree$Node$.MODULE$.unapply(node);
        }

        public Node(A key, B value, boolean red, Node<A, B> left, Node<A, B> right, Node<A, B> parent) {
            this.key = key;
            this.value = value;
            this.red = red;
            this.left = left;
            this.right = right;
            this.parent = parent;
        }

        public A key() {
            return this.key;
        }

        public void key_$eq(A x$1) {
            this.key = x$1;
        }

        public B value() {
            return this.value;
        }

        public void value_$eq(B x$1) {
            this.value = x$1;
        }

        public boolean red() {
            return this.red;
        }

        public void red_$eq(boolean x$1) {
            this.red = x$1;
        }

        public Node<A, B> left() {
            return this.left;
        }

        public void left_$eq(Node<A, B> x$1) {
            this.left = x$1;
        }

        public Node<A, B> right() {
            return this.right;
        }

        public void right_$eq(Node<A, B> x$1) {
            this.right = x$1;
        }

        public Node<A, B> parent() {
            return this.parent;
        }

        public void parent_$eq(Node<A, B> x$1) {
            this.parent = x$1;
        }

        public String toString() {
            return new StringBuilder(14).append("Node(").append(this.key()).append(", ").append(this.value()).append(", ").append(this.red()).append(", ").append(this.left()).append(", ").append(this.right()).append(")").toString();
        }
    }

    public static final class Tree<A, B> {
        private Node<A, B> root;
        private int size;

        public static <A, B> Tree<A, B> empty() {
            return RedBlackTree$Tree$.MODULE$.empty();
        }

        public Tree(Node<A, B> root, int size) {
            this.root = root;
            this.size = size;
        }

        public Node<A, B> root() {
            return this.root;
        }

        public void root_$eq(Node<A, B> x$1) {
            this.root = x$1;
        }

        public int size() {
            return this.size;
        }

        public void size_$eq(int x$1) {
            this.size = x$1;
        }

        public Tree<A, B> treeCopy() {
            return new Tree<A, B>(RedBlackTree$.MODULE$.copyTree(this.root()), this.size());
        }
    }

    public static abstract class TreeIterator<A, B, R>
    extends AbstractIterator<R> {
        private final Option<A> end;
        private final Ordering<A> ord;
        private Node<A, B> nextNode;

        public TreeIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> ord) {
            Node<A, B> node;
            this.end = end;
            this.ord = ord;
            Option<A> option = start;
            if (None$.MODULE$.equals(option)) {
                node = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$$minNode(tree.root());
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Object from = some.value();
                node = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$$minNodeAfter(tree.root(), from, ord);
            } else {
                throw new MatchError(option);
            }
            this.nextNode = node;
            this.setNullIfAfterEnd();
        }

        public abstract R nextResult(Node<A, B> var1);

        @Override
        public boolean hasNext() {
            return !(this.nextNode == null);
        }

        @Override
        public R next() throws NoSuchElementException {
            Node<A, B> node = this.nextNode;
            if (node == null) {
                throw new NoSuchElementException("next on empty iterator");
            }
            Node<A, B> node2 = node;
            this.nextNode = RedBlackTree$.MODULE$.scala$collection$mutable$RedBlackTree$$$successor(node2);
            this.setNullIfAfterEnd();
            return this.nextResult(node2);
        }

        private void setNullIfAfterEnd() {
            if (this.end.isDefined() && !(this.nextNode == null)) {
                Node<A, B> x$proxy136 = this.nextNode;
                if (x$proxy136 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                if (this.ord.compare(x$proxy136.key(), this.end.get()) >= 0) {
                    this.nextNode = null;
                    return;
                }
            }
        }
    }

    public static final class ValuesIterator<A, B>
    extends TreeIterator<A, B, B> {
        public ValuesIterator(Tree<A, B> tree, Option<A> start, Option<A> end, Ordering<A> evidence$1) {
            super(tree, start, end, evidence$1);
        }

        @Override
        public B nextResult(Node<A, B> node) {
            return node.value();
        }
    }
}

