/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterable;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.CommonErrors$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.MutationTracker;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Integral;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public class ListBuffer<A>
extends AbstractBuffer<A>
implements StrictOptimizedSeqOps<A, ListBuffer, ListBuffer<A>>,
ReusableBuilder<A, List<A>>,
DefaultSerializable {
    private static final long serialVersionUID = -8428291952499836345L;
    private transient int mutationCount;
    private List<A> first;
    private $colon$colon<A> last0;
    private boolean aliased;
    private int len;

    public static /* synthetic */ Object fill(int n, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, function0);
    }

    public static SeqOps fill(int n, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return ListBuffer$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <A> ListBuffer<A> from(IterableOnce<A> iterableOnce) {
        return ListBuffer$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return ListBuffer$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, ListBuffer<A>> newBuilder() {
        return ListBuffer$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return ListBuffer$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return ListBuffer$.MODULE$.range(object, object2, object3, integral);
    }

    public static /* synthetic */ Object tabulate(int n, Function1 function1) {
        return ListBuffer$.MODULE$.tabulate(n, function1);
    }

    public static SeqOps tabulate(int n, Function1 function1) {
        return ListBuffer$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return ListBuffer$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return ListBuffer$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return ListBuffer$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return ListBuffer$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static SeqOps unapplySeq(SeqOps seqOps) {
        return ListBuffer$.MODULE$.unapplySeq(seqOps);
    }

    public static Object unfold(Object object, Function1 function1) {
        return ListBuffer$.MODULE$.unfold(object, function1);
    }

    public ListBuffer() {
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        Builder.$init$(this);
        DefaultSerializable.$init$(this);
        this.mutationCount = 0;
        this.first = Nil$.MODULE$;
        this.last0 = null;
        this.aliased = false;
        this.len = 0;
    }

    @Override
    public Tuple2<ListBuffer<A>, ListBuffer<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<ListBuffer<A>, ListBuffer<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<ListBuffer<A1>, ListBuffer<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<ListBuffer<A1>, ListBuffer<A2>, ListBuffer<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<ListBuffer<A1>, ListBuffer<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<List<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    private List<A> first() {
        return this.first;
    }

    private void first_$eq(List<A> x$0) {
        this.first = x$0;
    }

    private $colon$colon<A> last0() {
        return this.last0;
    }

    private void last0_$eq($colon$colon<A> x$0) {
        this.last0 = x$0;
    }

    @Override
    public Iterator<A> iterator() {
        return new MutationTracker.CheckedIterator<A>(this.first().iterator(), (Function0<Object>)((Function0<Integer> & Serializable)this::iterator$$anonfun$1));
    }

    @Override
    public SeqFactory<ListBuffer> iterableFactory() {
        return ListBuffer$.MODULE$;
    }

    @Override
    public A apply(int i) throws IndexOutOfBoundsException {
        return this.first().apply(i);
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public int knownSize() {
        return this.len;
    }

    @Override
    public boolean isEmpty() {
        return this.len == 0;
    }

    private void copyElems() {
        ListBuffer<A> buf = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(this);
        this.first_$eq(super.first());
        this.last0_$eq(super.last0());
        this.aliased = false;
    }

    private void ensureUnaliased() {
        ++this.mutationCount;
        if (this.aliased) {
            this.copyElems();
            return;
        }
    }

    @Override
    public List<A> toList() {
        this.aliased = this.nonEmpty();
        Statics.releaseFence();
        return this.first();
    }

    @Override
    public List<A> result() {
        return this.toList();
    }

    public List<A> prependToList(List<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        this.ensureUnaliased();
        $colon$colon<A> x$proxy1 = this.last0();
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        x$proxy1.next_$eq(xs);
        return this.toList();
    }

    @Override
    public void clear() {
        ++this.mutationCount;
        this.first_$eq(Nil$.MODULE$);
        this.len = 0;
        this.last0_$eq(null);
        this.aliased = false;
    }

    @Override
    public final ListBuffer<A> addOne(A elem) {
        this.ensureUnaliased();
        $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)elem, Nil$.MODULE$);
        if (this.len == 0) {
            this.first_$eq(last1);
        } else {
            $colon$colon<Nothing$> x$proxy2 = this.last0();
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy2.next_$eq(last1);
        }
        this.last0_$eq(last1);
        ++this.len;
        return this;
    }

    public ListBuffer<A> scala$collection$mutable$ListBuffer$$freshFrom(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            int len = 1;
            $colon$colon<Nothing$> last0 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
            this.first_$eq(last0);
            while (it.hasNext()) {
                $colon$colon<Nothing$> last1 = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
                last0.next_$eq(last1);
                last0 = last1;
                ++len;
            }
            this.len = len;
            this.last0_$eq(last0);
        }
        return this;
    }

    @Override
    public final ListBuffer<A> addAll(IterableOnce<A> xs) {
        Iterator<A> it = xs.iterator();
        if (it.hasNext()) {
            ListBuffer<A> fresh = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(it);
            this.ensureUnaliased();
            if (this.len == 0) {
                this.first_$eq(super.first());
            } else {
                $colon$colon<A> x$proxy3 = this.last0();
                if (x$proxy3 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy3.next_$eq(super.first());
            }
            this.last0_$eq(super.last0());
            this.len += fresh.length();
        }
        return this;
    }

    @Override
    public ListBuffer<A> subtractOne(A elem) {
        this.ensureUnaliased();
        if (!this.isEmpty()) {
            if (BoxesRunTime.equals(this.first().head(), elem)) {
                this.first_$eq((List)this.first().tail());
                this.reduceLengthBy(1);
            } else {
                List cursor = this.first();
                while (!((List)cursor.tail()).isEmpty() && !BoxesRunTime.equals(((IterableOps)cursor.tail()).head(), elem)) {
                    cursor = (List)cursor.tail();
                }
                if (!((List)cursor.tail()).isEmpty()) {
                    $colon$colon z = ($colon$colon)cursor;
                    List list = z.next();
                    $colon$colon<A> $colon$colon = this.last0();
                    if (!(list != null ? !((Object)list).equals($colon$colon) : $colon$colon != null)) {
                        this.last0_$eq(z);
                    }
                    z.next_$eq((List)((IterableOps)cursor.tail()).tail());
                    this.reduceLengthBy(1);
                }
            }
        }
        return this;
    }

    private void reduceLengthBy(int num) {
        this.len -= num;
        if (this.len <= 0) {
            this.last0_$eq(null);
            return;
        }
    }

    private $colon$colon<A> predecessor(int i) {
        if (i == 0) {
            return null;
        }
        if (i == this.len) {
            return this.last0();
        }
        List p = this.first();
        for (int j = i - 1; j > 0; --j) {
            p = (List)p.tail();
        }
        return ($colon$colon)p;
    }

    private List<A> getNext($colon$colon<A> p) {
        if (p == null) {
            return this.first();
        }
        return p.next();
    }

    @Override
    public void update(int idx, A elem) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, this.len - 1);
        }
        if (idx == 0) {
            $colon$colon<A> newElem = new $colon$colon<A>(elem, (List)this.first().tail());
            if (this.last0() == this.first()) {
                this.last0_$eq(newElem);
            }
            this.first_$eq(newElem);
            return;
        }
        $colon$colon<A> x$proxy5 = this.predecessor(idx);
        if (x$proxy5 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        $colon$colon<A> p = x$proxy5;
        $colon$colon<A> newElem = new $colon$colon<A>(elem, (List)((AbstractIterable)p.tail()).tail());
        if (this.last0() == p.tail()) {
            this.last0_$eq(newElem);
        }
        p.next_$eq(newElem);
    }

    @Override
    public void insert(int idx, A elem) {
        this.ensureUnaliased();
        if (idx < 0 || idx > this.len) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, this.len - 1);
        }
        if (idx == this.len) {
            this.addOne((Object)elem);
            return;
        }
        $colon$colon<A> p = this.predecessor(idx);
        List<A> nx = this.getNext(p).$colon$colon(elem);
        if (p == null) {
            this.first_$eq(nx);
        } else {
            p.next_$eq(nx);
        }
        ++this.len;
    }

    @Override
    public ListBuffer<A> prepend(A elem) {
        this.insert(0, elem);
        return this;
    }

    private void insertAfter($colon$colon<A> prev, ListBuffer<A> fresh) {
        if (!fresh.isEmpty()) {
            List<A> follow = this.getNext(prev);
            if (prev == null) {
                this.first_$eq(super.first());
            } else {
                prev.next_$eq(super.first());
            }
            $colon$colon<A> x$proxy7 = super.last0();
            if (x$proxy7 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            x$proxy7.next_$eq(follow);
            if (follow.isEmpty()) {
                this.last0_$eq(super.last0());
            }
            this.len += fresh.length();
            return;
        }
    }

    @Override
    public void insertAll(int idx, IterableOnce<A> elems) {
        if (idx < 0 || idx > this.len) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, this.len - 1);
        }
        Iterator<A> it = elems.iterator();
        if (it.hasNext()) {
            if (idx == this.len) {
                this.addAll((IterableOnce)it);
                return;
            }
            ListBuffer<A> fresh = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(it);
            this.ensureUnaliased();
            this.insertAfter(this.predecessor(idx), fresh);
            return;
        }
    }

    @Override
    public A remove(int idx) {
        this.ensureUnaliased();
        if (idx < 0 || idx >= this.len) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(idx, this.len - 1);
        }
        $colon$colon<A> p = this.predecessor(idx);
        List<A> nx = this.getNext(p);
        if (p == null) {
            this.first_$eq((List)nx.tail());
            if (this.first().isEmpty()) {
                this.last0_$eq(null);
            }
        } else {
            if (this.last0() == nx) {
                this.last0_$eq(p);
            }
            p.next_$eq((List)nx.tail());
        }
        --this.len;
        return nx.head();
    }

    @Override
    public void remove(int idx, int count) {
        if (count > 0) {
            this.ensureUnaliased();
            if (idx < 0 || idx + count > this.len) {
                throw new IndexOutOfBoundsException(new StringBuilder(35).append(idx).append(" to ").append(idx + count).append(" is out of bounds (min 0, max ").append(this.len - 1).append(")").toString());
            }
            this.removeAfter(this.predecessor(idx), count);
            return;
        }
        if (count < 0) {
            throw new IllegalArgumentException(new StringBuilder(38).append("removing negative number of elements: ").append(count).toString());
        }
    }

    private void removeAfter($colon$colon<A> prev, int n) {
        List nx = ListBuffer.ahead$1(this.getNext(prev), n);
        if (prev == null) {
            this.first_$eq(nx);
        } else {
            prev.next_$eq(nx);
        }
        if (nx.isEmpty()) {
            this.last0_$eq(prev);
        }
        this.len -= n;
    }

    public ListBuffer<A> mapInPlace(Function1<A, A> f) {
        ++this.mutationCount;
        ListBuffer buf = new ListBuffer();
        this.foreach((Function1<Object, ListBuffer> & Serializable)elem -> (ListBuffer)buf.$plus$eq(f.apply(elem)));
        this.first_$eq(super.first());
        this.last0_$eq(super.last0());
        this.aliased = false;
        return this;
    }

    public ListBuffer<A> flatMapInPlace(Function1<A, IterableOnce<A>> f) {
        ++this.mutationCount;
        List src = this.first();
        $colon$colon<Nothing$> dst = null;
        this.last0_$eq(null);
        this.len = 0;
        while (!src.isEmpty()) {
            Iterator<A> it = f.apply(src.head()).iterator();
            while (it.hasNext()) {
                $colon$colon<Nothing$> v = new $colon$colon<Nothing$>((Nothing$)it.next(), Nil$.MODULE$);
                if (dst == null) {
                    dst = v;
                } else {
                    $colon$colon<Nothing$> x$proxy10 = this.last0();
                    if (x$proxy10 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy10.next_$eq(v);
                }
                this.last0_$eq(v);
                ++this.len;
            }
            src = (List)src.tail();
        }
        this.first_$eq(dst == null ? Nil$.MODULE$ : dst);
        this.aliased = false;
        return this;
    }

    public ListBuffer<A> filterInPlace(Function1<A, Object> p) {
        this.ensureUnaliased();
        $colon$colon prev = null;
        List cur = this.first();
        while (!cur.isEmpty()) {
            List follow = (List)cur.tail();
            if (!BoxesRunTime.unboxToBoolean(p.apply(cur.head()))) {
                if (prev == null) {
                    this.first_$eq(follow);
                } else {
                    prev.next_$eq(follow);
                }
                --this.len;
            } else {
                prev = ($colon$colon)cur;
            }
            cur = follow;
        }
        this.last0_$eq(prev);
        return this;
    }

    @Override
    public ListBuffer<A> patchInPlace(int from, IterableOnce<A> patch, int replaced) {
        boolean nonEmptyReplace;
        int _len = this.len;
        int _from = package$.MODULE$.max(from, 0);
        int _replaced = package$.MODULE$.max(replaced, 0);
        Iterator<A> it = patch.iterator();
        boolean nonEmptyPatch = it.hasNext();
        boolean bl = nonEmptyReplace = _from < _len && _replaced > 0;
        if (nonEmptyPatch || nonEmptyReplace) {
            ListBuffer<A> fresh = new ListBuffer<A>().scala$collection$mutable$ListBuffer$$freshFrom(it);
            this.ensureUnaliased();
            int i = package$.MODULE$.min(_from, _len);
            int n = package$.MODULE$.min(_replaced, _len);
            $colon$colon<A> p = this.predecessor(i);
            this.removeAfter(p, package$.MODULE$.min(n, _len - i));
            this.insertAfter(p, fresh);
        }
        return this;
    }

    @Override
    public A last() {
        if (this.last0() == null) {
            throw new NoSuchElementException("last of empty ListBuffer");
        }
        return this.last0().head();
    }

    @Override
    public Option<A> lastOption() {
        if (this.last0() == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.last0().head());
    }

    @Override
    public String stringPrefix() {
        return "ListBuffer";
    }

    private final int iterator$$anonfun$1() {
        return this.mutationCount;
    }

    private static final List ahead$1(List p, int n) {
        while (n != 0) {
            List list = (List)p.tail();
            int n2 = n - 1;
            p = list;
            n = n2;
        }
        return p;
    }
}

