/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.Factory;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.convert.impl.AnyTableStepper;
import scala.collection.convert.impl.DoubleTableStepper;
import scala.collection.convert.impl.IntTableStepper;
import scala.collection.convert.impl.LongTableStepper;
import scala.collection.convert.impl.TableStepperBase;
import scala.collection.generic.DefaultSerializationProxy;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Shrinkable;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

public final class HashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, HashSet, HashSet<A>>,
Serializable {
    private final double loadFactor;
    public Node<A>[] scala$collection$mutable$HashSet$$table;
    private int threshold;
    private int contentSize;

    public static int defaultInitialCapacity() {
        return HashSet$.MODULE$.defaultInitialCapacity();
    }

    public static double defaultLoadFactor() {
        return HashSet$.MODULE$.defaultLoadFactor();
    }

    public static Object fill(int n, Function0 function0) {
        return HashSet$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return HashSet$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <B> HashSet<B> from(IterableOnce<B> iterableOnce) {
        return HashSet$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return HashSet$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, HashSet<A>> newBuilder() {
        return HashSet$.MODULE$.newBuilder();
    }

    public static <A> Builder<A, HashSet<A>> newBuilder(int n, double d) {
        return HashSet$.MODULE$.newBuilder(n, d);
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return HashSet$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return HashSet$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return HashSet$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return HashSet$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static Object unfold(Object object, Function1 function1) {
        return HashSet$.MODULE$.unfold(object, function1);
    }

    public HashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        StrictOptimizedIterableOps.$init$(this);
        this.scala$collection$mutable$HashSet$$table = new Node[this.tableSizeFor(initialCapacity)];
        this.threshold = this.newThreshold(this.scala$collection$mutable$HashSet$$table.length);
        this.contentSize = 0;
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<HashSet<A>, HashSet<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<HashSet<A1>, HashSet<A2>, HashSet<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    public HashSet() {
        this(HashSet$.MODULE$.defaultInitialCapacity(), HashSet$.MODULE$.defaultLoadFactor());
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    public int unimproveHash(int improvedHash) {
        return this.improveHash(improvedHash);
    }

    private int improveHash(int originalHash) {
        return originalHash ^ originalHash >>> 16;
    }

    private int computeHash(A o) {
        return this.improveHash(Statics.anyHash(o));
    }

    private int index(int hash) {
        return hash & this.scala$collection$mutable$HashSet$$table.length - 1;
    }

    @Override
    public boolean contains(A elem) {
        return !(this.findNode(elem) == null);
    }

    private Node<A> findNode(A elem) {
        int hash = this.computeHash(elem);
        Node<A> node = this.scala$collection$mutable$HashSet$$table[this.index(hash)];
        if (node == null) {
            return null;
        }
        Node<A> nd = node;
        return nd.findNode(elem, hash);
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / this.loadFactor));
        if (target > this.scala$collection$mutable$HashSet$$table.length) {
            this.growTable(target);
            return;
        }
    }

    @Override
    public boolean add(A elem) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$HashSet$$table.length * 2);
        }
        return this.addElem(elem, this.computeHash(elem));
    }

    @Override
    public HashSet<A> addAll(IterableOnce<A> xs) {
        this.sizeHint(xs, 0);
        IterableOnce<A> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.immutable.HashSet) {
            scala.collection.immutable.HashSet hashSet;
            scala.collection.immutable.HashSet hs = hashSet = (scala.collection.immutable.HashSet)iterableOnce;
            hs.foreachWithHash((Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
                this.addAll$$anonfun$1(v1, BoxesRunTime.unboxToInt(v2));
                return BoxedUnit.UNIT;
            });
            return this;
        }
        if (iterableOnce instanceof HashSet) {
            HashSet hashSet;
            HashSet hs = hashSet = (HashSet)iterableOnce;
            Iterator<Node<A>> iter = hs.nodeIterator();
            while (iter.hasNext()) {
                Node<A> next = iter.next();
                this.addElem(next.key(), next.hash());
            }
            return this;
        }
        if (iterableOnce instanceof LinkedHashSet) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet lhs = linkedHashSet = (LinkedHashSet)iterableOnce;
            Iterator iter = lhs.entryIterator();
            while (iter.hasNext()) {
                LinkedHashSet.Entry next = iter.next();
                this.addElem(next.key(), next.hash());
            }
            return this;
        }
        return (HashSet)Growable.addAll$(this, xs);
    }

    @Override
    public HashSet<A> subtractAll(IterableOnce<A> xs) {
        if (this.size() == 0) {
            return this;
        }
        IterableOnce<A> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.immutable.HashSet) {
            scala.collection.immutable.HashSet hashSet;
            scala.collection.immutable.HashSet hs = hashSet = (scala.collection.immutable.HashSet)iterableOnce;
            hs.foreachWithHashWhile((Function2<Object, Object, Boolean> & Serializable)(k, h) -> this.subtractAll$$anonfun$1(k, BoxesRunTime.unboxToInt(h)));
            return this;
        }
        if (iterableOnce instanceof HashSet) {
            HashSet hashSet;
            HashSet hs = hashSet = (HashSet)iterableOnce;
            Iterator<Node<A>> iter = hs.nodeIterator();
            while (iter.hasNext()) {
                Node<A> next = iter.next();
                this.remove(next.key(), next.hash());
                if (this.size() != 0) continue;
                return this;
            }
            return this;
        }
        if (iterableOnce instanceof LinkedHashSet) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet lhs = linkedHashSet = (LinkedHashSet)iterableOnce;
            Iterator iter = lhs.entryIterator();
            while (iter.hasNext()) {
                LinkedHashSet.Entry next = iter.next();
                this.remove(next.key(), next.hash());
                if (this.size() != 0) continue;
                return this;
            }
            return this;
        }
        return (HashSet)Shrinkable.subtractAll$(this, xs);
    }

    private boolean addElem(A elem, int hash) {
        int idx = this.index(hash);
        Node<A> node = this.scala$collection$mutable$HashSet$$table[idx];
        if (node == null) {
            this.scala$collection$mutable$HashSet$$table[idx] = new Node<A>(elem, hash, null);
        } else {
            Node<A> old = node;
            Node<A> prev = null;
            Node<A> n = old;
            while (!(n == null) && n.hash() <= hash) {
                if (n.hash() == hash && BoxesRunTime.equals(elem, n.key())) {
                    return false;
                }
                prev = n;
                n = n.next();
            }
            if (prev == null) {
                this.scala$collection$mutable$HashSet$$table[idx] = new Node<A>(elem, hash, old);
            } else {
                prev.next_$eq(new Node<A>(elem, hash, prev.next()));
            }
        }
        ++this.contentSize;
        return true;
    }

    private boolean remove(A elem, int hash) {
        Node<A> nd;
        int idx = this.index(hash);
        Node<A> node = this.scala$collection$mutable$HashSet$$table[idx];
        if (node == null) {
            return false;
        }
        Node<A> nd2 = node;
        if (nd2.hash() == hash && BoxesRunTime.equals(nd2.key(), elem)) {
            this.scala$collection$mutable$HashSet$$table[idx] = nd2.next();
            --this.contentSize;
            return true;
        }
        Node<A> prev = nd = node;
        Node<A> next = nd.next();
        while (!(next == null) && next.hash() <= hash) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                --this.contentSize;
                return true;
            }
            prev = next;
            next = next.next();
        }
        return false;
    }

    @Override
    public boolean remove(A elem) {
        return this.remove(elem, this.computeHash(elem));
    }

    @Override
    public Iterator<A> iterator() {
        return new HashSetIterator<A>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(Node nd) {
                return nd.key();
            }
        };
    }

    public Iterator<Node<A>> nodeIterator() {
        return new HashSetIterator<Node<A>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Node extract(Node nd) {
                return nd;
            }
        };
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        int n = shape.shape();
        TableStepperBase s = StepperShape$.MODULE$.IntShape() == n ? new IntTableStepper<Node<A>>(this.size(), this.scala$collection$mutable$HashSet$$table, (Function1<Node, Node> & Serializable)_$1 -> {
            Node x$proxy12 = _$1.next();
            if (x$proxy12 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy12;
        }, (Function1<Node, Integer> & Serializable)_$2 -> BoxesRunTime.unboxToInt(_$2.key()), 0, this.scala$collection$mutable$HashSet$$table.length) : (StepperShape$.MODULE$.LongShape() == n ? new LongTableStepper<Node<A>>(this.size(), this.scala$collection$mutable$HashSet$$table, (Function1<Node, Node> & Serializable)_$3 -> {
            Node x$proxy13 = _$3.next();
            if (x$proxy13 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy13;
        }, (Function1<Node, Long> & Serializable)_$4 -> BoxesRunTime.unboxToLong(_$4.key()), 0, this.scala$collection$mutable$HashSet$$table.length) : (StepperShape$.MODULE$.DoubleShape() == n ? new DoubleTableStepper<Node<A>>(this.size(), this.scala$collection$mutable$HashSet$$table, (Function1<Node, Node> & Serializable)_$5 -> {
            Node x$proxy14 = _$5.next();
            if (x$proxy14 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy14;
        }, (Function1<Node, Double> & Serializable)_$6 -> BoxesRunTime.unboxToDouble(_$6.key()), 0, this.scala$collection$mutable$HashSet$$table.length) : shape.parUnbox(new AnyTableStepper(this.size(), this.scala$collection$mutable$HashSet$$table, (Function1<Node, Node> & Serializable)_$7 -> {
            Node x$proxy15 = _$7.next();
            if (x$proxy15 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy15;
        }, (Function1<Node, Object> & Serializable)_$8 -> _$8.key(), 0, this.scala$collection$mutable$HashSet$$table.length))));
        return (S)s;
    }

    private void growTable(int newlen) {
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.scala$collection$mutable$HashSet$$table = new Node[newlen];
            return;
        }
        this.scala$collection$mutable$HashSet$$table = Arrays.copyOf(this.scala$collection$mutable$HashSet$$table, newlen);
        Node<Object> preLow = new Node<Object>(null, 0, null);
        Node<Object> preHigh = new Node<Object>(null, 0, null);
        for (int oldlen = this.scala$collection$mutable$HashSet$$table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                Node<A> old = this.scala$collection$mutable$HashSet$$table[i];
                if (!(!(old == null))) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Node<Object> lastLow = preLow;
                Node<Object> lastHigh = preHigh;
                Node<A> n = old;
                while (!(n == null)) {
                    Node<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (!(old == preLow.next())) {
                    this.scala$collection$mutable$HashSet$$table[i] = preLow.next();
                }
                if (!(!(preHigh.next() == null))) continue;
                this.scala$collection$mutable$HashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    public HashSet<A> filterInPlace(Function1<A, Object> p) {
        if (this.nonEmpty()) {
            for (int bucket = 0; bucket < this.scala$collection$mutable$HashSet$$table.length; ++bucket) {
                Node<A> head = this.scala$collection$mutable$HashSet$$table[bucket];
                while (!(head == null) && !BoxesRunTime.unboxToBoolean(p.apply(head.key()))) {
                    head = head.next();
                    --this.contentSize;
                }
                if (!(head == null)) {
                    Node<A> prev = head;
                    Node<A> next = head.next();
                    while (!(next == null)) {
                        if (BoxesRunTime.unboxToBoolean(p.apply(next.key()))) {
                            prev = next;
                        } else {
                            prev.next_$eq(next.next());
                            --this.contentSize;
                        }
                        next = next.next();
                    }
                }
                this.scala$collection$mutable$HashSet$$table[bucket] = head;
            }
        }
        return this;
    }

    private int tableSizeFor(int capacity) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(Integer.highestOneBit(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(capacity - 1), 4)) * 2), 0x40000000);
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$HashSet$$table, null);
        this.contentSize = 0;
    }

    @Override
    public IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    @Override
    public HashSet<A> addOne(A elem) {
        this.add(elem);
        return this;
    }

    @Override
    public HashSet<A> subtractOne(A elem) {
        this.remove(elem);
        return this;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        for (Node<A> n : this.scala$collection$mutable$HashSet$$table) {
            if (!(!(n == null))) continue;
            n.foreach(f);
        }
    }

    public Object writeReplace() {
        return new DefaultSerializationProxy(new DeserializationFactory(this.scala$collection$mutable$HashSet$$table.length, this.loadFactor), this);
    }

    @Override
    public String className() {
        return "HashSet";
    }

    @Override
    public int hashCode() {
        HashSetIterator<Object> setIterator = this.iterator();
        HashSetIterator<Object> hashIterator = setIterator.isEmpty() ? setIterator : new HashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ HashSet $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hash = 0;
            }

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(Node nd) {
                this.hash_$eq(this.$outer.unimproveHash(nd.hash()));
                return this;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)hashIterator, MurmurHash3$.MODULE$.setSeed());
    }

    private final /* synthetic */ void addAll$$anonfun$1(Object k, int h) {
        this.addElem(k, this.improveHash(h));
    }

    private final /* synthetic */ boolean subtractAll$$anonfun$1(Object k, int h) {
        this.remove(k, this.improveHash(h));
        return this.size() > 0;
    }

    public static final class DeserializationFactory<A>
    implements Factory<A, HashSet<A>>,
    Serializable {
        private static final long serialVersionUID = 3L;
        private final int tableLength;
        private final double loadFactor;

        public DeserializationFactory(int tableLength, double loadFactor) {
            this.tableLength = tableLength;
            this.loadFactor = loadFactor;
        }

        public int tableLength() {
            return this.tableLength;
        }

        public double loadFactor() {
            return this.loadFactor;
        }

        @Override
        public HashSet<A> fromSpecific(IterableOnce<A> it) {
            return (HashSet)new HashSet(this.tableLength(), this.loadFactor()).$plus$plus$eq((IterableOnce)it);
        }

        @Override
        public Builder<A, HashSet<A>> newBuilder() {
            return HashSet$.MODULE$.newBuilder(this.tableLength(), this.loadFactor());
        }
    }

    public abstract class HashSetIterator<B>
    extends AbstractIterator<B> {
        private int i;
        private Node<A> node;
        private final int len;

        public HashSetIterator() {
            if (HashSet.this == null) {
                throw new NullPointerException();
            }
            this.i = 0;
            this.node = null;
            this.len = HashSet.this.scala$collection$mutable$HashSet$$table.length;
        }

        public abstract B extract(Node<A> var1);

        @Override
        public boolean hasNext() {
            if (!(this.node == null)) {
                return true;
            }
            while (this.i < this.len) {
                Node n = HashSet.this.scala$collection$mutable$HashSet$$table[this.i];
                ++this.i;
                if (!(!(n == null))) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public B next() {
            void var2_1;
            if (!this.hasNext()) {
                return (B)Iterator$.MODULE$.empty().next();
            }
            Node x$proxy10 = this.node;
            if (x$proxy10 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            B r = this.extract((Node)var2_1);
            Node x$proxy11 = this.node;
            if (x$proxy11 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            this.node = x$proxy11.next();
            return r;
        }

        public final /* synthetic */ HashSet scala$collection$mutable$HashSet$HashSetIterator$$$outer() {
            return HashSet.this;
        }
    }

    public static final class Node<K> {
        private final K _key;
        private final int _hash;
        private Node<K> _next;

        public Node(K _key, int _hash, Node<K> _next) {
            this._key = _key;
            this._hash = _hash;
            this._next = _next;
        }

        private Node<K> _next() {
            return this._next;
        }

        private void _next_$eq(Node<K> x$0) {
            this._next = x$0;
        }

        public K key() {
            return this._key;
        }

        public int hash() {
            return this._hash;
        }

        public Node<K> next() {
            return this._next();
        }

        public void next_$eq(Node<K> n) {
            this._next_$eq(n);
        }

        public Node<K> findNode(K k, int h) {
            while (h != this_._hash || !BoxesRunTime.equals(k, this_._key)) {
                if (this_._next() == null || this_._hash > h) {
                    return null;
                }
                Node<K> this_ = this_._next();
            }
            return this_;
        }

        public <U> void foreach(Function1<K, U> f) {
            while (true) {
                f.apply(this_._key);
                if (!(!(this_._next() == null))) break;
                Node<K> this_ = this_._next();
            }
        }

        public String toString() {
            return new StringBuilder(12).append("Node(").append(this.key()).append(", ").append(this.hash()).append(") -> ").append(this.next()).toString();
        }
    }
}

