/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.Factory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedMapOps;
import scala.collection.convert.impl.AnyTableStepper;
import scala.collection.convert.impl.DoubleTableStepper;
import scala.collection.convert.impl.IntTableStepper;
import scala.collection.convert.impl.LongTableStepper;
import scala.collection.convert.impl.TableStepperBase;
import scala.collection.generic.DefaultSerializationProxy;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AbstractMap;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Shrinkable;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HashMap<K, V>
extends AbstractMap<K, V>
implements StrictOptimizedMapOps<K, V, HashMap, HashMap<K, V>>,
Serializable {
    private final double loadFactor;
    public Node<K, V>[] scala$collection$mutable$HashMap$$table;
    private int threshold;
    private int contentSize;

    public static int defaultInitialCapacity() {
        return HashMap$.MODULE$.defaultInitialCapacity();
    }

    public static double defaultLoadFactor() {
        return HashMap$.MODULE$.defaultLoadFactor();
    }

    public static <K, V> HashMap<K, V> from(IterableOnce<Tuple2<K, V>> iterableOnce) {
        return HashMap$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <K, V> Builder<Tuple2<K, V>, HashMap<K, V>> newBuilder() {
        return HashMap$.MODULE$.newBuilder();
    }

    public static <K, V> Builder<Tuple2<K, V>, HashMap<K, V>> newBuilder(int n, double d) {
        return HashMap$.MODULE$.newBuilder(n, d);
    }

    public HashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedMapOps.$init$(this);
        this.scala$collection$mutable$HashMap$$table = new Node[this.tableSizeFor(initialCapacity)];
        this.threshold = this.newThreshold(this.scala$collection$mutable$HashMap$$table.length);
        this.contentSize = 0;
    }

    @Override
    public Tuple2<HashMap<K, V>, HashMap<K, V>> partition(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<HashMap<K, V>, HashMap<K, V>> span(Function1<Tuple2<K, V>, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<Tuple2<K, V>, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<Tuple2<K, V>, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<Tuple2<K, V>, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<Tuple2<K, V>, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<Tuple2<K, V>, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<Tuple2<K, V>, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<Tuple2<K, V>, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<Tuple2<K, V>, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public IterableOps map(Function1 f) {
        return StrictOptimizedMapOps.map$(this, f);
    }

    @Override
    public IterableOps flatMap(Function1 f) {
        return StrictOptimizedMapOps.flatMap$(this, f);
    }

    @Override
    public IterableOps concat(IterableOnce suffix) {
        return StrictOptimizedMapOps.concat$(this, suffix);
    }

    @Override
    public IterableOps collect(PartialFunction pf) {
        return StrictOptimizedMapOps.collect$(this, pf);
    }

    @Override
    public IterableOps $plus(Tuple2 elem1, Tuple2 elem2, Seq elems) {
        return StrictOptimizedMapOps.$plus$(this, elem1, elem2, elems);
    }

    public HashMap() {
        this(HashMap$.MODULE$.defaultInitialCapacity(), HashMap$.MODULE$.defaultLoadFactor());
    }

    @Override
    public int size() {
        return this.contentSize;
    }

    public int unimproveHash(int improvedHash) {
        return this.improveHash(improvedHash);
    }

    private int improveHash(int originalHash) {
        return originalHash ^ originalHash >>> 16;
    }

    private int computeHash(K o) {
        return this.improveHash(Statics.anyHash(o));
    }

    private int index(int hash) {
        return hash & this.scala$collection$mutable$HashMap$$table.length - 1;
    }

    @Override
    public boolean contains(K key) {
        return !(this.findNode(key) == null);
    }

    private Node<K, V> findNode(K key) {
        int hash = this.computeHash(key);
        Node<K, V> node = this.scala$collection$mutable$HashMap$$table[this.index(hash)];
        if (node == null) {
            return null;
        }
        Node<K, V> nd = node;
        return nd.findNode(key, hash);
    }

    @Override
    public void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / this.loadFactor));
        if (target > this.scala$collection$mutable$HashMap$$table.length) {
            this.growTable(target);
            return;
        }
    }

    public HashMap<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.sizeHint(xs, this.sizeHint$default$2());
        IterableOnce<Tuple2<K, V>> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.immutable.HashMap) {
            scala.collection.immutable.HashMap hashMap;
            scala.collection.immutable.HashMap hm = hashMap = (scala.collection.immutable.HashMap)iterableOnce;
            hm.foreachWithHash((Function3<Object, Object, Object, Object> & Serializable)(v1, v2, v3) -> {
                this.addAll$$anonfun$1(v1, v2, BoxesRunTime.unboxToInt(v3));
                return BoxedUnit.UNIT;
            });
            return this;
        }
        if (iterableOnce instanceof HashMap) {
            HashMap hashMap;
            HashMap hm = hashMap = (HashMap)iterableOnce;
            Iterator<Node<K, V>> iter = hm.nodeIterator();
            while (iter.hasNext()) {
                Node<K, V> next = iter.next();
                this.put0(next.key(), next.value(), next.hash(), false);
            }
            return this;
        }
        if (iterableOnce instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap;
            LinkedHashMap lhm = linkedHashMap = (LinkedHashMap)iterableOnce;
            Iterator iter = lhm.entryIterator();
            while (iter.hasNext()) {
                LinkedHashMap.LinkedEntry entry = iter.next();
                this.put0(entry.key(), entry.value(), entry.hash(), false);
            }
            return this;
        }
        if (iterableOnce instanceof Map) {
            Map map;
            Map thatMap = map = (Map)iterableOnce;
            thatMap.foreachEntry((Function2<Object, Object, Some> & Serializable)(key, value) -> this.put0(key, value, this.improveHash(Statics.anyHash(key)), false));
            return this;
        }
        return (HashMap)Growable.addAll$(this, xs);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Option<V> updateWith(K key, Function1<Option<V>, Option<V>> remappingFunction) {
        Serializable serializable;
        Option option;
        Class<?> clazz = this.getClass();
        Class<HashMap> clazz2 = HashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return scala.collection.mutable.MapOps.updateWith$(this, key, remappingFunction);
        }
        int hash = this.computeHash(key);
        int indexedHash = this.index(hash);
        ObjectRef<Object> foundNode = ObjectRef.create(null);
        ObjectRef<Object> previousNode = ObjectRef.create(null);
        Node<K, V> node = this.scala$collection$mutable$HashMap$$table[indexedHash];
        if (node != null) {
            Node<K, V> nd = node;
            HashMap.findNode$1(previousNode, foundNode, null, nd, key, hash);
        }
        Node node2 = (Node)foundNode.elem;
        if (node2 == null) {
            option = None$.MODULE$;
        } else {
            Node nd = node2;
            option = Some$.MODULE$.apply(nd.value());
        }
        None$ previousValue = option;
        Option<V> nextValue = remappingFunction.apply(previousValue);
        Tuple2<None$, Option<V>> tuple2 = Tuple2$.MODULE$.apply(previousValue, nextValue);
        Option option2 = tuple2._1();
        Option<V> option3 = tuple2._2();
        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3)) {
            serializable = BoxedUnit.UNIT;
            return nextValue;
        }
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            if (None$.MODULE$.equals(option3)) {
                if ((Node)previousNode.elem != null) {
                    Node x$proxy3 = (Node)previousNode.elem;
                    if (x$proxy3 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    Node x$proxy4 = (Node)foundNode.elem;
                    if (x$proxy4 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    x$proxy3.next_$eq(x$proxy4.next());
                } else {
                    Node x$proxy5 = (Node)foundNode.elem;
                    if (x$proxy5 == null) {
                        throw Scala3RunTime$.MODULE$.nnFail();
                    }
                    this.scala$collection$mutable$HashMap$$table[indexedHash] = x$proxy5.next();
                }
                --this.contentSize;
                serializable = BoxedUnit.UNIT;
                return nextValue;
            }
        }
        if (None$.MODULE$.equals(option2) && option3 instanceof Some) {
            int n;
            Some some = (Some)option3;
            Object value = some.value();
            if (this.contentSize + 1 >= this.threshold) {
                this.growTable(this.scala$collection$mutable$HashMap$$table.length * 2);
                n = this.index(hash);
            } else {
                n = indexedHash;
            }
            int newIndexedHash = n;
            serializable = this.put0(key, value, false, hash, newIndexedHash);
            return nextValue;
        }
        if (!(option2 instanceof Some)) throw new MatchError(tuple2);
        Some some = (Some)option2;
        if (!(option3 instanceof Some)) throw new MatchError(tuple2);
        Some some2 = (Some)option3;
        Object newValue = some2.value();
        Node x$proxy6 = (Node)foundNode.elem;
        if (x$proxy6 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        x$proxy6.value_$eq(newValue);
        serializable = BoxedUnit.UNIT;
        return nextValue;
    }

    public HashMap<K, V> subtractAll(IterableOnce<K> xs) {
        if (this.size() == 0) {
            return this;
        }
        IterableOnce<K> iterableOnce = xs;
        if (iterableOnce instanceof scala.collection.immutable.HashSet) {
            scala.collection.immutable.HashSet hashSet;
            scala.collection.immutable.HashSet hs = hashSet = (scala.collection.immutable.HashSet)iterableOnce;
            hs.foreachWithHashWhile((Function2<Object, Object, Boolean> & Serializable)(k, h) -> this.subtractAll$$anonfun$1(k, BoxesRunTime.unboxToInt(h)));
            return this;
        }
        if (iterableOnce instanceof HashSet) {
            HashSet hashSet;
            HashSet hs = hashSet = (HashSet)iterableOnce;
            Iterator iter = hs.nodeIterator();
            while (iter.hasNext()) {
                HashSet.Node next = iter.next();
                this.remove0(next.key(), next.hash());
                if (this.size() != 0) continue;
                return this;
            }
            return this;
        }
        if (iterableOnce instanceof LinkedHashSet) {
            LinkedHashSet linkedHashSet;
            LinkedHashSet lhs = linkedHashSet = (LinkedHashSet)iterableOnce;
            Iterator iter = lhs.entryIterator();
            while (iter.hasNext()) {
                LinkedHashSet.Entry next = iter.next();
                this.remove0(next.key(), next.hash());
                if (this.size() != 0) continue;
                return this;
            }
            return this;
        }
        return (HashMap)Shrinkable.subtractAll$(this, xs);
    }

    private Some<V> put0(K key, V value, int hash, boolean getOld) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$HashMap$$table.length * 2);
        }
        int idx = this.index(hash);
        return this.put0(key, value, getOld, hash, idx);
    }

    private Some<V> put0(K key, V value, boolean getOld) {
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$HashMap$$table.length * 2);
        }
        int hash = this.computeHash(key);
        int idx = this.index(hash);
        return this.put0(key, value, getOld, hash, idx);
    }

    private Some<V> put0(K key, V value, boolean getOld, int hash, int idx) {
        Node<K, V> node = this.scala$collection$mutable$HashMap$$table[idx];
        if (node == null) {
            this.scala$collection$mutable$HashMap$$table[idx] = new Node<K, V>(key, hash, value, null);
        } else {
            Node<K, V> old = node;
            Node<K, V> prev = null;
            Node<K, V> n = old;
            while (!(n == null) && n.hash() <= hash) {
                if (n.hash() == hash && BoxesRunTime.equals(key, n.key())) {
                    V old2 = n.value();
                    n.value_$eq(value);
                    if (getOld) {
                        return Some$.MODULE$.apply(old2);
                    }
                    return null;
                }
                prev = n;
                n = n.next();
            }
            if (prev == null) {
                this.scala$collection$mutable$HashMap$$table[idx] = new Node<K, V>(key, hash, value, old);
            } else {
                prev.next_$eq(new Node<K, V>(key, hash, value, prev.next()));
            }
        }
        ++this.contentSize;
        return null;
    }

    private Node<K, V> remove0(K elem) {
        return this.remove0(elem, this.computeHash(elem));
    }

    private Node<K, V> remove0(K elem, int hash) {
        Node<K, V> nd;
        int idx = this.index(hash);
        Node<K, V> node = this.scala$collection$mutable$HashMap$$table[idx];
        if (node == null) {
            return null;
        }
        Node<K, V> nd2 = node;
        if (nd2.hash() == hash && BoxesRunTime.equals(nd2.key(), elem)) {
            this.scala$collection$mutable$HashMap$$table[idx] = nd2.next();
            --this.contentSize;
            return nd2;
        }
        Node<K, V> prev = nd = node;
        Node<K, V> next = nd.next();
        while (!(next == null) && next.hash() <= hash) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                --this.contentSize;
                return next;
            }
            prev = next;
            next = next.next();
        }
        return null;
    }

    @Override
    public Iterator<Tuple2<K, V>> iterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new HashMapIterator<Tuple2<K, V>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Tuple2 extract(Node nd) {
                return Tuple2$.MODULE$.apply(nd.key(), nd.value());
            }
        };
    }

    @Override
    public Iterator<K> keysIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new HashMapIterator<K>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(Node nd) {
                return nd.key();
            }
        };
    }

    @Override
    public Iterator<V> valuesIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new HashMapIterator<V>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Object extract(Node nd) {
                return nd.value();
            }
        };
    }

    public Iterator<Node<K, V>> nodeIterator() {
        if (this.size() == 0) {
            return Iterator$.MODULE$.empty();
        }
        return new HashMapIterator<Node<K, V>>(this){
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
            }

            public Node extract(Node nd) {
                return nd;
            }
        };
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<K, V>, S> shape) {
        return shape.parUnbox(new AnyTableStepper(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$1 -> {
            Node x$proxy16 = _$1.next();
            if (x$proxy16 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy16;
        }, (Function1<Node, Tuple2> & Serializable)node -> Tuple2$.MODULE$.apply(node.key(), node.value()), 0, this.scala$collection$mutable$HashMap$$table.length));
    }

    @Override
    public <S extends Stepper<?>> S keyStepper(StepperShape<K, S> shape) {
        int n = shape.shape();
        TableStepperBase s = StepperShape$.MODULE$.IntShape() == n ? new IntTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$2 -> {
            Node x$proxy17 = _$2.next();
            if (x$proxy17 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy17;
        }, (Function1<Node, Integer> & Serializable)_$3 -> BoxesRunTime.unboxToInt(_$3.key()), 0, this.scala$collection$mutable$HashMap$$table.length) : (StepperShape$.MODULE$.LongShape() == n ? new LongTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$4 -> {
            Node x$proxy18 = _$4.next();
            if (x$proxy18 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy18;
        }, (Function1<Node, Long> & Serializable)_$5 -> BoxesRunTime.unboxToLong(_$5.key()), 0, this.scala$collection$mutable$HashMap$$table.length) : (StepperShape$.MODULE$.DoubleShape() == n ? new DoubleTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$6 -> {
            Node x$proxy19 = _$6.next();
            if (x$proxy19 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy19;
        }, (Function1<Node, Double> & Serializable)_$7 -> BoxesRunTime.unboxToDouble(_$7.key()), 0, this.scala$collection$mutable$HashMap$$table.length) : shape.parUnbox(new AnyTableStepper(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$8 -> {
            Node x$proxy20 = _$8.next();
            if (x$proxy20 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy20;
        }, (Function1<Node, Object> & Serializable)_$9 -> _$9.key(), 0, this.scala$collection$mutable$HashMap$$table.length))));
        return (S)s;
    }

    @Override
    public <S extends Stepper<?>> S valueStepper(StepperShape<V, S> shape) {
        int n = shape.shape();
        TableStepperBase s = StepperShape$.MODULE$.IntShape() == n ? new IntTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$10 -> {
            Node x$proxy21 = _$10.next();
            if (x$proxy21 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy21;
        }, (Function1<Node, Integer> & Serializable)_$11 -> BoxesRunTime.unboxToInt(_$11.value()), 0, this.scala$collection$mutable$HashMap$$table.length) : (StepperShape$.MODULE$.LongShape() == n ? new LongTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$12 -> {
            Node x$proxy22 = _$12.next();
            if (x$proxy22 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy22;
        }, (Function1<Node, Long> & Serializable)_$13 -> BoxesRunTime.unboxToLong(_$13.value()), 0, this.scala$collection$mutable$HashMap$$table.length) : (StepperShape$.MODULE$.DoubleShape() == n ? new DoubleTableStepper<Node<K, V>>(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$14 -> {
            Node x$proxy23 = _$14.next();
            if (x$proxy23 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy23;
        }, (Function1<Node, Double> & Serializable)_$15 -> BoxesRunTime.unboxToDouble(_$15.value()), 0, this.scala$collection$mutable$HashMap$$table.length) : shape.parUnbox(new AnyTableStepper(this.size(), this.scala$collection$mutable$HashMap$$table, (Function1<Node, Node> & Serializable)_$16 -> {
            Node x$proxy24 = _$16.next();
            if (x$proxy24 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            return x$proxy24;
        }, (Function1<Node, Object> & Serializable)_$17 -> _$17.value(), 0, this.scala$collection$mutable$HashMap$$table.length))));
        return (S)s;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(39).append("new HashMap table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.scala$collection$mutable$HashMap$$table = new Node[newlen];
            return;
        }
        this.scala$collection$mutable$HashMap$$table = Arrays.copyOf(this.scala$collection$mutable$HashMap$$table, newlen);
        Node<Object, Object> preLow = new Node<Object, Object>(null, 0, null, null);
        Node<Object, Object> preHigh = new Node<Object, Object>(null, 0, null, null);
        for (int oldlen = this.scala$collection$mutable$HashMap$$table.length; oldlen < newlen; oldlen *= 2) {
            for (int i = 0; i < oldlen; ++i) {
                Node<K, V> old = this.scala$collection$mutable$HashMap$$table[i];
                if (!(!(old == null))) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Node<Object, Object> lastLow = preLow;
                Node<Object, Object> lastHigh = preHigh;
                Node<K, V> n = old;
                while (!(n == null)) {
                    Node<K, V> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (!(old == preLow.next())) {
                    this.scala$collection$mutable$HashMap$$table[i] = preLow.next();
                }
                if (!(!(preHigh.next() == null))) continue;
                this.scala$collection$mutable$HashMap$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    private int tableSizeFor(int capacity) {
        return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(Integer.highestOneBit(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(capacity - 1), 4)) * 2), 0x40000000);
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor);
    }

    @Override
    public void clear() {
        Arrays.fill(this.scala$collection$mutable$HashMap$$table, null);
        this.contentSize = 0;
    }

    @Override
    public Option<V> get(K key) {
        Node<K, V> node = this.findNode(key);
        if (node == null) {
            return None$.MODULE$;
        }
        Node<K, V> nd = node;
        return Some$.MODULE$.apply(nd.value());
    }

    @Override
    public V apply(K key) throws NoSuchElementException {
        Node<K, V> node = this.findNode(key);
        if (node == null) {
            return this.default(key);
        }
        Node<K, V> nd = node;
        return nd.value();
    }

    @Override
    public <V1> V1 getOrElse(K key, Function0<V1> function0) {
        Class<?> clazz = this.getClass();
        Class<HashMap> clazz2 = HashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return (V1)MapOps.getOrElse$(this, key, function0);
        }
        Node<K, V> nd = this.findNode(key);
        if (nd == null) {
            return function0.apply();
        }
        return (V1)nd.value();
    }

    @Override
    public V getOrElseUpdate(K key, Function0<V> defaultValue) {
        Node<K, V> nd;
        Node<K, V> node;
        Class<?> clazz = this.getClass();
        Class<HashMap> clazz2 = HashMap.class;
        if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
            return (V)scala.collection.mutable.MapOps.getOrElseUpdate$(this, key, defaultValue);
        }
        int hash = this.computeHash(key);
        int idx = this.index(hash);
        Node<K, V> node2 = this.scala$collection$mutable$HashMap$$table[idx];
        if (node2 == null) {
            node = null;
        } else {
            Node<K, V> nd2 = node2;
            node = nd = nd2.findNode(key, hash);
        }
        if (nd != null) {
            return nd.value();
        }
        Node<K, V>[] table0 = this.scala$collection$mutable$HashMap$$table;
        V v = defaultValue.apply();
        if (this.contentSize + 1 >= this.threshold) {
            this.growTable(this.scala$collection$mutable$HashMap$$table.length * 2);
        }
        int newIdx = table0 == this.scala$collection$mutable$HashMap$$table ? idx : this.index(hash);
        this.put0(key, v, false, hash, newIdx);
        return v;
    }

    @Override
    public Option<V> put(K key, V value) {
        Some<V> some = this.put0(key, value, true);
        if (some == null) {
            return None$.MODULE$;
        }
        Some<V> sm = some;
        return sm;
    }

    @Override
    public Option<V> remove(K key) {
        Node<K, V> node = this.remove0(key);
        if (node == null) {
            return None$.MODULE$;
        }
        Node<K, V> nd = node;
        return Some$.MODULE$.apply(nd.value());
    }

    @Override
    public void update(K key, V value) {
        this.put0(key, value, false);
    }

    public HashMap<K, V> addOne(Tuple2<K, V> elem) {
        this.put0(elem._1(), elem._2(), false);
        return this;
    }

    public HashMap<K, V> subtractOne(K elem) {
        this.remove0(elem);
        return this;
    }

    @Override
    public int knownSize() {
        return this.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
        for (Node<K, V> n : this.scala$collection$mutable$HashMap$$table) {
            if (!(!(n == null))) continue;
            n.foreach(f);
        }
    }

    @Override
    public <U> void foreachEntry(Function2<K, V, U> f) {
        for (Node<K, V> n : this.scala$collection$mutable$HashMap$$table) {
            if (!(!(n == null))) continue;
            n.foreachEntry(f);
        }
    }

    public Object writeReplace() {
        return new DefaultSerializationProxy(new DeserializationFactory(this.scala$collection$mutable$HashMap$$table.length, this.loadFactor), this);
    }

    public HashMap<K, V> filterInPlace(Function2<K, V, Object> p) {
        if (this.nonEmpty()) {
            for (int bucket = 0; bucket < this.scala$collection$mutable$HashMap$$table.length; ++bucket) {
                Node<K, V> head = this.scala$collection$mutable$HashMap$$table[bucket];
                while (!(head == null) && !BoxesRunTime.unboxToBoolean(p.apply(head.key(), head.value()))) {
                    head = head.next();
                    --this.contentSize;
                }
                if (!(head == null)) {
                    Node<K, V> prev = head;
                    Node<K, V> next = head.next();
                    while (!(next == null)) {
                        if (BoxesRunTime.unboxToBoolean(p.apply(next.key(), next.value()))) {
                            prev = next;
                        } else {
                            prev.next_$eq(next.next());
                            --this.contentSize;
                        }
                        next = next.next();
                    }
                }
                this.scala$collection$mutable$HashMap$$table[bucket] = head;
            }
        }
        return this;
    }

    public HashMap<K, V> mapValuesInPlaceImpl(Function2<K, V, V> f) {
        for (Node<K, V> n : this.scala$collection$mutable$HashMap$$table) {
            while (!(n == null)) {
                n.value_$eq(f.apply(n.key(), n.value()));
                n = n.next();
            }
        }
        return this;
    }

    @Override
    public MapFactory<HashMap> mapFactory() {
        return HashMap$.MODULE$;
    }

    @Override
    public String stringPrefix() {
        return "HashMap";
    }

    @Override
    public int hashCode() {
        if (this.isEmpty()) {
            return MurmurHash3$.MODULE$.emptyMapHash();
        }
        HashMapIterator<Object> tupleHashIterator = new HashMapIterator<Object>(this){
            private int hash;
            private final /* synthetic */ HashMap $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hash = 0;
            }

            public int hash() {
                return this.hash;
            }

            public void hash_$eq(int x$1) {
                this.hash = x$1;
            }

            public int hashCode() {
                return this.hash();
            }

            public Object extract(Node nd) {
                this.hash_$eq(MurmurHash3$.MODULE$.tuple2Hash(BoxesRunTime.boxToInteger(this.$outer.unimproveHash(nd.hash())), BoxesRunTime.boxToInteger(Statics.anyHash(nd.value()))));
                return this;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)tupleHashIterator, MurmurHash3$.MODULE$.mapSeed());
    }

    private final /* synthetic */ void addAll$$anonfun$1(Object k, Object v, int h) {
        this.put0(k, v, this.improveHash(h), false);
    }

    private static final void findNode$1(ObjectRef previousNode$1, ObjectRef foundNode$1, Node prev, Node nd, Object k, int h) {
        while (true) {
            if (h == nd.hash() && BoxesRunTime.equals(k, nd.key())) {
                previousNode$1.elem = prev;
                foundNode$1.elem = nd;
                return;
            }
            Node ndNext = nd.next();
            if (ndNext == null || nd.hash() > h) {
                return;
            }
            Node node = nd;
            Node node2 = ndNext;
            prev = node;
            nd = node2;
        }
    }

    private final /* synthetic */ boolean subtractAll$$anonfun$1(Object k, int h) {
        this.remove0(k, this.improveHash(h));
        return this.size() > 0;
    }

    public static final class DeserializationFactory<K, V>
    implements Factory<Tuple2<K, V>, HashMap<K, V>>,
    Serializable {
        private static final long serialVersionUID = 3L;
        private final int tableLength;
        private final double loadFactor;

        public DeserializationFactory(int tableLength, double loadFactor) {
            this.tableLength = tableLength;
            this.loadFactor = loadFactor;
        }

        public int tableLength() {
            return this.tableLength;
        }

        public double loadFactor() {
            return this.loadFactor;
        }

        @Override
        public HashMap<K, V> fromSpecific(IterableOnce<Tuple2<K, V>> it) {
            return new HashMap(this.tableLength(), this.loadFactor()).addAll((IterableOnce)it);
        }

        @Override
        public Builder<Tuple2<K, V>, HashMap<K, V>> newBuilder() {
            return HashMap$.MODULE$.newBuilder(this.tableLength(), this.loadFactor());
        }
    }

    public abstract class HashMapIterator<A>
    extends AbstractIterator<A> {
        private int i;
        private Node<K, V> node;
        private final int len;

        public HashMapIterator() {
            if (HashMap.this == null) {
                throw new NullPointerException();
            }
            this.i = 0;
            this.node = null;
            this.len = HashMap.this.scala$collection$mutable$HashMap$$table.length;
        }

        public abstract A extract(Node<K, V> var1);

        @Override
        public boolean hasNext() {
            if (!(this.node == null)) {
                return true;
            }
            while (this.i < this.len) {
                Node n = HashMap.this.scala$collection$mutable$HashMap$$table[this.i];
                ++this.i;
                if (!(!(n == null))) continue;
                this.node = n;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public A next() {
            void var2_1;
            if (!this.hasNext()) {
                return Iterator$.MODULE$.empty().next();
            }
            Node x$proxy14 = this.node;
            if (x$proxy14 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            A r = this.extract((Node)var2_1);
            Node x$proxy15 = this.node;
            if (x$proxy15 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            this.node = x$proxy15.next();
            return r;
        }

        public final /* synthetic */ HashMap scala$collection$mutable$HashMap$HashMapIterator$$$outer() {
            return HashMap.this;
        }
    }

    public static final class Node<K, V> {
        private final K _key;
        private final int _hash;
        private V _value;
        private Node<K, V> _next;

        public Node(K _key, int _hash, V _value, Node<K, V> _next) {
            this._key = _key;
            this._hash = _hash;
            this._value = _value;
            this._next = _next;
        }

        private V _value() {
            return this._value;
        }

        private void _value_$eq(V x$0) {
            this._value = x$0;
        }

        private Node<K, V> _next() {
            return this._next;
        }

        private void _next_$eq(Node<K, V> x$0) {
            this._next = x$0;
        }

        public K key() {
            return this._key;
        }

        public int hash() {
            return this._hash;
        }

        public V value() {
            return this._value();
        }

        public void value_$eq(V v) {
            this._value_$eq(v);
        }

        public Node<K, V> next() {
            return this._next();
        }

        public void next_$eq(Node<K, V> n) {
            this._next_$eq(n);
        }

        public Node<K, V> findNode(K k, int h) {
            while (h != this_._hash || !BoxesRunTime.equals(k, this_._key)) {
                if (this_._next() == null || this_._hash > h) {
                    return null;
                }
                Node<K, V> this_ = this_._next();
            }
            return this_;
        }

        public <U> void foreach(Function1<Tuple2<K, V>, U> f) {
            while (true) {
                f.apply(Tuple2$.MODULE$.apply(this_._key, this_._value()));
                if (!(!(this_._next() == null))) break;
                Node<K, V> this_ = this_._next();
            }
        }

        public <U> void foreachEntry(Function2<K, V, U> f) {
            while (true) {
                f.apply(this_._key, this_._value());
                if (!(!(this_._next() == null))) break;
                Node<K, V> this_ = this_._next();
            }
        }

        public String toString() {
            return new StringBuilder(14).append("Node(").append(this.key()).append(", ").append(this.value()).append(", ").append(this.hash()).append(") -> ").append(this.next()).toString();
        }
    }
}

