/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$;
import scala.math.BigDecimal;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$BigInt$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class NumericRange$
implements Serializable {
    private static final Map<Numeric<?>, Ordering<?>> defaultOrdering;
    public static final NumericRange$ MODULE$;

    private NumericRange$() {
    }

    static {
        MODULE$ = new NumericRange$();
        Tuple2[] tuple2Array = new Tuple2[7];
        package$.MODULE$.Numeric();
        Numeric$BigIntIsIntegral$ numeric$BigIntIsIntegral$ = (Numeric$BigIntIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$BigIntIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[0] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$BigIntIsIntegral$, Ordering$BigInt$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$IntIsIntegral$ numeric$IntIsIntegral$ = (Numeric$IntIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$IntIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[1] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$IntIsIntegral$, Ordering$Int$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$ShortIsIntegral$ numeric$ShortIsIntegral$ = (Numeric$ShortIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$ShortIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[2] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$ShortIsIntegral$, Ordering$Short$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$ByteIsIntegral$ numeric$ByteIsIntegral$ = (Numeric$ByteIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$ByteIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[3] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$ByteIsIntegral$, Ordering$Byte$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$CharIsIntegral$ numeric$CharIsIntegral$ = (Numeric$CharIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$CharIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[4] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$CharIsIntegral$, Ordering$Char$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$LongIsIntegral$ numeric$LongIsIntegral$ = (Numeric$LongIsIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$LongIsIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[5] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$LongIsIntegral$, Ordering$Long$.MODULE$);
        package$.MODULE$.Numeric();
        Numeric$BigDecimalAsIfIntegral$ numeric$BigDecimalAsIfIntegral$ = (Numeric$BigDecimalAsIfIntegral$)Predef$.MODULE$.ArrowAssoc(Numeric$BigDecimalAsIfIntegral$.MODULE$);
        package$.MODULE$.Ordering();
        tuple2Array[6] = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(numeric$BigDecimalAsIfIntegral$, Ordering$BigDecimal$.MODULE$);
        defaultOrdering = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(tuple2Array));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(NumericRange$.class);
    }

    private <T> void bigDecimalCheckUnderflow(T start, T end, T step, Integral<T> num) {
        if (!BoxesRunTime.equals(num.minus(num.plus(start, step), start), step)) {
            this.FAIL$1(start, step);
        }
        if (!BoxesRunTime.equals(num.minus(end, num.minus(end, step)), step)) {
            this.FAIL$1(end, step);
            return;
        }
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        Object object;
        T endside;
        int stepint;
        int endint;
        Object zero = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero);
        if (BoxesRunTime.equals(step, zero)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            if (isInclusive) {
                return 1;
            }
            return 0;
        }
        if (upward != posStep) {
            return 0;
        }
        int startint = num.toInt(start);
        if (BoxesRunTime.equals(start, num.fromInt(startint)) && BoxesRunTime.equals(end, num.fromInt(endint = num.toInt(end))) && BoxesRunTime.equals(step, num.fromInt(stepint = num.toInt(step)))) {
            if (isInclusive) {
                return Range$.MODULE$.inclusive(startint, endint, stepint).length();
            }
            return Range$.MODULE$.apply(startint, endint, stepint).length();
        }
        if (num instanceof Numeric.BigDecimalAsIfIntegral) {
            this.bigDecimalCheckUnderflow(start, end, step, num);
        }
        Object one = num.one();
        Object limit = num.fromInt(Integer.MAX_VALUE);
        T startside = num.sign(start);
        if (num.gteq(num.times(startside, endside = num.sign(end)), zero)) {
            T diff = num.minus(end, start);
            Object quotient = this.check$1(num, limit, num.quot(diff, step));
            Object remainder = num.minus(diff, num.times(quotient, step));
            object = !isInclusive && BoxesRunTime.equals(zero, remainder) ? quotient : this.check$1(num, limit, num.plus(quotient, one));
        } else {
            Object object2;
            Object negone = num.fromInt(-1);
            Object startlim = posStep ? negone : one;
            T startdiff = posStep && num.lt(startlim, start) || !posStep && num.gt(startlim, start) ? start : num.minus(startlim, start);
            Object startq = this.check$1(num, limit, num.quot(startdiff, step));
            Object waypointA = BoxesRunTime.equals(startq, zero) ? start : num.plus(start, num.times(startq, step));
            T waypointB = num.plus(waypointA, step);
            if (num.lt(waypointB, end) != upward) {
                object2 = isInclusive && BoxesRunTime.equals(waypointB, end) ? num.plus(startq, num.fromInt(2)) : num.plus(startq, one);
            } else {
                T enddiff = num.minus(end, waypointB);
                Object endq = this.check$1(num, limit, num.quot(enddiff, step));
                T last = BoxesRunTime.equals(endq, zero) ? waypointB : num.plus(waypointB, num.times(endq, step));
                object2 = num.plus(startq, num.plus(endq, !isInclusive && BoxesRunTime.equals(last, end) ? one : num.fromInt(2)));
            }
            object = this.check$1(num, limit, object2);
        }
        return num.toInt(object);
    }

    public <T> NumericRange.Exclusive<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Exclusive<T>(start, end, step, num);
    }

    public <T> NumericRange.Inclusive<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Inclusive<T>(start, end, step, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return defaultOrdering;
    }

    private final void FAIL$1(Object boundary2, Object step) {
        String string2;
        Object object = boundary2;
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal;
            BigDecimal bd = bigDecimal = (BigDecimal)object;
            string2 = new StringBuilder(10).append("Precision ").append(bd.mc().getPrecision()).toString();
        } else {
            string2 = "Precision";
        }
        String msg = string2;
        throw new IllegalArgumentException(new StringBuilder(45).append(msg).append(" inadequate to represent steps of size ").append(step).append(" near ").append(boundary2).toString());
    }

    private final Object check$1(Integral num$1, Object limit$1, Object t) {
        if (num$1.gt(t, limit$1)) {
            throw new IllegalArgumentException("More than Int.MaxValue elements.");
        }
        return t;
    }
}

