/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.HashMapBuilder;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.runtime.BoxedUnit;

public final class MapBuilderImpl<K, V>
implements ReusableBuilder<Tuple2<K, V>, Map<K, V>> {
    private Map<K, V> elems;
    private boolean switchedToHashMapBuilder;
    private HashMapBuilder<K, V> hashMapBuilder;

    public MapBuilderImpl() {
        Growable.$init$(this);
        Builder.$init$(this);
        this.elems = Map$.MODULE$.empty();
        this.switchedToHashMapBuilder = false;
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public int knownSize() {
        return Growable.knownSize$(this);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<Tuple2<K, V>, NewTo> mapResult(Function1<Map<K, V>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    public <V0> V0 getOrElse(K key, V0 value) {
        if (!(this.hashMapBuilder == null)) {
            return this.hashMapBuilder.getOrElse(key, value);
        }
        return (V0)this.elems.getOrElse(key, () -> MapBuilderImpl.getOrElse$$anonfun$1(value));
    }

    @Override
    public void clear() {
        this.elems = Map$.MODULE$.empty();
        if (this.hashMapBuilder != null) {
            this.hashMapBuilder.clear();
        }
        this.switchedToHashMapBuilder = false;
    }

    @Override
    public Map<K, V> result() {
        if (this.switchedToHashMapBuilder) {
            return this.hashMapBuilder.result();
        }
        return this.elems;
    }

    public MapBuilderImpl<K, V> addOne(K key, V value) {
        HashMapBuilder<K, V> hashMapBuilder;
        if (this.switchedToHashMapBuilder) {
            hashMapBuilder = this.hashMapBuilder.addOne(key, value);
        } else if (this.elems.size() < 4) {
            this.elems = (Map)this.elems.updated(key, value);
            hashMapBuilder = BoxedUnit.UNIT;
        } else if (this.elems.contains(key)) {
            this.elems = (Map)this.elems.updated(key, value);
            hashMapBuilder = BoxedUnit.UNIT;
        } else {
            this.switchedToHashMapBuilder = true;
            if (this.hashMapBuilder == null) {
                this.hashMapBuilder = new HashMapBuilder();
            }
            ((Map.Map4)this.elems).buildTo(this.hashMapBuilder);
            hashMapBuilder = this.hashMapBuilder.addOne(key, value);
        }
        return this;
    }

    public MapBuilderImpl<K, V> addOne(Tuple2<K, V> elem) {
        return this.addOne(elem._1(), elem._2());
    }

    public MapBuilderImpl<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        if (this.switchedToHashMapBuilder) {
            this.hashMapBuilder.addAll((IterableOnce)xs);
            return this;
        }
        return (MapBuilderImpl)Growable.addAll$(this, xs);
    }

    private static final Object getOrElse$$anonfun$1(Object value$1) {
        return value$1;
    }
}

