/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.convert.impl;

import java.io.Serializable;
import java.util.Arrays;
import scala.Int$;
import scala.collection.Stepper;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class ChampStepperBase<A, T extends Node<T>, Sub, Semi extends ChampStepperBase<A, T, ?, ?>>
implements Stepper.EfficientSplit {
    private int maxSize;
    private int currentValueCursor;
    private int currentValueLength;
    private T currentValueNode;
    private int currentStackLevel;
    private int[] nodeCursorsAndLengths;
    private T[] nodes;

    public ChampStepperBase(int maxSize) {
        this.maxSize = maxSize;
        this.currentValueCursor = 0;
        this.currentValueLength = 0;
        this.currentStackLevel = -1;
    }

    public int maxSize() {
        return this.maxSize;
    }

    public void maxSize_$eq(int x$1) {
        this.maxSize = x$1;
    }

    public int currentValueCursor() {
        return this.currentValueCursor;
    }

    public void currentValueCursor_$eq(int x$1) {
        this.currentValueCursor = x$1;
    }

    public int currentValueLength() {
        return this.currentValueLength;
    }

    public void currentValueLength_$eq(int x$1) {
        this.currentValueLength = x$1;
    }

    public T currentValueNode() {
        return this.currentValueNode;
    }

    public void currentValueNode_$eq(T x$1) {
        this.currentValueNode = x$1;
    }

    private int currentStackLevel() {
        return this.currentStackLevel;
    }

    private void currentStackLevel_$eq(int x$0) {
        this.currentStackLevel = x$0;
    }

    private int[] nodeCursorsAndLengths() {
        return this.nodeCursorsAndLengths;
    }

    private void nodeCursorsAndLengths_$eq(int[] x$0) {
        this.nodeCursorsAndLengths = x$0;
    }

    private T[] nodes() {
        return this.nodes;
    }

    private void nodes_$eq(T[] x$0) {
        this.nodes = x$0;
    }

    private void initNodes() {
        if (this.nodeCursorsAndLengths() == null) {
            this.nodeCursorsAndLengths_$eq(new int[Node$.MODULE$.MaxDepth() * 2]);
            this.nodes_$eq(new Node[Node$.MODULE$.MaxDepth()]);
            return;
        }
    }

    public void initRoot(T rootNode) {
        if (((Node)rootNode).hasNodes()) {
            this.pushNode(rootNode);
        }
        if (((Node)rootNode).hasPayload()) {
            this.setupPayloadNode(rootNode);
            return;
        }
    }

    private final void setupPayloadNode(T node) {
        this.currentValueNode_$eq(node);
        this.currentValueCursor_$eq(0);
        this.currentValueLength_$eq(((Node)node).payloadArity());
    }

    private final void pushNode(T node) {
        this.initNodes();
        this.currentStackLevel_$eq(this.currentStackLevel() + 1);
        int cursorIndex = this.currentStackLevel() * 2;
        int lengthIndex = this.currentStackLevel() * 2 + 1;
        this.nodes()[this.currentStackLevel()] = node;
        this.nodeCursorsAndLengths()[cursorIndex] = 0;
        this.nodeCursorsAndLengths()[lengthIndex] = ((Node)node).nodeArity();
    }

    private final void popNode() {
        this.currentStackLevel_$eq(this.currentStackLevel() - 1);
    }

    private final boolean searchNextValueNode() {
        while (this.currentStackLevel() >= 0) {
            int nodeLength;
            int cursorIndex = this.currentStackLevel() * 2;
            int lengthIndex = this.currentStackLevel() * 2 + 1;
            int nodeCursor = this.nodeCursorsAndLengths()[cursorIndex];
            if (nodeCursor < (nodeLength = this.nodeCursorsAndLengths()[lengthIndex])) {
                int[] nArray = this.nodeCursorsAndLengths();
                nArray[cursorIndex] = nArray[cursorIndex] + 1;
                Object nextNode = this.nodes()[this.currentStackLevel()].getNode(nodeCursor);
                if (((Node)nextNode).hasNodes()) {
                    this.pushNode(nextNode);
                }
                if (!((Node)nextNode).hasPayload()) continue;
                this.setupPayloadNode(nextNode);
                return true;
            }
            this.popNode();
        }
        return false;
    }

    public int characteristics() {
        return 0;
    }

    public long estimateSize() {
        if (this.hasStep()) {
            return Int$.MODULE$.int2long(this.maxSize());
        }
        return 0L;
    }

    public abstract Semi semiclone();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasStep() {
        boolean ans;
        if (this.maxSize() <= 0) return false;
        if (this.currentValueCursor() < this.currentValueLength()) return true;
        if (this.searchNextValueNode()) {
            return true;
        }
        boolean bl = ans = false;
        if (!ans) {
            this.maxSize_$eq(0);
        }
        if (!ans) return false;
        return true;
    }

    public final Sub trySplit() {
        Serializable serializable;
        int fork;
        if (!this.hasStep()) {
            return null;
        }
        for (fork = 0; fork <= this.currentStackLevel() && this.nodeCursorsAndLengths()[2 * fork] >= this.nodeCursorsAndLengths()[2 * fork + 1]; ++fork) {
        }
        if (fork > this.currentStackLevel() && this.currentValueCursor() > this.currentValueLength() - 2) {
            return null;
        }
        Semi semi = this.semiclone();
        ((ChampStepperBase)semi).maxSize_$eq(this.maxSize());
        ((ChampStepperBase)semi).currentValueCursor_$eq(this.currentValueCursor());
        ((ChampStepperBase)semi).currentValueNode_$eq(this.currentValueNode());
        if (fork > this.currentStackLevel()) {
            super.currentStackLevel_$eq(-1);
            int i = this.currentValueCursor() + this.currentValueLength() >>> 1;
            ((ChampStepperBase)semi).currentValueLength_$eq(i);
            this.currentValueCursor_$eq(i);
            serializable = BoxedUnit.UNIT;
        } else {
            int i;
            super.nodeCursorsAndLengths_$eq(Arrays.copyOf(this.nodeCursorsAndLengths(), this.nodeCursorsAndLengths().length));
            super.nodes_$eq(Arrays.copyOf(this.nodes(), this.nodes().length));
            super.currentStackLevel_$eq(this.currentStackLevel());
            ((ChampStepperBase)semi).currentValueLength_$eq(this.currentValueLength());
            super.nodeCursorsAndLengths()[2 * fork + 1] = i = this.nodeCursorsAndLengths()[2 * fork] + this.nodeCursorsAndLengths()[2 * fork + 1] >>> 1;
            for (int j = this.currentStackLevel(); j > fork; --j) {
                this.nodeCursorsAndLengths()[2 * j] = this.nodeCursorsAndLengths()[2 * j + 1];
            }
            this.nodeCursorsAndLengths()[2 * fork] = i;
            serializable = BoxesRunTime.boxToBoolean(this.searchNextValueNode());
        }
        return (Sub)semi;
    }
}

