/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.AbstractView;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.View$;
import scala.collection.View$Filter$;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public interface View<A>
extends Iterable<A>,
Serializable {
    public static /* synthetic */ Object apply(Seq seq) {
        return View$.MODULE$.apply(seq);
    }

    public static <A> View<A> apply(Seq<A> seq) {
        return View$.MODULE$.apply((Seq)seq);
    }

    public static <A> Iterator<A> dropRightIterator(Iterator<A> iterator, int n) {
        return View$.MODULE$.dropRightIterator(iterator, n);
    }

    public static Object fill(int n, Function0 function0) {
        return View$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return View$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return View$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return View$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return View$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <E> View<E> from(IterableOnce<E> iterableOnce) {
        return View$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static <A> View<A> fromIteratorProvider(Function0<Iterator<A>> function0) {
        return View$.MODULE$.fromIteratorProvider(function0);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return View$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, View<A>> newBuilder() {
        return View$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return View$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return View$.MODULE$.range(object, object2, object3, integral);
    }

    public static Object tabulate(int n, Function1 function1) {
        return View$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return View$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return View$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return View$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return View$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static <A> Iterator<A> takeRightIterator(Iterator<A> iterator, int n) {
        return View$.MODULE$.takeRightIterator(iterator, n);
    }

    public static Object unfold(Object object, Function1 function1) {
        return View$.MODULE$.unfold(object, function1);
    }

    public static void $init$(View $this) {
    }

    public static View view$(View $this) {
        return $this.view();
    }

    @Override
    default public View<A> view() {
        return this;
    }

    public static IterableFactory iterableFactory$(View $this) {
        return $this.iterableFactory();
    }

    @Override
    default public IterableFactory<View> iterableFactory() {
        return View$.MODULE$;
    }

    public static View empty$(View $this) {
        return $this.empty();
    }

    @Override
    default public View<A> empty() {
        return this.iterableFactory().empty();
    }

    public static String toString$(View $this) {
        return $this.toString();
    }

    @Override
    default public String toString() {
        return new StringBuilder(16).append(this.className()).append("(<not computed>)").toString();
    }

    public static String stringPrefix$(View $this) {
        return $this.stringPrefix();
    }

    @Override
    default public String stringPrefix() {
        return "View";
    }

    public static IndexedSeq force$(View $this) {
        return $this.force();
    }

    default public IndexedSeq<A> force() {
        return this.toIndexedSeq();
    }

    public static class Appended<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final A elem;

        public Appended(IterableOps<A, Object, ?> underlying, A elem) {
            this.underlying = underlying;
            this.elem = elem;
        }

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(this.underlying, new Single<A>(this.elem)).iterator();
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class Collect<A, B>
    extends AbstractView<B> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final PartialFunction<A, B> pf;

        public Collect(IterableOps<A, Object, ?> underlying, PartialFunction<A, B> pf) {
            this.underlying = underlying;
            this.pf = pf;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().collect(this.pf);
        }
    }

    public static class Concat<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> prefix;
        private final IterableOps<A, Object, ?> suffix;

        public Concat(IterableOps<A, Object, ?> prefix, IterableOps<A, Object, ?> suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public Iterator<A> iterator() {
            return this.prefix.iterator().$plus$plus(this::iterator$$anonfun$1);
        }

        @Override
        public int knownSize() {
            int prefixSize = this.prefix.knownSize();
            if (prefixSize >= 0) {
                int suffixSize = this.suffix.knownSize();
                if (suffixSize >= 0) {
                    return prefixSize + suffixSize;
                }
                return -1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.prefix.isEmpty() && this.suffix.isEmpty();
        }

        private final IterableOnce iterator$$anonfun$1() {
            return this.suffix.iterator();
        }
    }

    public static class DistinctBy<A, B>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, B> f;

        public DistinctBy(IterableOps<A, Object, ?> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().distinctBy(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class Drop<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int n;
        private final int normN;

        public Drop(IterableOps<A, Object, ?> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().drop(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(size - this.normN()), 0);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class DropRight<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int n;
        private final int normN;

        public DropRight(IterableOps<A, Object, ?> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public Iterator<A> iterator() {
            return View$.MODULE$.dropRightIterator(this.underlying.iterator(), this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(size - this.normN()), 0);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (this.knownSize() >= 0) {
                return this.knownSize() == 0;
            }
            return this.iterator().isEmpty();
        }
    }

    public static final class DropRightIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> underlying;
        private final int maxlen;
        private int len;
        private int pos;
        private ArrayBuffer<Object> buf;

        public DropRightIterator(Iterator<A> underlying, int maxlen) {
            this.underlying = underlying;
            this.maxlen = maxlen;
            this.len = -1;
            this.pos = 0;
        }

        private Iterator<A> underlying() {
            return this.underlying;
        }

        private void underlying_$eq(Iterator<A> x$0) {
            this.underlying = x$0;
        }

        public void init() {
            if (this.buf == null) {
                this.buf = new ArrayBuffer(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.maxlen), 256));
                while (this.pos < this.maxlen && this.underlying().hasNext()) {
                    this.buf.addOne((Object)this.underlying().next());
                    ++this.pos;
                }
                if (!this.underlying().hasNext()) {
                    this.len = 0;
                }
                this.pos = 0;
                return;
            }
        }

        @Override
        public int knownSize() {
            return this.len;
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.len != 0;
        }

        @Override
        public A next() {
            if (!this.hasNext()) {
                return Iterator$.MODULE$.empty().next();
            }
            ArrayBuffer<Object> x$proxy4 = this.buf;
            if (x$proxy4 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Object x = x$proxy4.apply(this.pos);
            if (this.len == -1) {
                ArrayBuffer<Object> x$proxy5 = this.buf;
                if (x$proxy5 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                x$proxy5.update(this.pos, this.underlying().next());
                if (!this.underlying().hasNext()) {
                    this.len = 0;
                }
            } else {
                --this.len;
            }
            ++this.pos;
            if (this.pos == this.maxlen) {
                this.pos = 0;
            }
            return (A)x;
        }
    }

    public static class DropWhile<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, Object> p;

        public DropWhile(IterableOps<A, Object, ?> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().dropWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Elems<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final Seq<A> xs;

        public Elems(Seq<A> xs) {
            this.xs = xs;
        }

        @Override
        public Iterator<A> iterator() {
            return this.xs.iterator();
        }

        @Override
        public int knownSize() {
            return this.xs.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.xs.isEmpty();
        }
    }

    public static class Fill<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final int n;
        private final Function0<A> elem;

        public Fill(int n, Function0<A> elem) {
            this.n = n;
            this.elem = elem;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.fill(this.n, (Function0)this.elem);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.n);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }
    }

    public static class Filter<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, Object> p;
        private final boolean isFlipped;

        public static <A> Filter<A> apply(Iterable<A> iterable, Function1<A, Object> function1, boolean bl) {
            return View$Filter$.MODULE$.apply(iterable, function1, bl);
        }

        public Filter(IterableOps<A, Object, ?> underlying, Function1<A, Object> p, boolean isFlipped) {
            this.underlying = underlying;
            this.p = p;
            this.isFlipped = isFlipped;
        }

        public IterableOps<A, Object, ?> underlying() {
            return this.underlying;
        }

        public Function1<A, Object> p() {
            return this.p;
        }

        public boolean isFlipped() {
            return this.isFlipped;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying().iterator().filterImpl(this.p(), this.isFlipped());
        }

        @Override
        public int knownSize() {
            if (this.underlying().knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class FlatMap<A, B>
    extends AbstractView<B> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, IterableOnce<B>> f;

        public FlatMap(IterableOps<A, Object, ?> underlying, Function1<A, IterableOnce<B>> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().flatMap(this.f);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Iterate<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final A start;
        private final int len;
        private final Function1<A, A> f;

        public Iterate(A start, int len, Function1<A, A> f) {
            this.start = start;
            this.len = len;
            this.f = f;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.iterate(this.start, this.f).take(this.len);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.len);
        }

        @Override
        public boolean isEmpty() {
            return this.len <= 0;
        }
    }

    public static class LeftPartitionMapped<A, A1, A2>
    extends AbstractView<A1> {
        private static final long serialVersionUID = 3L;
        public final IterableOps<A, Object, ?> scala$collection$View$LeftPartitionMapped$$underlying;
        public final Function1<A, Either<A1, A2>> scala$collection$View$LeftPartitionMapped$$f;

        public LeftPartitionMapped(IterableOps<A, Object, ?> underlying, Function1<A, Either<A1, A2>> f) {
            this.scala$collection$View$LeftPartitionMapped$$underlying = underlying;
            this.scala$collection$View$LeftPartitionMapped$$f = f;
        }

        @Override
        public AbstractIterator<A1> iterator() {
            return new AbstractIterator<A1>(this){
                private final Iterator self;
                private Object hd;
                private boolean hdDefined;
                private final /* synthetic */ LeftPartitionMapped $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.self = $outer.scala$collection$View$LeftPartitionMapped$$underlying.iterator();
                    this.hdDefined = false;
                }

                public boolean hasNext() {
                    return this.hdDefined || this.findNext$1();
                }

                public Object next() {
                    if (this.hasNext()) {
                        this.hdDefined = false;
                        return this.hd;
                    }
                    return Iterator$.MODULE$.empty().next();
                }

                private final boolean findNext$1() {
                    while (this.self.hasNext()) {
                        Either<A1, A2> either = this.$outer.scala$collection$View$LeftPartitionMapped$$f.apply(this.self.next());
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            A a1 = left.value();
                            this.hd = a1;
                            this.hdDefined = true;
                            return true;
                        }
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            continue;
                        }
                        throw new MatchError(either);
                    }
                    return false;
                }
            };
        }
    }

    public static class Map<A, B>
    extends AbstractView<B> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, B> f;

        public Map(IterableOps<A, Object, ?> underlying, Function1<A, B> f) {
            this.underlying = underlying;
            this.f = f;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().map(this.f);
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }

    public static class PadTo<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int len;
        private final A elem;

        public PadTo(IterableOps<A, Object, ?> underlying, int len, A elem) {
            this.underlying = underlying;
            this.len = len;
            this.elem = elem;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().padTo(this.len, this.elem);
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(size), this.len);
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty() && this.len <= 0;
        }
    }

    public static class Patched<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int from;
        private final int replaced;
        private final Iterable<A> _other;

        public Patched(IterableOps<A, Object, ?> underlying, int from, IterableOnce<A> other, int replaced) {
            Object object;
            this.underlying = underlying;
            this.from = from;
            this.replaced = replaced;
            IterableOnce<A> iterableOnce = other;
            if (iterableOnce instanceof Iterable) {
                Iterable iterable;
                Iterable other2 = iterable = (Iterable)iterableOnce;
                object = other2;
            } else {
                IterableOnce<A> other3 = iterableOnce;
                object = LazyList$.MODULE$.from((IterableOnce)other3);
            }
            this._other = object;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().patch(this.from, this._other.iterator(), this.replaced);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0 && this._other.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            if (this.knownSize() == 0) {
                return true;
            }
            return this.iterator().isEmpty();
        }
    }

    public static class Prepended<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final A elem;
        private final IterableOps<A, Object, ?> underlying;

        public Prepended(A elem, IterableOps<A, Object, ?> underlying) {
            this.elem = elem;
            this.underlying = underlying;
        }

        @Override
        public Iterator<A> iterator() {
            return new Concat<A>(new Single<A>(this.elem), this.underlying).iterator();
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class RightPartitionMapped<A, A1, A2>
    extends AbstractView<A2> {
        private static final long serialVersionUID = 3L;
        public final IterableOps<A, Object, ?> scala$collection$View$RightPartitionMapped$$underlying;
        public final Function1<A, Either<A1, A2>> scala$collection$View$RightPartitionMapped$$f;

        public RightPartitionMapped(IterableOps<A, Object, ?> underlying, Function1<A, Either<A1, A2>> f) {
            this.scala$collection$View$RightPartitionMapped$$underlying = underlying;
            this.scala$collection$View$RightPartitionMapped$$f = f;
        }

        @Override
        public AbstractIterator<A2> iterator() {
            return new AbstractIterator<A2>(this){
                private final Iterator self;
                private Object hd;
                private boolean hdDefined;
                private final /* synthetic */ RightPartitionMapped $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.self = $outer.scala$collection$View$RightPartitionMapped$$underlying.iterator();
                    this.hdDefined = false;
                }

                public boolean hasNext() {
                    return this.hdDefined || this.findNext$2();
                }

                public Object next() {
                    if (this.hasNext()) {
                        this.hdDefined = false;
                        return this.hd;
                    }
                    return Iterator$.MODULE$.empty().next();
                }

                private final boolean findNext$2() {
                    while (this.self.hasNext()) {
                        Either<A1, A2> either = this.$outer.scala$collection$View$RightPartitionMapped$$f.apply(this.self.next());
                        if (either instanceof Left) {
                            Left left = (Left)either;
                            continue;
                        }
                        if (either instanceof Right) {
                            Right right = (Right)either;
                            B a2 = right.value();
                            this.hd = a2;
                            this.hdDefined = true;
                            return true;
                        }
                        throw new MatchError(either);
                    }
                    return false;
                }
            };
        }
    }

    public static class ScanLeft<A, B>
    extends AbstractView<B> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final B z;
        private final Function2<B, A, B> op;

        public ScanLeft(IterableOps<A, Object, ?> underlying, B z, Function2<B, A, B> op) {
            this.underlying = underlying;
            this.z = z;
            this.op = op;
        }

        @Override
        public Iterator<B> iterator() {
            return this.underlying.iterator().scanLeft(this.z, this.op);
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return size + 1;
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Single<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final A a;

        public Single(A a) {
            this.a = a;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.single(this.a);
        }

        @Override
        public int knownSize() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public static class Tabulate<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final int n;
        private final Function1<Object, A> f;

        public Tabulate(int n, Function1<Object, A> f) {
            this.n = n;
            this.f = f;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.tabulate(this.n, (Function1)this.f);
        }

        @Override
        public int knownSize() {
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(0), this.n);
        }

        @Override
        public boolean isEmpty() {
            return this.n <= 0;
        }
    }

    public static class Take<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int n;
        private final int normN;

        public Take(IterableOps<A, Object, ?> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().take(this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(size), this.normN());
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class TakeRight<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final int n;
        private final int normN;

        public TakeRight(IterableOps<A, Object, ?> underlying, int n) {
            this.underlying = underlying;
            this.n = n;
            this.normN = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(n), 0);
        }

        @Override
        public Iterator<A> iterator() {
            return View$.MODULE$.takeRightIterator(this.underlying.iterator(), this.n);
        }

        public int normN() {
            return this.normN;
        }

        @Override
        public int knownSize() {
            int size = this.underlying.knownSize();
            if (size >= 0) {
                return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(size), this.normN());
            }
            return -1;
        }

        @Override
        public boolean isEmpty() {
            if (this.knownSize() >= 0) {
                return this.knownSize() == 0;
            }
            return this.iterator().isEmpty();
        }
    }

    public static final class TakeRightIterator<A>
    extends AbstractIterator<A> {
        private Iterator<A> underlying;
        private final int maxlen;
        private int len;
        private int pos;
        private ArrayBuffer<Object> buf;

        public TakeRightIterator(Iterator<A> underlying, int maxlen) {
            this.underlying = underlying;
            this.maxlen = maxlen;
            this.len = -1;
            this.pos = 0;
        }

        private Iterator<A> underlying() {
            return this.underlying;
        }

        private void underlying_$eq(Iterator<A> x$0) {
            this.underlying = x$0;
        }

        public void init() {
            if (this.buf == null) {
                this.buf = new ArrayBuffer(RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.maxlen), 256));
                this.len = 0;
                while (this.underlying().hasNext()) {
                    Object object;
                    A n = this.underlying().next();
                    if (this.pos >= this.buf.length()) {
                        object = this.buf.addOne((Object)n);
                    } else {
                        this.buf.update(this.pos, n);
                        object = BoxedUnit.UNIT;
                    }
                    ++this.pos;
                    if (this.pos == this.maxlen) {
                        this.pos = 0;
                    }
                    ++this.len;
                }
                this.underlying_$eq(null);
                if (this.len > this.maxlen) {
                    this.len = this.maxlen;
                }
                this.pos -= this.len;
                if (this.pos < 0) {
                    this.pos += this.maxlen;
                    return;
                }
                return;
            }
        }

        @Override
        public int knownSize() {
            return this.len;
        }

        @Override
        public boolean hasNext() {
            this.init();
            return this.len > 0;
        }

        @Override
        public A next() {
            this.init();
            if (this.len == 0) {
                return Iterator$.MODULE$.empty().next();
            }
            ArrayBuffer<Object> x$proxy2 = this.buf;
            if (x$proxy2 == null) {
                throw Scala3RunTime$.MODULE$.nnFail();
            }
            Object x = x$proxy2.apply(this.pos);
            ++this.pos;
            if (this.pos == this.maxlen) {
                this.pos = 0;
            }
            --this.len;
            return (A)x;
        }

        @Override
        public Iterator<A> drop(int n) {
            this.init();
            if (n > 0) {
                this.len = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.len - n), 0);
                this.pos = (this.pos + n) % this.maxlen;
            }
            return this;
        }
    }

    public static class TakeWhile<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Function1<A, Object> p;

        public TakeWhile(IterableOps<A, Object, ?> underlying, Function1<A, Object> p) {
            this.underlying = underlying;
            this.p = p;
        }

        @Override
        public Iterator<A> iterator() {
            return this.underlying.iterator().takeWhile(this.p);
        }

        @Override
        public int knownSize() {
            if (this.underlying.knownSize() == 0) {
                return 0;
            }
            return IterableOnce.knownSize$(this);
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Unfold<A, S>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        private final S initial;
        private final Function1<S, Option<Tuple2<A, S>>> f;

        public Unfold(S initial, Function1<S, Option<Tuple2<A, S>>> f) {
            this.initial = initial;
            this.f = f;
        }

        @Override
        public Iterator<A> iterator() {
            return Iterator$.MODULE$.unfold((Object)this.initial, (Function1)this.f);
        }
    }

    public static class Updated<A>
    extends AbstractView<A> {
        private static final long serialVersionUID = 3L;
        public final IterableOps<A, Object, ?> scala$collection$View$Updated$$underlying;
        public final int scala$collection$View$Updated$$index;
        public final A scala$collection$View$Updated$$elem;

        public Updated(IterableOps<A, Object, ?> underlying, int index, A elem) {
            this.scala$collection$View$Updated$$underlying = underlying;
            this.scala$collection$View$Updated$$index = index;
            this.scala$collection$View$Updated$$elem = elem;
        }

        @Override
        public Iterator<A> iterator() {
            return new AbstractIterator<A>(this){
                private final Iterator it;
                private int i;
                private final /* synthetic */ Updated $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.it = $outer.scala$collection$View$Updated$$underlying.iterator();
                    this.i = 0;
                }

                public Object next() {
                    A a;
                    if (this.i == this.$outer.scala$collection$View$Updated$$index) {
                        this.it.next();
                        a = this.$outer.scala$collection$View$Updated$$elem;
                    } else {
                        a = this.it.next();
                    }
                    A value = a;
                    ++this.i;
                    return value;
                }

                public boolean hasNext() {
                    if (this.it.hasNext()) {
                        return true;
                    }
                    if (this.$outer.scala$collection$View$Updated$$index >= this.i) {
                        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(this.$outer.scala$collection$View$Updated$$index).toString());
                    }
                    return false;
                }
            };
        }

        @Override
        public int knownSize() {
            return this.scala$collection$View$Updated$$underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.iterator().isEmpty();
        }
    }

    public static class Zip<A, B>
    extends AbstractView<Tuple2<A, B>> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Iterable<B> other;

        public Zip(IterableOps<A, Object, ?> underlying, Iterable<B> other) {
            this.underlying = underlying;
            this.other = other;
        }

        @Override
        public Iterator<Tuple2<A, B>> iterator() {
            return this.underlying.iterator().zip(this.other);
        }

        @Override
        public int knownSize() {
            int s1 = this.underlying.knownSize();
            if (s1 == 0) {
                return 0;
            }
            int s2 = this.other.knownSize();
            if (s2 == 0) {
                return 0;
            }
            return RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(s1), s2);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty() || this.other.isEmpty();
        }
    }

    public static class ZipAll<A, B>
    extends AbstractView<Tuple2<A, B>> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;
        private final Iterable<B> other;
        private final A thisElem;
        private final B thatElem;

        public ZipAll(IterableOps<A, Object, ?> underlying, Iterable<B> other, A thisElem, B thatElem) {
            this.underlying = underlying;
            this.other = other;
            this.thisElem = thisElem;
            this.thatElem = thatElem;
        }

        @Override
        public Iterator<Tuple2<A, B>> iterator() {
            return this.underlying.iterator().zipAll(this.other, this.thisElem, this.thatElem);
        }

        @Override
        public int knownSize() {
            int s1 = this.underlying.knownSize();
            if (s1 == -1) {
                return -1;
            }
            int s2 = this.other.knownSize();
            if (s2 == -1) {
                return -1;
            }
            return RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(s1), s2);
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty() && this.other.isEmpty();
        }
    }

    public static class ZipWithIndex<A>
    extends AbstractView<Tuple2<A, Object>> {
        private static final long serialVersionUID = 3L;
        private final IterableOps<A, Object, ?> underlying;

        public ZipWithIndex(IterableOps<A, Object, ?> underlying) {
            this.underlying = underlying;
        }

        @Override
        public Iterator<Tuple2<A, Object>> iterator() {
            return this.underlying.iterator().zipWithIndex();
        }

        @Override
        public int knownSize() {
            return this.underlying.knownSize();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying.isEmpty();
        }
    }
}

