/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterator;
import scala.collection.AnyStepper$;
import scala.collection.BitSet;
import scala.collection.BitSetOps$;
import scala.collection.IntStepper;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Set;
import scala.collection.SortedSet;
import scala.collection.SortedSetOps;
import scala.collection.SpecificIterableFactory;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.View;
import scala.collection.convert.impl.BitSetStepper$;
import scala.math.Ordering;
import scala.math.Ordering$Int$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Scala3RunTime$;

public interface BitSetOps<C extends BitSet & BitSetOps<C>>
extends SortedSetOps<Object, SortedSet, C> {
    public static int LogWL() {
        return BitSetOps$.MODULE$.LogWL();
    }

    public static int MaxSize() {
        return BitSetOps$.MODULE$.MaxSize();
    }

    public static int WordLength() {
        return BitSetOps$.MODULE$.WordLength();
    }

    public static long computeWordForFilter(Function1<Object, Object> function1, boolean bl, long l, int n) {
        return BitSetOps$.MODULE$.computeWordForFilter(function1, bl, l, n);
    }

    public static long[] updateArray(long[] lArray, int n, long l) {
        return BitSetOps$.MODULE$.updateArray(lArray, n, l);
    }

    public static void $init$(BitSetOps $this) {
    }

    public /* synthetic */ int scala$collection$BitSetOps$$super$max(Ordering var1);

    public /* synthetic */ int scala$collection$BitSetOps$$super$min(Ordering var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$concat(IterableOnce var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$intersect(Set var1);

    public /* synthetic */ BitSet scala$collection$BitSetOps$$super$diff(Set var1);

    public SpecificIterableFactory<Object, C> bitSetFactory();

    @Override
    public Set<Object> unsorted();

    public static Ordering ordering$(BitSetOps $this) {
        return $this.ordering();
    }

    @Override
    default public Ordering<Object> ordering() {
        package$.MODULE$.Ordering();
        return Ordering$Int$.MODULE$;
    }

    public int nwords();

    public long word(int var1);

    public C fromBitMaskNoCopy(long[] var1);

    public static boolean contains$(BitSetOps $this, int elem) {
        return $this.contains(elem);
    }

    @Override
    default public boolean contains(int elem) {
        return 0 <= elem && (this.word(elem >> 6) & 1L << elem) != 0L;
    }

    public static Iterator iterator$(BitSetOps $this) {
        return $this.iterator();
    }

    @Override
    default public Iterator<Object> iterator() {
        return this.iteratorFrom(0);
    }

    public static Iterator iteratorFrom$(BitSetOps $this, int start) {
        return $this.iteratorFrom(start);
    }

    @Override
    default public Iterator<Object> iteratorFrom(int start) {
        return new AbstractIterator<Object>(start, this){
            private int currentPos;
            private long currentWord;
            private final /* synthetic */ BitSetOps $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.currentPos = start$1 > 0 ? start$1 >> 6 : 0;
                this.currentWord = start$1 > 0 ? $outer.word(this.currentPos) & -1L << (start$1 & 0x3F) : $outer.word(0);
            }

            public final boolean hasNext() {
                while (this.currentWord == 0L) {
                    if (this.currentPos + 1 >= this.$outer.nwords()) {
                        return false;
                    }
                    ++this.currentPos;
                    this.currentWord = this.$outer.word(this.currentPos);
                }
                return true;
            }

            public final int next() {
                if (this.hasNext()) {
                    int bitPos = Long.numberOfTrailingZeros(this.currentWord);
                    this.currentWord &= this.currentWord - 1L;
                    return (this.currentPos << 6) + bitPos;
                }
                return BoxesRunTime.unboxToInt(Iterator$.MODULE$.empty().next());
            }
        };
    }

    public static Stepper stepper$(BitSetOps $this, StepperShape shape) {
        return $this.stepper(shape);
    }

    @Override
    default public <S extends Stepper<?>> S stepper(StepperShape<Object, S> shape) {
        Stepper<Object> stepper;
        IntStepper st = BitSetStepper$.MODULE$.from(this);
        if (shape.shape() == StepperShape$.MODULE$.IntShape()) {
            stepper = st;
        } else {
            if (shape.shape() != StepperShape$.MODULE$.ReferenceShape()) {
                throw Scala3RunTime$.MODULE$.assertFailed(new StringBuilder(25).append("unexpected StepperShape: ").append(shape).toString());
            }
            stepper = AnyStepper$.MODULE$.ofParIntStepper(st);
        }
        IntStepper r = stepper;
        return (S)r;
    }

    public static int size$(BitSetOps $this) {
        return $this.size();
    }

    @Override
    default public int size() {
        int s = 0;
        int i = this.nwords();
        while (i > 0) {
            s += Long.bitCount(this.word(--i));
        }
        return s;
    }

    public static boolean isEmpty$(BitSetOps $this) {
        return $this.isEmpty();
    }

    @Override
    default public boolean isEmpty() {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.nwords()).forall((Function1<Object, Boolean> & Serializable)i -> this.isEmpty$$anonfun$1(BoxesRunTime.unboxToInt(i)));
    }

    private int smallestInt() {
        int thisnwords = this.nwords();
        for (int i = 0; i < thisnwords; ++i) {
            long currentWord = this.word(i);
            if (currentWord == 0L) continue;
            return Long.numberOfTrailingZeros(currentWord) + i * 64;
        }
        throw new UnsupportedOperationException("empty.smallestInt");
    }

    private int largestInt() {
        for (int i = this.nwords() - 1; i >= 0; --i) {
            long currentWord = this.word(i);
            if (currentWord == 0L) continue;
            return (i + 1) * 64 - Long.numberOfLeadingZeros(currentWord) - 1;
        }
        throw new UnsupportedOperationException("empty.largestInt");
    }

    public static int max$(BitSetOps $this, Ordering ord) {
        return $this.max(ord);
    }

    @Override
    default public <B> int max(Ordering<B> ord) {
        package$.MODULE$.Ordering();
        if (Ordering$Int$.MODULE$ == ord) {
            return this.largestInt();
        }
        package$.MODULE$.Ordering();
        if (Ordering$Int$.MODULE$.isReverseOf(ord)) {
            return this.smallestInt();
        }
        return this.scala$collection$BitSetOps$$super$max(ord);
    }

    public static int min$(BitSetOps $this, Ordering ord) {
        return $this.min(ord);
    }

    @Override
    default public <B> int min(Ordering<B> ord) {
        package$.MODULE$.Ordering();
        if (Ordering$Int$.MODULE$ == ord) {
            return this.smallestInt();
        }
        package$.MODULE$.Ordering();
        if (Ordering$Int$.MODULE$.isReverseOf(ord)) {
            return this.largestInt();
        }
        return this.scala$collection$BitSetOps$$super$min(ord);
    }

    public static void foreach$(BitSetOps $this, Function1 f) {
        $this.foreach(f);
    }

    @Override
    default public <U> void foreach(Function1<Object, U> f) {
        for (int i = 0; i < this.nwords(); ++i) {
            long w = this.word(i);
            int j = i * 64;
            while (w != 0L) {
                if ((w & 1L) == 1L) {
                    f.apply(BoxesRunTime.boxToInteger(j));
                }
                w >>>= 1;
                ++j;
            }
        }
    }

    public static long[] toBitMask$(BitSetOps $this) {
        return $this.toBitMask();
    }

    default public long[] toBitMask() {
        long[] a = new long[this.nwords()];
        int i = a.length;
        while (i > 0) {
            a[--i] = this.word(i);
        }
        return a;
    }

    public static BitSet rangeImpl$(BitSetOps $this, Option from, Option until) {
        return $this.rangeImpl(from, until);
    }

    @Override
    default public C rangeImpl(Option<Object> from, Option<Object> until) {
        long[] a = ((BitSetOps)this.coll()).toBitMask();
        int len = a.length;
        if (from.isDefined()) {
            int f = BoxesRunTime.unboxToInt(from.get());
            int w = f >> 6;
            int b = f & 0x3F;
            if (w >= 0) {
                Arrays.fill(a, 0, scala.math.package$.MODULE$.min(w, len), 0L);
                if (b > 0 && w < len) {
                    a[w] = a[w] & ((1L << b) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
        }
        if (until.isDefined()) {
            int u = BoxesRunTime.unboxToInt(until.get());
            int w = u >> 6;
            int b = u & 0x3F;
            if (w < len) {
                Arrays.fill(a, scala.math.package$.MODULE$.max(w + 1, 0), len, 0L);
                if (w >= 0) {
                    a[w] = a[w] & (1L << b) - 1L;
                }
            }
        }
        return ((BitSetOps)this.coll()).fromBitMaskNoCopy(a);
    }

    public static BitSet concat$(BitSetOps $this, IterableOnce other) {
        return $this.concat(other);
    }

    @Override
    default public C concat(IterableOnce<Object> other) {
        IterableOnce<Object> iterableOnce = other;
        if (iterableOnce instanceof BitSet) {
            BitSet bitSet;
            BitSet otherBitset = bitSet = (BitSet)iterableOnce;
            int len = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(((BitSetOps)this.coll()).nwords()), otherBitset.nwords());
            long[] words = new long[len];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
                this.concat$$anonfun$1(words, otherBitset, BoxesRunTime.unboxToInt(v1));
                return BoxedUnit.UNIT;
            });
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$concat(other);
    }

    public static BitSet intersect$(BitSetOps $this, Set other) {
        return $this.intersect(other);
    }

    @Override
    default public C intersect(Set<Object> other) {
        Set<Object> set = other;
        if (set instanceof BitSet) {
            BitSet bitSet;
            BitSet otherBitset = bitSet = (BitSet)set;
            int len = RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(((BitSetOps)this.coll()).nwords()), otherBitset.nwords());
            long[] words = new long[len];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
                this.intersect$$anonfun$1(words, otherBitset, BoxesRunTime.unboxToInt(v1));
                return BoxedUnit.UNIT;
            });
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$intersect(other);
    }

    public static BitSet diff$(BitSetOps $this, Set other) {
        return $this.diff(other);
    }

    @Override
    default public C diff(Set<Object> other) {
        Set<Object> set = other;
        if (set instanceof BitSet) {
            BitSet bitSet;
            BitSet otherBitset = bitSet = (BitSet)set;
            int len = ((BitSetOps)this.coll()).nwords();
            long[] words = new long[len];
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
                this.diff$$anonfun$1(words, otherBitset, BoxesRunTime.unboxToInt(v1));
                return BoxedUnit.UNIT;
            });
            return this.fromBitMaskNoCopy(words);
        }
        return (C)this.scala$collection$BitSetOps$$super$diff(other);
    }

    public static BitSet xor$(BitSetOps $this, BitSet other) {
        return $this.xor(other);
    }

    default public C xor(BitSet other) {
        int len = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(((BitSetOps)this.coll()).nwords()), other.nwords());
        long[] words = new long[len];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
            this.xor$$anonfun$1(words, other, BoxesRunTime.unboxToInt(v1));
            return BoxedUnit.UNIT;
        });
        return ((BitSetOps)this.coll()).fromBitMaskNoCopy(words);
    }

    public static BitSet $up$(BitSetOps $this, BitSet other) {
        return $this.$up(other);
    }

    default public C $up(BitSet other) {
        return this.xor(other);
    }

    public static BitSet map$(BitSetOps $this, Function1 f) {
        return $this.map(f);
    }

    @Override
    default public C map(Function1<Object, Object> f) {
        return (C)((BitSet)this.fromSpecific(new View.Map<Object, Object>(this, f)));
    }

    public static BitSet flatMap$(BitSetOps $this, Function1 f) {
        return $this.flatMap(f);
    }

    @Override
    default public C flatMap(Function1<Object, IterableOnce<Object>> f) {
        return (C)((BitSet)this.fromSpecific(new View.FlatMap<Object, Object>(this, f)));
    }

    public static BitSet collect$(BitSetOps $this, PartialFunction pf) {
        return $this.collect(pf);
    }

    @Override
    default public C collect(PartialFunction<Object, Object> pf) {
        return (C)((BitSet)this.fromSpecific(SortedSetOps.collect$(this, pf, Ordering$Int$.MODULE$)));
    }

    public static Tuple2 partition$(BitSetOps $this, Function1 p) {
        return $this.partition(p);
    }

    @Override
    default public Tuple2<C, C> partition(Function1<Object, Object> p) {
        BitSet left = (BitSet)this.filter(p);
        return Tuple2$.MODULE$.apply(left, this.$amp$tilde(left));
    }

    private /* synthetic */ boolean isEmpty$$anonfun$1(int i) {
        return this.word(i) == 0L;
    }

    private /* synthetic */ void concat$$anonfun$1(long[] words$1, BitSet otherBitset$1, int idx) {
        words$1[idx] = this.word(idx) | otherBitset$1.word(idx);
    }

    private /* synthetic */ void intersect$$anonfun$1(long[] words$2, BitSet otherBitset$2, int idx) {
        words$2[idx] = this.word(idx) & otherBitset$2.word(idx);
    }

    private /* synthetic */ void diff$$anonfun$1(long[] words$3, BitSet otherBitset$3, int idx) {
        words$3[idx] = this.word(idx) & (otherBitset$3.word(idx) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    private /* synthetic */ void xor$$anonfun$1(long[] words$4, BitSet other$1, int idx) {
        words$4[idx] = ((BitSetOps)this.coll()).word(idx) ^ other$1.word(idx);
    }
}

