/*
 * Decompiled with CFR 0.152.
 */
package scala.util.hashing;

import scala.Product;
import scala.collection.IndexedSeq;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.hashing.Hashing;
import scala.util.hashing.MurmurHash3$;

public class MurmurHash3 {
    public static <T> ArrayHashing<T> arrayHashing() {
        return MurmurHash3$.MODULE$.arrayHashing();
    }

    public static int arraySeed() {
        return MurmurHash3$.MODULE$.arraySeed();
    }

    public static <T> int arraySeqHash(Object object) {
        return MurmurHash3$.MODULE$.arraySeqHash(object);
    }

    public static Hashing<byte[]> bytesHashing() {
        return MurmurHash3$.MODULE$.bytesHashing();
    }

    public static Hashing<Product> caseClassHashing() {
        return MurmurHash3$.MODULE$.caseClassHashing();
    }

    public static int emptyMapHash() {
        return MurmurHash3$.MODULE$.emptyMapHash();
    }

    public static int mapHash(Map<?, ?> map) {
        return MurmurHash3$.MODULE$.mapHash(map);
    }

    public static int mapSeed() {
        return MurmurHash3$.MODULE$.mapSeed();
    }

    public static Hashing<IterableOnce<Object>> orderedHashing() {
        return MurmurHash3$.MODULE$.orderedHashing();
    }

    public static Hashing<Product> productHashing() {
        return MurmurHash3$.MODULE$.productHashing();
    }

    public static int productSeed() {
        return MurmurHash3$.MODULE$.productSeed();
    }

    public static int seqHash(Seq<?> seq) {
        return MurmurHash3$.MODULE$.seqHash(seq);
    }

    public static int seqSeed() {
        return MurmurHash3$.MODULE$.seqSeed();
    }

    public static int setHash(Set<?> set) {
        return MurmurHash3$.MODULE$.setHash(set);
    }

    public static int setSeed() {
        return MurmurHash3$.MODULE$.setSeed();
    }

    public static Hashing<String> stringHashing() {
        return MurmurHash3$.MODULE$.stringHashing();
    }

    public static int stringSeed() {
        return MurmurHash3$.MODULE$.stringSeed();
    }

    public static int symmetricSeed() {
        return MurmurHash3$.MODULE$.symmetricSeed();
    }

    public static int traversableSeed() {
        return MurmurHash3$.MODULE$.traversableSeed();
    }

    public static Hashing<IterableOnce<Object>> unorderedHashing() {
        return MurmurHash3$.MODULE$.unorderedHashing();
    }

    public static String caseClassHash$default$2() {
        return MurmurHash3$.MODULE$.caseClassHash$default$2();
    }

    public final int mix(int hash, int data) {
        int h = this.mixLast(hash, data);
        h = Integer.rotateLeft(h, 13);
        return h * 5 + -430675100;
    }

    public final int mixLast(int hash, int data) {
        int k = data;
        k *= -862048943;
        k = Integer.rotateLeft(k, 15);
        return hash ^ (k *= 461845907);
    }

    public final int finalizeHash(int hash, int length) {
        return this.avalanche(hash ^ length);
    }

    private final int avalanche(int hash) {
        int h = hash;
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    public int tuple2Hash(int x, int y, int seed) {
        int h = seed;
        h = this.mix(h, "Tuple2".hashCode());
        h = this.mix(h, x);
        h = this.mix(h, y);
        return this.finalizeHash(h, 2);
    }

    public final int productHash(Product x, int seed, boolean ignorePrefix) {
        int arr = x.productArity();
        if (arr == 0) {
            if (!ignorePrefix) {
                return x.productPrefix().hashCode();
            }
            return seed;
        }
        int h = seed;
        if (!ignorePrefix) {
            h = this.mix(h, x.productPrefix().hashCode());
        }
        for (int i = 0; i < arr; ++i) {
            h = this.mix(h, Statics.anyHash(x.productElement(i)));
        }
        return this.finalizeHash(h, arr);
    }

    public boolean productHash$default$3() {
        return false;
    }

    public final int caseClassHash(Product x, int seed, String caseClassName) {
        int arr = x.productArity();
        int aye = (caseClassName != null ? caseClassName : x.productPrefix()).hashCode();
        if (arr == 0) {
            return aye;
        }
        int h = seed;
        h = this.mix(h, aye);
        for (int i = 0; i < arr; ++i) {
            h = this.mix(h, Statics.anyHash(x.productElement(i)));
        }
        return this.finalizeHash(h, arr);
    }

    public final int stringHash(String str, int seed) {
        int h = seed;
        int i = 0;
        while (i + 1 < str.length()) {
            int data = (str.charAt(i) << 16) + str.charAt(i + 1);
            h = this.mix(h, data);
            i += 2;
        }
        if (i < str.length()) {
            h = this.mixLast(h, str.charAt(i));
        }
        return this.finalizeHash(h, str.length());
    }

    public final int unorderedHash(IterableOnce<Object> xs, int seed) {
        int a = 0;
        int b = 0;
        int n = 0;
        int c = 1;
        Iterator<Object> iterator = xs.iterator();
        while (iterator.hasNext()) {
            Object x = iterator.next();
            int h = Statics.anyHash(x);
            a += h;
            b ^= h;
            c *= h | 1;
            ++n;
        }
        int h = seed;
        h = this.mix(h, a);
        h = this.mix(h, b);
        h = this.mixLast(h, c);
        return this.finalizeHash(h, n);
    }

    public final int orderedHash(IterableOnce<Object> xs, int seed) {
        Iterator<Object> it = xs.iterator();
        int h = seed;
        if (!it.hasNext()) {
            return this.finalizeHash(h, 0);
        }
        Object x0 = it.next();
        if (!it.hasNext()) {
            return this.finalizeHash(this.mix(h, Statics.anyHash(x0)), 1);
        }
        Object x1 = it.next();
        int initial = Statics.anyHash(x0);
        int h0 = h = this.mix(h, initial);
        int prev = Statics.anyHash(x1);
        int rangeDiff = prev - initial;
        int i = 2;
        while (it.hasNext()) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(it.next());
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (it.hasNext()) {
                    h = this.mix(h, Statics.anyHash(it.next()));
                    ++i;
                }
                return this.finalizeHash(h, i);
            }
            prev = hash;
            ++i;
        }
        return this.avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final <T> int arrayHash(Object a, int seed) {
        int h = seed;
        int l = ScalaRunTime$.MODULE$.array_length(a);
        int n = l;
        if (0 == n) {
            return this.finalizeHash(h, 0);
        }
        if (1 == n) {
            return this.finalizeHash(this.mix(h, Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 0))), 1);
        }
        int initial = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 0));
        int h0 = h = this.mix(h, initial);
        int prev = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, 1));
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, i));
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.anyHash(ScalaRunTime$.MODULE$.array_apply(a, i)));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int rangeHash(int start, int step, int last, int seed) {
        return this.avalanche(this.mix(this.mix(this.mix(seed, start), step), last));
    }

    public final int bytesHash(byte[] data, int seed) {
        int len;
        int h = seed;
        int i = 0;
        for (len = data.length; len >= 4; len -= 4) {
            int k = data[i + 0] & 0xFF;
            k |= (data[i + 1] & 0xFF) << 8;
            k |= (data[i + 2] & 0xFF) << 16;
            h = this.mix(h, k |= (data[i + 3] & 0xFF) << 24);
            i += 4;
        }
        int k = 0;
        if (len == 3) {
            k ^= (data[i + 2] & 0xFF) << 16;
        }
        if (len >= 2) {
            k ^= (data[i + 1] & 0xFF) << 8;
        }
        if (len >= 1) {
            h = this.mixLast(h, k ^= data[i + 0] & 0xFF);
        }
        return this.finalizeHash(h, data.length);
    }

    public final int indexedSeqHash(IndexedSeq<Object> a, int seed) {
        int h = seed;
        int l = a.length();
        int n = l;
        if (0 == n) {
            return this.finalizeHash(h, 0);
        }
        if (1 == n) {
            return this.finalizeHash(this.mix(h, Statics.anyHash(a.apply(false))), 1);
        }
        int initial = Statics.anyHash(a.apply(false));
        int h0 = h = this.mix(h, initial);
        int prev = Statics.anyHash(a.apply(true));
        int rangeDiff = prev - initial;
        for (int i = 2; i < l; ++i) {
            h = this.mix(h, prev);
            int hash = Statics.anyHash(a.apply(i));
            if (rangeDiff != hash - prev || rangeDiff == 0) {
                h = this.mix(h, hash);
                ++i;
                while (i < l) {
                    h = this.mix(h, Statics.anyHash(a.apply(i)));
                    ++i;
                }
                return this.finalizeHash(h, l);
            }
            prev = hash;
        }
        return this.avalanche(this.mix(this.mix(h0, rangeDiff), prev));
    }

    public final int listHash(List<?> xs, int seed) {
        int n = 0;
        int h = seed;
        int rangeState = 0;
        int rangeDiff = 0;
        int prev = 0;
        int initial = 0;
        List elems = xs;
        while (!elems.isEmpty()) {
            Object head = elems.head();
            List tail = (List)elems.tail();
            int hash = Statics.anyHash(head);
            h = this.mix(h, hash);
            int n2 = rangeState;
            switch (n2) {
                case 0: {
                    initial = hash;
                    rangeState = 1;
                    break;
                }
                case 1: {
                    rangeDiff = hash - prev;
                    rangeState = 2;
                    break;
                }
                case 2: {
                    if (rangeDiff == hash - prev && rangeDiff != 0) break;
                    rangeState = 3;
                    break;
                }
            }
            prev = hash;
            ++n;
            elems = tail;
        }
        if (rangeState == 2) {
            return this.rangeHash(initial, rangeDiff, prev, seed);
        }
        return this.finalizeHash(h, n);
    }

    public static class ArrayHashing<T>
    implements Hashing<Object> {
        @Override
        public int hash(Object a) {
            return MurmurHash3$.MODULE$.arrayHash(a);
        }
    }
}

