/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t}s!B\u0001\u0003\u0011\u000bI\u0011A\u0004$j]&$X\rR;sCRLwN\u001c\u0006\u0003\u0007\u0011\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0003\u000b\u0019\t!bY8oGV\u0014(/\u001a8u\u0015\u00059\u0011!B:dC2\f7\u0001\u0001\t\u0003\u0015-i\u0011A\u0001\u0004\u0006\u0019\tA)!\u0004\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o'\u0011YaB\u0006\u000e\u0011\u0005=!R\"\u0001\t\u000b\u0005E\u0011\u0012\u0001\u00027b]\u001eT\u0011aE\u0001\u0005U\u00064\u0018-\u0003\u0002\u0016!\t1qJ\u00196fGR\u0004\"a\u0006\r\u000e\u0003\u0019I!!\u0007\u0004\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\t\u0003/mI!\u0001\b\u0004\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000byYA\u0011A\u0010\u0002\rqJg.\u001b;?)\u0005Iq!B\u0011\f\u0011\u000f\u0011\u0013a\u0006$j]&$X\rR;sCRLwN\\%t\u001fJ$WM]3e!\t\u0019C%D\u0001\f\r\u0015)3\u0002#\u0002'\u0005]1\u0015N\\5uK\u0012+(/\u0019;j_:L5o\u0014:eKJ,Gm\u0005\u0003%\u001d\u001d2\u0002c\u0001\u00151g9\u0011\u0011F\f\b\u0003U5j\u0011a\u000b\u0006\u0003Y!\ta\u0001\u0010:p_Rt\u0014\"A\u0004\n\u0005=2\u0011a\u00029bG.\fw-Z\u0005\u0003cI\u0012\u0001b\u0014:eKJLgn\u001a\u0006\u0003_\u0019\u0001\"A\u0003\u001b\u0007\t1\u0011!!N\n\u0004iY2\u0002C\u0001\u00068\u0013\tA$A\u0001\u0005EkJ\fG/[8o\u0011!QDG!b\u0001\n\u0003Y\u0014A\u00027f]\u001e$\b.F\u0001=!\t9R(\u0003\u0002?\r\t!Aj\u001c8h\u0011!\u0001EG!A!\u0002\u0013a\u0014a\u00027f]\u001e$\b\u000e\t\u0005\t\u0005R\u0012)\u0019!C\u0001\u0007\u0006!QO\\5u+\u0005!\u0005CA#H\u001d\tQa)\u0003\u00020\u0005%\u0011\u0001*\u0013\u0002\t)&lW-\u00168ji*\u0011qF\u0001\u0005\t\u0017R\u0012\t\u0011)A\u0005\t\u0006)QO\\5uA!)a\u0004\u000eC\u0001\u001bR\u00191GT(\t\u000bib\u0005\u0019\u0001\u001f\t\u000b\tc\u0005\u0019\u0001#\t\rE#\u0004\u0015\"\u0003S\u0003\u001d\u0011w.\u001e8eK\u0012$\"a\u0015,\u0011\u0005]!\u0016BA+\u0007\u0005\u001d\u0011un\u001c7fC:DQa\u0016)A\u0002q\n1!\\1y\u0011\u0015IF\u0007\"\u0001<\u0003\u001d!xNT1o_NDQa\u0017\u001b\u0005\u0002m\n\u0001\u0002^8NS\u000e\u0014xn\u001d\u0005\u0006;R\"\taO\u0001\ti>l\u0015\u000e\u001c7jg\")q\f\u000eC\u0001w\u0005IAo\\*fG>tGm\u001d\u0005\u0006CR\"\taO\u0001\ni>l\u0015N\\;uKNDQa\u0019\u001b\u0005\u0002m\nq\u0001^8I_V\u00148\u000fC\u0003fi\u0011\u00051(\u0001\u0004u_\u0012\u000b\u0017p\u001d\u0005\u0006OR\"\t\u0001[\u0001\u0007i>,f.\u001b;\u0015\u0005%d\u0007CA\fk\u0013\tYgA\u0001\u0004E_V\u0014G.\u001a\u0005\u0006[\u001a\u0004\r\u0001R\u0001\u0002k\")q\u000e\u000eC\u0001a\u00069aM]8n\u001d><X#A9\u0011\u0005)\u0011\u0018BA:\u0003\u0005!!U-\u00193mS:,\u0007BB;5A\u0013%a/\u0001\u0006v]&$8\u000b\u001e:j]\u001e,\u0012a\u001e\t\u0003\u001faL!!\u001f\t\u0003\rM#(/\u001b8h\u0011\u0015YH\u0007\"\u0011}\u0003!!xn\u0015;sS:<G#A<\t\u000by$D\u0011A@\u0002\u000f\r|W\u000e]1sKR!\u0011\u0011AA\u0004!\r9\u00121A\u0005\u0004\u0003\u000b1!aA%oi\"1\u0011\u0011B?A\u0002Y\nQa\u001c;iKJD\u0001\"!\u00045A\u0013%\u0011qB\u0001\bg\u00064W-\u00113e)\u0015a\u0014\u0011CA\u000b\u0011\u001d\t\u0019\"a\u0003A\u0002q\n\u0011!\u0019\u0005\b\u0003/\tY\u00011\u0001=\u0003\u0005\u0011\u0007\u0002CA\u000ei\u0001&I!!\b\u0002\u0007\u0005$G\rF\u00034\u0003?\t\u0019\u0003C\u0004\u0002\"\u0005e\u0001\u0019\u0001\u001f\u0002\u0017=$\b.\u001a:MK:<G\u000f\u001b\u0005\b\u0003K\tI\u00021\u0001E\u0003%yG\u000f[3s+:LG\u000fC\u0004\u0002*Q\"\t!a\u000b\u0002\u000b\u0011\u0002H.^:\u0015\u0007Y\ni\u0003C\u0004\u0002\n\u0005\u001d\u0002\u0019\u0001\u001c\t\u000f\u0005EB\u0007\"\u0001\u00024\u00051A%\\5okN$2ANA\u001b\u0011\u001d\tI!a\fA\u0002YBq!!\u000f5\t\u0003\tY$\u0001\u0004%i&lWm\u001d\u000b\u0004m\u0005u\u0002bBA \u0003o\u0001\r![\u0001\u0007M\u0006\u001cGo\u001c:\t\u000f\u0005\rC\u0007\"\u0001\u0002F\u0005!A\u0005Z5w)\r1\u0014q\t\u0005\b\u0003\u0013\n\t\u00051\u0001j\u0003\u001d!\u0017N^5t_JD\u0001\"!\u00145A\u0013%\u0011qJ\u0001\n[&tWo\u001d.fe>,\u0012!\u001b\u0005\b\u0003\u0007\"D\u0011AA*)\rI\u0017Q\u000b\u0005\b\u0003\u0013\n\t\u00061\u00017\u0011\u001d\tI\u0003\u000eC\u0001\u00033\"2aMA.\u0011\u001d\tI!a\u0016A\u0002MBq!!\r5\t\u0003\ty\u0006F\u00024\u0003CBq!!\u0003\u0002^\u0001\u00071\u0007C\u0004\u0002fQ\"\t!a\u001a\u0002\tAdWo\u001d\u000b\u0004g\u0005%\u0004bBA\u0005\u0003G\u0002\ra\r\u0005\b\u0003[\"D\u0011AA8\u0003\u0015i\u0017N\\;t)\r\u0019\u0014\u0011\u000f\u0005\b\u0003\u0013\tY\u00071\u00014\u0011\u001d\t)\b\u000eC\u0001\u0003o\n1!\\5o)\r\u0019\u0014\u0011\u0010\u0005\b\u0003\u0013\t\u0019\b1\u00014\u0011\u00199F\u0007\"\u0001\u0002~Q\u00191'a \t\u000f\u0005%\u00111\u0010a\u0001g!9\u00111\t\u001b\u0005\u0002\u0005\rEcA\u001a\u0002\u0006\"9\u0011\u0011JAA\u0001\u0004a\u0004bBA\u001di\u0011\u0005\u0011\u0011\u0012\u000b\u0004g\u0005-\u0005bBA \u0003\u000f\u0003\r\u0001\u0010\u0005\b\u0003\u001f#D\u0011BAI\u0003\u001d\u0019\u0018MZ3Nk2$R\u0001PAJ\u0003/Cq!!&\u0002\u000e\u0002\u0007A(\u0001\u0002`C\"9\u0011\u0011TAG\u0001\u0004a\u0014AA0c\u0011\u001d\ti\n\u000eC\u0001\u0003?\u000b1\u0001Z5w)\r\u0019\u0014\u0011\u0015\u0005\b\u0003\u0013\nY\n1\u0001=\u0011\u001d\t)\u000b\u000eC\u0001\u0003O\u000b1!\\;m)\r\u0019\u0014\u0011\u0016\u0005\b\u0003\u007f\t\u0019\u000b1\u0001=\u0011\u001d\ti\u000b\u000eC\u0001\u0003_\u000bA\"\u001e8bef|F%\\5okN,\u0012a\r\u0005\b\u0003g#DQAA[\u0003!I7OR5oSR,G#A*\t\u000f\u0005eF\u0007\"\u0011\u0002<\u00061Q-];bYN$2aUA_\u0011!\tI!a.A\u0002\u0005}\u0006cA\f\u0002B&\u0019\u00111\u0019\u0004\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002HR\"\t%!3\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0001\t\ry!C\u0011AAg)\u0005\u0011\u0003B\u0002@%\t\u0003\t\t\u000e\u0006\u0004\u0002\u0002\u0005M\u0017Q\u001b\u0005\b\u0003'\ty\r1\u00014\u0011\u001d\t9\"a4A\u0002MBq!!7%\t#\tY.A\u0006sK\u0006$'+Z:pYZ,G#\u0001\b\t\u000f\u0005}7\u0002\"\u0001\u0002b\u0006)\u0011\r\u001d9msR)1'a9\u0002f\"1!(!8A\u0002qBaAQAo\u0001\u0004!\u0005bBAp\u0017\u0011\u0005\u0011\u0011\u001e\u000b\u0006g\u0005-\u0018Q\u001e\u0005\u0007u\u0005\u001d\b\u0019\u0001\u001f\t\u000f\t\u000b9\u000f1\u0001\u0002pB!\u0011\u0011_A|\u001d\r9\u00121_\u0005\u0004\u0003k4\u0011A\u0002)sK\u0012,g-C\u0002z\u0003sT1!!>\u0007\u0011%\tip\u0003b\u0001\n\u001b\ty0\u0001\u0004nCb|fn]\u000b\u0003\u0005\u0003y!Aa\u0001\u001f\u0011}|\u0000\u0000\u0000\u0000\u0000\u0000\u0000H\u0001Ba\u0002\fA\u00035!\u0011A\u0001\b[\u0006DxL\\:!\u0011%\u0011Ya\u0003b\u0001\n\u001b\u0011i!A\u0004nCb|&9n:\u0016\u0005\t=qB\u0001B\t=\u001d\u0001CygSd(^H\u0001B!\u0006\fA\u00035!qB\u0001\t[\u0006DxLq[tA!I!\u0011D\u0006C\u0002\u00135!1D\u0001\u0007[\u0006Dx,\\:\u0016\u0005\tuqB\u0001B\u0010=\u0019A1m\u001fi[m$A!1E\u0006!\u0002\u001b\u0011i\"A\u0004nCb|Vn\u001d\u0011\t\u0013\t\u001d2B1A\u0005\u000e\t%\u0012!B7bq~\u001bXC\u0001B\u0016\u001f\t\u0011iCH\u0003\u0003K\u0005oH\u0001\u0003\u0005\u00032-\u0001\u000bQ\u0002B\u0016\u0003\u0019i\u0017\r_0tA!I!QG\u0006C\u0002\u00135!qG\u0001\b[\u0006Dx,\\5o+\t\u0011Id\u0004\u0002\u0003<y!\u0011\"KPt\u0012!\u0011yd\u0003Q\u0001\u000e\te\u0012\u0001C7bq~k\u0017N\u001c\u0011\t\u0013\t\r3B1A\u0005\u000e\t\u0015\u0013!B7bq~CWC\u0001B$\u001f\t\u0011IEH\u0002(/}H\u0001B!\u0014\fA\u00035!qI\u0001\u0007[\u0006Dx\f\u001b\u0011\t\u0013\tE3B1A\u0005\u000e\tM\u0013!B7bq~#WC\u0001B+\u001f\t\u00119FH\u0002\u0002A\u007fH\u0001Ba\u0017\fA\u00035!QK\u0001\u0007[\u0006Dx\f\u001a\u0011\t\u000f\u0005e7\u0002\"\u0005\u0002\\\u0002")
public final class FiniteDuration
extends Duration
implements ScalaObject {
    public final long length;
    public final TimeUnit unit;

    public static final FiniteDuration apply(long l, String string2) {
        return FiniteDuration$.MODULE$.apply(l, string2);
    }

    public static final FiniteDuration apply(long l, TimeUnit timeUnit) {
        return FiniteDuration$.MODULE$.apply(l, timeUnit);
    }

    public long length() {
        return this.length;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    private boolean bounded(long max2) {
        return -max2 <= this.length() && this.length() <= max2;
    }

    public long toNanos() {
        return this.unit().toNanos(this.length());
    }

    public long toMicros() {
        return this.unit().toMicros(this.length());
    }

    public long toMillis() {
        return this.unit().toMillis(this.length());
    }

    public long toSeconds() {
        return this.unit().toSeconds(this.length());
    }

    public long toMinutes() {
        return this.unit().toMinutes(this.length());
    }

    public long toHours() {
        return this.unit().toHours(this.length());
    }

    public long toDays() {
        return this.unit().toDays(this.length());
    }

    public double toUnit(TimeUnit u) {
        return (double)this.toNanos() / (double)TimeUnit.NANOSECONDS.convert(1L, u);
    }

    public Deadline fromNow() {
        return Deadline$.MODULE$.now().$plus(this);
    }

    private String unitString() {
        return new StringBuilder().append((Object)((String)Duration$.MODULE$.timeUnitName().apply(this.unit()))).append((Object)(this.length() == 1L ? "" : "s")).toString();
    }

    public String toString() {
        return new StringBuilder().append((Object)"").append(BoxesRunTime.boxToLong(this.length())).append((Object)" ").append((Object)this.unitString()).toString();
    }

    public int compare(Duration other) {
        Duration duration = other;
        return duration instanceof FiniteDuration ? Predef$.MODULE$.longWrapper(this.toNanos()).compare(BoxesRunTime.boxToLong(((FiniteDuration)duration).toNanos())) : -other.compare(this);
    }

    private long safeAdd(long a, long b) {
        if (b > 0L && a > Long.MAX_VALUE - b || b < 0L && a < Long.MIN_VALUE - b) {
            throw new IllegalArgumentException("integer overflow");
        }
        return a + b;
    }

    private FiniteDuration add(long otherLength, TimeUnit otherUnit) {
        TimeUnit commonUnit = otherUnit.convert(1L, this.unit()) == 0L ? this.unit() : otherUnit;
        long totalLength = this.safeAdd(commonUnit.convert(this.length(), this.unit()), commonUnit.convert(otherLength, otherUnit));
        return new FiniteDuration(totalLength, commonUnit);
    }

    public Duration $plus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x2 = finiteDuration = (FiniteDuration)duration2;
            duration = this.add(x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    public Duration $minus(Duration other) {
        Duration duration;
        Duration duration2 = other;
        if (duration2 instanceof FiniteDuration) {
            FiniteDuration finiteDuration;
            FiniteDuration x2 = finiteDuration = (FiniteDuration)duration2;
            duration = this.add(-x2.length(), x2.unit());
        } else {
            duration = other;
        }
        return duration;
    }

    public Duration $times(double factor) {
        return Predef$.MODULE$.double2Double(factor).isInfinite() ? (Predef$.MODULE$.double2Double(factor).isNaN() ? Duration$.MODULE$.Undefined() : (factor > 0.0 ^ this.$less(Duration$.MODULE$.Zero()) ? Duration$.MODULE$.Inf() : Duration$.MODULE$.MinusInf())) : Duration$.MODULE$.fromNanos((double)this.toNanos() * factor);
    }

    public Duration $div(double divisor) {
        return Predef$.MODULE$.double2Double(divisor).isInfinite() ? (Predef$.MODULE$.double2Double(divisor).isNaN() ? Duration$.MODULE$.Undefined() : Duration$.MODULE$.Zero()) : Duration$.MODULE$.fromNanos((double)this.toNanos() / divisor);
    }

    private double minusZero() {
        return -0.0;
    }

    public double $div(Duration divisor) {
        return divisor.isFinite() ? (double)this.toNanos() / (double)divisor.toNanos() : (divisor == Duration$.MODULE$.Undefined() ? Double.NaN : (this.length() < 0L ^ divisor.$greater(Duration$.MODULE$.Zero()) ? 0.0 : this.minusZero()));
    }

    public FiniteDuration $plus(FiniteDuration other) {
        return this.add(other.length(), other.unit());
    }

    public FiniteDuration $minus(FiniteDuration other) {
        return this.add(-other.length(), other.unit());
    }

    public FiniteDuration plus(FiniteDuration other) {
        return this.$plus(other);
    }

    public FiniteDuration minus(FiniteDuration other) {
        return this.$minus(other);
    }

    public FiniteDuration min(FiniteDuration other) {
        return this.$less(other) ? this : other;
    }

    public FiniteDuration max(FiniteDuration other) {
        return this.$greater(other) ? this : other;
    }

    public FiniteDuration $div(long divisor) {
        return Duration$.MODULE$.fromNanos(this.toNanos() / divisor);
    }

    public FiniteDuration $times(long factor) {
        return new FiniteDuration(this.safeMul(this.length(), factor), this.unit());
    }

    private long safeMul(long _a, long _b) {
        long a = package$.MODULE$.abs(_a);
        long b = package$.MODULE$.abs(_b);
        if (Long.numberOfLeadingZeros(a) + Long.numberOfLeadingZeros(b) < 64) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        long product2 = a * b;
        if (product2 < 0L) {
            throw new IllegalArgumentException("multiplication overflow");
        }
        return a == _a ^ b == _b ? -product2 : product2;
    }

    public FiniteDuration div(long divisor) {
        return this.$div(divisor);
    }

    public FiniteDuration mul(long factor) {
        return this.$times(factor);
    }

    public FiniteDuration unary_$minus() {
        return Duration$.MODULE$.apply(-this.length(), this.unit());
    }

    public final boolean isFinite() {
        return true;
    }

    public boolean equals(Object other) {
        Object object = other;
        return object instanceof FiniteDuration ? this.toNanos() == ((FiniteDuration)object).toNanos() : super.equals(other);
    }

    public int hashCode() {
        return (int)this.toNanos();
    }

    public FiniteDuration(long length, TimeUnit unit) {
        boolean bl;
        TimeUnit timeUnit;
        this.length = length;
        this.unit = unit;
        TimeUnit timeUnit2 = timeUnit = unit;
        if (!(timeUnit2 != null ? !((Object)((Object)timeUnit2)).equals((Object)TimeUnit.NANOSECONDS) : TimeUnit.NANOSECONDS != null)) {
            bl = this.bounded(Long.MAX_VALUE);
        } else {
            TimeUnit timeUnit3 = timeUnit;
            if (!(timeUnit3 != null ? !((Object)((Object)timeUnit3)).equals((Object)TimeUnit.MICROSECONDS) : TimeUnit.MICROSECONDS != null)) {
                bl = this.bounded(9223372036854775L);
            } else {
                TimeUnit timeUnit4 = timeUnit;
                if (!(timeUnit4 != null ? !((Object)((Object)timeUnit4)).equals((Object)TimeUnit.MILLISECONDS) : TimeUnit.MILLISECONDS != null)) {
                    bl = this.bounded(9223372036854L);
                } else {
                    TimeUnit timeUnit5 = timeUnit;
                    if (!(timeUnit5 != null ? !((Object)((Object)timeUnit5)).equals((Object)TimeUnit.SECONDS) : TimeUnit.SECONDS != null)) {
                        bl = this.bounded(9223372036L);
                    } else {
                        TimeUnit timeUnit6 = timeUnit;
                        if (!(timeUnit6 != null ? !((Object)((Object)timeUnit6)).equals((Object)TimeUnit.MINUTES) : TimeUnit.MINUTES != null)) {
                            bl = this.bounded(153722867L);
                        } else {
                            TimeUnit timeUnit7 = timeUnit;
                            if (!(timeUnit7 != null ? !((Object)((Object)timeUnit7)).equals((Object)TimeUnit.HOURS) : TimeUnit.HOURS != null)) {
                                bl = this.bounded(2562047L);
                            } else {
                                TimeUnit timeUnit8 = timeUnit;
                                if (!(timeUnit8 != null ? !((Object)((Object)timeUnit8)).equals((Object)TimeUnit.DAYS) : TimeUnit.DAYS != null)) {
                                    bl = this.bounded(106751L);
                                } else {
                                    long v = TimeUnit.DAYS.convert(length, unit);
                                    bl = -106751L <= v && v <= 106751L;
                                }
                            }
                        }
                    }
                }
            }
        }
        Predef$.MODULE$.require(bl, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Duration is limited to +-(2^63-1)ns (ca. 292 years)";
            }
        }));
    }
}

