/*
 * Decompiled with CFR 0.152.
 */
package scala.collection;

import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.IterableLike$;
import scala.collection.IterableView;
import scala.collection.Iterator;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Stream;
import scala.collection.mutable.Builder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt;
import scala.runtime.ScalaRunTime$;

public abstract class IterableLike$class {
    public static Iterable thisCollection(IterableLike $this) {
        return (Iterable)$this;
    }

    public static Iterable toCollection(IterableLike $this, Object repr) {
        return (Iterable)repr;
    }

    public static void foreach(IterableLike $this, Function1 f) {
        $this.iterator().foreach(f);
    }

    public static boolean forall(IterableLike $this, Function1 p) {
        return $this.iterator().forall(p);
    }

    public static boolean exists(IterableLike $this, Function1 p) {
        return $this.iterator().exists(p);
    }

    public static Option find(IterableLike $this, Function1 p) {
        return $this.iterator().find(p);
    }

    public static boolean isEmpty(IterableLike $this) {
        return !$this.iterator().hasNext();
    }

    public static Object foldRight(IterableLike $this, Object z, Function2 op) {
        return $this.iterator().foldRight(z, op);
    }

    public static Object reduceRight(IterableLike $this, Function2 op) {
        return $this.iterator().reduceRight(op);
    }

    public static Iterable toIterable(IterableLike $this) {
        return $this.thisCollection();
    }

    public static Object head(IterableLike $this) {
        if ($this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return $this.iterator().next();
    }

    public static Object take(IterableLike $this, int n) {
        Builder b = $this.newBuilder();
        Iterator it = $this.iterator();
        for (int i = 0; i < n && it.hasNext(); ++i) {
            b.$plus$eq(it.next());
        }
        return b.result();
    }

    public static Object slice(IterableLike $this, int from2, int until2) {
        Builder b = $this.newBuilder();
        Iterator it = $this.iterator().drop(from2);
        for (int i = from2; i < until2 && it.hasNext(); ++i) {
            b.$plus$eq(it.next());
        }
        return b.result();
    }

    public static Object takeWhile(IterableLike $this, Function1 p) {
        Builder b = $this.newBuilder();
        Iterator it = $this.iterator();
        while (it.hasNext()) {
            Object x = it.next();
            if (BoxesRunTime.unboxToBoolean(p.apply(x))) {
                b.$plus$eq(x);
                continue;
            }
            return b.result();
        }
        return b.result();
    }

    public static Iterator grouped(IterableLike $this, int size2) {
        return $this.iterator().grouped(size2).map(new IterableLike$.anonfun.grouped.1($this));
    }

    public static Iterator sliding(IterableLike $this, int size2) {
        return $this.sliding(size2, 1);
    }

    public static Iterator sliding(IterableLike $this, int size2, int step) {
        return $this.iterator().sliding(size2, step).map(new IterableLike$.anonfun.sliding.1($this));
    }

    public static Object takeRight(IterableLike $this, int n) {
        Builder b$1 = $this.newBuilder();
        Iterator lead$1 = $this.iterator().drop(n);
        BooleanRef go$1 = new BooleanRef(false);
        $this.foreach(new IterableLike$.anonfun.takeRight.1($this, b$1, lead$1, go$1));
        return b$1.result();
    }

    public static Object dropRight(IterableLike $this, int n) {
        Builder b = $this.newBuilder();
        Iterator lead = $this.iterator().drop(n);
        Iterator it = $this.iterator();
        while (lead.hasNext()) {
            b.$plus$eq(it.next());
            lead.next();
        }
        return b.result();
    }

    public static void copyToArray(IterableLike $this, Object xs, int start2, int len) {
        int n = start2 + len;
        int end = new RichInt(n).min(ScalaRunTime$.MODULE$.array_length(xs));
        Iterator it = $this.iterator();
        for (int i = start2; i < end && it.hasNext(); ++i) {
            ScalaRunTime$.MODULE$.array_update(xs, i, it.next());
        }
    }

    public static Object zip(IterableLike $this, Iterable that, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        return b.result();
    }

    public static Object zipAll(IterableLike $this, Iterable that, Object thisElem, Object thatElem, CanBuildFrom bf) {
        Builder b = bf.apply($this.repr());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        while (these.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), thatElem));
        }
        while (those.hasNext()) {
            b.$plus$eq(new Tuple2(thisElem, those.next()));
        }
        return b.result();
    }

    public static Object zipWithIndex(IterableLike $this, CanBuildFrom bf) {
        Builder b$2 = bf.apply($this.repr());
        IntRef i$1 = new IntRef(0);
        $this.foreach(new IterableLike$.anonfun.zipWithIndex.1($this, b$2, i$1));
        return b$2.result();
    }

    /*
     * WARNING - void declaration
     */
    public static boolean sameElements(IterableLike $this, Iterable that) {
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            void y0;
            void x0;
            Object a = those.next();
            Object a2 = these.next();
            if (a2 == a ? true : (x0 == null ? false : (x0 instanceof Number ? BoxesRunTime.equalsNumObject((Number)x0, y0) : (x0 instanceof Character ? BoxesRunTime.equalsCharObject((Character)x0, y0) : x0.equals(y0))))) continue;
            return false;
        }
        return !these.hasNext() && !those.hasNext();
    }

    public static Stream toStream(IterableLike $this) {
        return $this.iterator().toStream();
    }

    public static boolean canEqual(IterableLike $this, Object that) {
        return true;
    }

    public static IterableView view(IterableLike $this) {
        return new IterableLike$.anon.1($this);
    }

    public static IterableView view(IterableLike $this, int from2, int until2) {
        return (IterableView)$this.view().slice(from2, until2);
    }

    public static Iterator elements(IterableLike $this) {
        return $this.iterator();
    }

    public static Object first(IterableLike $this) {
        return $this.head();
    }

    public static Option firstOption(IterableLike $this) {
        return $this.headOption();
    }

    public static IterableView projection(IterableLike $this) {
        return $this.view();
    }

    public static void $init$(IterableLike $this) {
    }
}

