/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.runtime.Comparator;

public abstract class FlatHashTable$class {
    public static void $init$(FlatHashTable $this) {
        $this.table_$eq($this.initialSize() == 0 ? null : new Object[$this.initialSize()]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.initialSize()));
    }

    private static final boolean precedes$0(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        return i <= j ? j - i < d : i - j > d;
    }

    public static void clear(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
    }

    private static int newThreshold(FlatHashTable $this, int size) {
        int lf = $this.loadFactor();
        Predef$.MODULE$.assert(lf < $this.loadFactorDenum() / 2, "loadFactor too large; must be < 0.5");
        return (int)((long)size * (long)lf / (long)$this.loadFactorDenum());
    }

    public static final int index(FlatHashTable $this, int hcode) {
        return $this.improve(hcode) & $this.table().length - 1;
    }

    public static final int improve(FlatHashTable $this, int hcode) {
        int h = hcode + ~(hcode << 9);
        h ^= h >>> 14;
        h += h << 4;
        return h ^ h >>> 10;
    }

    public static int elemHashCode(FlatHashTable $this, Object elem) {
        return elem.hashCode();
    }

    private static void checkConsistent(FlatHashTable $this) {
        Predef$.MODULE$.intWrapper(0).until($this.table().length).foreach(new FlatHashTable$.anonfun.0($this));
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$class.newThreshold($this, $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            if (Comparator.equals(null, entry)) continue;
            $this.addEntry(entry);
        }
    }

    public static Object elements(FlatHashTable $this) {
        return new FlatHashTable$.anon.0($this);
    }

    public static void removeEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (!Comparator.equals(null, entry)) {
            if (Comparator.equals(entry, elem)) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while (true) {
                    if (Comparator.equals(null, $this.table()[h1])) {
                        $this.table()[h0] = null;
                        $this.tableSize_$eq($this.tableSize() - 1);
                        return;
                    }
                    int h2 = $this.index($this.elemHashCode($this.table()[h1]));
                    if (h2 != h1 && FlatHashTable$class.precedes$0($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return;
    }

    public static void addEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (true) {
            if (Comparator.equals(null, entry)) {
                $this.table()[h] = elem;
                $this.tableSize_$eq($this.tableSize() + 1);
                if ($this.tableSize() >= $this.threshold()) {
                    FlatHashTable$class.growTable($this);
                }
                return;
            }
            if (Comparator.equals(entry, elem)) {
                return;
            }
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
    }

    public static boolean containsEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (!Comparator.equals(null, entry) && !Comparator.equals(entry, elem)) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return !Comparator.equals(null, entry);
    }

    public static Option findEntry(FlatHashTable $this, Object elem) {
        int h = $this.index($this.elemHashCode(elem));
        Object entry = $this.table()[h];
        while (!Comparator.equals(null, entry) && !Comparator.equals(entry, elem)) {
            h = (h + 1) % $this.table().length;
            entry = $this.table()[h];
        }
        return Comparator.equals(null, entry) ? None$.MODULE$ : new Some(entry);
    }

    public static int size(FlatHashTable $this) {
        return $this.tableSize();
    }

    public static int initialSize(FlatHashTable $this) {
        return 16;
    }

    public static final int loadFactorDenum(FlatHashTable $this) {
        return 1000;
    }

    public static int loadFactor(FlatHashTable $this) {
        return 450;
    }
}

