/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.List;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.actors.Debug$;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Serializer;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpService$;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private NetKernel kernel;
    private HashMap connections;
    private HashMap pendingSends;
    private Node internalNode;
    private JavaSerializer serializer;
    private int port;

    public TcpService(int port) {
        this.port = port;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), port);
        this.pendingSends = new HashMap();
        this.connections = new HashMap();
    }

    private final void liftedTry0$0(Node node, byte[] byArray) {
        block5: {
            try {
                TcpServiceWorker newWorker$0 = this.connect(node);
                newWorker$0.transmit(byArray);
                Option option = this.pendingSends().get(node);
                if (None$.MODULE$ == option) break block5;
                if (option instanceof Some) {
                    ((List)((Some)option).x()).foreach(new $anonfun$0(this, newWorker$0));
                    this.pendingSends().$minus$eq(node);
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                this.bufferMsg$0(iOException, node, byArray);
            }
            catch (UnknownHostException unknownHostException) {
                this.bufferMsg$0(unknownHostException, node, byArray);
            }
        }
    }

    private final void bufferMsg$0(Throwable t, Node node, byte[] byArray) {
        Option option;
        block4: {
            block5: {
                block3: {
                    block2: {
                        option = this.pendingSends().get(node);
                        if (None$.MODULE$ != option) break block2;
                        byte[] byArray2 = byArray;
                        this.pendingSends().$plus$eq(node).$minus$greater(Nil$.MODULE$.$colon$colon(byArray2));
                        break block3;
                    }
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    List list = (List)some.x();
                    List msgs = list;
                    if (!this.gd0$0(msgs)) break block5;
                    byte[] byArray3 = byArray;
                    this.pendingSends().$plus$eq(node).$minus$greater(list.$colon$colon(byArray3));
                }
                return;
            }
            throw new MatchError(option);
        }
        throw new MatchError(option);
    }

    private final /* synthetic */ boolean gd0$0(List x$1) {
        return x$1.length() < TcpService$.MODULE$.BufSize();
    }

    public Serializer serializer() {
        return this.serializer();
    }

    public void nodeDown(Node mnode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$minus$eq(mnode);
            return;
        }
    }

    public boolean isReachable(Node node) {
        boolean bl;
        if (this.isConnected(node)) {
            bl = true;
        } else {
            try {
                this.connect(node);
                return true;
            }
            catch (SecurityException securityException) {
                bl = false;
            }
            catch (IOException iOException) {
                bl = false;
            }
            catch (UnknownHostException unknownHostException) {
                bl = false;
            }
        }
        return bl;
    }

    public void disconnectNode(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.connections().get(n);
                        if (None$.MODULE$ != option) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    this.connections().$minus$eq(n);
                    ((TcpServiceWorker)((Some)option).x()).halt();
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public TcpServiceWorker connect(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Socket sock = new Socket(n.address(), n.port());
            TcpServiceWorker worker = new TcpServiceWorker(this, sock);
            worker.sendNode(n);
            worker.start();
            this.addConnection(n, worker);
            return worker;
        }
    }

    public boolean isConnected(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return BoxesUtility.unboxToBoolean(BoxesUtility.boxToBoolean(!this.connections().get(n).isEmpty()));
        }
    }

    public Option getConnection(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get(n);
        }
    }

    public void addConnection(Node node, TcpServiceWorker worker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq(node).$minus$greater(worker);
            return;
        }
    }

    private HashMap connections() {
        return this.connections;
    }

    public void run() {
        try {
            ServerSocket socket = new ServerSocket(this.port);
            while (true) {
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": waiting for new connection..."));
                Socket nextClient = socket.accept();
                TcpServiceWorker worker = new TcpServiceWorker(this, nextClient);
                Debug$.MODULE$.info("Started new " + worker);
                worker.readNode();
                worker.start();
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + exception);
        }
        catch (SecurityException securityException) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + securityException);
        }
        catch (IOException iOException) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": caught ") + iOException);
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
        }
        finally {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
        }
    }

    public void send(Node node$0, byte[] data$0) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.getConnection(node$0);
                        if (None$.MODULE$ != option) break block5;
                        this.liftedTry0$0(node$0, data$0);
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    ((TcpServiceWorker)((Some)option).x()).transmit(data$0);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    private HashMap pendingSends() {
        return this.pendingSends;
    }

    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    public JavaSerializer serializer() {
        return this.serializer;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public final void kernel_$eq(NetKernel x$1) {
        this.kernel = x$1;
    }

    public final NetKernel kernel() {
        return this.kernel;
    }
}

